/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3303.configitem;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.AbstractRbs3RadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.ConfigurationMicro;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.SectorCapability;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRaxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.nonautogenerated.MimAntennaBranchDef;
import se.ericsson.wcdma.rbs.bem.common.moi.HubSubrackMoi;

public class RadioEquipment3303CI
extends AbstractRbs3RadioEquipmentCI {
    private int sTrxSlot;

    public RadioEquipment3303CI(Rbs rbs, int n) {
        super(rbs);
        this.sTrxSlot = n;
        this.setBoardPositions(MimRaxDeviceGroup.MOTYPENAME, new String[]{"6", "7", "8"});
        this.setBoardPositions(MimTxDeviceGroup.MOTYPENAME, new String[]{"5"});
    }

    protected void createConfigurations() throws BemException {
        int n = this.getRbs().getMaxNumberOfSectors();
        for (int i = 1; i <= n; ++i) {
            HubSubrackMoi hubSubrackMoi = new HubSubrackMoi(this.getRbs().getEquipmentMoi());
            ConfigurationMicro configurationMicro = new ConfigurationMicro(this.getRbs(), i, hubSubrackMoi, this.sTrxSlot);
            SectorCapability sectorCapability = new SectorCapability();
            sectorCapability.addConfiguration(configurationMicro);
            this.addSectorCapability(i, sectorCapability);
        }
    }

    public Integer getTerminationConnector(int n, String string) throws BemException {
        Integer[] integerArray;
        if (string.equals(MimAntennaBranchDef.BRANCH_A)) {
            integerArray = new Integer[]{new Integer(3), new Integer(5), new Integer(7)};
        } else if (string.equals(MimAntennaBranchDef.BRANCH_B)) {
            integerArray = new Integer[]{new Integer(4), new Integer(6), new Integer(8)};
        } else {
            throw new BemException(this.getClass().getName() + " getTerminationConnector(): Type " + string + " not supported");
        }
        return integerArray[n - 1];
    }
}

