/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.moi;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public abstract class MoInstance {
    protected static final String RDN_DELIMITER = ",";
    protected static final String TYPE_DELIMITER = "=";
    protected static final String RDN_PREFIX_WHEN_OCCUPIED = "_";
    private final Vector compulsoryAttributeSettings = new Vector();
    private final MoHandler moHandler = new MoHandlerImpl();
    private String cachedLdn = null;

    public MoHandler getMoHandler() {
        return this.moHandler;
    }

    public String getLdn() throws BemException {
        if (this.cachedLdn == null) {
            this.cachedLdn = this.getDiscoveredOrDefaultLdn();
        }
        return this.cachedLdn;
    }

    protected abstract String getDiscoveredOrDefaultLdn() throws BemException;

    protected String generateDefaultLdn(String string, String string2, String string3) throws BemException {
        ExceptionProperties exceptionProperties = new ExceptionProperties();
        exceptionProperties.setProperty("Failing Method", "generateDefaultLdn()");
        exceptionProperties.setProperty("Failing Method  - Params", "parentLdn=" + string + ", moType=" + string2 + ", defaultRdnId=" + string3);
        exceptionProperties.setProperty("MoInstance", this);
        if (string3 == null) {
            exceptionProperties.setProperty("Problem, Low Level", "PROGRAMMING ERROR! MOI can't generate defaultLdn when defaultRdnId==null!");
            throw new BemException("Could not generate LDN", exceptionProperties);
        }
        if (this.moHandler == null) {
            exceptionProperties.setProperty("Problem, Low Level", "PROGRAMMING ERROR! MOI can't generate defaultLdn when moHandler==null!");
            throw new BemException("MoHandler not setup", exceptionProperties);
        }
        String string4 = string + RDN_DELIMITER + string2 + TYPE_DELIMITER + string3;
        exceptionProperties.setProperty("Failing Method  - Additional info", "defaultLdn=" + string4);
        BemMo bemMo = this.moHandler.getMo(string4);
        try {
            if (this.moHandler.isExisting(bemMo)) {
                string4 = string + RDN_DELIMITER + string2 + TYPE_DELIMITER + RDN_PREFIX_WHEN_OCCUPIED + string3;
                exceptionProperties.appendProperty("Failing Method  - Additional info", ", ", "alternativeLdn=" + string4);
                bemMo = this.moHandler.getMo(string4);
                if (this.moHandler.isExisting(bemMo)) {
                    exceptionProperties.setProperty("Problem, Low Level", "Default and alternative LDN already occupied");
                    throw new BemException("LDN already ockupied", exceptionProperties);
                }
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("Failed generating default Ldn", exceptionProperties);
        }
        return string4;
    }

    public Vector getCompulsoryAttributes() throws BemException {
        int n = this.compulsoryAttributeSettings.size();
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        for (int i = 0; i < n; ++i) {
            String string;
            NalNameValue nalNameValue = (NalNameValue)this.compulsoryAttributeSettings.elementAt(i);
            if (nalNameValue.getValue() instanceof MoInstance) {
                string = nalNameValue.getName();
                MoInstance moInstance = (MoInstance)nalNameValue.getValue();
                String string2 = moInstance.getLdn();
                BemMo bemMo = this.moHandler.getMo(string2);
                nalNameValue = Nal.getFactory().getNameValue(string, bemMo);
            }
            if (nalNameValue.getValue() instanceof NalNameValue) {
                string = this.getClass().getName();
                throw new UnsupportedOperationException(string + ": not supported nested NameValues" + nalNameValue.getName());
            }
            vector.add(nalNameValue);
        }
        return vector;
    }

    public void addAllCompulsoryAttributes(NalNameValue[] nalNameValueArray) {
        for (int i = 0; i < nalNameValueArray.length; ++i) {
            this.compulsoryAttributeSettings.addElement(nalNameValueArray[i]);
        }
    }

    public void addCompulsoryAttributes(NalNameValue nalNameValue) {
        this.compulsoryAttributeSettings.addElement(nalNameValue);
    }

    public boolean equals(Object object) {
        Object object2;
        String string = null;
        try {
            string = this.getLdn();
        }
        catch (BemException bemException) {
            return false;
        }
        if (string == null) {
            return false;
        }
        boolean bl = false;
        if (object instanceof MoInstance) {
            String string2;
            object2 = (MoInstance)object;
            try {
                string2 = ((MoInstance)object2).getLdn();
            }
            catch (BemException bemException) {
                return false;
            }
            bl = string.equals(string2);
        }
        if (object instanceof BemMo) {
            object2 = (BemMo)object;
            bl = string.equals(object2.getDN());
        } else {
            bl = this.cachedLdn.equals(object);
        }
        return bl;
    }

    public int hashCode() {
        return this.cachedLdn.hashCode() * 11;
    }

    public String toString() {
        return this.cachedLdn == null ? "(MOI cashedLdn still unintialized)" : this.cachedLdn;
    }
}

