/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.nal.impl.backend;

import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalBackend;

public class NalStructBackend {
    protected final NalNameValue[] nalNameValues;
    private String[] cashedNames = null;

    public NalStructBackend(NalNameValue[] nalNameValueArray) {
        if (nalNameValueArray == null) {
            this.nalNameValues = new NalNameValue[0];
        } else {
            this.nalNameValues = new NalNameValue[nalNameValueArray.length];
            System.arraycopy(nalNameValueArray, 0, this.nalNameValues, 0, nalNameValueArray.length);
        }
    }

    public NalNameValue getMember(String string) {
        int n = this.indexOf(string);
        if (n == -1) {
            return null;
        }
        NalNameValue nalNameValue = this.nalNameValues[n];
        return nalNameValue;
    }

    public Object getMemberValue(String string) throws NoSuchFieldException {
        NalNameValue nalNameValue = this.getMember(string);
        if (nalNameValue == null) {
            throw new NoSuchFieldException("No member by name=" + string + " present in NalStruct of size=" + this.nalNameValues.length + "!");
        }
        Object object = nalNameValue.getValue();
        return object;
    }

    public synchronized String[] getMemberNames() {
        if (this.cashedNames == null) {
            String[] stringArray = new String[this.nalNameValues.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.nalNameValues[i].getName();
            }
            this.cashedNames = stringArray;
        }
        return this.cashedNames;
    }

    public NalNameValue[] getNameValueArray() {
        return this.nalNameValues;
    }

    public int getSize() {
        return this.nalNameValues.length;
    }

    protected int indexOf(String string) {
        for (int i = 0; i < this.nalNameValues.length; ++i) {
            if (!this.nalNameValues[i].getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        String string = NalBackend.toString(this.nalNameValues);
        return string;
    }
}

