/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.fm.alv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.omg.TimeBase.UtcT;
import se.ericsson.cello.emas.fm.common.EventType;
import se.ericsson.cello.emas.fm.common.ExtendedEventType;
import se.ericsson.cello.emas.fm.common.ProbablyCause;
import se.ericsson.cello.emas.fm.common.RowDataInterface;
import se.ericsson.cello.emas.fm.common.Severity;
import se.ericsson.cello.emas.fm.common.TimeFormatter;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.TimeConverter;

public class AlarmLogRecord
implements RowDataInterface {
    private int numberOfNotifications;
    private List corrNotificationMoi = new ArrayList();
    private List corrNotificationId = new ArrayList();
    private int numberOfTypeValuePairs;
    private List additionalType = new ArrayList();
    private List additionalValue = new ArrayList();
    private boolean errorInRecord = true;
    private Map myAttributeValue = new HashMap();
    private boolean ackIsAvailable;

    public AlarmLogRecord(String tokenString, boolean hasAck) {
        this.ackIsAvailable = hasAck;
        this.fillAttributes(this.parseTokens(tokenString));
    }

    public Object getValueAt(String colName) {
        Object obj = this.myAttributeValue.get(colName);
        if (obj == null) {
            return "";
        }
        return obj;
    }

    public String getAdditionalInfo(ResourceBundle bundle) {
        int i;
        StringBuffer strBuf = new StringBuffer();
        String fontName = new String("Arial");
        strBuf.append("<html>");
        strBuf.append("<FONT FACE=");
        strBuf.append('\"');
        strBuf.append(fontName);
        strBuf.append('\"');
        strBuf.append(">");
        strBuf.append("<font size = -1>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("ALARM_ID_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("ALARM_ID"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("PERCEIVED_SEVERITY_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("SEVERITY"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("EVENT_TIME_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(TimeFormatter.setTimeFormat(this.getStringValue("EVENT_TIME")));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("EVENT_TYPE_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("EVENT_TYPE"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("EXTENDED_EVENT_TYPE_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("EXTENDED_EVENT_TYPE"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("ADDITIONAL_TEXT_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("ADDITIONAL_TEXT"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("PROBABLE_CAUSE_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("PROBABLE_CAUSE"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("SPECIFIC_PROBLEM_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("SPECIFIC_PROBLEM"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("MANAGED_OBJECT_CLASS_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("MANAGED_OBJECT_CLASS"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("MANAGED_OBJECT_INSTANCE_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("MANAGED_OBJECT_INSTANCE"));
        strBuf.append("<BR>");
        if (this.ackIsAvailable) {
            strBuf.append("<b>");
            strBuf.append(bundle.getString("ACK_USER_DETAILS"));
            strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;");
            strBuf.append(this.getStringValue("ACK"));
            strBuf.append("<BR>");
            strBuf.append("<b>");
            strBuf.append(bundle.getString("ACK_TIME_DETAILS"));
            strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;");
            strBuf.append(this.getStringValue("ACK_TIME"));
            strBuf.append("<BR>");
        }
        strBuf.append("<b>");
        strBuf.append(bundle.getString("NOTIFICATION_ID_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("NOTIFICATION_ID"));
        strBuf.append("<BR>");
        strBuf.append("<b>");
        strBuf.append(bundle.getString("SYSTEM_DN_DETAILS"));
        strBuf.append("</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        strBuf.append(this.getStringValue("SYSTEM_DN"));
        strBuf.append("<BR>");
        if (this.numberOfNotifications > 0) {
            strBuf.append("<b>");
            strBuf.append(bundle.getString("CORRELATED_NOTIFICATIONS_DETAILS"));
            strBuf.append("</b>");
            strBuf.append("<ul>");
            for (i = 0; i < this.numberOfNotifications; ++i) {
                strBuf.append("<li>");
                strBuf.append(bundle.getString("CORR_NOTIFY_MOI_DETAILS"));
                strBuf.append(this.corrNotificationMoi.get(i));
                strBuf.append("   ");
                strBuf.append(bundle.getString("CORR_NOTIFY_NOT_ID_DETAILS"));
                strBuf.append(this.corrNotificationId.get(i));
                strBuf.append("</li>");
            }
        }
        strBuf.append("</ul>");
        if (this.numberOfTypeValuePairs > 0) {
            strBuf.append("<b>");
            strBuf.append(bundle.getString("ADDITIONAL_INFORMATION_DETAILS"));
            strBuf.append("</b>");
            strBuf.append("<ul>");
            for (i = 0; i < this.numberOfTypeValuePairs; ++i) {
                strBuf.append("<li>");
                strBuf.append(this.additionalType.get(i));
                strBuf.append(": ");
                strBuf.append(this.additionalValue.get(i));
                strBuf.append("</li>");
            }
            strBuf.append("</ul>");
        }
        strBuf.append("</font>");
        strBuf.append("</html>");
        return strBuf.toString();
    }

    public String getLineForWriting() {
        int i;
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(this.getStringValue("ALARM_ID"));
        strBuf.append(";");
        strBuf.append(this.getStringValue("SEVERITY"));
        strBuf.append(";");
        strBuf.append(TimeFormatter.setTimeFormat(this.getStringValue("EVENT_TIME")));
        strBuf.append(";");
        strBuf.append(this.getStringValue("EVENT_TYPE"));
        strBuf.append(";");
        strBuf.append(this.getStringValue("EXTENDED_EVENT_TYPE"));
        strBuf.append(";");
        strBuf.append(this.getStringValue("ADDITIONAL_TEXT"));
        strBuf.append(";");
        strBuf.append(this.getStringValue("PROBABLE_CAUSE"));
        strBuf.append(";");
        strBuf.append(this.getStringValue("SPECIFIC_PROBLEM"));
        strBuf.append(";");
        strBuf.append(this.getStringValue("MANAGED_OBJECT_CLASS"));
        strBuf.append(";");
        strBuf.append(this.getStringValue("MANAGED_OBJECT_INSTANCE"));
        strBuf.append(";");
        if (this.ackIsAvailable) {
            strBuf.append(this.getStringValue("ACK"));
            strBuf.append(";");
            strBuf.append(this.getStringValue("ACK_TIME"));
            strBuf.append(";");
        }
        strBuf.append(this.getStringValue("NOTIFICATION_ID"));
        strBuf.append(";");
        strBuf.append(this.getStringValue("SYSTEM_DN"));
        strBuf.append(";");
        for (i = 0; i < this.numberOfNotifications; ++i) {
            strBuf.append("managedObjectInstance:" + this.corrNotificationMoi.get(i));
            strBuf.append("   ");
            strBuf.append("notificationID: " + this.corrNotificationId.get(i));
            strBuf.append(" | ");
        }
        strBuf.append(";");
        for (i = 0; i < this.numberOfTypeValuePairs; ++i) {
            strBuf.append(this.additionalType.get(i));
            strBuf.append(": ");
            String tmp1 = (String)this.additionalValue.get(i);
            tmp1 = tmp1.replace('\n', ' ');
            tmp1 = tmp1.replace('\t', ' ');
            tmp1 = tmp1.replace('\r', ' ');
            strBuf.append(tmp1);
            strBuf.append(" | ");
        }
        strBuf.append(";");
        strBuf.append("\n");
        return strBuf.toString();
    }

    public String toString() {
        return this.myAttributeValue.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AlarmLogRecord) {
            AlarmLogRecord elr = (AlarmLogRecord)obj;
            String uniqIdObj = elr.getNotificationId() + elr.getEventTime();
            String uniqIdThis = this.getNotificationId() + this.getEventTime();
            return uniqIdObj.equals(uniqIdThis);
        }
        return false;
    }

    public int hashCode() {
        return this.getStringValue("NOTIFICATION_ID").hashCode();
    }

    private List parseTokens(String s) {
        String[] stringArr = s.split(";", -99);
        ArrayList<String> tokens = new ArrayList<String>(stringArr.length);
        for (int i = 0; i < stringArr.length; ++i) {
            tokens.add(stringArr[i]);
            tokens.add(";");
        }
        return tokens;
    }

    private void fillAttributes(List tokens) {
        int index = 0;
        try {
            String domainName = (String)tokens.get(index);
            this.myAttributeValue.put("DOMAIN_NAME", domainName);
            EventType eventType = EventType.getEventType((String)tokens.get(index += 2));
            this.myAttributeValue.put("EVENT_TYPE", eventType);
            ExtendedEventType extendedEventType = ExtendedEventType.getExtendedEventType((String)tokens.get(index += 2));
            this.myAttributeValue.put("EXTENDED_EVENT_TYPE", extendedEventType);
            String managedObjectClass = (String)tokens.get(index += 2);
            this.myAttributeValue.put("MANAGED_OBJECT_CLASS", managedObjectClass);
            String managedObjectInstance = (String)tokens.get(index += 2);
            this.myAttributeValue.put("MANAGED_OBJECT_INSTANCE", managedObjectInstance);
            String notificationId = (String)tokens.get(index += 2);
            this.myAttributeValue.put("NOTIFICATION_ID", notificationId);
            String eventTime = (String)tokens.get(index += 2);
            String systemDN = "";
            if (!((String)tokens.get(index += 2)).equals(";")) {
                systemDN = (String)tokens.get(index);
                index += 2;
            } else {
                systemDN = "";
                ++index;
            }
            this.myAttributeValue.put("SYSTEM_DN", systemDN);
            String probCause = (String)tokens.get(index);
            ProbablyCause probableCause = new ProbablyCause(new Short(probCause));
            this.myAttributeValue.put("PROBABLE_CAUSE", probableCause);
            String sevStr = (String)tokens.get(index += 2);
            try {
                Severity severity = Severity.getSeverity(Short.parseShort(sevStr));
                this.myAttributeValue.put("SEVERITY", severity);
            }
            catch (Exception e) {
                Log.logError((String)("Can't create Severity from: " + sevStr), null);
            }
            String specificProblem = (String)tokens.get(index += 2);
            this.myAttributeValue.put("SPECIFIC_PROBLEM", specificProblem);
            index += 2;
            try {
                this.numberOfNotifications = new Integer((String)tokens.get(index));
            }
            catch (Exception x1) {
                Log.trace((String)("Alarmlog error: numberOfNotifications=" + (String)tokens.get(index)));
                this.numberOfNotifications = 0;
            }
            index += 2;
            for (int x = 0; x < this.numberOfNotifications; ++x) {
                this.corrNotificationMoi.add((String)tokens.get(index));
                this.corrNotificationId.add((String)tokens.get(index += 2));
                index += 2;
            }
            String additionalText = "";
            if (!((String)tokens.get(index)).equals(";")) {
                additionalText = (String)tokens.get(index);
                index += 2;
            } else {
                ++index;
            }
            this.myAttributeValue.put("ADDITIONAL_TEXT", additionalText);
            String alarmIdentity = (String)tokens.get(index);
            this.myAttributeValue.put("ALARM_ID", alarmIdentity);
            String ackUser = "-";
            if (!((String)tokens.get(index += 2)).equals(";")) {
                ackUser = (String)tokens.get(index);
                index += 2;
            } else {
                ++index;
            }
            this.myAttributeValue.put("ACK", ackUser);
            String readAckTime = (String)tokens.get(index);
            String ackState = (String)tokens.get(index += 2);
            this.myAttributeValue.put("ACK_STATE", ackState);
            String timeZone = (String)tokens.get(index += 2);
            this.myAttributeValue.put("TIME_ZONE", timeZone);
            if ((index += 2) > tokens.size() - 1) {
                this.numberOfTypeValuePairs = 0;
            } else {
                try {
                    this.numberOfTypeValuePairs = new Integer((String)tokens.get(index));
                }
                catch (Exception x1) {
                    Log.trace((String)("Alarmlog error: numberOfTypeValuePairs, index=" + index));
                    this.numberOfTypeValuePairs = 0;
                }
                index += 2;
                String userLabel = "";
                for (int x = 0; x < this.numberOfTypeValuePairs; ++x) {
                    boolean userLabelFound = false;
                    if (!((String)tokens.get(index)).equals(";")) {
                        if (((String)tokens.get(index)).equals("userLabel")) {
                            userLabelFound = true;
                        }
                        this.additionalType.add((String)tokens.get(index));
                        index += 2;
                    } else {
                        this.additionalType.add("");
                        ++index;
                    }
                    if (!((String)tokens.get(index)).equals(";")) {
                        if (userLabelFound) {
                            userLabel = (String)tokens.get(index);
                        }
                        this.additionalValue.add((String)tokens.get(index));
                        index += 2;
                        continue;
                    }
                    this.additionalValue.add("");
                    ++index;
                }
                this.myAttributeValue.put("USERLABEL", userLabel);
            }
            int inacclo = 0;
            short inacchi = 0;
            short tdf = 0;
            String ackTime = "-";
            if (!readAckTime.equals("0")) {
                UtcT utcT_readAckTime = new UtcT(new Long(readAckTime).longValue(), inacclo, inacchi, tdf);
                ackTime = new TimeConverter().formatTime(utcT_readAckTime);
            }
            this.myAttributeValue.put("ACK_TIME", ackTime);
            UtcT utcT_eventTime = new UtcT(new Long(eventTime).longValue(), inacclo, inacchi, tdf);
            String time = Long.toString(utcT_eventTime.time);
            this.myAttributeValue.put("EVENT_TIME", time);
        }
        catch (Exception e) {
            Log.logError((String)("Wrong format of the alarm_log.xml: " + tokens), (Throwable)e);
            this.errorInRecord = false;
        }
    }

    public String getEventTime() {
        return (String)this.myAttributeValue.get("EVENT_TIME");
    }

    public String getNotificationId() {
        return (String)this.myAttributeValue.get("NOTIFICATION_ID");
    }

    public boolean getErrorInRecord() {
        return this.errorInRecord;
    }

    private String getStringValue(String tag) {
        return this.myAttributeValue.get(tag).toString();
    }
}

