/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.fm.am;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import se.ericsson.cello.emas.fm.common.AlarmSortedTable;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationView;

public class AlarmApplicationView
extends AbstractApplicationView {
    JMenu jMenuAlarm;
    JMenu jMenuView;
    JMenu subMenuAlarmType;
    JMenuItem jMenuItemRefresh;
    JMenu hyperlinks = null;
    JMenuItem jMenuItemAck;
    JMenuItem jMenuItemUnAck;
    JMenuItem jMenuItemDetails;
    JMenuItem jMenuItemHelpOnAlarm;
    JCheckBoxMenuItem jMenuItemSound;
    JCheckBoxMenuItem jMenuItemComm;
    JCheckBoxMenuItem jMenuItemEnv;
    JCheckBoxMenuItem jMenuItemEqu;
    JCheckBoxMenuItem jMenuItemProcess;
    JCheckBoxMenuItem jMenuItemQos;
    JMenuItem popupmenuitemAck;
    JMenuItem popupmenuitemUnAck;
    JMenuItem popupmenuitemDetails;
    JMenuItem popupmenuitemHelpOnAlarm;
    JPopupMenu mypopupmenu;
    BorderLayout borderLayout;
    AlarmSortedTable jTable1;
    AlarmSortedTable jTable2;
    JScrollPane jScrollPane1;
    JScrollPane jScrollPane2;
    JPanel jPanel1;
    JPanel jPanel2;
    JPanel jPanel3;
    JPanel jPanel4;
    JPanel jPanel5;
    JPanel SummaryPanel1;
    JPanel SummaryPanel2;
    JSplitPane jSplitPane1;
    JLabel TopLabel1;
    JLabel TopLabel2;
    JLabel TopLabel3;
    JLabel TopLabel4;
    JLabel BotLabel1;
    JLabel BotLabel2;
    JLabel BotLabel3;
    JLabel BotLabel4;
    JLabel SummaryLabel1;
    JLabel SummaryLabel2;
    JLabel CriLabel1;
    JLabel MajLabel1;
    JLabel MinLabel1;
    JLabel WarnLabel1;
    JLabel IndetLabel1;
    JLabel CriLabel2;
    JLabel MajLabel2;
    JLabel MinLabel2;
    JLabel WarnLabel2;
    JLabel IndetLabel2;
    JLabel idTitleLabel;
    JLabel idValueLabel;
    JMenuItem printMenuItem = new JMenuItem("PRINT");
    JMenuItem exportMenuItem = new JMenuItem("EXPORT");
    private boolean hasAck = false;
    JMenuItem pageLayoutMenuItem = new JMenuItem("PAGE_LAYOUT");

    protected void init() {
        try {
            this.checkAckStatus();
            this.initMenu();
            this.setLayout(new BorderLayout());
            this.initComps();
            this.add(this.jPanel5, "North");
            if (this.hasAck) {
                this.add(this.jSplitPane1, "Center");
            } else {
                this.add(this.jPanel1, "Center");
            }
        }
        catch (Exception e) {
            Log.logError(null, (Throwable)e);
        }
    }

    private void checkAckStatus() {
        String columnTag = null;
        try {
            columnTag = this.getApplication().getLanguageBundle().getString("ACKNOWLEDGEMENT_USED");
            if (columnTag.equals("Yes")) {
                this.hasAck = true;
            }
        }
        catch (Exception e) {
            this.hasAck = false;
            return;
        }
    }

    private void initMenu() {
        this.jMenuAlarm = new JMenu("MENU1");
        if (this.hasAck) {
            this.jMenuItemAck = new JMenuItem("ACKNOWLEDGE");
            this.jMenuItemUnAck = new JMenuItem("UNACKNOWLEDGE");
            this.jMenuAlarm.add(this.jMenuItemAck);
            this.jMenuAlarm.add(this.jMenuItemUnAck);
            this.jMenuItemAck.setEnabled(false);
            this.jMenuItemUnAck.setEnabled(false);
        }
        this.jMenuItemDetails = new JMenuItem("ADDITIONAL_INFO");
        this.jMenuItemHelpOnAlarm = new JMenuItem("HELP_ON_ALARM");
        this.jMenuAlarm.add(this.jMenuItemDetails);
        this.jMenuItemDetails.setEnabled(false);
        this.jMenuItemHelpOnAlarm.setEnabled(false);
        this.jMenuItemHelpOnAlarm.putClientProperty("HELP_ENABLE", "");
        this.jMenuItemSound = new JCheckBoxMenuItem("SOUND_INDICATION_MENUITEM");
        this.jMenuItemSound.setState(false);
        this.jMenuAlarm.add(this.jMenuItemSound);
        this.jMenuView = new JMenu("MENU2");
        this.subMenuAlarmType = new JMenu("SUBMENU1");
        this.jMenuItemRefresh = new JMenuItem("REFRESH");
        this.jMenuView.add(this.subMenuAlarmType);
        this.jMenuView.add(this.jMenuItemRefresh);
        this.jMenuItemComm = new JCheckBoxMenuItem("COMMUNICATIONS_ALARM");
        this.jMenuItemEnv = new JCheckBoxMenuItem("ENVIRONMENTAL_ALARM");
        this.jMenuItemEqu = new JCheckBoxMenuItem("EQUIPMENT_ALARM");
        this.jMenuItemProcess = new JCheckBoxMenuItem("PROCESSING_ERROR_ALARM");
        this.jMenuItemQos = new JCheckBoxMenuItem("QOS_ALARM");
        this.jMenuItemComm.setState(true);
        this.jMenuItemEnv.setState(true);
        this.jMenuItemEqu.setState(true);
        this.jMenuItemProcess.setState(true);
        this.jMenuItemQos.setState(true);
        this.subMenuAlarmType.add(this.jMenuItemComm);
        this.subMenuAlarmType.add(this.jMenuItemEnv);
        this.subMenuAlarmType.add(this.jMenuItemEqu);
        this.subMenuAlarmType.add(this.jMenuItemProcess);
        this.subMenuAlarmType.add(this.jMenuItemQos);
        this.mypopupmenu = new JPopupMenu();
        if (this.hasAck) {
            this.popupmenuitemAck = new JMenuItem("ACKNOWLEDGE_POPUP");
            this.popupmenuitemUnAck = new JMenuItem("UNACKNOWLEDGE_POPUP");
            this.mypopupmenu.add(this.popupmenuitemAck);
            this.mypopupmenu.add(this.popupmenuitemUnAck);
            this.popupmenuitemAck.setEnabled(false);
            this.popupmenuitemUnAck.setEnabled(false);
        }
        this.popupmenuitemDetails = new JMenuItem("ADDITIONAL_INFO_POPUP");
        this.popupmenuitemHelpOnAlarm = new JMenuItem("HELP_ON_ALARM_POPUP");
        this.mypopupmenu.add(this.popupmenuitemDetails);
        this.mypopupmenu.add(this.popupmenuitemHelpOnAlarm);
        this.popupmenuitemDetails.setEnabled(false);
        this.popupmenuitemHelpOnAlarm.setEnabled(false);
        this.popupmenuitemHelpOnAlarm.putClientProperty("HELP_ENABLE", "");
    }

    public JMenuItem[] getFileMenuItems() {
        return new JMenuItem[]{this.printMenuItem, this.pageLayoutMenuItem, this.exportMenuItem};
    }

    private void initComps() {
        this.jTable1 = new AlarmSortedTable();
        if (this.hasAck) {
            this.jTable2 = new AlarmSortedTable();
            this.jTable2.setSelectionMode(2);
            this.jTable2.setShowGrid(false);
            this.jPanel2 = new JPanel(new GridBagLayout());
            this.jPanel4 = new JPanel(new GridBagLayout());
            this.jScrollPane2 = new JScrollPane((Component)((Object)this.jTable2));
        }
        this.jTable1.setSelectionMode(2);
        this.jTable1.setShowGrid(false);
        this.jPanel1 = new JPanel(new GridBagLayout());
        this.jPanel3 = new JPanel(new GridBagLayout());
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        this.jPanel5 = new JPanel(flowLayout);
        this.jScrollPane1 = new JScrollPane((Component)((Object)this.jTable1));
        this.jPanel1.add((Component)this.jScrollPane1, new GridBagConstraints(0, 2, 1, 1, 10.0, 10.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel3, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel5, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (this.hasAck) {
            this.jPanel2.add((Component)this.jScrollPane2, new GridBagConstraints(0, 1, 1, 1, 10.0, 10.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel2.add((Component)this.jPanel4, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.TopLabel1 = new JLabel("NEWLABEL");
        this.TopLabel2 = new JLabel();
        this.TopLabel2.putClientProperty("LANGUAGE_CONTROLLED", "NA");
        this.TopLabel3 = new JLabel("CHANGED");
        this.TopLabel4 = new JLabel();
        this.TopLabel4.putClientProperty("LANGUAGE_CONTROLLED", "NA");
        this.TopLabel1.setForeground(Color.black);
        this.TopLabel2.setForeground(Color.black);
        this.TopLabel3.setForeground(Color.black);
        this.TopLabel4.setForeground(Color.black);
        if (this.hasAck) {
            this.BotLabel1 = new JLabel("ACKNOWLEDGEDLABEL");
            this.BotLabel2 = new JLabel();
            this.BotLabel2.putClientProperty("LANGUAGE_CONTROLLED", "NA");
            this.BotLabel3 = new JLabel("CHANGED");
            this.BotLabel4 = new JLabel();
            this.BotLabel4.putClientProperty("LANGUAGE_CONTROLLED", "NA");
            this.BotLabel1.setForeground(Color.black);
            this.BotLabel2.setForeground(Color.black);
            this.BotLabel3.setForeground(Color.black);
            this.BotLabel4.setForeground(Color.black);
        }
        this.idTitleLabel = new JLabel("ID_TITLE_LABEL");
        this.idValueLabel = new JLabel();
        this.idValueLabel.putClientProperty("LANGUAGE_CONTROLLED", "NA");
        this.idTitleLabel.setForeground(Color.black);
        this.idValueLabel.setForeground(Color.black);
        this.jPanel5.add((Component)this.idTitleLabel, null);
        this.jPanel5.add((Component)this.idValueLabel, null);
        this.jPanel5.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        this.jPanel3.add((Component)this.TopLabel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.TopLabel2, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.TopLabel3, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.TopLabel4, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (this.hasAck) {
            this.jPanel4.add((Component)this.BotLabel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel4.add((Component)this.BotLabel2, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel4.add((Component)this.BotLabel3, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel4.add((Component)this.BotLabel4, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jSplitPane1 = new JSplitPane(0, this.jPanel1, this.jPanel2);
            this.jSplitPane1.setOneTouchExpandable(true);
            this.jSplitPane1.setDividerSize(25);
            Dimension windim = this.getPreferredSize();
            int winhgt = windim.height;
            this.jSplitPane1.setDividerLocation(winhgt / 2 - this.jSplitPane1.getDividerSize());
        }
        this.SummaryLabel1 = new JLabel("ALARMSUMMARY1");
        this.SummaryLabel1.setForeground(Color.black);
        this.CriLabel1 = new JLabel("CRILABEL1", 0);
        this.MajLabel1 = new JLabel("MAJLABEL1", 0);
        this.MinLabel1 = new JLabel("MINLABEL1", 0);
        this.WarnLabel1 = new JLabel("WARNLABEL1", 0);
        this.IndetLabel1 = new JLabel("INDETLABEL1", 0);
        this.SummaryPanel1 = new JPanel();
        this.CriLabel1.putClientProperty("LANGUAGE_CONTROLLED", "NA");
        this.CriLabel1.setText(Integer.toString(0));
        this.CriLabel1.setBorder(BorderFactory.createLineBorder(Color.black));
        this.CriLabel1.setOpaque(true);
        this.CriLabel1.setBackground(Color.red);
        this.CriLabel1.setForeground(Color.black);
        this.MajLabel1.putClientProperty("LANGUAGE_CONTROLLED", "NA");
        this.MajLabel1.setText(Integer.toString(0));
        this.MajLabel1.setBorder(BorderFactory.createLineBorder(Color.black));
        this.MajLabel1.setOpaque(true);
        this.MajLabel1.setBackground(new Color(255, 153, 0));
        this.MajLabel1.setForeground(Color.black);
        this.MinLabel1.putClientProperty("LANGUAGE_CONTROLLED", "NA");
        this.MinLabel1.setText(Integer.toString(0));
        this.MinLabel1.setBorder(BorderFactory.createLineBorder(Color.black));
        this.MinLabel1.setOpaque(true);
        this.MinLabel1.setBackground(Color.yellow);
        this.MinLabel1.setForeground(Color.black);
        this.WarnLabel1.putClientProperty("LANGUAGE_CONTROLLED", "NA");
        this.WarnLabel1.setText(Integer.toString(0));
        this.WarnLabel1.setBorder(BorderFactory.createLineBorder(Color.black));
        this.WarnLabel1.setOpaque(true);
        this.WarnLabel1.setBackground(new Color(51, 153, 204));
        this.WarnLabel1.setForeground(Color.black);
        this.IndetLabel1.putClientProperty("LANGUAGE_CONTROLLED", "NA");
        this.IndetLabel1.setText(Integer.toString(0));
        this.IndetLabel1.setBorder(BorderFactory.createLineBorder(Color.black));
        this.IndetLabel1.setOpaque(true);
        this.IndetLabel1.setBackground(new Color(153, 204, 204));
        this.IndetLabel1.setForeground(Color.black);
        this.SummaryPanel1.setLayout(new GridBagLayout());
        this.SummaryPanel1.add((Component)this.SummaryLabel1, new GridBagConstraints(0, 0, 1, 1, 4.0, 1.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        this.SummaryPanel1.add((Component)this.CriLabel1, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.SummaryPanel1.add((Component)this.MajLabel1, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.SummaryPanel1.add((Component)this.MinLabel1, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.SummaryPanel1.add((Component)this.WarnLabel1, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.SummaryPanel1.add((Component)this.IndetLabel1, new GridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 20), 0, 0));
        this.jPanel3.add((Component)this.SummaryPanel1, new GridBagConstraints(5, 0, 1, 1, 4.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (this.hasAck) {
            this.SummaryLabel2 = new JLabel("ALARMSUMMARY2");
            this.SummaryLabel2.setForeground(Color.black);
            this.CriLabel2 = new JLabel("CRILABEL2", 0);
            this.MajLabel2 = new JLabel("MAJLABEL2", 0);
            this.MinLabel2 = new JLabel("MINLABEL2", 0);
            this.WarnLabel2 = new JLabel("WARNLABEL2", 0);
            this.IndetLabel2 = new JLabel("INDETLABEL2", 0);
            this.SummaryPanel2 = new JPanel();
            this.CriLabel2.putClientProperty("LANGUAGE_CONTROLLED", "NA");
            this.CriLabel2.setText(Integer.toString(0));
            this.CriLabel2.setBorder(BorderFactory.createLineBorder(Color.black));
            this.CriLabel2.setOpaque(true);
            this.CriLabel2.setBackground(Color.red);
            this.CriLabel2.setForeground(Color.black);
            this.MajLabel2.putClientProperty("LANGUAGE_CONTROLLED", "NA");
            this.MajLabel2.setText(Integer.toString(0));
            this.MajLabel2.setBorder(BorderFactory.createLineBorder(Color.black));
            this.MajLabel2.setOpaque(true);
            this.MajLabel2.setBackground(new Color(255, 153, 0));
            this.MajLabel2.setForeground(Color.black);
            this.MinLabel2.putClientProperty("LANGUAGE_CONTROLLED", "NA");
            this.MinLabel2.setText(Integer.toString(0));
            this.MinLabel2.setBorder(BorderFactory.createLineBorder(Color.black));
            this.MinLabel2.setOpaque(true);
            this.MinLabel2.setBackground(Color.yellow);
            this.MinLabel2.setForeground(Color.black);
            this.WarnLabel2.putClientProperty("LANGUAGE_CONTROLLED", "NA");
            this.WarnLabel2.setText(Integer.toString(0));
            this.WarnLabel2.setBorder(BorderFactory.createLineBorder(Color.black));
            this.WarnLabel2.setOpaque(true);
            this.WarnLabel2.setBackground(new Color(51, 153, 204));
            this.WarnLabel2.setForeground(Color.black);
            this.IndetLabel2.putClientProperty("LANGUAGE_CONTROLLED", "NA");
            this.IndetLabel2.setText(Integer.toString(0));
            this.IndetLabel2.setBorder(BorderFactory.createLineBorder(Color.black));
            this.IndetLabel2.setOpaque(true);
            this.IndetLabel2.setBackground(new Color(153, 204, 204));
            this.IndetLabel2.setForeground(Color.black);
            this.SummaryPanel2.setLayout(new GridBagLayout());
            this.SummaryPanel2.add((Component)this.SummaryLabel2, new GridBagConstraints(0, 0, 1, 1, 4.0, 1.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
            this.SummaryPanel2.add((Component)this.CriLabel2, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.SummaryPanel2.add((Component)this.MajLabel2, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.SummaryPanel2.add((Component)this.MinLabel2, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.SummaryPanel2.add((Component)this.WarnLabel2, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.SummaryPanel2.add((Component)this.IndetLabel2, new GridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 20), 0, 0));
            this.jPanel4.add((Component)this.SummaryPanel2, new GridBagConstraints(5, 0, 1, 1, 4.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public JMenu[] getMenus() {
        return new JMenu[]{this.jMenuView, this.jMenuAlarm};
    }

    public JComponent[] getToolBarComponents() {
        return null;
    }

    public Dimension getPreferredSize() {
        return new Dimension(550, 420);
    }

    public void tidyUp() {
        this.jTable1.getColumnModel().getColumn(0).setCellRenderer(null);
        if (this.hasAck) {
            this.jTable2.getColumnModel().getColumn(0).setCellRenderer(null);
        }
        try {
            Field[] fields = ((Object)((Object)this)).getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!(!Modifier.isFinal(field.getModifiers()) & !field.getType().isPrimitive())) continue;
                fields[i].set((Object)this, null);
            }
        }
        catch (Throwable t) {
            Log.logError(null, (Throwable)t);
        }
    }

    void activateHyperlinks(JMenu hl) {
        if (this.hyperlinks != null) {
            this.jMenuAlarm.remove(this.hyperlinks);
            this.mypopupmenu.remove(this.hyperlinks);
        }
        this.hyperlinks = hl;
        this.jMenuAlarm.add(hl);
        this.mypopupmenu.add(hl);
    }

    void deactivateHyperlinks() {
        if (this.hyperlinks != null) {
            this.jMenuAlarm.remove(this.hyperlinks);
            this.mypopupmenu.remove(this.hyperlinks);
        }
    }

    public void setHelpOnWindowKey() {
        JMenu helpMenu = this.getHelpMenu();
        JMenuItem onWindowMenuItem = helpMenu.getItem(0);
        onWindowMenuItem.putClientProperty("HELP_KEY", "FAULTMANAGEMENT_ALARMLIST_BUTTON_HELP");
    }
}

