/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.internaltransport;

import enea.ose.system.Signal;
import se.ericsson.cello.equipment.CppBoardMarker;
import se.ericsson.cello.equipment.SlotMoInternal;
import se.ericsson.cello.equipment.SubrackMoInternal;
import se.ericsson.cello.internaltransport.EquipmentInternal;
import se.ericsson.cello.internaltransport.SwitchExtensionUnitMo;
import se.ericsson.cello.internaltransport.SwitchInternalLinkPortMo;
import se.ericsson.cello.internaltransport.SwitchInternalLinkPortMoFactoryExtended;
import se.ericsson.cello.internaltransport.SwitchUnitInterface;
import se.ericsson.cello.internaltransport.fropxy.NssSxuFroCreateRsp;
import se.ericsson.cello.internaltransport.fropxy.NssSxuFroDeleteRsp;
import se.ericsson.cello.internaltransport.fropxy.NssSxuFroProxy;
import se.ericsson.cello.internaltransport.fropxy.NssSxuFroSetAdmStateRsp;
import se.ericsson.cello.internaltransport.fropxy.NssSxuGetAttrRsp;
import se.ericsson.cello.internaltransport.fropxy.SpasSiliFroCreateRsp;
import se.ericsson.cello.internaltransport.fropxy.SpasSiliFroDeleteRsp;
import se.ericsson.cello.internaltransport.fropxy.SpasSiliFroProxy;
import se.ericsson.cello.internaltransport.fropxy.SpasSiliFroSetAdmStateRsp;
import se.ericsson.cello.internaltransport.fropxy.SpasSiliGetAttrRsp;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class SwitchExtensionUnitMoImpl
extends ManagedObjectBase
implements SwitchExtensionUnitMo,
SwitchUnitInterface,
EquipmentInternal,
CppBoardMarker,
Reservable {
    private MoData data;
    private StringAttribute userLabel;
    private SequenceAttribute reservedBy;
    private IntegerAttribute silifroId;
    private IntegerAttribute nssfroId;
    private SwitchInternalLinkPortMoFactoryExtended switchInternalLinkPortMoFactory = (SwitchInternalLinkPortMoFactoryExtended)MoFactoryMgr.instance().lookup("SwitchInternalLinkPort");
    public static final String NSS_RESOURCE_ID = "nss_resourceId";
    public static final String SPAS_RESOURCE_ID = "spas_resourceId";
    private static NssSxuFroProxy nssSxuFroProxy = NssSxuFroProxy.instance();
    private static SpasSiliFroProxy spasSiliFroProxy = SpasSiliFroProxy.instance();
    private static final int MO_DATA_REVISION_31 = 3000;
    private static final int MO_DATA_REVISION_LATEST = 3000;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"PlugInUnit");
        MoAttributeValidator.checkIdentity((String)"SwitchExtensionUnit", (String)string);
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"SwitchExtensionUnit", (int)1);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"SwitchExtensionUnit", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeStateSil", (AttrList)attrList, (boolean)false, (int)1, (int)1, (int)2, (String)"SwitchExtensionUnit");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"SwitchExtensionUnit");
        return new SwitchExtensionUnitMoImpl(managedObject, string, string2, n, coordinator);
    }

    private SwitchExtensionUnitMoImpl(ManagedObject managedObject, String string, String string2, int n, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "SwitchExtensionUnit", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.reservedBy = new SequenceAttribute("reservedBy", true);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        ManagedObject managedObject2 = this.getParent();
        SlotMoInternal slotMoInternal = (SlotMoInternal)managedObject2.getParent();
        SubrackMoInternal subrackMoInternal = (SubrackMoInternal)slotMoInternal.getParent();
        int n2 = slotMoInternal.getAsciPortNumber(coordinator);
        int n3 = subrackMoInternal.getSwitchModuleNumber(coordinator);
        SpasSiliFroCreateRsp spasSiliFroCreateRsp = spasSiliFroProxy.sendSpasSiliFroCreateReq(coordinator.getTransactionID(), n3, n2, n);
        this.checkSignal((Signal)spasSiliFroCreateRsp);
        if (spasSiliFroCreateRsp.getResult() != 1) {
            throw new FroRequestFailedException("SwitchExtensionUnit", "SpasSili", "CreateFroReq: " + spasSiliFroProxy.getResultMsg(spasSiliFroCreateRsp.getResult()), spasSiliFroCreateRsp.getResult());
        }
        this.silifroId = new IntegerAttribute(SPAS_RESOURCE_ID, false, spasSiliFroCreateRsp.getFroId());
        this.data.registerPersistentAttr((Attribute)this.silifroId);
        NssSxuFroCreateRsp nssSxuFroCreateRsp = nssSxuFroProxy.sendNssSxuFroCreateReq(coordinator.getTransactionID(), n, n3, n2);
        this.checkSignal((Signal)nssSxuFroCreateRsp);
        if (nssSxuFroCreateRsp.getResult() != 0) {
            throw new FroRequestFailedException("SwitchExtensionUnit", "NssSxu", "CreateFroReq: " + nssSxuFroProxy.getResultMsg(nssSxuFroCreateRsp.getResult()), nssSxuFroCreateRsp.getResult());
        }
        this.nssfroId = new IntegerAttribute(NSS_RESOURCE_ID, false, nssSxuFroCreateRsp.getFroId());
        this.data.registerPersistentAttr((Attribute)this.nssfroId);
        this.data.setRevision(3000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        spasSiliFroProxy.registerForNotifications(coordinator, this, this.silifroId.getValue(coordinator));
        nssSxuFroProxy.registerForNotifications(coordinator, this, this.nssfroId.getValue(coordinator));
    }

    public SwitchExtensionUnitMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute(SPAS_RESOURCE_ID);
        moDataRecoveryHelper.assertAttribute(NSS_RESOURCE_ID);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.reservedBy = (SequenceAttribute)moData.getAttribute("reservedBy");
        this.silifroId = (IntegerAttribute)moData.getAttribute(SPAS_RESOURCE_ID);
        this.nssfroId = (IntegerAttribute)moData.getAttribute(NSS_RESOURCE_ID);
        spasSiliFroProxy.registerForNotifications(null, this, this.silifroId.getValue(null));
        nssSxuFroProxy.registerForNotifications(null, this, this.nssfroId.getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (!this.reservedBy.isEmpty()) {
            throw new MoReservedNotDeletableException("SwitchExtensionUnit");
        }
        SpasSiliFroDeleteRsp spasSiliFroDeleteRsp = spasSiliFroProxy.sendSpasSiliFroDeleteReq(coordinator.getTransactionID(), this.silifroId.getValue(coordinator));
        this.checkSignal((Signal)spasSiliFroDeleteRsp);
        if (spasSiliFroDeleteRsp.getResult() != 1) {
            throw new FroRequestFailedException("SwitchExtensionUnit", "SpasSili", "DeleteFroReq: " + spasSiliFroProxy.getResultMsg(spasSiliFroDeleteRsp.getResult()), spasSiliFroDeleteRsp.getResult());
        }
        NssSxuFroDeleteRsp nssSxuFroDeleteRsp = nssSxuFroProxy.sendNssSxuFroDeleteReq(coordinator.getTransactionID(), this.nssfroId.getValue(coordinator));
        this.checkSignal((Signal)nssSxuFroDeleteRsp);
        if (nssSxuFroDeleteRsp.getResult() != 0) {
            throw new FroRequestFailedException("SwitchExtensionUnit", "NssSxu", "DeleteFroReq: " + nssSxuFroProxy.getResultMsg(nssSxuFroDeleteRsp.getResult()), nssSxuFroDeleteRsp.getResult());
        }
        spasSiliFroProxy.deregisterForNotifications(coordinator, this.silifroId.getValue(coordinator));
        nssSxuFroProxy.deregisterForNotifications(coordinator, this.nssfroId.getValue(coordinator));
        this.deleteChildren(coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"SwitchExtensionUnit", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getAsciPortNumber(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((SlotMoInternal)this.getParent().getParent()).getAsciPortNumber(coordinator);
    }

    public int getSwitchModuleNumber(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((SubrackMoInternal)this.getParent().getParent().getParent()).getSwitchModuleNumber(coordinator);
    }

    public int getAdministrativeStateSil(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SpasSiliGetAttrRsp spasSiliGetAttrRsp = spasSiliFroProxy.sendSpasSiliGetAttrReq(this.getTranId(coordinator), this.silifroId.getValue(coordinator));
        this.checkSignal((Signal)spasSiliGetAttrRsp);
        if (spasSiliGetAttrRsp.getResult() != 1) {
            throw new FroRequestFailedException("SwitchExtensionUnit", "SpasSili", "GetAttrReq: " + spasSiliFroProxy.getResultMsg(spasSiliGetAttrRsp.getResult()), spasSiliGetAttrRsp.getResult());
        }
        return spasSiliGetAttrRsp.getAdmStateSili();
    }

    public void setAdministrativeStateSil(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n != 0 && n != 1) {
            throw new ValueOutOfRangeException("administrativeStateSil", "SwitchExtensionUnit");
        }
        SpasSiliFroSetAdmStateRsp spasSiliFroSetAdmStateRsp = spasSiliFroProxy.sendSpasSiliFroSetAdmStateReq(coordinator.getTransactionID(), this.silifroId.getValue(coordinator), n);
        this.checkSignal((Signal)spasSiliFroSetAdmStateRsp);
        if (spasSiliFroSetAdmStateRsp.getResult() != 1) {
            throw new FroRequestFailedException("SwitchExtensionUnit", "SpasSili", "SetAttrReq: " + spasSiliFroProxy.getResultMsg(spasSiliFroSetAdmStateRsp.getResult()), spasSiliFroSetAdmStateRsp.getResult());
        }
        NssSxuFroSetAdmStateRsp nssSxuFroSetAdmStateRsp = nssSxuFroProxy.sendNssSxuFroSetAdmStateReq(coordinator.getTransactionID(), this.nssfroId.getValue(coordinator), n);
        this.checkSignal((Signal)nssSxuFroSetAdmStateRsp);
        if (nssSxuFroSetAdmStateRsp.getResult() != 0) {
            throw new FroRequestFailedException("SwitchExtensionUnit", "NssSxu", "SetAttrReq: " + nssSxuFroProxy.getResultMsg(nssSxuFroSetAdmStateRsp.getResult()), nssSxuFroSetAdmStateRsp.getResult());
        }
        String[] stringArray = new String[]{"administrativeStateSil"};
        Object[] objectArray = new Object[]{new Integer(n)};
        SwitchExtensionUnitMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
    }

    public int getOperationalStateSil(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SpasSiliGetAttrRsp spasSiliGetAttrRsp = spasSiliFroProxy.sendSpasSiliGetAttrReq(this.getTranId(coordinator), this.silifroId.getValue(coordinator));
        this.checkSignal((Signal)spasSiliGetAttrRsp);
        if (spasSiliGetAttrRsp.getResult() != 1) {
            throw new FroRequestFailedException("SwitchExtensionUnit", "SpasSili", "GetAttrReq: " + spasSiliFroProxy.getResultMsg(spasSiliGetAttrRsp.getResult()), spasSiliGetAttrRsp.getResult());
        }
        return spasSiliGetAttrRsp.getOpStateSili();
    }

    public int getOperationalStateSync(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssSxuGetAttrRsp nssSxuGetAttrRsp = nssSxuFroProxy.sendNssSxuGetAttrReq(this.getTranId(coordinator), this.nssfroId.getValue(coordinator));
        this.checkSignal((Signal)nssSxuGetAttrRsp);
        if ((int)nssSxuGetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("SwitchExtensionUnit", "NssSxu", "GetAttrReq: " + nssSxuFroProxy.getResultMsg((int)nssSxuGetAttrRsp.getResult()), (int)nssSxuGetAttrRsp.getResult());
        }
        return nssSxuGetAttrRsp.getOpStateSxu();
    }

    public int getAvailabilityStatusSil(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SpasSiliGetAttrRsp spasSiliGetAttrRsp = spasSiliFroProxy.sendSpasSiliGetAttrReq(this.getTranId(coordinator), this.silifroId.getValue(coordinator));
        this.checkSignal((Signal)spasSiliGetAttrRsp);
        if (spasSiliGetAttrRsp.getResult() != 1) {
            throw new FroRequestFailedException("SwitchExtensionUnit", "SpasSili", "GetAttrReq: " + spasSiliFroProxy.getResultMsg(spasSiliGetAttrRsp.getResult()), spasSiliGetAttrRsp.getResult());
        }
        return AvailConverter.convert((int)spasSiliGetAttrRsp.getAvailStateSili());
    }

    public int getAvailabilityStatusSync(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssSxuGetAttrRsp nssSxuGetAttrRsp = nssSxuFroProxy.sendNssSxuGetAttrReq(this.getTranId(coordinator), this.nssfroId.getValue(coordinator));
        this.checkSignal((Signal)nssSxuGetAttrRsp);
        if ((int)nssSxuGetAttrRsp.getResult() != 0) {
            throw new FroRequestFailedException("SwitchExtensionUnit", "NssFro", "GetAttrReq: " + nssSxuFroProxy.getResultMsg((int)nssSxuGetAttrRsp.getResult()), (int)nssSxuGetAttrRsp.getResult());
        }
        return nssSxuGetAttrRsp.getAvailStateSxu();
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Attribute[] attributeArray = this.reservedBy.getValue(coordinator);
        ManagedObject[] managedObjectArray = new ManagedObject[attributeArray.length];
        for (int i = 0; i < attributeArray.length; ++i) {
            managedObjectArray[i] = ((ReferenceAttribute)attributeArray[i]).getValue(coordinator);
        }
        return managedObjectArray;
    }

    public int[] getSilPorts(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SpasSiliGetAttrRsp spasSiliGetAttrRsp = spasSiliFroProxy.sendSpasSiliGetAttrReq(this.getTranId(coordinator), this.silifroId.getValue(coordinator));
        this.checkSignal((Signal)spasSiliGetAttrRsp);
        if (spasSiliGetAttrRsp.getResult() != 1) {
            throw new FroRequestFailedException("SwitchExtensionUnit", "SpasSili", "GetAttrReq: " + spasSiliFroProxy.getResultMsg(spasSiliGetAttrRsp.getResult()), spasSiliGetAttrRsp.getResult());
        }
        return spasSiliGetAttrRsp.getActivePorts();
    }

    public int actionGetSilPortState(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SpasSiliGetAttrRsp spasSiliGetAttrRsp = spasSiliFroProxy.sendSpasSiliGetAttrReq(this.getTranId(coordinator), this.silifroId.getValue(coordinator));
        this.checkSignal((Signal)spasSiliGetAttrRsp);
        if (spasSiliGetAttrRsp.getResult() != 1) {
            throw new FroRequestFailedException("SwitchExtensionUnit", "SpasSili", "GetAllAttrReq: " + spasSiliFroProxy.getResultMsg(spasSiliGetAttrRsp.getResult()), spasSiliGetAttrRsp.getResult());
        }
        return spasSiliGetAttrRsp.getSilPortState(n);
    }

    public int actionGetSilOperState(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SpasSiliGetAttrRsp spasSiliGetAttrRsp = spasSiliFroProxy.sendSpasSiliGetAttrReq(this.getTranId(coordinator), this.silifroId.getValue(coordinator));
        this.checkSignal((Signal)spasSiliGetAttrRsp);
        if (spasSiliGetAttrRsp.getResult() != 1) {
            throw new FroRequestFailedException("SwitchExtensionUnit", "SpasSili", "GetAttrReq: " + spasSiliFroProxy.getResultMsg(spasSiliGetAttrRsp.getResult()), spasSiliGetAttrRsp.getResult());
        }
        return spasSiliGetAttrRsp.getSilOperState(n);
    }

    public int actionGetSilAvailState(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SpasSiliGetAttrRsp spasSiliGetAttrRsp = spasSiliFroProxy.sendSpasSiliGetAttrReq(this.getTranId(coordinator), this.silifroId.getValue(coordinator));
        this.checkSignal((Signal)spasSiliGetAttrRsp);
        if (spasSiliGetAttrRsp.getResult() != 1) {
            throw new FroRequestFailedException("SwitchExtensionUnit", "SpasSili", "GetAttrReq: " + spasSiliFroProxy.getResultMsg(spasSiliGetAttrRsp.getResult()), spasSiliGetAttrRsp.getResult());
        }
        return AvailConverter.convert((int)spasSiliGetAttrRsp.getSilAvailState(n));
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"SwitchExtensionUnit", (MoData)this.data, (SequenceAttribute)this.reservedBy);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedBy = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"SwitchExtensionUnit", (MoData)this.data, (SequenceAttribute)this.reservedBy);
    }

    public int getSpasResourceId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.silifroId.getValue(coordinator);
    }

    public int getNssResourceId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.nssfroId.getValue(coordinator);
    }

    private void checkSignal(Signal signal) throws FroNotAccessibleException {
        if (signal == null) {
            throw new FroNotAccessibleException("SwitchExtensionUnit", "SXU Fro");
        }
    }

    public String getType() {
        return "SwitchExtensionUnit";
    }

    private int getTranId(Coordinator coordinator) {
        return MoAttributeValidator.getTransactionId((Coordinator)coordinator);
    }

    private static void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        NotificationSender notificationSender = NotificationSender.instance();
        notificationSender.pushAVC(managedObject, stringArray, objectArray, coordinator);
    }

    public void createSILP(int n, Coordinator coordinator) throws MoAccessException {
        AttrListImpl attrListImpl = new AttrListImpl();
        this.switchInternalLinkPortMoFactory.autoCreateMo(this, (AttrList)attrListImpl, Integer.toString(n), null, coordinator);
    }

    public void deleteSILP(int n, Coordinator coordinator) throws MoAccessException {
        this.deleteChildMo(Integer.toString(n), coordinator);
    }

    private void deleteChildMo(String string, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        MoIterator moIterator = this.getChildren();
        boolean bl = false;
        while (moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (!managedObject.getType().equals("SwitchInternalLinkPort") || !((SwitchInternalLinkPortMo)managedObject).getNamingAttributeValue().equals(string)) continue;
            bl = true;
            managedObject.delete(coordinator);
            break;
        }
        if (!bl) {
            MessageLog.info(this.getClass(), (String)" SwitchInternalLinkPortMo to be deleted not found");
        }
    }

    private void deleteChildren(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (!managedObject.getType().equals("SwitchInternalLinkPort")) continue;
            managedObject.delete(coordinator);
        }
    }
}

