/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.nodeservicestool.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.text.html.HTMLDocument;
import se.ericsson.cello.emt.nodeservicestool.view.NodeMonitorController;
import se.ericsson.cello.emt.nodeservicestool.view.NodeMonitorView;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeMonitorGui
extends JFrame
implements NodeMonitorView,
ActionListener {
    private static final EmLogger LOG = EmLogger.NODE_SERVICE;
    private Image iconImage;
    private JPanel topPanel;
    private JPanel centerPanel;
    private JPanel bottomPanel;
    private JPanel panel1;
    private JPanel panel2;
    private JPanel panel3;
    private JPanel panel4;
    private JLabel status;
    private JTextArea statusText;
    private JLabel downTimeLabel;
    private JTextArea downTimeText;
    private JEditorPane infoText;
    private JButton closeAllButton;
    private JButton continueButton;
    private JLabel actionText;
    private JScrollPane scrollPane;
    private NodeMonitorController myNodeMonitorController = null;
    private static NodeMonitorGui uniqueInstance;
    private long startTime;
    private long currentTime;
    private Timer myTimer;
    private static final String STATUS_TEXT_CONNECTION_RESTORED = "Connection Restored";
    private static final String EXCLUDE_APP_RESTORE_CV = "Restore CV";
    private static final String EXCLUDE_APP_GET_FROM_FTP = "CV Get from FTP";
    private static final String BUTTON_TEXT_CONTINUE = "Continue";
    private static final String BUTTON_TEXT_CLOSE_ALL = "Close All";
    private List<String> myExcludedApps = new ArrayList<String>(0);
    private volatile boolean guiInitialized = false;
    private String myStatusText = "";
    private String myInfoText = "";
    private String myActionText = "";
    private String hostAddress;
    private static final String HTML_START = "<html><body>";
    private static final String HTML_END = "</body></html>";
    private static final String HTML_PARAGRAPH_START = "<p>";
    private static final String HTML_PARAGRAPH_END = "</p>";
    private static final String HTML_BOLD_START = "<b>";
    private static final String HTML_BOLD_END = "</b>";
    private static final String HTML_LINE_BREAK = "<br></br>";
    private static final Dimension DEFAULT_DIMENSION;
    private transient ActionListener listener = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            NodeMonitorGui.this.currentTime = System.currentTimeMillis();
            long elapsedTimeInMillisec = NodeMonitorGui.this.currentTime - NodeMonitorGui.this.startTime;
            String digTime = NodeMonitorGui.this.getDigitalTime(elapsedTimeInMillisec);
            NodeMonitorGui.this.downTimeText.setText(digTime);
        }
    };
    private static final long serialVersionUID = 1L;

    private NodeMonitorGui() {
        this.myExcludedApps.add(EXCLUDE_APP_RESTORE_CV);
        this.myExcludedApps.add(EXCLUDE_APP_GET_FROM_FTP);
    }

    public static NodeMonitorGui getNodeMonitorGui() {
        if (uniqueInstance == null) {
            LOG.info(" creates a NodeMonitorGui", new Object[0]);
            uniqueInstance = new NodeMonitorGui();
        }
        return uniqueInstance;
    }

    public static void clearUniqueInstance() {
        uniqueInstance = null;
    }

    public JFrame getMainWindow() {
        return this;
    }

    @Override
    public void initView() {
        if (!this.guiInitialized) {
            this.init();
            this.guiInitialized = true;
        }
    }

    private void init() {
        LOG.info(" instantiating the NodeMonitorGui", new Object[0]);
        EtchedBorder border = new EtchedBorder();
        this.status = new JLabel("Status:");
        this.statusText = new JTextArea("Connection Lost");
        this.statusText.setEditable(false);
        this.statusText.setBorder(border);
        this.statusText.setName("statusText");
        this.panel1 = new JPanel();
        this.panel1.setLayout(new FlowLayout(0));
        this.panel1.add(this.status);
        this.panel1.add(this.statusText);
        this.panel1.setName("panel1");
        this.downTimeLabel = new JLabel("Down time:");
        this.downTimeText = new JTextArea();
        this.downTimeText.setEditable(false);
        this.downTimeText.setBorder(border);
        this.downTimeText.setName("downTimeText");
        this.panel2 = new JPanel();
        this.panel2.setLayout(new FlowLayout(0));
        this.panel2.add(this.downTimeLabel);
        this.panel2.add(this.downTimeText);
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 1));
        this.topPanel.add(this.panel1);
        this.topPanel.add(this.panel2);
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BorderLayout());
        this.infoText = new JEditorPane();
        this.infoText.setEditable(false);
        this.infoText.setContentType("text/html");
        this.infoText.setName("infoText");
        Font font = UIManager.getFont("TextArea.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)this.infoText.getDocument()).getStyleSheet().addRule(bodyRule);
        this.infoText.setPreferredSize(DEFAULT_DIMENSION);
        this.centerPanel.add((Component)this.infoText, "Center");
        this.centerPanel.setBorder(border);
        this.scrollPane = new JScrollPane(this.centerPanel);
        this.actionText = new JLabel();
        this.actionText.setName("actionText");
        this.panel3 = new JPanel();
        this.panel3.setLayout(new FlowLayout(0));
        this.panel3.add(this.actionText);
        this.closeAllButton = new JButton(BUTTON_TEXT_CLOSE_ALL);
        this.closeAllButton.setName("close_all");
        this.closeAllButton.addActionListener(this);
        this.continueButton = new JButton(BUTTON_TEXT_CONTINUE);
        this.continueButton.setName("continue");
        this.continueButton.addActionListener(this);
        this.panel4 = new JPanel();
        this.panel4.setLayout(new FlowLayout(1));
        this.panel4.add(this.continueButton);
        this.panel4.add(this.closeAllButton);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.setBorder(border);
        this.bottomPanel.add((Component)this.panel3, "North");
        this.bottomPanel.add((Component)this.panel4, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.bottomPanel, "South");
        this.myTimer = new Timer(1000, this.listener);
        this.pack();
    }

    private String getNonReconnectableApps() {
        LOG.info("getNonReconnectableApps()", new Object[0]);
        StringBuffer buf = new StringBuffer();
        String[] tools = this.myNodeMonitorController.getNodeServicesTool().getRunningApplications(null, false);
        int numberOfApps = tools.length;
        for (int i = 0; i < numberOfApps; ++i) {
            if (tools[i] == null || tools[i].equalsIgnoreCase("")) continue;
            buf.append(tools[i] + HTML_LINE_BREAK);
        }
        String apps = buf.toString();
        LOG.info("the nonReconnectableApps apps:" + apps, new Object[0]);
        return apps;
    }

    private String getRunningApps() {
        LOG.info("getRunningApps()", new Object[0]);
        StringBuffer buf = new StringBuffer();
        String[] tools = this.myNodeMonitorController.getNodeServicesTool().getRunningApplications(null, true);
        int numberOfApps = tools.length;
        for (int i = 0; i < numberOfApps; ++i) {
            if (i != 0) {
                buf.append(HTML_LINE_BREAK);
            }
            buf.append(tools[i]);
        }
        String apps = buf.toString();
        LOG.info("the running apps:" + apps, new Object[0]);
        return apps;
    }

    private String getNonExcludedRunningApps() {
        StringBuffer buf = new StringBuffer();
        String[] tools = this.myNodeMonitorController.getNodeServicesTool().getRunningApplications(this.myExcludedApps, true);
        int numberOfApps = tools.length;
        for (int i = 0; i < numberOfApps; ++i) {
            buf.append(tools[i] + HTML_LINE_BREAK);
        }
        String apps = buf.toString();
        LOG.info("the NonExcludedRunningApplications:" + apps, new Object[0]);
        return apps;
    }

    @Override
    public void connectionLost() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    NodeMonitorGui.this.connectionLost();
                }
            };
            SwingUtilities.invokeLater(runner);
        } else {
            LOG.info("Connection lost", new Object[0]);
            this.initView();
            try {
                this.setIconImage(this.getIconImage());
            }
            catch (Exception ex) {
                LOG.info(" Somehing went wrong when setting icon to main window.\n", new Object[0]);
            }
            this.toFront();
            String theTitle = this.myNodeMonitorController.getNodeServicesTool().getApplicationConfiguration().getTitle();
            this.setTitle(theTitle);
            this.startTime = System.currentTimeMillis();
            this.downTimeText.setText(this.getDigitalTime(0L));
            this.setStatusText("Connection Lost");
            String host = this.getHostAddress();
            this.setInfoText("<html><body>The connection to node " + host + " is lost." + HTML_PARAGRAPH_START + HTML_BOLD_START + "Close all tools or wait for connection to be restored." + HTML_BOLD_END + HTML_PARAGRAPH_END + HTML_PARAGRAPH_START + "Affected tools:" + HTML_PARAGRAPH_END + HTML_PARAGRAPH_START + this.getRunningApps() + HTML_PARAGRAPH_END + HTML_END);
            this.continueButton.setEnabled(false);
            this.myTimer.start();
            this.myNodeMonitorController.showView();
        }
    }

    public String getActionText() {
        return this.myActionText;
    }

    private void setStatusText(String statusMessage) {
        this.myStatusText = statusMessage;
        this.statusText.setText(this.myStatusText);
    }

    public String getStatusText() {
        return this.myStatusText;
    }

    private void setInfoText(String infoMessage) {
        this.myInfoText = infoMessage;
        this.infoText.setText(this.myInfoText);
        this.scrollPane.getViewport().setView(this.infoText);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NodeMonitorGui.this.scrollPane.getVerticalScrollBar().setValue(NodeMonitorGui.this.scrollPane.getVerticalScrollBar().getMinimum());
            }
        });
    }

    public String getInfoText() {
        return this.myInfoText;
    }

    @Override
    public Image getIconImage() {
        if (this.iconImage == null) {
            this.iconImage = this.myNodeMonitorController.getNodeServicesTool().getApplicationConfiguration().getIconImage();
        }
        return this.iconImage;
    }

    public String getHostAddress() {
        if (this.hostAddress == null) {
            this.hostAddress = this.myNodeMonitorController.getNodeServicesTool().getApplicationConfiguration().getHostAddress();
        }
        return this.hostAddress;
    }

    @Override
    public void connectionRestored(final boolean isSameSwVersion, final boolean isSameSecurity) {
        LOG.info("Connection restored: isSameSwVersion:" + isSameSwVersion + ", isSameSecurity:" + isSameSecurity, new Object[0]);
        if (!SwingUtilities.isEventDispatchThread()) {
            Runnable runner = new Runnable(){

                public void run() {
                    NodeMonitorGui.this.connectionRestored(isSameSwVersion, isSameSecurity);
                }
            };
            SwingUtilities.invokeLater(runner);
        } else if (isSameSwVersion && isSameSecurity) {
            this.connectionRestoredContinue();
        } else if (!isSameSecurity) {
            this.connectionRestoredDifferentSecurity();
        } else if (!isSameSwVersion) {
            this.connectionRestoredDifferentSwVersion();
        }
    }

    private void connectionRestoredContinue() {
        LOG.info("Connection restored", new Object[0]);
        this.myTimer.stop();
        this.toFront();
        this.setIconImage(this.getIconImage());
        String theTitle = this.myNodeMonitorController.getNodeServicesTool().getApplicationConfiguration().getTitle();
        this.setTitle(theTitle);
        String host = this.getHostAddress();
        this.setStatusText(STATUS_TEXT_CONNECTION_RESTORED);
        if (this.getNonReconnectableApps().length() < 1) {
            this.setInfoText("<html><body>The connection to node " + host + " is restored." + HTML_PARAGRAPH_START + HTML_BOLD_START + "You can now continue using all tools connected to " + host + HTML_BOLD_END + HTML_PARAGRAPH_END + HTML_END);
        } else {
            this.setInfoText("<html><body>The connection to node " + host + " is restored." + HTML_PARAGRAPH_START + "You can now continue using all tools connected to " + host + " except those listed below, which have to be closed and manually restarted." + HTML_PARAGRAPH_END + HTML_PARAGRAPH_START + this.getNonReconnectableApps() + HTML_PARAGRAPH_END + HTML_END);
        }
        this.continueButton.setEnabled(true);
        this.continueButton.setText(BUTTON_TEXT_CONTINUE);
        this.myNodeMonitorController.showView();
    }

    private void connectionRestoredDifferentSwVersion() {
        LOG.info("Connection restored, different SW version", new Object[0]);
        this.myTimer.stop();
        this.toFront();
        this.setIconImage(this.getIconImage());
        String theTitle = this.myNodeMonitorController.getNodeServicesTool().getApplicationConfiguration().getTitle();
        this.setTitle(theTitle);
        this.setStatusText(STATUS_TEXT_CONNECTION_RESTORED);
        String nonExclRunningApps = this.getNonExcludedRunningApps();
        String host = this.getHostAddress();
        List<String> runningExcludedApps = this.getExcludedRunningAppsList();
        String infoText = "<html><body>The connection to node " + host + " is restored." + HTML_PARAGRAPH_START + HTML_BOLD_START + "The following tools will be closed due to changed node version:" + HTML_BOLD_END + HTML_PARAGRAPH_END + HTML_PARAGRAPH_START + nonExclRunningApps + HTML_PARAGRAPH_END;
        if (runningExcludedApps.size() > 0) {
            String continueButtonText = runningExcludedApps.size() > 1 ? "Continue the CV Wizards" : "Continue the CV Wizard";
            infoText = infoText + "<p><b>Press '" + continueButtonText + "' to keep following tools open: " + HTML_BOLD_END + HTML_PARAGRAPH_END + HTML_PARAGRAPH_START;
            for (String exclApp : runningExcludedApps) {
                infoText = infoText + exclApp + HTML_LINE_BREAK;
            }
            infoText = infoText + HTML_PARAGRAPH_END;
            this.continueButton.setText(continueButtonText);
            this.continueButton.setEnabled(true);
        } else {
            this.continueButton.setText(BUTTON_TEXT_CONTINUE);
            this.continueButton.setEnabled(false);
        }
        infoText = infoText + HTML_END;
        this.setInfoText(infoText);
        this.myNodeMonitorController.showView();
    }

    private List<String> getExcludedRunningAppsList() {
        String[] applications;
        ArrayList<String> runningExcludedApps = new ArrayList<String>();
        block0: for (String runningApp : applications = this.myNodeMonitorController.getNodeServicesTool().getRunningApplications(null, true)) {
            for (String exclApp : this.myExcludedApps) {
                if (!runningApp.toLowerCase().contains(exclApp.toLowerCase())) continue;
                runningExcludedApps.add(runningApp);
                continue block0;
            }
        }
        return runningExcludedApps;
    }

    private void connectionRestoredDifferentSecurity() {
        LOG.info("Connection restored, Different security", new Object[0]);
        this.myTimer.stop();
        this.toFront();
        this.setIconImage(this.getIconImage());
        String theTitle = this.myNodeMonitorController.getNodeServicesTool().getApplicationConfiguration().getTitle();
        this.setTitle(theTitle);
        String host = this.getHostAddress();
        this.setStatusText(STATUS_TEXT_CONNECTION_RESTORED);
        this.setInfoText("<html><body>The connection to node " + host + " is restored." + HTML_PARAGRAPH_START + HTML_BOLD_START + "The Element Manager needs to be closed and manually restarted due to changed security level." + HTML_BOLD_END + HTML_PARAGRAPH_END + HTML_END);
        this.continueButton.setText(BUTTON_TEXT_CONTINUE);
        this.continueButton.setEnabled(false);
        this.myNodeMonitorController.showView();
    }

    @Override
    public void setNodeMonitorController(NodeMonitorController controller) {
        this.myNodeMonitorController = controller;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeAllButton) {
            LOG.info("about to close all running apps", new Object[0]);
            this.myNodeMonitorController.getNodeServicesTool().closeRunningApplications(null, true);
        } else if (e.getSource() == this.continueButton && !this.myNodeMonitorController.getNodeServicesTool().isSameVersion()) {
            LOG.info("about to close all apps, except the ones in the exclusion list", new Object[0]);
            this.myNodeMonitorController.getNodeServicesTool().closeRunningApplications(this.myExcludedApps, true);
        } else if (e.getSource() == this.continueButton) {
            LOG.info("about to close all non reconnectable apps", new Object[0]);
            this.myNodeMonitorController.getNodeServicesTool().closeRunningApplications(null, false);
        }
        this.dispose();
    }

    @Override
    public void closeDownGUI() {
        this.dispose();
    }

    private String getDigitalTime(long timeMillis) {
        long time = timeMillis / 1000L;
        String seconds = Integer.toString((int)(time % 60L));
        String minutes = Integer.toString((int)(time % 3600L / 60L));
        String hours = Integer.toString((int)(time / 3600L));
        for (int i = 0; i < 2; ++i) {
            if (seconds.length() < 2) {
                seconds = "0" + seconds;
            }
            if (minutes.length() < 2) {
                minutes = "0" + minutes;
            }
            if (hours.length() >= 2) continue;
            hours = "0" + hours;
        }
        return hours + ":" + minutes + ":" + seconds;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            super.processWindowEvent(e);
            this.myNodeMonitorController.getNodeServicesTool().closeRunningApplications(null, true);
        } else {
            super.processWindowEvent(e);
        }
    }

    static {
        DEFAULT_DIMENSION = new Dimension(660, 200);
    }
}

