/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.utils.launchhandler;

import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.LauncherInterface;

public abstract class LaunchHandler {
    public static void launchTool(final LauncherInterface launcher, final String configFile, final String hostname, final Properties props, final Launchable parent) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    launcher.runApplication(configFile, hostname, props, parent);
                }
                catch (Exception e) {
                    MessageDialogFactory.createMessageDialog("A tool was not possible to start.", e, false, null).setVisible(true);
                }
            }
        };
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.execute(runnable);
        exec.shutdown();
    }

    public static void launchToolAsResource(final LauncherInterface launcher, final String configFile, final String hostname, final Properties props, final Launchable parent) {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    launcher.runResource(configFile, hostname, props, parent);
                }
                catch (Exception e) {
                    MessageDialogFactory.createMessageDialog("A tool was not possible to start.", e, false, null).setVisible(true);
                }
            }
        };
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.execute(runnable);
        exec.shutdown();
    }

    public static Launchable getToolAsResource(final LauncherInterface launcher, final String configPath, final String hostname, final Properties props, final Launchable parentLaunchable) throws LauncherException, CancellationException, ExecutionException, InterruptedException, ClassCastException {
        PrivilegedExceptionAction<Launchable> launchAction = new PrivilegedExceptionAction<Launchable>(){

            @Override
            public Launchable run() throws LauncherException {
                return launcher.runResource(configPath, hostname, props, parentLaunchable);
            }
        };
        Callable<Object> launchResourceCallable = Executors.callable(launchAction);
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Future<Object> nsFuture = exec.submit(launchResourceCallable);
        Object obj = nsFuture.get();
        exec.shutdown();
        return (Launchable)obj;
    }

    public static Launchable getToolAsResource(final LauncherInterface launcher, final String configPath, final String hostname, final Properties props, final Launchable parentLaunchable, long timeoutSeconds) throws LauncherException, CancellationException, ExecutionException, InterruptedException, ClassCastException, TimeoutException {
        PrivilegedExceptionAction<Launchable> launchAction = new PrivilegedExceptionAction<Launchable>(){

            @Override
            public Launchable run() throws LauncherException {
                return launcher.runResource(configPath, hostname, props, parentLaunchable);
            }
        };
        Callable<Object> launchResourceCallable = Executors.callable(launchAction);
        ArrayList<Callable<Object>> list = new ArrayList<Callable<Object>>(1);
        list.add(launchResourceCallable);
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Object obj = exec.invokeAny(list, timeoutSeconds, TimeUnit.SECONDS);
        exec.shutdown();
        return (Launchable)obj;
    }

    public static Launchable getTool(final LauncherInterface launcher, final String configPath, final String hostname, final Properties props, final Launchable parentLaunchable) throws LauncherException, CancellationException, ExecutionException, InterruptedException, ClassCastException {
        PrivilegedExceptionAction<Launchable> launchAction = new PrivilegedExceptionAction<Launchable>(){

            @Override
            public Launchable run() throws LauncherException {
                return launcher.runApplication(configPath, hostname, props, parentLaunchable);
            }
        };
        Callable<Object> launchResourceCallable = Executors.callable(launchAction);
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Future<Object> nsFuture = exec.submit(launchResourceCallable);
        Object obj = nsFuture.get();
        exec.shutdown();
        return (Launchable)obj;
    }

    public static Launchable getTool(final LauncherInterface launcher, final String configPath, final String hostname, final Properties props, final Launchable parentLaunchable, long timeoutSeconds) throws LauncherException, CancellationException, ExecutionException, InterruptedException, ClassCastException, TimeoutException {
        PrivilegedExceptionAction<Launchable> launchAction = new PrivilegedExceptionAction<Launchable>(){

            @Override
            public Launchable run() throws LauncherException {
                return launcher.runApplication(configPath, hostname, props, parentLaunchable);
            }
        };
        Callable<Object> launchResourceCallable = Executors.callable(launchAction);
        ArrayList<Callable<Object>> list = new ArrayList<Callable<Object>>(1);
        list.add(launchResourceCallable);
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Object obj = exec.invokeAny(list, timeoutSeconds, TimeUnit.SECONDS);
        exec.shutdown();
        return (Launchable)obj;
    }
}

