/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.utils.impl;

import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import se.ericsson.cello.em.fm.common.config.ifc.Configuration;
import se.ericsson.cello.em.fm.common.config.ifc.PrintingService;
import se.ericsson.cello.em.fm.common.utils.ifc.Messenger;
import se.ericsson.cello.em.fm.common.utils.ifc.ToolService;
import se.ericsson.cello.em.fm.common.utils.impl.PrintoutImpl;
import se.ericsson.cello.emt.helpservice.HelpServiceI;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.emt.userpreferences.UserPreferencesI;
import se.ericsson.security.launcher.ApplicationFileInterface;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmToolService
implements ToolService {
    private static final EmLogger LOG = EmLogger.TROUBLE_SHOOTING;
    private Configuration configuration;
    private LauncherInterface launcher;
    private Launchable launchable;
    private NodeServices myNodeServices;
    private HelpServiceI myHelpService;
    private UserPreferencesI myUserPreferences;
    private Messenger messenger;
    protected PrintoutImpl myPrintoutImpl = null;

    public FmToolService(Launchable launchable, LauncherInterface launcher, Configuration configuration) {
        this(launchable, launcher, configuration, null);
    }

    public FmToolService(Launchable launchable, LauncherInterface launcher, Configuration configuration, Messenger messenger) {
        this.launchable = launchable;
        this.launcher = launcher;
        this.configuration = configuration;
        this.messenger = messenger;
    }

    @Override
    public void setMessenger(Messenger aMessenger) {
        this.messenger = aMessenger;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public HelpServiceI getHelpService() {
        if (null != this.myHelpService) {
            return this.myHelpService;
        }
        final Properties props = this.configuration.getSupersedingProperties();
        props.setProperty("HELPSERVICE_INIT", "TRUE");
        final String helpCfgFileName = this.configuration.getHelpServiceConfigurationFile();
        PrivilegedExceptionAction<Launchable> launchHelpServiceAction = new PrivilegedExceptionAction<Launchable>(){

            @Override
            public Launchable run() throws LauncherException {
                return FmToolService.this.launcher.runResource(helpCfgFileName, FmToolService.this.configuration.getHostAndPortString(), props, FmToolService.this.launchable);
            }
        };
        Callable<Object> launchResourceCallable = Executors.callable(launchHelpServiceAction);
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Future<Object> hsFuture = exec.submit(launchResourceCallable);
        try {
            Object obj = hsFuture.get();
            exec.shutdown();
            this.myHelpService = (HelpServiceI)obj;
        }
        catch (Exception ex) {
            String reason = "Help Service problem.\nIt is not possible to display any help information \n" + ex.getMessage();
            LOG.severe(reason, new Object[0]);
        }
        if (this.myHelpService == null) {
            String reason = "Help service is not up and running.\n This should never happen. See earlier log note to find the reason.";
            LOG.severe(reason, new Object[0]);
        }
        return this.myHelpService;
    }

    @Override
    public Messenger getMessenger() {
        return this.messenger;
    }

    @Override
    public NodeServices getNodeServices() throws Exception {
        if (null != this.myNodeServices) {
            return this.myNodeServices;
        }
        final Properties props = this.configuration.getSupersedingProperties();
        final String nodeServCfgFileName = this.configuration.getNodeServiceConfigurationFile();
        PrivilegedExceptionAction<Launchable> launchNodeServiceAction = new PrivilegedExceptionAction<Launchable>(){

            @Override
            public Launchable run() throws LauncherException {
                return FmToolService.this.launcher.runResource(nodeServCfgFileName, FmToolService.this.configuration.getHostAndPortString(), props, FmToolService.this.launchable);
            }
        };
        Callable<Object> launchResourceCallable = Executors.callable(launchNodeServiceAction);
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Future<Object> hsFuture = exec.submit(launchResourceCallable);
        Object obj = hsFuture.get();
        exec.shutdown();
        this.myNodeServices = (NodeServices)obj;
        return this.myNodeServices;
    }

    @Override
    public void displayAlexHelp(String doc, String section) {
        Properties props = this.configuration.getSupersedingProperties();
        String helpCfgFileName = this.configuration.getHelpServiceConfigurationFile();
        props.setProperty("DOC_TITLE", doc);
        props.setProperty("SECTION_TAG", section);
        this.startResource(helpCfgFileName, "Help Service", props);
    }

    @Override
    public Collection<ApplicationFileInterface> getConfigurationFiles() {
        return this.launcher.getConfigurationFiles(this.launchable);
    }

    @Override
    public UserPreferencesI getUserPreferences() {
        if (null != this.myUserPreferences) {
            return this.myUserPreferences;
        }
        final Properties props = this.configuration.getSupersedingProperties();
        final String prefServCfgFileName = this.configuration.getPreferenceServiceConfigurationFile();
        PrivilegedExceptionAction<Launchable> launchHelpServiceAction = new PrivilegedExceptionAction<Launchable>(){

            @Override
            public Launchable run() throws LauncherException {
                return FmToolService.this.launcher.runResource(prefServCfgFileName, FmToolService.this.configuration.getHostAndPortString(), props, FmToolService.this.launchable);
            }
        };
        Callable<Object> launchResourceCallable = Executors.callable(launchHelpServiceAction);
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Future<Object> hsFuture = exec.submit(launchResourceCallable);
        try {
            Object obj = hsFuture.get();
            exec.shutdown();
            this.myUserPreferences = (UserPreferencesI)obj;
        }
        catch (Exception ex) {
            LOG.warning("Could not get User Preference Service from Launcher. Using temporary preferences.\n", new Object[0]);
        }
        if (null == this.myUserPreferences) {
            this.myUserPreferences = new TempUserProps();
        }
        return this.myUserPreferences;
    }

    private void startResource(final String config, final String nameOfResource, final Properties props) {
        LOG.fine(" startResource() with LDNs: " + props.getProperty("LDNs"), new Object[0]);
        props.putAll((Map<?, ?>)this.configuration.getSupersedingProperties());
        Runnable runnable = new Runnable(){

            public void run() {
                block2: {
                    try {
                        FmToolService.this.launcher.runResource(config, FmToolService.this.configuration.getHostAndPortString(), props, FmToolService.this.launchable);
                    }
                    catch (LauncherException exep) {
                        LOG.severe("Could not launch " + nameOfResource, (Throwable)exep);
                        if (null == FmToolService.this.messenger) break block2;
                        FmToolService.this.messenger.setMessage("Could not start " + nameOfResource, (Exception)((Object)exep), false);
                    }
                }
            }
        };
        Thread t = new Thread(runnable);
        t.start();
    }

    @Override
    public void launchTool(final String config, final String nameOfTool, final Properties props) {
        LOG.fine(" launchTool() with LDNs: " + props.getProperty("LDNs"), new Object[0]);
        props.putAll((Map<?, ?>)this.configuration.getSupersedingProperties());
        Runnable runnable = new Runnable(){

            public void run() {
                block2: {
                    try {
                        FmToolService.this.launcher.runApplication(config, FmToolService.this.configuration.getHostAndPortString(), props, FmToolService.this.launchable);
                    }
                    catch (LauncherException exep) {
                        LOG.severe("Could not launch " + nameOfTool, (Throwable)exep);
                        if (null == FmToolService.this.messenger) break block2;
                        FmToolService.this.messenger.setMessage("Could not start " + nameOfTool, (Exception)((Object)exep), false);
                    }
                }
            }
        };
        Thread t = new Thread(runnable);
        t.start();
    }

    @Override
    public PrintingService getPrintingService() {
        if (this.myPrintoutImpl == null) {
            this.myPrintoutImpl = new PrintoutImpl();
        }
        return this.myPrintoutImpl;
    }

    private static class TempUserProps
    implements UserPreferencesI {
        Properties myProps = new Properties();

        private TempUserProps() {
        }

        public String getPreference(String key, String defaultValue) {
            return this.myProps.getProperty(key, defaultValue);
        }

        public void setPreference(String key, String value) {
            this.myProps.setProperty(key, value);
        }

        public void removePreference(String preferenceKey) {
            this.myProps.remove(preferenceKey);
        }
    }
}

