/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.utils.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import se.ericsson.cello.em.fm.common.config.ifc.PrintingService;

public class PrintoutImpl
implements Printable,
PrintingService {
    private Component component;
    private String title;
    private Vector tableHeaders = new Vector();
    private ArrayList firstLines;
    private int nCol = 0;
    private int nRow = 0;
    private int[] columnPositions;
    private int yPosition = 0;
    private int wPage = 0;
    private int hPage = 0;
    private boolean printDetailsPane = false;
    Font headerFont = new Font("TimesRoman", 1, 9);
    Font titleFont = new Font("TimesRoman", 1, 14);
    Font tableFont = new Font("Courier", 0, 9);
    Object[] arrayToPrint;
    private static PrinterJob printerJob = PrinterJob.getPrinterJob();
    private static PageFormat pageFormat = printerJob.defaultPage();
    private boolean firstTimePrintInterfaceCalled = true;

    public PrintoutImpl(Component component, String title) {
        this.component = component;
        this.title = title;
        pageFormat.setOrientation(0);
    }

    public PrintoutImpl() {
        pageFormat.setOrientation(0);
    }

    private void setPageSize(PageFormat pageFormat, int headerHeight) {
        this.wPage = (int)pageFormat.getImageableWidth();
        this.hPage = (int)pageFormat.getImageableHeight() - headerHeight - 100;
    }

    public void changeComponent(Component newComponent) {
        this.component = newComponent;
    }

    public void setPrintDetailsPane(boolean printFromDetailsPane) {
        this.printDetailsPane = printFromDetailsPane;
    }

    public void pageLayout() {
        pageFormat.setOrientation(0);
        pageFormat = printerJob.pageDialog(pageFormat);
    }

    public void print() {
        printerJob.setPrintable(this, pageFormat);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            return;
        }
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.printDetailsPane) {
            int result = this.printDetailsPane(g, pageIndex, pageFormat);
            if (result == 1) {
                this.printDetailsPane = false;
            }
            return result;
        }
        if (this.component instanceof JTable) {
            boolean bool;
            JTable table = (JTable)this.component;
            int headerHeight = this.calculateHeaderHeight(g);
            if (this.firstTimePrintInterfaceCalled) {
                this.setPageSize(pageFormat, headerHeight);
                TableColumnModel colModel = table.getColumnModel();
                this.nCol = colModel.getColumnCount();
                this.nRow = table.getRowCount();
                g.setFont(this.headerFont);
                this.createTableHeaderVector(g, table);
                g.setFont(this.tableFont);
                this.firstLines = new ArrayList();
                this.createTableVector(g, table);
                this.arrayToPrint = this.firstLines.toArray();
            }
            g.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
            this.yPosition = 0;
            this.yPosition = this.printTitle(g, this.yPosition, table, pageIndex);
            if (this.firstTimePrintInterfaceCalled) {
                this.firstTimePrintInterfaceCalled = false;
            }
            if (bool = this.print(g, pageIndex, table)) {
                return 0;
            }
            this.firstTimePrintInterfaceCalled = true;
            return 1;
        }
        return this.printOther(g, pageIndex, pageFormat);
    }

    public void setTitle(String aTitle) {
        this.title = aTitle;
    }

    private int printTitle(Graphics g, int yPosition, JTable table, int pageIndex) {
        g.setFont(this.titleFont);
        g.setColor(Color.black);
        FontMetrics fm = g.getFontMetrics();
        g.drawString(this.title, 10, yPosition += fm.getAscent());
        int x_pos = fm.charsWidth(this.title.toCharArray(), 0, this.title.length()) + 30;
        g.setFont(this.headerFont);
        g.drawString("page " + (pageIndex + 1), x_pos, yPosition);
        return yPosition += 20;
    }

    private int calculateHeaderHeight(Graphics g) {
        int headerHeight = 0;
        g.setFont(this.titleFont);
        headerHeight = g.getFontMetrics().getHeight();
        g.setFont(this.headerFont);
        headerHeight = headerHeight + g.getFontMetrics().getHeight() + 25;
        return headerHeight;
    }

    private int printDetailsPane(Graphics g, int pageIndex, PageFormat pageFormat) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        int fontHeight = g2.getFontMetrics().getHeight();
        int fontDescent = g2.getFontMetrics().getDescent();
        double pageHeight = pageFormat.getImageableHeight() - (double)fontHeight;
        double pageWidth = pageFormat.getImageableWidth();
        JTable table = (JTable)this.component;
        double tableWidth = table.getColumnModel().getTotalColumnWidth();
        double scale = 1.0;
        if (tableWidth >= pageWidth) {
            scale = pageWidth / tableWidth;
        }
        double headerHeightOnPage = (double)table.getTableHeader().getHeight() * scale;
        double tableWidthOnPage = tableWidth * scale;
        double oneRowHeight = (double)(table.getRowHeight() + table.getRowMargin()) * scale;
        int numRowsOnAPage = (int)((pageHeight - headerHeightOnPage) / oneRowHeight);
        double pageHeightForTable = oneRowHeight * (double)numRowsOnAPage;
        int totalNumPages = (int)Math.ceil((double)table.getRowCount() / (double)numRowsOnAPage);
        if (pageIndex >= totalNumPages) {
            return 1;
        }
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        g2.setFont(new Font("TimesRoman", 1, 24));
        g2.drawString(this.title, 0, -10);
        g2.setFont(new Font("TimesRoman", 1, 12));
        g2.drawString("Page: " + (pageIndex + 1), (int)pageWidth / 2 - 35, (int)(pageHeight + (double)fontHeight - (double)fontDescent));
        g2.translate(0.0, headerHeightOnPage);
        g2.translate(0.0, (double)(-pageIndex) * pageHeightForTable);
        if (pageIndex + 1 == totalNumPages) {
            int lastRowPrinted = numRowsOnAPage * pageIndex;
            int numRowsLeft = table.getRowCount() - lastRowPrinted;
            g2.setClip(0, (int)(pageHeightForTable * (double)pageIndex), (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(oneRowHeight * (double)numRowsLeft));
        } else {
            g2.setClip(0, (int)(pageHeightForTable * (double)pageIndex), (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(pageHeightForTable));
        }
        g2.scale(scale, scale);
        table.paint(g2);
        g2.scale(1.0 / scale, 1.0 / scale);
        g2.translate(0.0, (double)pageIndex * pageHeightForTable);
        g2.translate(0.0, -headerHeightOnPage);
        g2.setClip(0, 0, (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(headerHeightOnPage));
        g2.scale(scale, scale);
        table.getTableHeader().paint(g2);
        return 0;
    }

    private int printOther(Graphics g, int pageIndex, PageFormat pageFormat) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        if (pageIndex >= 1) {
            return 1;
        }
        g2.setFont(new Font("TimesRoman", 1, 24));
        g2.drawString(this.title, 0, 0);
        int fontHeight = g2.getFontMetrics().getHeight();
        double pageHeight = pageFormat.getImageableHeight() - (double)fontHeight + 20.0;
        double pageWidth = pageFormat.getImageableWidth();
        double scale = Math.min(pageWidth / (double)this.component.getWidth(), pageHeight / (double)this.component.getHeight());
        if (scale > 1.0) {
            scale = 1.0;
        }
        g2.scale(scale, scale);
        g2.setClip(0, 0, this.component.getWidth(), this.component.getHeight());
        this.component.paint(g2);
        g2.drawRect(0, 0, this.component.getWidth() - 1, this.component.getHeight() - 1);
        return 0;
    }

    public boolean print(Graphics g, int pageIndex, JTable table) {
        int spaceBetwRows = 1;
        g.setFont(this.headerFont);
        for (int i = 0; i < this.tableHeaders.size(); ++i) {
            Object tmpObj = this.tableHeaders.get(i);
            Cell cell = (Cell)tmpObj;
            cell.print(g, this.yPosition);
        }
        g.setFont(this.tableFont);
        int header = this.yPosition;
        FontMetrics fm = g.getFontMetrics();
        int h = fm.getHeight();
        int ascent = fm.getAscent();
        int rowH = h;
        int rowPerPage = (this.hPage - header) / rowH;
        int m_maxNumPage = Math.max((int)Math.ceil((double)this.firstLines.size() / (double)rowPerPage), 1);
        if (pageIndex >= m_maxNumPage) {
            this.firstLines.clear();
            this.tableHeaders.removeAllElements();
            return false;
        }
        int iniRow = pageIndex * rowPerPage;
        int endRow = iniRow + rowPerPage - 1;
        int rowToPrint = iniRow;
        this.yPosition += ascent;
        for (int firstLineIndex = iniRow; rowToPrint <= endRow && firstLineIndex < this.firstLines.size(); ++rowToPrint, ++firstLineIndex) {
            this.yPosition += rowH;
            Object tmpObj = this.arrayToPrint[rowToPrint];
            Line line = (Line)tmpObj;
            if (line.getFirstLine()) {
                this.yPosition += 5;
            }
            line.print(g, this.yPosition);
            this.yPosition = spaceBetwRows + this.yPosition;
        }
        return true;
    }

    public void createTableHeaderVector(Graphics g, JTable table) {
        FontMetrics fm = g.getFontMetrics();
        int[] x = new int[this.nCol];
        this.columnPositions = new int[this.nCol];
        x[0] = 0;
        this.columnPositions[0] = 20;
        int tmpCol = 0;
        for (tmpCol = 0; tmpCol < this.nCol; ++tmpCol) {
            Cell tmpCell;
            TableColumnModel colModel = table.getColumnModel();
            TableColumn tk = colModel.getColumn(tmpCol);
            String title = (String)tk.getIdentifier();
            int columnWidth = tk.getWidth();
            int width = fm.charsWidth(title.toCharArray(), 0, title.length()) + 25;
            if (columnWidth > 0) {
                if (this.columnPositions[tmpCol] + width > this.wPage) {
                    this.nCol = tmpCol;
                    break;
                }
                if (tmpCol + 1 < this.nCol) {
                    this.columnPositions[tmpCol + 1] = this.columnPositions[tmpCol] + width;
                }
                if ("Time".equalsIgnoreCase(title) || "Date".equalsIgnoreCase(title)) {
                    String str = "0000000000000000";
                    width = fm.charsWidth(str.toCharArray(), 0, 16);
                    this.columnPositions[tmpCol + 1] = this.columnPositions[tmpCol] + width;
                } else if ("MO Instance".equals(title) || "Alarm ID".equalsIgnoreCase(title)) {
                    this.columnPositions[tmpCol + 1] = this.columnPositions[tmpCol] + 2 * width;
                } else if (title.length() < 5 && tmpCol + 1 != this.nCol) {
                    this.columnPositions[tmpCol + 1] = this.columnPositions[tmpCol] + 2 * width;
                }
                tmpCell = new Cell(title, this.columnPositions[tmpCol]);
                this.tableHeaders.addElement(tmpCell);
                continue;
            }
            this.columnPositions[tmpCol] = this.columnPositions[tmpCol - 1];
            tmpCell = new Cell(title, 0);
            this.tableHeaders.addElement(tmpCell);
            TableColumn tk1 = colModel.getColumn(tmpCol - 1);
            String title1 = (String)tk1.getIdentifier();
            int width1 = fm.charsWidth(title1.toCharArray(), 0, title1.length()) + 10;
            if (tmpCol + 1 >= this.nCol) continue;
            this.columnPositions[tmpCol + 1] = this.columnPositions[tmpCol] + width1;
        }
    }

    public void createTableVector(Graphics g, JTable table) {
        ArrayList<Line> lines = new ArrayList<Line>();
        for (int tmpRow = 0; tmpRow < this.nRow; ++tmpRow) {
            Line firstLine = new Line(this.nCol);
            lines.add(firstLine);
            for (int tmpCol = 0; tmpCol < this.nCol; ++tmpCol) {
                FontMetrics fm;
                int stringWidth;
                int cellWidth = 0;
                cellWidth = tmpCol + 1 < this.nCol ? this.columnPositions[tmpCol + 1] - this.columnPositions[tmpCol] - 10 : this.wPage - this.columnPositions[tmpCol] - 10;
                String content = table.getValueAt(tmpRow, tmpCol).toString();
                if (null == content) {
                    content = "";
                }
                if ((stringWidth = (fm = g.getFontMetrics()).charsWidth(content.toCharArray(), 0, content.length())) <= cellWidth) {
                    Cell tmpCell = new Cell(content, this.columnPositions[tmpCol]);
                    firstLine.addCell(tmpCell, tmpCol);
                    continue;
                }
                int noOfCharsInOneRow = Math.abs(cellWidth / fm.charWidth('0'));
                boolean notTheEnd = true;
                int startOfSubstring = 0;
                int subLineIndex = 1;
                String restOfContent = content;
                boolean firstPart = true;
                String partOfContent = content;
                while (notTheEnd && content.length() >= 0) {
                    if (restOfContent.length() > noOfCharsInOneRow) {
                        int indexOfSpace;
                        int tmpIndexOfSpace = indexOfSpace = restOfContent.indexOf(32);
                        while (restOfContent.indexOf(32, tmpIndexOfSpace + 1) < noOfCharsInOneRow && indexOfSpace >= 0) {
                            indexOfSpace = restOfContent.indexOf(32, tmpIndexOfSpace + 1);
                            if (indexOfSpace > noOfCharsInOneRow || indexOfSpace < 0) continue;
                            tmpIndexOfSpace = indexOfSpace;
                        }
                        indexOfSpace = tmpIndexOfSpace;
                        if (indexOfSpace <= noOfCharsInOneRow && indexOfSpace >= 0) {
                            partOfContent = content.substring(startOfSubstring, startOfSubstring + indexOfSpace);
                            startOfSubstring = startOfSubstring + indexOfSpace + 1;
                        } else {
                            partOfContent = content.length() - startOfSubstring <= noOfCharsInOneRow ? content.substring(startOfSubstring, content.length()) : content.substring(startOfSubstring, startOfSubstring + noOfCharsInOneRow);
                            startOfSubstring += noOfCharsInOneRow;
                        }
                    } else {
                        notTheEnd = false;
                        partOfContent = restOfContent;
                    }
                    Cell tmpCell = new Cell(partOfContent, this.columnPositions[tmpCol]);
                    if (firstPart) {
                        firstLine.addCell(tmpCell, tmpCol);
                        firstLine.setFirstLine(true);
                        firstPart = false;
                    } else {
                        if (subLineIndex < lines.size()) {
                            Object tmpObj = lines.get(subLineIndex);
                            Line line = (Line)tmpObj;
                            line.addCell(tmpCell, tmpCol);
                        } else {
                            Line subLine = new Line(this.nCol);
                            subLine.addCell(tmpCell, tmpCol);
                            lines.add(subLine);
                        }
                        ++subLineIndex;
                    }
                    if (startOfSubstring >= content.length()) {
                        notTheEnd = false;
                        continue;
                    }
                    restOfContent = content.substring(startOfSubstring, content.length());
                }
            }
            for (int n = 0; n < lines.size(); ++n) {
                this.firstLines.add(lines.get(n));
            }
            lines.clear();
        }
    }

    public void print(Component component, String aTitle) {
        this.title = aTitle;
        this.changeComponent(component);
        this.print();
    }

    public class Cell {
        private String theString = null;
        private int xPos = 0;

        public Cell(String aString, int xPosition) {
            this.theString = aString;
            this.xPos = xPosition;
        }

        public void print(Graphics g, int yPos) {
            if (this.xPos != 0) {
                g.drawString(this.theString, this.xPos, yPos);
            }
        }
    }

    public class Line {
        private Cell[] theLine;
        private boolean isFirstLine = false;
        private int theNoOfCells = 0;

        public Line(int noOfCells) {
            this.theLine = new Cell[noOfCells];
            this.theNoOfCells = noOfCells;
            Cell emptyCell = new Cell("", 0);
            for (int i = 0; i < noOfCells; ++i) {
                this.theLine[i] = emptyCell;
            }
        }

        public void addCell(Cell aCell, int index) {
            this.theLine[index] = aCell;
        }

        public void setFirstLine(boolean firstLine) {
            this.isFirstLine = firstLine;
        }

        public boolean getFirstLine() {
            return this.isFirstLine;
        }

        public void print(Graphics g, int y_position) {
            for (int i = 0; i < this.theNoOfCells; ++i) {
                this.theLine[i].print(g, y_position);
            }
        }
    }
}

