/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step2.actions;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;

public class FixMaoEcBusReserveBy
implements MoDataAction {
    private static final Class THIS_CLASS = FixMaoEcBusReserveBy.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String ECBUS_LDN = "ManagedElement=1,Equipment=1,EcBus=1";
    private static final String ECPORT_ATT_EC_REF = "ecBusRef";
    private static final String RESERVED_BY_ATTR_NAME = "reservedBy";

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        MoDataWrapper moDataWrapper2 = null;
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        if (moDataAccessor == null) {
            logger.traceAbnormal(THIS_CLASS, "MoDataAccessor accessor is null");
        } else {
            Collection collection = moDataAccessor.getByType("EcBus");
            if (collection != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    moDataWrapper2 = (MoDataWrapper)iterator.next();
                    SequenceAttribute sequenceAttribute = new SequenceAttribute(RESERVED_BY_ATTR_NAME, false);
                    moDataWrapper2.registerPersistentAttr((Attribute)sequenceAttribute);
                    this.updateEcBusReservedBy(converterContext, sequenceAttribute, moDataWrapper2.getLocalDistinguishedName());
                    try {
                        moDataWrapper2.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                    }
                    catch (AueException aueException) {
                        CrbsAueException crbsAueException = new CrbsAueException(aueException.getMessage());
                        crbsAueException.setStackTrace(aueException.getStackTrace());
                        throw crbsAueException;
                    }
                }
            }
        }
    }

    private void updateEcBusReservedBy(ConverterContext converterContext, SequenceAttribute sequenceAttribute, String string) {
        logger.traceEnter(THIS_CLASS, "updateEcBusReservedBy()");
        MoDataWrapper moDataWrapper = null;
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        if (moDataAccessor == null) {
            logger.traceAbnormal(THIS_CLASS, "MoDataAccessor accessor is null");
        } else {
            Collection collection = moDataAccessor.getByType("EcPort");
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                moDataWrapper = (MoDataWrapper)iterator.next();
                logger.traceError(THIS_CLASS, "------------------> in while loop: getLocalDistinguishedName = " + moDataWrapper.getLocalDistinguishedName());
                ReferenceAttribute referenceAttribute = (ReferenceAttribute)moDataWrapper.getAttribute(ECPORT_ATT_EC_REF);
                if (referenceAttribute.equals(new ReferenceAttribute(ECPORT_ATT_EC_REF, string, false))) {
                    sequenceAttribute.addElement((Attribute)new ReferenceAttribute("", moDataWrapper.getLocalDistinguishedName(), false));
                    continue;
                }
                logger.traceError(THIS_CLASS, "---------------------------> ecBusRefAttribute fetched was null or not equal ManagedElement=1,Equipment=1,EcBus=1");
            }
        }
    }
}

