/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step2.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.actions.util.Step2Handler;

public class HandleMaoCtrlDomainRefForFuncMosAction
implements MoDataAction {
    private static final Class THIS_CLASS = HandleMaoCtrlDomainRefForFuncMosAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String RESERVED_BY_ATTRIBUTE_NAME = "reservedBy";
    private static final String CABINET_MO_TYPE = "Cabinet";
    private static final String POWERSUPPLY_MO_TYPE = "PowerSupply";
    private static final String POWERDISTRIBUTION_MO_TYPE = "PowerDistribution";
    private static final String BATTERYBACKUP_MO_TYPE = "BatteryBackup";
    private static final String EQUIPSUPPORTFUNC_LDN = "ManagedElement=1,EquipmentSupportFunction=1,";
    private static final String CONTROL_DOMAIN_REF_ATTRIBUTE_NAME = "controlDomainRef";
    private static final String STEP2_FUNCMO_UPDATED = "funcMoUpdated";
    private static final String STEP2_FUNCMO_LIST = "funcMoList";

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        Step2Handler step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
        if (step2Handler.retrieveFromAuePersistency("", STEP2_FUNCMO_UPDATED).equalsIgnoreCase("true")) {
            String[] stringArray = this.getLdnsOfUpdatedFuncMos(converterContext);
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                Object object;
                String string2 = step2Handler.retrieveFromAuePersistency(stringArray[i], CONTROL_DOMAIN_REF_ATTRIBUTE_NAME);
                MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
                Collection collection = moDataAccessor.getByType(this.getFuncMoType(stringArray[i]));
                MoDataWrapper moDataWrapper2 = null;
                if (collection != null && !collection.isEmpty()) {
                    object = collection.iterator();
                    while (object.hasNext()) {
                        moDataWrapper2 = (MoDataWrapper)object.next();
                        if (moDataWrapper2 == null || !(string = moDataWrapper2.getLocalDistinguishedName()).equalsIgnoreCase(stringArray[i])) continue;
                        this.setControlDomainRefOnFuncMo(moDataWrapper2, string2, coordinator);
                    }
                }
                object = moDataAccessor.getByType(CABINET_MO_TYPE);
                string = null;
                if (object == null) continue;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    string = (MoDataWrapper)iterator.next();
                    String string3 = string.getLocalDistinguishedName();
                    if (!string3.equalsIgnoreCase(string2)) continue;
                    this.updateReservedBy((MoDataWrapper)string, stringArray[i], coordinator);
                }
            }
        }
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private void setControlDomainRefOnFuncMo(MoDataWrapper moDataWrapper, String string, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "setControlDomainRefOnFuncMo()");
        SequenceAttribute sequenceAttribute = (SequenceAttribute)moDataWrapper.getAttribute(CONTROL_DOMAIN_REF_ATTRIBUTE_NAME);
        if (sequenceAttribute == null) {
            sequenceAttribute = new SequenceAttribute(CONTROL_DOMAIN_REF_ATTRIBUTE_NAME, false);
        }
        try {
            boolean bl = false;
            Enumeration enumeration = sequenceAttribute.elements();
            while (enumeration.hasMoreElements()) {
                ReferenceAttribute referenceAttribute = (ReferenceAttribute)enumeration.nextElement();
                String string2 = referenceAttribute.getReferenceAsLDN();
                if (!string2.equalsIgnoreCase(string)) continue;
                bl = true;
            }
            if (!bl) {
                sequenceAttribute.addElement((Attribute)new ReferenceAttribute("", string, true));
            }
            moDataWrapper.deregisterAttribute(CONTROL_DOMAIN_REF_ATTRIBUTE_NAME);
            moDataWrapper.registerPersistentAttr((Attribute)sequenceAttribute);
            moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        }
        catch (AueException aueException) {
            CrbsAueException crbsAueException = new CrbsAueException(aueException.getMessage());
            crbsAueException.setStackTrace(aueException.getStackTrace());
            throw crbsAueException;
        }
        logger.traceReturn(THIS_CLASS, "updateReservedBy()");
    }

    private String getFuncMoType(String string) {
        logger.traceReturn(THIS_CLASS, "getFuncMoType()");
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < 3; ++i) {
            switch (i) {
                case 0: {
                    string2 = POWERSUPPLY_MO_TYPE;
                    if (string.length() > EQUIPSUPPORTFUNC_LDN.length() + string2.length()) {
                        string3 = string.substring(EQUIPSUPPORTFUNC_LDN.length(), EQUIPSUPPORTFUNC_LDN.length() + string2.length());
                        break;
                    }
                }
                case 1: {
                    string2 = BATTERYBACKUP_MO_TYPE;
                    if (string.length() > EQUIPSUPPORTFUNC_LDN.length() + string2.length()) {
                        string3 = string.substring(EQUIPSUPPORTFUNC_LDN.length(), EQUIPSUPPORTFUNC_LDN.length() + string2.length());
                        break;
                    }
                }
                case 2: {
                    string2 = POWERDISTRIBUTION_MO_TYPE;
                    if (string.length() > EQUIPSUPPORTFUNC_LDN.length() + string2.length()) {
                        string3 = string.substring(EQUIPSUPPORTFUNC_LDN.length(), EQUIPSUPPORTFUNC_LDN.length() + string2.length());
                        break;
                    }
                }
                default: {
                    string2 = "";
                }
            }
            if (!string3.equalsIgnoreCase(string2)) continue;
            logger.traceReturn(THIS_CLASS, "getFuncMoType() funcMo: " + string2);
            return string2;
        }
        logger.traceReturn(THIS_CLASS, "getFuncMoType(): ");
        return "";
    }

    private String[] getLdnsOfUpdatedFuncMos(ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getLdnsOfUpdatedFuncMos()");
        String[] stringArray = new String[]{};
        Step2Handler step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
        String string = step2Handler.retrieveFromAuePersistency("", STEP2_FUNCMO_LIST);
        if (string == null || string.length() == 0) {
            logger.traceDebug(THIS_CLASS, "No Climates to create.");
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            stringArray = arrayList.toArray(stringArray);
        }
        logger.traceReturn(THIS_CLASS, "getLdnsOfCreatedClimates()");
        return stringArray;
    }

    private void updateReservedBy(MoDataWrapper moDataWrapper, String string, Coordinator coordinator) throws CrbsAueException {
        String string2 = moDataWrapper.getLocalDistinguishedName();
        logger.traceEnter(THIS_CLASS, "updateReservedBy() for " + string2);
        SequenceAttribute sequenceAttribute = (SequenceAttribute)moDataWrapper.getAttribute(RESERVED_BY_ATTRIBUTE_NAME);
        if (sequenceAttribute == null) {
            sequenceAttribute = new SequenceAttribute(RESERVED_BY_ATTRIBUTE_NAME, true);
        }
        try {
            boolean bl = false;
            Enumeration enumeration = sequenceAttribute.elements();
            while (enumeration.hasMoreElements()) {
                ReferenceAttribute referenceAttribute = (ReferenceAttribute)enumeration.nextElement();
                String string3 = referenceAttribute.getReferenceAsLDN();
                if (!string3.equalsIgnoreCase(string)) continue;
                bl = true;
            }
            if (!bl) {
                sequenceAttribute.addElement((Attribute)new ReferenceAttribute("", string, true));
            }
            moDataWrapper.deregisterAttribute(RESERVED_BY_ATTRIBUTE_NAME);
            moDataWrapper.registerPersistentAttr((Attribute)sequenceAttribute);
            moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        }
        catch (AueException aueException) {
            CrbsAueException crbsAueException = new CrbsAueException(aueException.getMessage());
            crbsAueException.setStackTrace(aueException.getStackTrace());
            throw crbsAueException;
        }
        logger.traceReturn(THIS_CLASS, "updateReservedBy()");
    }
}

