/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step2.actions;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;

public class UpdateReservedByOnPiuAction
implements MoDataAction {
    private static final Class THIS_CLASS = UpdateReservedByOnPiuAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String ECBUS_ATT_CONNECTOR_REF = "ecBusConnectorRef";
    private static final String PIU_ATT_RESERVEDBY = "reservedByList";
    private static final String PIU_MO_TYPE = "PlugInUnit";
    private static final String ECBUS_MO_TYPE = "EcBus";

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        MoDataWrapper moDataWrapper2 = null;
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        if (moDataAccessor == null) {
            logger.traceAbnormal(THIS_CLASS, "MoDataAccessor accessor is null");
        } else {
            logger.traceGeneral(THIS_CLASS, "Accessing MOs of type PlugInUnit");
            Collection collection = moDataAccessor.getByType(PIU_MO_TYPE);
            if (collection != null) {
                Iterator iterator = collection.iterator();
                logger.traceGeneral(THIS_CLASS, "Iterate over all MOs of type PlugInUnit");
                while (iterator.hasNext()) {
                    moDataWrapper2 = (MoDataWrapper)iterator.next();
                    logger.traceGeneral(THIS_CLASS, "Creating ReservedBy attribute");
                    SequenceAttribute sequenceAttribute = (SequenceAttribute)moDataWrapper2.getAttribute(PIU_ATT_RESERVEDBY);
                    if (sequenceAttribute == null) {
                        sequenceAttribute = new SequenceAttribute(PIU_ATT_RESERVEDBY, true);
                    }
                    logger.traceGeneral(THIS_CLASS, "Find and Assert ReservedBy Attribute");
                    this.addReferencesToReservedByAttribute(converterContext, sequenceAttribute, moDataWrapper2.getLocalDistinguishedName());
                    logger.traceGeneral(THIS_CLASS, "deregister and register Attribute: reservedByList");
                    try {
                        moDataWrapper2.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                    }
                    catch (AueException aueException) {
                        CrbsAueException crbsAueException = new CrbsAueException(aueException.getMessage());
                        crbsAueException.setStackTrace(aueException.getStackTrace());
                        throw crbsAueException;
                    }
                }
            } else {
                logger.traceGeneral(THIS_CLASS, "ecBusMosCollection  is null");
            }
        }
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private void addReferencesToReservedByAttribute(ConverterContext converterContext, SequenceAttribute sequenceAttribute, String string) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addReferencesToReservedByAttribute()");
        MoDataWrapper moDataWrapper = null;
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        if (moDataAccessor == null) {
            logger.traceAbnormal(THIS_CLASS, "MoDataAccessor accessor is null");
        } else {
            logger.traceGeneral(THIS_CLASS, "Accessing MOs of type EcBus");
            Collection collection = moDataAccessor.getByType(ECBUS_MO_TYPE);
            if (collection != null) {
                logger.traceGeneral(THIS_CLASS, "Iterate over MOs");
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    moDataWrapper = (MoDataWrapper)iterator.next();
                    logger.traceGeneral(THIS_CLASS, "Extract attribute ecBusConnectorRef where ldn match the Cabinet: " + string);
                    ReferenceAttribute referenceAttribute = (ReferenceAttribute)moDataWrapper.getAttribute(ECBUS_ATT_CONNECTOR_REF);
                    if (referenceAttribute == null || !referenceAttribute.getReferenceAsLDN().equals(string) || this.findEcBusRefInReservedBy(moDataWrapper.getLocalDistinguishedName(), sequenceAttribute)) continue;
                    logger.traceGeneral(THIS_CLASS, "Add HwUnit Ldn to Cabinet attribute ReservedBy");
                    sequenceAttribute.addElement((Attribute)new ReferenceAttribute("", moDataWrapper.getLocalDistinguishedName(), true));
                }
            } else {
                logger.traceGeneral(THIS_CLASS, "ecPortMoCollection is null");
            }
        }
        logger.traceReturn(THIS_CLASS, "addReferencesToReservedByAttribute()");
    }

    private boolean findEcBusRefInReservedBy(String string, SequenceAttribute sequenceAttribute) {
        Enumeration enumeration = sequenceAttribute.elements();
        while (enumeration.hasMoreElements()) {
            ReferenceAttribute referenceAttribute = (ReferenceAttribute)enumeration.nextElement();
            String string2 = referenceAttribute.getReferenceAsLDN();
            if (!string2.toLowerCase().equals(string.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

