/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.internal;

import BasicConfig.MIBRef;
import CelloAlarmIRPExtension.AlarmIRPExtensionHelper;
import CelloAlarmIRPExtension.AlarmIRPExtensionOperations;
import ConfigExtended.ConfigurationExtended;
import ConfigExtended.ConfigurationExtendedHelper;
import ConfigExtended.NotificationProducer;
import PerformanceIRPSystem._PerformanceIRPOperations;
import PerformanceIRPSystem._PerformanceIRPOperationsHelper;
import PmServiceExtended.PerformanceMonitoringExtendedHelper;
import PmServiceExtended.PerformanceMonitoringExtendedOperations;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.PortableServer.Servant;
import org.threegppsa5.AlarmIRPSystem._AlarmIRPOperations;
import org.threegppsa5.AlarmIRPSystem._AlarmIRPOperationsHelper;
import org.threegppsa5.NotificationIRPSystem._NotificationIRPOperations;
import org.threegppsa5.NotificationIRPSystem._NotificationIRPOperationsHelper;
import org.threegppsa5.PerformanceIRPSystem._PerformanceMonitoringOperations;
import org.threegppsa5.PerformanceIRPSystem._PerformanceMonitoringOperationsHelper;
import se.ericsson.cello.ProductInventory.InventoryService;
import se.ericsson.cello.ProductInventory.InventoryServiceHelper;
import se.ericsson.cello.neal.CppOamException;
import se.ericsson.cello.neal.NealRuntimeException;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.cm.OfflineCmUtil;
import se.ericsson.cello.neal.internal.ImmediateTaskRunner;
import se.ericsson.cello.neal.internal.InternalNameValueFactory;
import se.ericsson.cello.neal.internal.NealLog;
import se.ericsson.cello.neal.internal.NealOrb;
import se.ericsson.cello.neal.internal.ServiceContext;
import se.ericsson.cello.neal.internal.TaskRunner;
import se.ericsson.cello.neal.internal.omsi_version.AlarmIRPOperationsAdapter;
import se.ericsson.cello.neal.internal.omsi_version.ConfigurationExtendedAdapter;

public class ServiceContextImpl
implements ServiceContext {
    protected NealOrb nealOrb;
    protected Node node;
    private NamingContext rootNamingContext;
    private ConfigurationExtended configurationExtended;
    private NotificationProducer notificationProducer;
    private _AlarmIRPOperations alarmIRPOps;
    private AlarmIRPExtensionOperations alarmIRPExtOps;
    private _NotificationIRPOperations notificationIRPOps;
    private InventoryService inventoryService;
    private _PerformanceMonitoringOperations perfMonitorOps;
    private _PerformanceIRPOperations perfIRPOps;
    private PerformanceMonitoringExtendedOperations perfMonExtOps = null;
    private MIBRef mibRef;
    private AlarmIRPOperationsAdapter alarmIRPAdapter;
    private ConfigurationExtendedAdapter configurationAdapter;
    private static final String NS_CM_NAME = "CelloConfigurationService";
    private static final String CELLO_MIB_NAME = "Cello";
    private static final String NS_NOTIF_NAME = "NOTIFICATION_IRP_VERSION_1_1";
    private static final String NS_ALARM_NAME = "ALARM_IRP_VERSION_1_1";
    private static final String NS_PM_NAME = "CelloPerformanceMonitoring";
    private static final String NS_PM_IRP_NAME = "CelloPmNotifications";
    private static final String NS_PI_NAME = "CelloInventoryService";
    private static ServiceContext theMockServiceContext;

    public static void setMockServiceContext(ServiceContext serviceContext) {
        theMockServiceContext = serviceContext;
    }

    public static ServiceContext create() {
        return theMockServiceContext != null ? theMockServiceContext : new ServiceContextImpl();
    }

    protected ServiceContextImpl() {
    }

    public void init(Node node, NealOrb nealOrb, NamingContext namingContext) throws UserException {
        this.init(node, nealOrb, namingContext, true);
    }

    public void init(Node node, NealOrb nealOrb, NamingContext namingContext, boolean bl) throws UserException {
        this.nealOrb = nealOrb;
        this.node = node;
        this.setRootNamingContext(namingContext);
        if (bl) {
            NealLog.fine("Initializing OAM services. All services are required to be available");
            this.initFaultManagmentService();
            this.initProductInventoryService();
            this.initConfigurationService();
            this.initPerformanceMonitoringService();
        } else {
            NealLog.fine("Initializing OAM services. All services are not required to be available");
            try {
                this.initFaultManagmentService();
            }
            catch (Exception exception) {
                NealLog.info("Fault Management Service not available");
                this.setAlarmIRPOps(null);
                this.setAlarmIRPExtOps(null);
            }
            try {
                this.initProductInventoryService();
            }
            catch (Exception exception) {
                NealLog.info("Product Inventory Service not available");
                this.setInventoryService(null);
            }
            try {
                this.initConfigurationService();
            }
            catch (Exception exception) {
                NealLog.info("Configuration Service not available");
                this.setConfigurationExtended(null);
            }
            try {
                this.initPerformanceMonitoringService();
            }
            catch (Exception exception) {
                NealLog.info("Performance Monitoring Service not available");
                this.setPerfIRPOps(null);
            }
        }
    }

    protected void initProductInventoryService() throws UserException {
        Object object = this.resolveService(NS_PI_NAME);
        this.setInventoryService(InventoryServiceHelper.narrow(object));
    }

    protected void initPerformanceMonitoringService() throws UserException {
        Object object = this.resolveService(NS_PM_NAME);
        this.setPerfMonitorOps(_PerformanceMonitoringOperationsHelper.narrow(object));
        try {
            this.setPerfMonExtOps(PerformanceMonitoringExtendedHelper.narrow(object));
        }
        catch (Exception exception) {
            NealLog.info("Generic Performance Monitoring not supported by the node");
        }
        Object object2 = this.resolveService(NS_PM_IRP_NAME);
        this.setPerfIRPOps(_PerformanceIRPOperationsHelper.narrow(object2));
    }

    protected void initFaultManagmentService() throws UserException {
        Object object = this.resolveService(NS_ALARM_NAME);
        this.setAlarmIRPOps(_AlarmIRPOperationsHelper.narrow(object));
        Object object2 = this.resolveService(NS_ALARM_NAME);
        this.setAlarmIRPExtOps(AlarmIRPExtensionHelper.narrow(object2));
        Object object3 = this.resolveService(NS_NOTIF_NAME);
        this.setNotificationIRPOps(_NotificationIRPOperationsHelper.narrow(object3));
    }

    protected void initConfigurationService() throws UserException {
        Object object = this.resolveService(NS_CM_NAME);
        this.setConfigurationExtended(ConfigurationExtendedHelper.narrow(object));
        MIBRef mIBRef = this.getConfigurationExtended().get_MIB(CELLO_MIB_NAME, null);
        if (mIBRef == null) {
            NealLog.warning("Failed to retreive MIB 'Cello' from OAM service 'CelloConfigurationService'");
        }
        this.setMibRef(mIBRef);
        NotificationProducer notificationProducer = this.getConfigurationExtended().get_notification_producer();
        if (notificationProducer == null) {
            NealLog.warning("Failed to get the NotificationProducer from OAM service 'CelloConfigurationService'");
        }
        this.setNotificationProducer(notificationProducer);
    }

    private Object resolveService(String string) throws UserException {
        NameComponent[] nameComponentArray = new NameComponent[]{new NameComponent(string, "")};
        Object object = null;
        object = this.getRootNamingContext().resolve(nameComponentArray);
        return object;
    }

    public void free() {
        if (this.getInventoryService() != null) {
            this.getInventoryService()._release();
        }
        if (this.getPerfMonitorOps() != null) {
            this.getPerfMonitorOps()._release();
        }
        if (this.getAlarmIRPOps() != null) {
            this.getAlarmIRPOps()._release();
        }
        if (this.getNotificationIRPOps() != null) {
            this.getNotificationIRPOps()._release();
        }
        if (this.getConfigurationExtended() != null) {
            this.getConfigurationExtended()._release();
        }
        if (this.getRootNamingContext() != null) {
            this.getRootNamingContext()._release();
            this.setRootNamingContext(null);
        }
    }

    public MIBRef getMibRef() {
        this.checkConfigurationService();
        return this.mibRef;
    }

    protected void setMibRef(MIBRef mIBRef) {
        this.mibRef = mIBRef;
    }

    public _AlarmIRPOperations getAlarmIRPOps() {
        this.checkFaultManagementService();
        return this.alarmIRPOps;
    }

    public AlarmIRPExtensionOperations getAlarmIRPExtOps() {
        this.checkFaultManagementService();
        return this.alarmIRPExtOps;
    }

    public AlarmIRPOperationsAdapter getAlarmIRPAdapter() {
        this.checkFaultManagementService();
        return this.alarmIRPAdapter;
    }

    protected void setAlarmIRPOps(_AlarmIRPOperations _AlarmIRPOperations2) {
        this.alarmIRPOps = _AlarmIRPOperations2;
        this.alarmIRPAdapter = new AlarmIRPOperationsAdapter(_AlarmIRPOperations2);
    }

    protected void setAlarmIRPExtOps(AlarmIRPExtensionOperations alarmIRPExtensionOperations) {
        this.alarmIRPExtOps = alarmIRPExtensionOperations;
    }

    public ConfigurationExtended getConfigurationExtended() {
        this.checkConfigurationService();
        return this.configurationExtended;
    }

    public ConfigurationExtendedAdapter getConfigurationAdapter() {
        this.checkConfigurationService();
        return this.configurationAdapter;
    }

    protected void setConfigurationExtended(ConfigurationExtended configurationExtended) {
        this.configurationExtended = configurationExtended;
        this.configurationAdapter = new ConfigurationExtendedAdapter(configurationExtended);
    }

    public InventoryService getInventoryService() {
        this.checkProductInventoryService();
        return this.inventoryService;
    }

    protected void setInventoryService(InventoryService inventoryService) {
        this.inventoryService = inventoryService;
    }

    public _NotificationIRPOperations getNotificationIRPOps() {
        this.checkFaultManagementService();
        return this.notificationIRPOps;
    }

    protected void setNotificationIRPOps(_NotificationIRPOperations _NotificationIRPOperations2) {
        this.notificationIRPOps = _NotificationIRPOperations2;
    }

    public NotificationProducer getNotificationProducer() {
        this.checkConfigurationService();
        return this.notificationProducer;
    }

    protected void setNotificationProducer(NotificationProducer notificationProducer) {
        this.notificationProducer = notificationProducer;
    }

    public _PerformanceMonitoringOperations getPerfMonitorOps() {
        this.checkPerformanceMonitoringService();
        return this.perfMonitorOps;
    }

    public PerformanceMonitoringExtendedOperations getPerfMonExtOps() {
        this.checkPerformanceMonitoringService();
        return this.perfMonExtOps;
    }

    protected void setPerfMonitorOps(_PerformanceMonitoringOperations _PerformanceMonitoringOperations2) {
        this.perfMonitorOps = _PerformanceMonitoringOperations2;
    }

    public _PerformanceIRPOperations getPerfIRPOps() {
        this.checkPerformanceMonitoringService();
        return this.perfIRPOps;
    }

    public void setPerfIRPOps(_PerformanceIRPOperations _PerformanceIRPOperations2) {
        this.perfIRPOps = _PerformanceIRPOperations2;
    }

    public void setPerfMonExtOps(PerformanceMonitoringExtendedOperations performanceMonitoringExtendedOperations) {
        this.perfMonExtOps = performanceMonitoringExtendedOperations;
    }

    public void connect(Servant servant) {
        try {
            this.nealOrb.connect(servant);
            String string = this.nealOrb.object_to_string(this.servant_to_reference(servant));
            NealLog.finest("Connecting servant " + string + " (" + this.nealOrb.getHostname(string) + ")");
        }
        catch (UserException userException) {
            throw new NealRuntimeException("Failed to connect to servant=" + servant + "!", userException);
        }
    }

    public void disconnect(Servant servant) {
        this.nealOrb.disconnect(servant);
    }

    public Object servant_to_reference(Servant servant) {
        return this.nealOrb.servant_to_reference(servant);
    }

    public Servant reference_to_servant(Object object) {
        return this.nealOrb.reference_to_servant(object);
    }

    public Boolean isCmServiceSecure() {
        Boolean bl = null;
        if (this.configurationExtended != null) {
            bl = this.nealOrb.isSecure(this.configurationExtended);
        }
        return bl;
    }

    public InternalNameValueFactory getNameValueFactory() {
        return (InternalNameValueFactory)OfflineCmUtil.getNameValueFactory();
    }

    public TaskRunner getTaskRunner(String string) {
        ImmediateTaskRunner immediateTaskRunner = new ImmediateTaskRunner(string);
        return immediateTaskRunner;
    }

    public NamingContext getRootNamingContext() {
        return this.rootNamingContext;
    }

    protected void setRootNamingContext(NamingContext namingContext) {
        this.rootNamingContext = namingContext;
    }

    public NealOrb getNealOrb() {
        return this.nealOrb;
    }

    public Node getNode() {
        return this.node;
    }

    protected void checkConfigurationService() {
        if (this.configurationExtended == null) {
            try {
                this.initConfigurationService();
            }
            catch (UserException userException) {
                throw new CppOamException("Configuration Service not available", userException);
            }
        }
    }

    protected void checkFaultManagementService() {
        if (this.alarmIRPOps == null) {
            try {
                this.initFaultManagmentService();
            }
            catch (UserException userException) {
                throw new CppOamException("Fault Management Service not available: " + userException.toString());
            }
        }
    }

    protected void checkPerformanceMonitoringService() {
        if (this.perfIRPOps == null) {
            try {
                this.initPerformanceMonitoringService();
            }
            catch (UserException userException) {
                throw new CppOamException("Performance Monitoring Service not available: " + userException.toString());
            }
        }
    }

    protected void checkProductInventoryService() {
        if (this.inventoryService == null) {
            try {
                this.initProductInventoryService();
            }
            catch (UserException userException) {
                throw new CppOamException("Product Inventory Service not available: " + userException.toString());
            }
        }
    }
}

