/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.DomainExtension;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.mimparser.MomCardinality;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomRelationship;
import se.ericsson.cello.mimparser.MomRelationshipEndInfo;
import se.ericsson.cello.mimparser.model.DomainExtensionImpl;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MomBase;
import se.ericsson.cello.mimparser.model.MomClassImpl;

public class MomRelationshipImpl
extends MomBase
implements MomRelationship,
Cloneable {
    private String fromElementName;
    private String toElementName;
    private String fromName;
    private String toName;
    private String associationType;
    private MomClassImpl from;
    private MomRelationshipEndInfo fromInfo;
    private MomCardinality fromCardinality;
    private MomClassImpl to;
    private MomRelationshipEndInfo toInfo;
    private MomCardinality toCardinality;
    private MomRelationshipImpl masterObject;
    private DomainExtension domainExtension;
    private boolean mandatory;
    private List associationClassAttributes = new ArrayList(0);
    private List clones;

    public MomRelationshipImpl(String xmlType, Attributes attributes, MimModelImpl model, int id) {
        super(xmlType, attributes, model, id);
        this.masterObject = this;
        model.addRelationshipToBeResolved(this);
    }

    protected void addClone(MomRelationshipImpl clone) {
        if (this.clones == null) {
            this.clones = new ArrayList(0);
        }
        this.clones.add(clone);
    }

    public DomainExtension getDomain() {
        return this.domainExtension;
    }

    public void setDomain(DomainExtensionImpl domainExtension) {
        this.domainExtension = domainExtension;
    }

    public void setDescription(String description) {
        super.setDescription(description);
        if (this.clones != null) {
            for (int i = 0; i < this.clones.size(); ++i) {
                MomRelationshipImpl ri = (MomRelationshipImpl)this.clones.get(i);
                ri.setDescription(description);
            }
        }
    }

    public MomClass getFrom() {
        return this.from;
    }

    public void setFrom(MomClassImpl fromObj) {
        this.from = fromObj;
    }

    public MomRelationshipEndInfo getFromInfo() {
        return this.fromInfo;
    }

    public void setFromInfo(MomRelationshipEndInfo fromInfoObj) {
        this.fromInfo = fromInfoObj;
    }

    public MomCardinality getFromCardinality() {
        return this.fromCardinality;
    }

    public void setFromCardinality(MomCardinality fromCardinalityObj) {
        this.fromCardinality = fromCardinalityObj;
    }

    public MomClass getTo() {
        return this.to;
    }

    public void setTo(MomClassImpl toObj) {
        this.to = toObj;
    }

    public MomRelationshipEndInfo getToInfo() {
        return this.toInfo;
    }

    public void setToInfo(MomRelationshipEndInfo toInfoObj) {
        this.toInfo = toInfoObj;
    }

    public MomCardinality getToCardinality() {
        return this.toCardinality;
    }

    public void setToCardinality(MomCardinality toCardinalityObj) {
        this.toCardinality = toCardinalityObj;
    }

    public String getAssociationType() {
        return this.associationType;
    }

    public void setAssociationType(String type) {
        this.associationType = type;
    }

    public Iterator getAssociationClassAttributes() {
        return this.associationClassAttributes.iterator();
    }

    public void addAssociationClassAttribute(MomAttribute momAttribute) {
        this.associationClassAttributes.add(momAttribute);
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory() {
        this.mandatory = true;
    }

    public String getFromElementName() {
        return this.fromElementName;
    }

    public void setFromElementName(String name) {
        this.fromElementName = name;
    }

    public void setToElementName(String name) {
        this.toElementName = name;
    }

    public String getToElementName() {
        return this.toElementName;
    }

    public String getFromName() {
        return this.fromName;
    }

    public void setFromName(String name) {
        this.fromName = name;
    }

    public void setToName(String name) {
        this.toName = name;
    }

    public String getToName() {
        return this.toName;
    }

    public MomRelationshipImpl createNewRelationshipWithEmptyTo() {
        MomRelationshipImpl cloneObj = null;
        try {
            cloneObj = (MomRelationshipImpl)this.masterObject.clone();
            cloneObj.clones = null;
            this.masterObject.addClone(cloneObj);
            this.getModel().addRelationshipToBeResolved(cloneObj);
            cloneObj.to = null;
            cloneObj.toInfo = null;
            cloneObj.toCardinality = null;
            cloneObj.toElementName = null;
            cloneObj.toName = null;
        }
        catch (Exception exc) {
            String errText = "Can not clone relationship\n reason=" + exc.toString();
            this.getModel().addToWarningList(errText);
            return null;
        }
        return cloneObj;
    }

    public MomRelationshipImpl createNewRelationshipWithReversedDirection() {
        MomRelationshipImpl cloneObj = null;
        try {
            cloneObj = (MomRelationshipImpl)this.masterObject.clone();
            cloneObj.clones = null;
            this.masterObject.addClone(cloneObj);
            this.getModel().addRelationshipToBeResolved(cloneObj);
            String fromElementName = this.fromElementName;
            String fromName = this.fromName;
            MomClassImpl from = this.from;
            MomRelationshipEndInfo fromInfo = this.fromInfo;
            MomCardinality fromCardinality = this.fromCardinality;
            this.fromElementName = this.toElementName;
            this.fromName = this.toName;
            this.from = this.to;
            this.fromInfo = this.toInfo;
            this.fromCardinality = this.toCardinality;
            this.toElementName = fromElementName;
            this.toName = fromName;
            this.to = from;
            this.toInfo = fromInfo;
            this.toCardinality = fromCardinality;
        }
        catch (Exception exc) {
            String errText = "Can not reverse relationship\n reason=" + exc.toString();
            this.getModel().addToWarningList(errText);
        }
        return cloneObj;
    }

    public void synchronizeAssociationClassAttributes() {
        if (this.clones != null) {
            for (int i = 0; i < this.clones.size(); ++i) {
                MomRelationshipImpl clone = (MomRelationshipImpl)this.clones.get(i);
                clone.associationClassAttributes = this.associationClassAttributes;
            }
        }
    }

    public void setName(String name) {
        super.setName(name);
    }
}

