/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomAssociationEnd;
import se.ericsson.cello.mimparser.MomChild;
import se.ericsson.cello.mimparser.MomSupported;
import se.ericsson.cello.mimparser.model.MomBiDirectionalAssociationImpl;
import se.ericsson.cello.mimparser.model.MomClassImpl;
import se.ericsson.cello.mimparser.model.MomContainmentImpl;
import se.ericsson.cello.mimparser.model.MomRelationshipImpl;
import se.ericsson.cello.mimparser.model.MomSoftLinkImpl;
import se.ericsson.cello.mimparser.model.MomSupportImpl;
import se.ericsson.cello.mimparser.model.MomUniDirectionalAssociationImpl;

public class RelationshipResolver {
    private List relationships = new ArrayList(0);
    private List softLinks = new ArrayList(0);
    private List supports = new ArrayList(0);
    private List biDirectionalAssociations = new ArrayList(0);
    private List uniDirectionalAssociations = new ArrayList(0);
    private List containments = new ArrayList(0);

    RelationshipResolver() {
    }

    void addRelationship(MomRelationshipImpl relationship) {
        this.relationships.add(relationship);
    }

    void addSoftLink(MomSoftLinkImpl softLink) {
        this.softLinks.add(softLink);
    }

    void addSupport(MomSupportImpl support) {
        this.supports.add(support);
    }

    void addBiDirectionalAssociation(MomBiDirectionalAssociationImpl association) {
        this.biDirectionalAssociations.add(association);
    }

    void addUniDirectionalAssociation(MomUniDirectionalAssociationImpl association) {
        this.uniDirectionalAssociations.add(association);
    }

    void addContainment(MomContainmentImpl containment) {
        this.containments.add(containment);
    }

    void resolve(MimModel model) {
        int noRelations = this.relationships.size();
        for (int i = 0; i < noRelations; ++i) {
            MomRelationshipImpl r = (MomRelationshipImpl)this.relationships.get(i);
            this.resolveFromTo(r, model);
        }
        int noSoftlinks = this.softLinks.size();
        for (int i = 0; i < noSoftlinks; ++i) {
            MomSoftLinkImpl r = (MomSoftLinkImpl)this.softLinks.get(i);
            this.resolveSoftLinks(r, model);
        }
        int noSupports = this.supports.size();
        for (int i = 0; i < noSupports; ++i) {
            MomSupportImpl r = (MomSupportImpl)this.supports.get(i);
            this.resolveSupports(r, model);
        }
        int noBiDirectionalAssociations = this.biDirectionalAssociations.size();
        for (int i = 0; i < noBiDirectionalAssociations; ++i) {
            MomBiDirectionalAssociationImpl r = (MomBiDirectionalAssociationImpl)this.biDirectionalAssociations.get(i);
            this.resolveBiDirectionalAssociation(r, model);
        }
        int noUniDirectionalAssociations = this.uniDirectionalAssociations.size();
        for (int i = 0; i < noUniDirectionalAssociations; ++i) {
            MomUniDirectionalAssociationImpl r = (MomUniDirectionalAssociationImpl)this.uniDirectionalAssociations.get(i);
            this.resolveUniDirectionalAssociation(r, model);
        }
        int noContainments = this.containments.size();
        for (int i = 0; i < noContainments; ++i) {
            MomContainmentImpl r = (MomContainmentImpl)this.containments.get(i);
            this.resolveContainments(r, model);
        }
    }

    private void resolveFromTo(MomRelationshipImpl r, MimModel model) {
        String fromName = r.getFromElementName();
        String toName = r.getToElementName();
        if (fromName != null && toName != null) {
            MomClassImpl fromMo = (MomClassImpl)model.getClass(fromName);
            MomClassImpl toMo = (MomClassImpl)model.getClass(toName);
            if (fromMo == null || toMo == null) {
                String errorMsg = "Can not resolve From/To relation for relationship=" + r.getName() + ". from Object name=" + fromName + " to Object name=" + toName + " method=RelationshipResolver.resolveParentChild()";
                throw new RuntimeException(errorMsg);
            }
            r.setFrom(fromMo);
            r.setTo(toMo);
            toMo.addParent(fromMo, r);
            toMo.addRelationship(r);
            fromMo.addChild(toMo, r);
            fromMo.addRelationship(r);
        }
    }

    private void resolveSoftLinks(MomSoftLinkImpl momSoftLink, MimModel mimModel) {
        String className = momSoftLink.getParent().getHasClass().getName();
        MomClassImpl parentClass = (MomClassImpl)mimModel.getClass(className);
        Iterator children = momSoftLink.getChildren();
        while (children.hasNext()) {
            MomChild momChild = (MomChild)children.next();
            String childName = momChild.getHasClass().getName();
            MomClassImpl childClass = (MomClassImpl)mimModel.getClass(childName);
            childClass.addSoftLinkParent(parentClass);
            parentClass.addSoftLinkChild(childClass);
        }
    }

    private void resolveSupports(MomSupportImpl momSupport, MimModel mimModel) {
        String className = momSupport.getSupporter().getHasClass().getName();
        MomClassImpl parentClass = (MomClassImpl)mimModel.getClass(className);
        Iterator children = momSupport.getSupported();
        while (children.hasNext()) {
            MomSupported momSupported = (MomSupported)children.next();
            String supportedName = momSupported.getHasClass().getName();
            MomClassImpl supportedClass = (MomClassImpl)mimModel.getClass(supportedName);
            supportedClass.addSupporter(parentClass);
            parentClass.addSupported(supportedClass);
        }
    }

    private void resolveBiDirectionalAssociation(MomBiDirectionalAssociationImpl biDirectionalAssociation, MimModel mimModel) {
        MomAssociationEnd from = biDirectionalAssociation.getAssociationEndFrom();
        String className = biDirectionalAssociation.getAssociationEndFrom().getHasClass().getName();
        MomClassImpl parentClass = (MomClassImpl)mimModel.getClass(className);
        Iterator children = biDirectionalAssociation.getAssociationEndsTo();
        while (children.hasNext()) {
            MomAssociationEnd to = (MomAssociationEnd)children.next();
            String childName = to.getHasClass().getName();
            MomClassImpl childClass = (MomClassImpl)mimModel.getClass(childName);
            childClass.addDirectionalAssociationFrom(from);
            parentClass.addDirectionalAssociationTo(to);
        }
    }

    private void resolveUniDirectionalAssociation(MomUniDirectionalAssociationImpl unidirectionalAssociation, MimModel mimModel) {
        String className = unidirectionalAssociation.getHasClass().getName();
        MomClassImpl parentClass = (MomClassImpl)mimModel.getClass(className);
        Iterator children = unidirectionalAssociation.getAssociationEndsTo();
        while (children.hasNext()) {
            parentClass.addDirectionalAssociationTo((MomAssociationEnd)children.next());
        }
    }

    private void resolveContainments(MomContainmentImpl momContainment, MimModel mimModel) {
        String className = momContainment.getParent().getHasClass().getName();
        MomClassImpl parentClass = (MomClassImpl)mimModel.getClass(className);
        Iterator children = momContainment.getChildren();
        while (children.hasNext()) {
            MomChild momChild = (MomChild)children.next();
            String childName = momChild.getHasClass().getName();
            MomClassImpl childClass = (MomClassImpl)mimModel.getClass(childName);
            childClass.addContaimentParent(parentClass);
            parentClass.addContainmentChild(childClass);
        }
    }
}

