/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.model.MomAttributeImpl;
import se.ericsson.cello.mimparser.model.RestartTypeImpl;
import se.ericsson.cello.mimparser.state.AttributeValueState;
import se.ericsson.cello.mimparser.state.ConditionState;
import se.ericsson.cello.mimparser.state.CounterContextState;
import se.ericsson.cello.mimparser.state.CounterResetState;
import se.ericsson.cello.mimparser.state.CounterTypeState;
import se.ericsson.cello.mimparser.state.DependenciesScriptState;
import se.ericsson.cello.mimparser.state.DependenciesState;
import se.ericsson.cello.mimparser.state.DeprecatedState;
import se.ericsson.cello.mimparser.state.DisturbancesState;
import se.ericsson.cello.mimparser.state.FeatureState;
import se.ericsson.cello.mimparser.state.FilterState;
import se.ericsson.cello.mimparser.state.MomBaseState;
import se.ericsson.cello.mimparser.state.ObsoleteState;
import se.ericsson.cello.mimparser.state.PreConditionState;
import se.ericsson.cello.mimparser.state.RestartTypeState;
import se.ericsson.cello.mimparser.state.SamplingRateState;
import se.ericsson.cello.mimparser.state.ScannerState;
import se.ericsson.cello.mimparser.state.SideEffectsState;
import se.ericsson.cello.mimparser.state.SpecificationState;
import se.ericsson.cello.mimparser.state.TakesEffectState;
import se.ericsson.cello.mimparser.state.TransactionConstraintState;
import se.ericsson.cello.mimparser.state.UndefinedValueState;
import se.ericsson.cello.mimparser.state.VisibilityState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

class AttributeState
extends MomBaseState {
    private MomAttributeImpl momAttribute;
    public static final String ATTRIBUTE_TAG = "attribute";

    public AttributeState(MomAttributeImpl moAttribute) {
        super(ATTRIBUTE_TAG);
        this.momAttribute = moAttribute;
    }

    public void startElement(StateMachine stateMachine, String name, Attributes attributes) {
        super.startElement(stateMachine, name, this.momAttribute);
        this.handleFlagElements(name);
        if (name.equals("deprecated")) {
            stateMachine.pushState(new DeprecatedState(this.momAttribute));
        } else if (name.equals("undefinedValue")) {
            stateMachine.pushState(new UndefinedValueState(this.momAttribute));
        } else if (name.equals("disturbances")) {
            stateMachine.pushState(new DisturbancesState(this.momAttribute));
        } else if (name.equals("takesEffect")) {
            stateMachine.pushState(new TakesEffectState(this.momAttribute));
        } else if (name.equals("transactionConstraint")) {
            stateMachine.pushState(new TransactionConstraintState(this.momAttribute));
        } else if (name.equals("sideEffects")) {
            stateMachine.pushState(new SideEffectsState(this.momAttribute));
        } else if (name.equals("dependencies")) {
            stateMachine.pushState(new DependenciesState(this.momAttribute));
        } else if (name.equals("precondition")) {
            stateMachine.pushState(new PreConditionState(this.momAttribute));
        } else if (name.equals("condition")) {
            stateMachine.pushState(new ConditionState(this.momAttribute));
        } else if (name.equals("counterType")) {
            stateMachine.pushState(new CounterTypeState(this.momAttribute));
        } else if (name.equals("counterReset")) {
            stateMachine.pushState(new CounterResetState(this.momAttribute));
        } else if (name.equals("samplingRate")) {
            stateMachine.pushState(new SamplingRateState(this.momAttribute));
        } else if (name.equals("scanner")) {
            stateMachine.pushState(new ScannerState(this.momAttribute));
        } else if (name.equals("counterContext")) {
            stateMachine.pushState(new CounterContextState(this.momAttribute));
        } else if (name.equals("specification")) {
            stateMachine.pushState(new SpecificationState(this.momAttribute));
        } else if (name.equals("obsolete")) {
            stateMachine.pushState(new ObsoleteState(this.momAttribute));
        } else if (name.equals("visibility")) {
            stateMachine.pushState(new VisibilityState(this.momAttribute));
        } else if (name.equals("dependenciesScript")) {
            stateMachine.pushState(new DependenciesScriptState(this.momAttribute));
        } else if (name.equals("filter")) {
            stateMachine.pushState(new FilterState(this.momAttribute));
        } else if (name.equals("feature")) {
            stateMachine.pushState(new FeatureState(this.momAttribute));
        } else if (name.equals("value")) {
            stateMachine.pushState(new AttributeValueState(this.momAttribute));
        } else if (name.equals("restartType")) {
            RestartTypeImpl restartType = new RestartTypeImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.momAttribute.setRestart(restartType);
            stateMachine.pushState(new RestartTypeState(restartType));
        } else {
            stateMachine.getDataTypeManager().handleDataTypes(this.momAttribute, name, attributes);
        }
    }

    private void handleFlagElements(String name) {
        if (name.equals("mandatory")) {
            this.momAttribute.setMandatory();
        } else if (name.equals("noNotification")) {
            this.momAttribute.setNoNotification();
        } else if (name.equals("restricted")) {
            this.momAttribute.setRestricted();
        } else if (name.equals("readOnly")) {
            this.momAttribute.setReadOnly();
        } else if (name.equals("nonPersistent")) {
            this.momAttribute.setNonPersistent();
        } else if (name.equals("local")) {
            this.momAttribute.setLocal();
        } else if (name.equals("static")) {
            this.momAttribute.setStatic();
        } else if (name.equals("undefined")) {
            this.momAttribute.setUndefined();
        } else if (name.equals("lockBeforeModify")) {
            this.momAttribute.setLockBeforeModify();
        } else if (name.equals("interfaceOnly")) {
            this.momAttribute.setInterfaceOnly();
        } else if (name.equals("transactionRequired")) {
            this.momAttribute.setTransactionRequired();
        } else if (name.equals("indexed")) {
            this.momAttribute.setIsIndexed();
        } else if (name.equals("key")) {
            this.momAttribute.setHasKey();
        }
    }
}

