/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.model.DirectionalAssociationImpl;
import se.ericsson.cello.mimparser.model.DomainExtensionImpl;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MomAssociationEndImpl;
import se.ericsson.cello.mimparser.model.MomBiDirectionalAssociationImpl;
import se.ericsson.cello.mimparser.model.MomCardinalityImpl;
import se.ericsson.cello.mimparser.model.MomHasClassImpl;
import se.ericsson.cello.mimparser.model.MomRelationshipEndInfoImpl;
import se.ericsson.cello.mimparser.model.MomRelationshipImpl;
import se.ericsson.cello.mimparser.model.MomUniDirectionalAssociationImpl;
import se.ericsson.cello.mimparser.state.ApplicationTagState;
import se.ericsson.cello.mimparser.state.DeletionPolicySettable;
import se.ericsson.cello.mimparser.state.DeletionPolicyState;
import se.ericsson.cello.mimparser.state.DescriptionSettable;
import se.ericsson.cello.mimparser.state.DescriptionState;
import se.ericsson.cello.mimparser.state.DomainExtensionState;
import se.ericsson.cello.mimparser.state.HasClassState;
import se.ericsson.cello.mimparser.state.MaxMinSettable;
import se.ericsson.cello.mimparser.state.MaxState;
import se.ericsson.cello.mimparser.state.MinState;
import se.ericsson.cello.mimparser.state.MomBaseState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

class FromState
extends MomBaseState
implements MaxMinSettable,
DescriptionSettable,
DeletionPolicySettable {
    private MomRelationshipImpl momRelationship;
    private MomAssociationEndImpl associationEnd = null;
    private static String[] allPossibleFromElements = new String[]{"associationEnd", "hasClass", "supporter"};
    private MimModelImpl model;

    public FromState(MomRelationshipImpl moRelationship, DirectionalAssociationImpl associationImpl, StateMachine stateMachine, String returnTag, Attributes attributes) {
        super(returnTag);
        this.momRelationship = moRelationship;
        if (returnTag.equals("hasClass")) {
            this.momRelationship.setFromElementName(attributes.getValue("name"));
            if (associationImpl instanceof MomUniDirectionalAssociationImpl) {
                MomUniDirectionalAssociationImpl unidirectionalAssociation = (MomUniDirectionalAssociationImpl)associationImpl;
                MomClass momClass = stateMachine.getParseInfo().getMimModel().getClass(attributes.getValue("name"));
                MomHasClassImpl hasClass = new MomHasClassImpl(attributes, momClass);
                unidirectionalAssociation.setHasClass(hasClass);
            }
        } else if (returnTag.equals("associationEnd")) {
            if (associationImpl instanceof MomBiDirectionalAssociationImpl) {
                MomBiDirectionalAssociationImpl biDirectionalAssociation = (MomBiDirectionalAssociationImpl)associationImpl;
                this.associationEnd = new MomAssociationEndImpl(returnTag, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
                biDirectionalAssociation.setAssociationEndFrom(this.associationEnd);
            }
            this.momRelationship.setFromName(attributes.getValue("name"));
        }
    }

    public void startElement(StateMachine stateMachine, String name, Attributes attributes) {
        this.model = stateMachine.getParseInfo().getMimModel();
        if (name.equals("description")) {
            stateMachine.pushState(new DescriptionState(this));
        } else if (name.equals("applicationTag")) {
            stateMachine.pushState(new ApplicationTagState(this));
        } else if (name.equals("hasClass")) {
            MomClass momClass = stateMachine.getParseInfo().getMimModel().getClass(attributes.getValue("name"));
            MomHasClassImpl hasClass = new MomHasClassImpl(attributes, momClass);
            this.associationEnd.setHasClass(hasClass);
            stateMachine.pushState(new HasClassState(hasClass));
            this.momRelationship.setFromElementName(attributes.getValue("name"));
        } else if (name.equals("cardinality")) {
            this.associationEnd.setCardinality(this.getCardinality());
        } else if (name.equals("min")) {
            stateMachine.pushState(new MinState(this));
        } else if (name.equals("max")) {
            stateMachine.pushState(new MaxState(this));
        } else if (name.equals("deletionPolicy")) {
            stateMachine.pushState(new DeletionPolicyState(this));
        } else if (name.equals("domainExtension")) {
            DomainExtensionImpl domainObject = new DomainExtensionImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.associationEnd.setDomain(domainObject);
            stateMachine.pushState(new DomainExtensionState(domainObject));
        }
    }

    public void setDescription(String description) {
        MomRelationshipEndInfoImpl endInfo = this.getEndInfo();
        endInfo.setDescription(description);
    }

    public void setApplicationTag(String applicationTag) {
        MomRelationshipEndInfoImpl endInfo = this.getEndInfo();
        endInfo.setApplicationTag(applicationTag);
    }

    public void addMinValue(String minValue) {
        MomCardinalityImpl cardinality = this.getCardinality();
        cardinality.setMin(minValue);
    }

    public void addMaxValue(String maxValue) {
        MomCardinalityImpl cardinality = this.getCardinality();
        cardinality.setMax(maxValue);
    }

    private MomRelationshipEndInfoImpl getEndInfo() {
        MomRelationshipEndInfoImpl endInfo = (MomRelationshipEndInfoImpl)this.momRelationship.getFromInfo();
        if (endInfo == null) {
            endInfo = new MomRelationshipEndInfoImpl();
            this.momRelationship.setFromInfo(endInfo);
        }
        return endInfo;
    }

    private MomCardinalityImpl getCardinality() {
        MomCardinalityImpl cardinality = (MomCardinalityImpl)this.momRelationship.getFromCardinality();
        if (cardinality == null) {
            cardinality = new MomCardinalityImpl(this.model);
            this.momRelationship.setFromCardinality(cardinality);
        }
        return cardinality;
    }

    public static boolean isFromElement(String elementName) {
        boolean isType = false;
        for (int i = 0; i < allPossibleFromElements.length; ++i) {
            if (!elementName.equals(allPossibleFromElements[i])) continue;
            isType = true;
            break;
        }
        return isType;
    }

    public void setDeletionPolicy(String deletionPolicy) {
        this.associationEnd.setDeletionPolicy(deletionPolicy);
    }
}

