/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.seclev.proxy;

import enea.ose.system.AttachSignal;
import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import se.ericsson.cello.seclev.SecurityEvent;
import se.ericsson.cello.seclev.SecurityEventException;
import se.ericsson.cello.seclev.SecurityEventMgr;
import se.ericsson.cello.seclev.proxy.IpomSeclevjiChangeInd;
import se.ericsson.cello.seclev.proxy.IpomSeclevjiInitiateServiceCfm;
import se.ericsson.cello.seclev.proxy.IpomSeclevjiInitiateServiceReq;
import se.ericsson.cello.seclev.proxy.IpomSeclevjiNotifySubscribeReq;
import se.ericsson.cello.seclev.proxy.IpomSeclevjiTerminateServiceCfm;
import se.ericsson.cello.seclev.proxy.IpomSeclevjiTerminateServiceReq;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.support.sigutil.SignalObserver;
import se.ericsson.cello.support.sigutil.SignalPort;
import se.ericsson.cello.support.sigutil.SubscriptionObserver;

public class SecurityEventProxy
implements SubscriptionObserver,
SignalObserver {
    public static final String SERVICE_NAME = "IPOM_SECLEVJI_SERVICE_NAME";
    private SignalPort signalPort = PortManager.instance();
    private SecurityEventMgr mgr;
    private static final Class SECLEVJI_CHANGE_IND = IpomSeclevjiChangeInd.class;
    private static OseProcess op = null;
    private static final int MAX_NO_OF_RETRIES = 5;
    private static final int PV_FIRST = 1;
    private static final int PV_SECOND = 1;
    private static final int PV_THIRD = 1;
    private static final int IPOM_SECLEVEL_OK = 0;
    private static final int TRACEGROUP = 5;
    private static SecurityEventProxy instance;
    private static final int RECEIVE_TIMEOUT = 5000;

    public static SecurityEventProxy instance() {
        if (instance == null) {
            instance = new SecurityEventProxy();
        }
        return instance;
    }

    public void registerSubscriber(SecurityEventMgr securityEventMgr) {
        this.mgr = securityEventMgr;
    }

    public synchronized void serviceAdded(String string) {
        MessageLog.trace((int)5, this.getClass(), (String)"serviceAdded = IPOM_SECLEVJI_SERVICE_NAME");
        if (op != null) {
            if (op.equals((Object)OseNameServer.lookup((String)SERVICE_NAME))) {
                this.sendIpomSeclevjiTerminateServiceReq();
            }
        }
        int n = 0;
        boolean bl = false;
        op = OseNameServer.lookup((String)SERVICE_NAME);
        while (true) {
            if (op != null && bl || n > 5) break;
            if (op != null) {
                MessageLog.trace((int)5, this.getClass(), (String)("In serviceAdded, op = : " + op));
                bl = this.initiateService();
                if (bl) {
                    return;
                }
                MessageLog.trace((int)5, this.getClass(), (String)"Failed to initiate service IPOM_SECLEVJI_SERVICE_NAME, retrying.");
            } else if (op == null) {
                MessageLog.trace((int)5, this.getClass(), (String)"Failed to look up service name IPOM_SECLEVJI_SERVICE_NAME in name server, retrying.");
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            op = OseNameServer.lookup((String)SERVICE_NAME);
            ++n;
        }
        if (op == null) {
            MessageLog.traceError(this.getClass(), (String)"Failed to look up service name IPOM_SECLEVJI_SERVICE_NAME in name server. SecurityEvent indications will not be received. ORB will not be restarted at security events.");
            return;
        }
        if (!bl) {
            MessageLog.traceError(this.getClass(), (String)"Failed to initiate service IPOM_SECLEVJI_SERVICE_NAME. SecurityEvent indications will not be received. ORB will not be restarted at security events.");
            return;
        }
    }

    public synchronized void serviceRemoved(String string) {
        block3: {
            block2: {
                MessageLog.trace((int)5, this.getClass(), (String)"serviceRemoved: IPOM_SECLEVJI_SERVICE_NAME");
                if (op == null) break block2;
                if (op.equals((Object)OseNameServer.lookup((String)SERVICE_NAME))) break block3;
            }
            op = null;
        }
    }

    public void signalReceived(InSignal inSignal) {
        MessageLog.trace((int)5, this.getClass(), (String)("signalReceived(enea.ose.system.InSignal sig), sig: " + inSignal));
        if (inSignal instanceof IpomSeclevjiChangeInd) {
            IpomSeclevjiChangeInd ipomSeclevjiChangeInd = (IpomSeclevjiChangeInd)inSignal;
            try {
                SecurityEvent securityEvent = new SecurityEvent(ipomSeclevjiChangeInd.getOldSeclevel(), ipomSeclevjiChangeInd.getNewSeclevel(), ipomSeclevjiChangeInd.getNewNodecreds(), ipomSeclevjiChangeInd.getTelnetFtpSecure(), ipomSeclevjiChangeInd.getTargetMonitorSecure(), ipomSeclevjiChangeInd.getDebugServerSecure(), ipomSeclevjiChangeInd.getFileTransferClientSecure());
                this.mgr.securityEventNotification(securityEvent);
            }
            catch (SecurityEventException securityEventException) {
                MessageLog.traceError(this.getClass(), (String)("Faulty IpomSeclevjiChangeInd received. " + securityEventException.getMessage()));
            }
        } else {
            MessageLog.info(this.getClass(), (String)"signalReceived is NOT instance of IpomSeclevjiChangeInd");
        }
    }

    private SecurityEventProxy() {
        this.signalPort.addSignalObserver((SignalObserver)this, SECLEVJI_CHANGE_IND);
        OseNameServer.addSubscriptionObserver((String)SERVICE_NAME, (SubscriptionObserver)this);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean initiateService() {
        IpomSeclevjiInitiateServiceReq ipomSeclevjiInitiateServiceReq = new IpomSeclevjiInitiateServiceReq(1, 1, 1);
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)ipomSeclevjiInitiateServiceReq, (Class)IpomSeclevjiInitiateServiceCfm.class, (int)5000);
        if (signal == null) {
            MessageLog.trace((int)5, this.getClass(), (String)" initiate service: no response signal, rspSig == null. ");
            return false;
        }
        if (signal instanceof IpomSeclevjiInitiateServiceCfm) {
            if (((IpomSeclevjiInitiateServiceCfm)signal).getResult() == 0) {
                MessageLog.trace((int)5, this.getClass(), (String)(" initiate service ok, pv = : " + ((IpomSeclevjiInitiateServiceCfm)signal).getSelectedPV()));
                IpomSeclevjiNotifySubscribeReq ipomSeclevjiNotifySubscribeReq = new IpomSeclevjiNotifySubscribeReq();
                OseProcess oseProcess = this.signalPort.getOseProcess();
                SignalHelper.sendWithSender((OseProcess)op, (OseProcess)oseProcess, (Signal)ipomSeclevjiNotifySubscribeReq);
                return true;
            }
            MessageLog.trace((int)5, this.getClass(), (String)(" initiate service not ok, received result: " + ((IpomSeclevjiInitiateServiceCfm)signal).getResult() + "pv received: " + ((IpomSeclevjiInitiateServiceCfm)signal).getSelectedPV()));
            return false;
        }
        if (signal instanceof AttachSignal) {
            MessageLog.trace((int)5, this.getClass(), (String)"initiate service not ok (received AttachSignal), receiver process terminated: IPOM_SECLEVJI_SERVICE_NAME");
            return false;
        }
        MessageLog.info(this.getClass(), (String)("initiate service not ok, received unexpected response signal of class: " + signal.getClass()));
        return false;
    }

    protected void sendIpomSeclevjiTerminateServiceReq() {
        IpomSeclevjiTerminateServiceReq ipomSeclevjiTerminateServiceReq = new IpomSeclevjiTerminateServiceReq();
        IpomSeclevjiTerminateServiceCfm ipomSeclevjiTerminateServiceCfm = (IpomSeclevjiTerminateServiceCfm)SignalHelper.sendAndReceiveAttachedClean((OseProcess)op, (Signal)ipomSeclevjiTerminateServiceReq, (Class)IpomSeclevjiTerminateServiceCfm.class, (int)5000);
        if (ipomSeclevjiTerminateServiceCfm != null) {
            if (ipomSeclevjiTerminateServiceCfm instanceof IpomSeclevjiTerminateServiceCfm) {
                MessageLog.trace((int)5, this.getClass(), (String)" serviceAdded, termination of old service confirmed");
            } else {
                MessageLog.info(this.getClass(), (String)(" serviceAdded, IpomSeclevjiTerminateServiceReq, received rspSig:  " + ((Object)((Object)ipomSeclevjiTerminateServiceCfm)).getClass()));
            }
        }
    }
}

