/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swmanagement;

import enea.ose.system.Signal;
import java.util.Vector;
import se.ericsson.cello.equipment.JvmMo;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.equipment.ReliableProgramUniterMarker;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.equipment.SlotMoInternal;
import se.ericsson.cello.equipment.intma.ReliableProgramUniterAccess;
import se.ericsson.cello.equipment.suaccess.ProgramMoSU_Access;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.ActionNotAllowedException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.SetNotAllowedException;
import se.ericsson.cello.mao.SingletonMoFactory;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IllegalArgumentTypeException;
import se.ericsson.cello.moframework.LongAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.control.Control;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.cello.swmanagement.Aal2ApReservingRpu;
import se.ericsson.cello.swmanagement.Aal2PduReservingRpu;
import se.ericsson.cello.swmanagement.LoadModuleMo;
import se.ericsson.cello.swmanagement.PiuTypeMoImpl;
import se.ericsson.cello.swmanagement.ReliableProgramUniterMaoi;
import se.ericsson.cello.swmanagement.ReliableProgramUniterMoInternal;
import se.ericsson.cello.swmanagement.ReliableProgramUniterRepository;
import se.ericsson.cello.swmanagement.ReliableProgramUniterRepositoryImpl;
import se.ericsson.cello.swmanagement.ReliableThread;
import se.ericsson.cello.swmanagement.fropxy.OsaRpuCreateCfm;
import se.ericsson.cello.swmanagement.fropxy.OsaRpuDeleteCfm;
import se.ericsson.cello.swmanagement.fropxy.OsaRpuGetAttributesRsp;
import se.ericsson.cello.swmanagement.fropxy.OsaRpuMgmntProxy;
import se.ericsson.cello.swmanagement.fropxy.OsaRpuSetAdmActiveCfm;
import se.ericsson.cello.swmanagement.fropxy.OsaRpuSetAdmPassiveCfm;
import se.ericsson.cello.swmanagement.fropxy.OsaRpuSetNewAdmActiveCfm;
import se.ericsson.cello.swmanagement.fropxy.OsaRpuSetNewAdmPassiveCfm;
import se.ericsson.cello.swmanagement.fropxy.OsaRpuSetNormalizationCfm;
import se.ericsson.cello.swmanagement.fropxy.OsaRpuSetReplicationCfm;
import se.ericsson.cello.swmanagement.fropxy.OsaRpuSetSwitchOverCfm;
import se.ericsson.cello.swmanagement.fropxy.OsaRpuSwitchCfm;
import se.ericsson.cello.swmanagement.suaccess.RPU_AttributesInformation;
import se.ericsson.cello.swmanagement.suaccess.ReliableProgramUniterMoSU_Access;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.util.library.Lib;

public class ReliableProgramUniterMoImpl
extends ManagedObjectBase
implements ReliableProgramUniterMoInternal,
ReliableProgramUniterAccess,
ReliableProgramUniterMarker,
ReliableProgramUniterMoSU_Access,
ReliableProgramUniterMaoi,
FroInfo {
    static String debugheader = "DEBUG:";
    static int debuglevel = 1;
    private static long nextRpuId = 1L;
    private static Coordinator coordinator = null;
    private MoData data;
    private LongAttribute rpuId;
    private StringAttribute userLabel;
    private StringAttribute rpLabel;
    private ReferenceAttribute admActiveSlot;
    private ReferenceAttribute admPassiveSlot;
    private SequenceAttribute reservedBy;
    private BooleanAttribute isForDeviceProgram;
    private OsaRpuMgmntProxy froProxy = OsaRpuMgmntProxy.instance();
    private static final String CMA_SINGLE_RPU_SWITCH_THREAD_BASE = "Cma_ActionSwitch_Thread";
    private static final String CMA_RPU_NORMALISE_THREAD = "Cma_NormaliseAllRPUs_Thread";
    private static ReliableProgramUniterRepository myFroIdRepository = ReliableProgramUniterRepositoryImpl.instance();
    public static final String R_P_U_ID = "rpuId";
    public static final int MAX_NUMBER_OF_RESERVING_AAL2_AP = 280;
    public static final int MAX_NUMBER_OF_RESERVING_AAL2_PATHDISTRIBUTIONUNIT = 280;
    public static final int MAX_NUMBER_OF_RESERVING_SCTP = 1;
    public static final int MAX_NUMBER_OF_RESERVING_M3UA = 1;
    public static final int SWITH_OVER_MIN = 1;
    public static final int SWITH_OVER_MAX = 2;
    public static final int NORMALISATION_MIN = 1;
    public static final int NORMALISATION_MAX = 2;
    public static final int REPLICATION_MIN = 1;
    public static final int REPLICATION_MAX = 4;
    static final String[] SUPPORTED_VERSIONS = new String[]{"SU_1", "SU_2"};
    private static final int MO_DATA_REVISION_16_2 = 16200;
    private static final int MO_DATA_REVISION_LATEST = 16200;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)ReliableProgramUniterMoImpl.class, (int)70, (String)"create( ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context )", (String)("parent: " + managedObject + "\n\tattributes: " + Lib.toString((AttrList)attrList) + "\n\tidentity: " + string + "\n\tsource: " + managedObject2 + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"SwManagement");
        MoAttributeValidator.checkIdentity((String)"ReliableProgramUniter", (String)string);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"ReliableProgramUniter", (int)128, (int)0);
        String string3 = ReliableProgramUniterMoImpl.checkAndGetReliableProgramLabel(attrList);
        ManagedObject managedObject3 = ReliableProgramUniterMoImpl.checkAndGetAdmActiveSlot(attrList);
        ManagedObject managedObject4 = ReliableProgramUniterMoImpl.checkAndGetAdmPassiveSlot(attrList);
        int n = ReliableProgramUniterMoImpl.checkAndGetSwitchOver(attrList);
        int n2 = ReliableProgramUniterMoImpl.checkAndGetNormalisation(attrList);
        int n3 = ReliableProgramUniterMoImpl.checkAndGetReplication(attrList);
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"isForDeviceProgram", (AttrList)attrList, (boolean)false, (boolean)false, (String)"ReliableProgramUniter");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"ReliableProgramUniter");
        return new ReliableProgramUniterMoImpl(managedObject, string, string2, string3, managedObject3, managedObject4, n, n2, n3, bl, coordinator);
    }

    private ReliableProgramUniterMoImpl(ManagedObject managedObject, String string, String string2, String string3, ManagedObject managedObject2, ManagedObject managedObject3, int n, int n2, int n3, boolean bl, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "ReliableProgramUniter", string, coordinator);
        UpgradeTrace.debug((Class)PiuTypeMoImpl.class, (int)70, (String)"ReliableProgramUniterMoImpl(ManagedObject parent, String identity, String checkedUserLabel, String checkedReliableProgramLabel, ManagedObject checkedAdmActiveSlot, ManagedObject checkedAdmPassiveSlot, int checkedSwitchOver, int checkedNormalisation, int checkedReplication,Coordinator context)", (String)("parent: " + managedObject + "\n\tidentity: " + string + "\n\tcheckedUserLabel: " + string2 + "\n\tcheckedReliableProgramLabel: " + string3 + "\n\tcheckedAdmActiveSlot: " + managedObject2 + "\n\tcheckedAdmPassiveSlot: " + managedObject3 + "\n\tcheckedSwitchOver: " + n + "\n\tcheckedNormalisation: " + n2 + "\n\tcheckedReplication: " + n3 + "\n\tcheckedIsForDeviceProgram " + bl + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        if (bl) {
            if (Control.getOs() == 0) {
                throw new MoCanNotBeCreatedException("ReliableProgramUniter", "Attribute isForDeviceprgroam value must be false for all other than 8300");
            }
            if (managedObject3 != null) {
                throw new MoCanNotBeCreatedException("ReliableProgramUniter", "Attribute admPassiveSlot should be null when IsForDeviceProgram is true");
            }
        }
        if (managedObject2 == managedObject3) {
            managedObject3 = null;
        }
        ProgramMoSU_Access programMoSU_Access = this.getMatchingProgram((SlotMo)managedObject2, string3, bl, coordinator);
        ProgramMoSU_Access programMoSU_Access2 = this.getMatchingProgram((SlotMo)managedObject3, string3, bl, coordinator);
        int n4 = 0;
        int n5 = 0;
        if (programMoSU_Access != null) {
            n4 = programMoSU_Access.getProgramFroId(coordinator);
        }
        if (programMoSU_Access2 != null) {
            n5 = programMoSU_Access2.getProgramFroId(coordinator);
        }
        OsaRpuCreateCfm osaRpuCreateCfm = this.froProxy.sendOsaRpuCreateReq(nextRpuId, coordinator.getTransactionID(), n4, n5, 0L, 0L, n, n2, n3, bl);
        ReliableProgramUniterMoImpl.checkSignal((Signal)osaRpuCreateCfm);
        ReliableProgramUniterMoImpl.checkResult(osaRpuCreateCfm.getResult(), "OsaRpuCreateReq");
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.rpuId = new LongAttribute(R_P_U_ID, false, nextRpuId);
        this.data.registerPersistentAttr((Attribute)this.rpuId);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.rpLabel = new StringAttribute("reliableProgramLabel", false, string3);
        this.data.registerPersistentAttr((Attribute)this.rpLabel);
        this.isForDeviceProgram = new BooleanAttribute("isForDeviceProgram", false, bl);
        this.data.registerPersistentAttr((Attribute)this.isForDeviceProgram);
        this.admActiveSlot = new ReferenceAttribute("admActiveSlot", true);
        this.admActiveSlot.setValue(managedObject2);
        this.data.registerPersistentAttr((Attribute)this.admActiveSlot);
        this.admPassiveSlot = new ReferenceAttribute("admPassiveSlot", true);
        this.admPassiveSlot.setValue(managedObject3);
        this.data.registerPersistentAttr((Attribute)this.admPassiveSlot);
        this.reservedBy = new SequenceAttribute("reservedBy", true);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        myFroIdRepository.addInstance((int)this.rpuId.getValue(coordinator), this, coordinator);
        this.data.setRevision(16200);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ((SlotMoInternal)managedObject2).reserve((ManagedObject)this, coordinator);
        if (managedObject3 != null) {
            ((SlotMoInternal)managedObject3).reserve((ManagedObject)this, coordinator);
        }
        ++nextRpuId;
        ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
        serviceRepository.addService((Object)this, ReliableProgramUniterAccess.class, coordinator);
    }

    public ReliableProgramUniterMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"ReliableProgramUniterMoImpl(MoData recoveredData)", (String)("recoveredData: " + moData));
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(16200);
        moDataRecoveryHelper.assertAttribute(R_P_U_ID);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reliableProgramLabel");
        moDataRecoveryHelper.assertAttribute("isForDeviceProgram");
        moDataRecoveryHelper.assertAttribute("admActiveSlot");
        moDataRecoveryHelper.assertAttribute("admPassiveSlot");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.rpuId = (LongAttribute)this.data.getAttribute(R_P_U_ID);
        if (this.rpuId.getValue(null) == 0L) {
            moDataRecoveryHelper.fail("Recovered attribute rpuId is 0 in");
        }
        if (this.rpuId.getValue(null) >= nextRpuId) {
            nextRpuId = this.rpuId.getValue(null) + 1L;
        }
        this.userLabel = (StringAttribute)this.data.getAttribute("userLabel");
        this.rpLabel = (StringAttribute)this.data.getAttribute("reliableProgramLabel");
        this.isForDeviceProgram = (BooleanAttribute)this.data.getAttribute("isForDeviceProgram");
        this.admActiveSlot = (ReferenceAttribute)this.data.getAttribute("admActiveSlot");
        this.admPassiveSlot = (ReferenceAttribute)this.data.getAttribute("admPassiveSlot");
        this.reservedBy = (SequenceAttribute)this.data.getAttribute("reservedBy");
        ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
        serviceRepository.addService((Object)this, ReliableProgramUniterAccess.class, null);
        myFroIdRepository.addInstance((int)this.rpuId.getValue(null), this);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"delete(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length != 0) {
            throw new UndeletableMoException((ManagedObject)this);
        }
        SlotMoInternal slotMoInternal = (SlotMoInternal)this.admActiveSlot.getValue(coordinator);
        slotMoInternal.release((ManagedObject)this, coordinator);
        SlotMoInternal slotMoInternal2 = (SlotMoInternal)this.admPassiveSlot.getValue(coordinator);
        if (slotMoInternal2 != null) {
            slotMoInternal2.release((ManagedObject)this, coordinator);
        }
        OsaRpuDeleteCfm osaRpuDeleteCfm = this.froProxy.sendOsaRpuDeleteReq(coordinator.getTransactionID(), this.rpuId.getValue(coordinator));
        ReliableProgramUniterMoImpl.checkSignal((Signal)osaRpuDeleteCfm);
        ReliableProgramUniterMoImpl.checkResult(osaRpuDeleteCfm.getResult(), "OsaRpuDeleteReq");
        myFroIdRepository.removeInstance((int)this.rpuId.getValue(coordinator), coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
        ServiceRepository serviceRepository = ServiceLocatorFacade.getRepository();
        serviceRepository.removeService((Object)this, ReliableProgramUniterAccess.class, coordinator);
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getUserLabel(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"ReliableProgramUniter", (int)128, (int)0);
        UpgradeTrace.debug(this.getClass(), (int)72, (String)"setUserLabel(String value, Coordinator c)", (String)("value: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public String getReliableProgramLabel(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getReliableProgramLabel(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.rpLabel.getValue(coordinator);
    }

    public void setReliableProgramLabelForSU(String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setReliableProgramLabelForSU(String aRP_Label, Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.rpLabel.setValue(string);
    }

    public void setIsForDeviceProgramForSU(boolean bl, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setIsForDeviceProgramSU(boolean value, Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        boolean bl2 = this.getIsForDeviceProgram(null);
        if (bl != bl2) {
            throw new SetNotAllowedException("ReliableProgramUniter", "admPassiveSlot", "trying to set IsforDeviceProgram from " + bl2 + "to " + bl);
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.isForDeviceProgram.setValue(bl);
    }

    public ManagedObject getAdmActiveSlot(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAdmActiveSlot(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.admActiveSlot.getValue(coordinator);
    }

    public void setAdmActiveSlot(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdmActiveSlot( ManagedObject value, Coordinator c )", (String)("value: " + managedObject + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        if (managedObject == null) {
            throw new ValueOutOfRangeException("admActiveSlot", "ReliableProgramUniter");
        }
        if (!(managedObject instanceof SlotMo)) {
            throw new IllegalArgumentTypeException((ManagedObject)this, managedObject.toString());
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == this.admPassiveSlot.getValue(coordinator)) {
            this.setAdmPassiveSlot(null, coordinator);
        }
        SlotMoInternal slotMoInternal = (SlotMoInternal)this.admActiveSlot.getValue(coordinator);
        slotMoInternal.release((ManagedObject)this, coordinator);
        ProgramMoSU_Access programMoSU_Access = this.getMatchingProgram((SlotMo)managedObject, this.rpLabel.getValue(coordinator), this.getIsForDeviceProgram(coordinator), coordinator);
        int n = 0;
        if (programMoSU_Access != null) {
            n = programMoSU_Access.getProgramFroId(coordinator);
        }
        OsaRpuSetAdmActiveCfm osaRpuSetAdmActiveCfm = this.froProxy.sendOsaRpuSetAdmActiveReq(coordinator.getTransactionID(), this.rpuId.getValue(coordinator), n);
        ReliableProgramUniterMoImpl.checkSignal((Signal)osaRpuSetAdmActiveCfm);
        ReliableProgramUniterMoImpl.checkResult(osaRpuSetAdmActiveCfm.getResult(), "OsaRpuSetAdmActiveReq");
        this.sendOsaRpuSetNewAdmActiveReq(0L, coordinator);
        ((SlotMoInternal)managedObject).reserve((ManagedObject)this, coordinator);
        this.admActiveSlot.setValue(managedObject);
    }

    public ManagedObject getAdmPassiveSlot(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAdmPassiveSlot(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.admPassiveSlot.getValue(coordinator);
    }

    public void setAdmPassiveSlot(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        SlotMoInternal slotMoInternal;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdmPassiveSlot(ManagedObject value, Coordinator c)", (String)("value: " + managedObject + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        boolean bl = this.getIsForDeviceProgram(coordinator);
        if (bl && managedObject != null) {
            throw new SetNotAllowedException("ReliableProgramUniter", "admPassiveSlot", "Set not allowed for the RPU with attribute IsForDeviceProgram " + bl);
        }
        int n = 0;
        if (managedObject != null) {
            if (!(managedObject instanceof SlotMo)) {
                throw new IllegalArgumentTypeException((ManagedObject)this, managedObject.toString());
            }
            if (managedObject == this.admActiveSlot.getValue(coordinator)) {
                if (this.admPassiveSlot.getValue(coordinator) == null) {
                    return;
                }
                managedObject = null;
            } else {
                slotMoInternal = this.getMatchingProgram((SlotMo)managedObject, this.rpLabel.getValue(coordinator), bl, coordinator);
                if (slotMoInternal != null) {
                    n = slotMoInternal.getProgramFroId(coordinator);
                }
            }
        } else if (this.admPassiveSlot.getValue(coordinator) == null) {
            return;
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        slotMoInternal = (SlotMoInternal)this.admPassiveSlot.getValue(coordinator);
        if (slotMoInternal != null) {
            slotMoInternal.release((ManagedObject)this, coordinator);
        }
        OsaRpuSetAdmPassiveCfm osaRpuSetAdmPassiveCfm = this.froProxy.sendOsaRpuSetAdmPassiveReq(coordinator.getTransactionID(), this.rpuId.getValue(coordinator), n);
        ReliableProgramUniterMoImpl.checkSignal((Signal)osaRpuSetAdmPassiveCfm);
        ReliableProgramUniterMoImpl.checkResult(osaRpuSetAdmPassiveCfm.getResult(), "OsaRpuSetAdmPassiveReq");
        this.sendOsaRpuSetNewAdmPassiveReq(0L, coordinator);
        if (managedObject != null) {
            ((SlotMoInternal)managedObject).reserve((ManagedObject)this, coordinator);
        }
        this.admPassiveSlot.setValue(managedObject);
    }

    public int getSwitchOver(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSwitchOver(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        return (int)this.getFroAttributes((Coordinator)coordinator).switchOverMode;
    }

    public void setSwitchOver(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setSwitchOver(int value, Coordinator c)", (String)("value: " + n + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        if (n < 1 || n > 2) {
            throw new ValueOutOfRangeException("switchOver value: " + n, "ReliableProgramUniter");
        }
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        OsaRpuSetSwitchOverCfm osaRpuSetSwitchOverCfm = this.froProxy.sendOsaRpuSetSwitchOverReq(coordinator.getTransactionID(), this.rpuId.getValue(coordinator), n);
        ReliableProgramUniterMoImpl.checkSignal((Signal)osaRpuSetSwitchOverCfm);
        ReliableProgramUniterMoImpl.checkResult(osaRpuSetSwitchOverCfm.getResult(), "OsaRpuSetSwitchOverReq");
        String[] stringArray = new String[]{"switchOver"};
        Object[] objectArray = new Object[]{new Integer(n)};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getNormalisation(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getNormalisation(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        return (int)this.getFroAttributes((Coordinator)coordinator).normalizationMode;
    }

    public void setNormalisation(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setNormalisation(int value, Coordinator c)", (String)("value: " + n + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (n > 2 || n < 1) {
            throw new ValueOutOfRangeException("normalisation", "ReliableProgramUniter");
        }
        OsaRpuSetNormalizationCfm osaRpuSetNormalizationCfm = this.froProxy.sendOsaRpuSetNormalizationReq(coordinator.getTransactionID(), this.rpuId.getValue(coordinator), n);
        ReliableProgramUniterMoImpl.checkSignal((Signal)osaRpuSetNormalizationCfm);
        ReliableProgramUniterMoImpl.checkResult(osaRpuSetNormalizationCfm.getResult(), "OsaRpuSetNormalizationReq");
        String[] stringArray = new String[]{"normalisation"};
        Object[] objectArray = new Object[]{new Integer(n)};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public void setReplication(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (n > 4 || n <= 0) {
            throw new ValueOutOfRangeException("SetReplication: Value: " + n + " is out of range.", "ReliableProgramUniter");
        }
        OsaRpuSetReplicationCfm osaRpuSetReplicationCfm = this.froProxy.sendOsaRpuSetReplicationReq(coordinator.getTransactionID(), this.rpuId.getValue(coordinator), n);
        ReliableProgramUniterMoImpl.checkSignal((Signal)osaRpuSetReplicationCfm);
        ReliableProgramUniterMoImpl.checkResult(osaRpuSetReplicationCfm.getResult(), "OsaRpuSetReplicationReq");
    }

    public int getReplication(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getReplication(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        return (int)this.getFroAttributes((Coordinator)coordinator).replicationMode;
    }

    public int getOperationalMode(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getOperationalMode(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        return this.getFroAttributes((Coordinator)coordinator).operationalMode;
    }

    public boolean getIsForDeviceProgram(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getIsForDevicePgm(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.isForDeviceProgram.getValue(coordinator);
    }

    public String getReliableProgramUniterId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getReliableProgramUniterId(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        return this.getNamingAttributeValue();
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getReservedBy(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Attribute[] attributeArray = this.reservedBy.getValue(coordinator);
        ManagedObject[] managedObjectArray = new ManagedObject[attributeArray.length];
        for (int i = 0; i < attributeArray.length; ++i) {
            managedObjectArray[i] = ((ReferenceAttribute)attributeArray[i]).getValue(coordinator);
        }
        Aal2ApReservingRpu aal2ApReservingRpu = null;
        Aal2PduReservingRpu aal2PduReservingRpu = null;
        ManagedObject[] managedObjectArray2 = null;
        ManagedObject[] managedObjectArray3 = null;
        MoIterator moIterator = MoRepository.instance().lookupType("Aal2Ap");
        MoIterator moIterator2 = MoRepository.instance().lookupType("Aal2PathDistributionUnit");
        if (moIterator != null) {
            aal2ApReservingRpu = (Aal2ApReservingRpu)moIterator.nextMo();
            managedObjectArray2 = aal2ApReservingRpu.actionAal2ApReservingRpu((int)this.getRpuId(coordinator), coordinator);
        }
        if (moIterator2 != null) {
            aal2PduReservingRpu = (Aal2PduReservingRpu)moIterator2.nextMo();
            managedObjectArray3 = aal2PduReservingRpu.actionAal2PduReservingRpu((int)this.getRpuId(coordinator), coordinator);
        }
        if (managedObjectArray2 != null || managedObjectArray3 != null) {
            int n = 0;
            int n2 = 0;
            if (managedObjectArray2 != null) {
                n = managedObjectArray2.length;
            }
            if (managedObjectArray3 != null) {
                n2 = managedObjectArray3.length;
            }
            ManagedObject[] managedObjectArray4 = new ManagedObject[attributeArray.length + n + n2];
            System.arraycopy(managedObjectArray, 0, managedObjectArray4, 0, attributeArray.length);
            if (managedObjectArray2 != null) {
                System.arraycopy(managedObjectArray2, 0, managedObjectArray4, attributeArray.length, n);
            }
            if (managedObjectArray3 != null) {
                System.arraycopy(managedObjectArray3, 0, managedObjectArray4, attributeArray.length + n, n2);
            }
            return managedObjectArray4;
        }
        return managedObjectArray;
    }

    public long getRpuId(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRpuId(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.rpuId.getValue(coordinator);
    }

    public void actionSwitch(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionSwitch(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.admPassiveSlot.getValue(coordinator) == null) {
            throw new ActionNotAllowedException("ReliableProgramUniter", "actionSwitch not allowed, admPassiveSlot is null");
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ReliableThread reliableThread = new ReliableThread(coordinator, CMA_SINGLE_RPU_SWITCH_THREAD_BASE + this.getRpuId(coordinator), this);
        reliableThread.registerResource(coordinator);
    }

    public void doActionSwitch() throws MoAccessException {
        int n;
        OsaRpuSwitchCfm osaRpuSwitchCfm = null;
        for (n = 0; n < 2 && osaRpuSwitchCfm == null; ++n) {
            osaRpuSwitchCfm = this.froProxy.sendOsaRpuSwitchReq(this.rpuId.getValue(null));
        }
        n = 0;
        ReliableProgramUniterMoImpl.checkSignal(osaRpuSwitchCfm);
        ReliableProgramUniterMoImpl.checkResult(osaRpuSwitchCfm.getResult(), "OsaRpuSwitchReq");
    }

    public static void doNormaliseAll(Coordinator coordinator) throws MoAccessException {
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("ReliableProgramUniter");
            if (moIterator == null) {
                return;
            }
            MoFactory moFactory = MoFactoryMgr.instance().lookup("Jvm");
            JvmMo jvmMo = (JvmMo)((SingletonMoFactory)moFactory).getMo();
            Object object = null;
            boolean bl = false;
            while (moIterator.hasMoreElements()) {
                ReliableProgramUniterMoImpl reliableProgramUniterMoImpl = (ReliableProgramUniterMoImpl)moIterator.nextMo();
                OsaRpuGetAttributesRsp osaRpuGetAttributesRsp = reliableProgramUniterMoImpl.getFroAttributes(coordinator);
                if (osaRpuGetAttributesRsp.operationalMode != 2) continue;
                if (reliableProgramUniterMoImpl.getLocalDistinguishedName().equals(jvmMo.getReliableProgramUniter(coordinator).getLocalDistinguishedName())) {
                    object = reliableProgramUniterMoImpl;
                    bl = true;
                    continue;
                }
                reliableProgramUniterMoImpl.doActionSwitch();
            }
            if (bl) {
                MessageLog.info(object.getClass(), (String)"About to switch over jvm finally. ");
                ((ReliableProgramUniterMoImpl)object).doActionSwitch();
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError((Class)ReliableProgramUniterMoImpl.class, (String)"Switchover failed", (Throwable)moAccessException);
            throw new RuntimeException("Failed in ReliableProgramUniterMoImpl while normalising all RPUs", moAccessException);
        }
    }

    public String getType() {
        return "ReliableProgramUniter";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        return (int)this.getRpuId(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"reserve(ManagedObject mo, Coordinator context)", (String)("mo: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        if (managedObject.getType().equals("Aal2Ap") || managedObject.getType().equals("Aal2PathDistributionUnit")) {
            this.checkReservers(managedObject, coordinator);
        } else if (managedObject.getType().equals("Sctp")) {
            this.checkReservers(managedObject, coordinator);
        } else if (managedObject.getType().equals("M3ua")) {
            this.checkReservers(managedObject, coordinator);
        }
        this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"ReliableProgramUniter", (MoData)this.data, (SequenceAttribute)this.reservedBy);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"release(ManagedObject mo, Coordinator context)", (String)("mo: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.reservedBy = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"ReliableProgramUniter", (MoData)this.data, (SequenceAttribute)this.reservedBy);
    }

    public static void normaliseAllRPUs(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)ReliableProgramUniterMoImpl.class, (int)70, (String)"normaliseAllRPUs(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        ReliableThread reliableThread = new ReliableThread(coordinator, CMA_RPU_NORMALISE_THREAD, null);
        try {
            coordinator.registerResource((Resource)reliableThread);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.traceError((Class)ReliableProgramUniterMoImpl.class, (String)"Transaction", (Throwable)inactiveTransactionException);
            throw new RuntimeException("Failed registerResource() in ReliableProgramUniterMoImpl", inactiveTransactionException);
        }
    }

    private void checkReservers(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"checkReservers(ManagedObject  reserver, Coordinator context )", (String)("reserver: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = ReservableImpl.noOfReservers((SequenceAttribute)this.reservedBy, (String)managedObject.getClass().getName(), (Coordinator)coordinator);
        if (managedObject.getType().equals("Aal2Ap")) {
            if (n >= 280) {
                throw new MaxNumberExceededException("Max_number_of_reserving_Aal2_AP", "ReliableProgramUniter");
            }
        } else if (managedObject.getType().equals("Aal2PathDistributionUnit")) {
            if (n >= 280) {
                throw new MaxNumberExceededException("Max_number_of_reserving_Aal2_Path_Distribution_Unit", "ReliableProgramUniter");
            }
        } else if (managedObject.getType().equals("Sctp")) {
            if (n >= 1) {
                throw new MaxNumberExceededException("Max_number_of_reserving_SCTP", "ReliableProgramUniter");
            }
        } else if (managedObject.getType().equals("M3ua") && n >= 1) {
            throw new MaxNumberExceededException("Max_number_of_reserving_M3ua", "ReliableProgramUniter");
        }
    }

    public boolean isReservable(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"isReservable(ManagedObject  reserver, Coordinator context )", (String)("reserver: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = ReservableImpl.noOfReservers((SequenceAttribute)this.reservedBy, (String)managedObject.getClass().getName(), (Coordinator)coordinator);
        return !(managedObject.getType().equals("Aal2Ap") ? n > 280 : managedObject.getType().equals("Aal2PathDistributionUnit") && n > 280);
    }

    private static String checkAndGetReliableProgramLabel(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)ReliableProgramUniterMoImpl.class, (int)70, (String)"checkAndGetReliableProgramLabel( AttrList attributes )", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        String string = null;
        int n = attrList.indexOf("reliableProgramLabel");
        if (n == -1) {
            throw new AttrMissingAtCreateException("ReliableProgramUniter", "reliableProgramLabel");
        }
        if (!(attrList.getValue(n) instanceof String)) {
            throw new WrongAttributeTypeException("reliableProgramLabel", "ReliableProgramUniter");
        }
        string = (String)attrList.getValue(n);
        attrList.removeElementAt(n);
        return string;
    }

    private static ManagedObject checkAndGetAdmActiveSlot(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)ReliableProgramUniterMoImpl.class, (int)70, (String)"checkAndGetAdmActiveSlot( AttrList attributes )", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        ManagedObject managedObject = null;
        int n = attrList.indexOf("admActiveSlot");
        if (n == -1) {
            throw new AttrMissingAtCreateException("ReliableProgramUniter", "admActiveSlot");
        }
        if (!(attrList.getValue(n) instanceof SlotMo)) {
            throw new WrongAttributeTypeException("admActiveSlot", "ReliableProgramUniter");
        }
        managedObject = (ManagedObject)attrList.getValue(n);
        attrList.removeElementAt(n);
        return managedObject;
    }

    private static ManagedObject checkAndGetAdmPassiveSlot(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)ReliableProgramUniterMoImpl.class, (int)70, (String)"checkAndGetAdmPassiveSlot( AttrList attributes )", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        ManagedObject managedObject = null;
        int n = attrList.indexOf("admPassiveSlot");
        if (n == -1) {
            return managedObject;
        }
        if (!(attrList.getValue(n) instanceof SlotMo)) {
            throw new WrongAttributeTypeException("admActiveSlot", "ReliableProgramUniter");
        }
        managedObject = (ManagedObject)attrList.getValue(n);
        attrList.removeElementAt(n);
        return managedObject;
    }

    private static int checkAndGetSwitchOver(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)ReliableProgramUniterMoImpl.class, (int)70, (String)"checkAndGetSwitchOver( AttrList attributes )", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = 1;
        int n2 = attrList.indexOf("switchOver");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("switchOver", "ReliableProgramUniter");
        }
        n = (Integer)attrList.getValue(n2);
        if (n < 1 || n > 2) {
            throw new ValueOutOfRangeException("switchOver value: " + n, "ReliableProgramUniter");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetNormalisation(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)ReliableProgramUniterMoImpl.class, (int)70, (String)"checkAndGetNormalisation( AttrList attributes )", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = 2;
        int n2 = attrList.indexOf("normalisation");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("normalisation", "ReliableProgramUniter");
        }
        n = (Integer)attrList.getValue(n2);
        if (n < 1 || n > 2) {
            throw new ValueOutOfRangeException("normalisation", "ReliableProgramUniter");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetReplication(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)ReliableProgramUniterMoImpl.class, (int)70, (String)"checkAndGetReplication( AttrList attributes )", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = 4;
        int n2 = attrList.indexOf("replication");
        if (n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("replication", "ReliableProgramUniter");
        }
        n = (Integer)attrList.getValue(n2);
        if (n < 1 || n > 4) {
            throw new ValueOutOfRangeException("replication", "ReliableProgramUniter");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    public RPU_AttributesInformation getRPU_AttributesInformation(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRPU_AttributesInformation(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        OsaRpuGetAttributesRsp osaRpuGetAttributesRsp = this.getFroAttributes(coordinator);
        return new RPU_AttributesInformation(osaRpuGetAttributesRsp.admActiveInstanceId, osaRpuGetAttributesRsp.admPassiveInstanceId, osaRpuGetAttributesRsp.newAdmActiveInstanceId, osaRpuGetAttributesRsp.newAdmPassiveInstanceId, osaRpuGetAttributesRsp.switchOverMode, osaRpuGetAttributesRsp.normalizationMode, osaRpuGetAttributesRsp.replicationMode, osaRpuGetAttributesRsp.operationalMode, this.getIsForDeviceProgram(coordinator));
    }

    private OsaRpuGetAttributesRsp getFroAttributes(Coordinator coordinator) throws MoAccessException {
        int n;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getFroAttributes(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n2 = 0;
        if (coordinator != null) {
            n2 = coordinator.getTransactionID();
        }
        OsaRpuGetAttributesRsp osaRpuGetAttributesRsp = null;
        for (n = 0; n < 2 && osaRpuGetAttributesRsp == null; ++n) {
            osaRpuGetAttributesRsp = this.froProxy.sendOsaRpuGetAttributesReq(n2, this.rpuId.getValue(coordinator));
        }
        n = 0;
        ReliableProgramUniterMoImpl.checkSignal(osaRpuGetAttributesRsp);
        ReliableProgramUniterMoImpl.checkResult(osaRpuGetAttributesRsp.result, "OsaRpuGetAttributesReq");
        return osaRpuGetAttributesRsp;
    }

    public void setAdmActivePgmId(long l, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdmActivePgmId(long pgmFroId, Coordinator c)", (String)("pgmFroId: " + l + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        OsaRpuSetAdmActiveCfm osaRpuSetAdmActiveCfm = this.froProxy.sendOsaRpuSetAdmActiveReq(coordinator.getTransactionID(), this.rpuId.getValue(coordinator), l);
        ReliableProgramUniterMoImpl.checkSignal((Signal)osaRpuSetAdmActiveCfm);
        ReliableProgramUniterMoImpl.checkResult(osaRpuSetAdmActiveCfm.getResult(), "OsaRpuSetAdmActiveReq");
    }

    public void setAdmPassivePgmId(long l, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setAdmPassivePgmId(long pgmFroId, Coordinator c)", (String)("pgmFroId: " + l + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        OsaRpuSetAdmPassiveCfm osaRpuSetAdmPassiveCfm = this.froProxy.sendOsaRpuSetAdmPassiveReq(coordinator.getTransactionID(), this.rpuId.getValue(coordinator), l);
        ReliableProgramUniterMoImpl.checkSignal((Signal)osaRpuSetAdmPassiveCfm);
        ReliableProgramUniterMoImpl.checkResult(osaRpuSetAdmPassiveCfm.getResult(), "OsaRpuSetAdmPassiveReq");
    }

    public void setNewAdmActivePgmId(long l, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setNewAdmActivePgmId(long pgmFroId, Coordinator c)", (String)("pgmFroId: " + l + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.sendOsaRpuSetNewAdmActiveReq(l, coordinator);
    }

    public void setNewAdmPassivePgmId(long l, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setNewAdmPassivePgmId(long pgmFroId, Coordinator c)", (String)("pgmFroId: " + l + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.sendOsaRpuSetNewAdmPassiveReq(l, coordinator);
    }

    private ProgramMoSU_Access getMatchingProgram(SlotMo slotMo, String string, boolean bl, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getMatchingProgram(SlotMo slot, String reliableProgramLabel, Coordinator context)", (String)("slot: " + slotMo + "\n\treliableProgramLabel: " + string + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        if (slotMo == null) {
            return null;
        }
        Vector<ManagedObject> vector = new Vector<ManagedObject>();
        Vector<ManagedObject> vector2 = new Vector<ManagedObject>();
        MoIterator moIterator = slotMo.getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            if (!(managedObject instanceof PlugInUnitMo) || ((PlugInUnitMo)managedObject).getRole(coordinator) != 1) continue;
            MoIterator moIterator2 = managedObject.getChildren();
            while (moIterator2.hasMoreElements()) {
                managedObject = moIterator2.nextMo();
                if (!(managedObject instanceof ProgramMoSU_Access)) continue;
                try {
                    LoadModuleMo loadModuleMo = (LoadModuleMo)((ProgramMoSU_Access)managedObject).getLoadModule(coordinator);
                    if (!string.equals(loadModuleMo.getReliableProgramLabel(coordinator))) continue;
                    int n = ((ProgramMoSU_Access)managedObject).getLoaderType(coordinator);
                    if (bl) {
                        if (n != 6) continue;
                        if (((ProgramMoSU_Access)managedObject).getStartState(coordinator) == 1) {
                            vector.addElement(managedObject);
                            continue;
                        }
                        vector2.addElement(managedObject);
                        continue;
                    }
                    if (n == 6) continue;
                    if (((ProgramMoSU_Access)managedObject).getStartState(coordinator) == 1) {
                        vector.addElement(managedObject);
                        continue;
                    }
                    vector2.addElement(managedObject);
                }
                catch (MoRemovedException moRemovedException) {
                    MessageLog.info(this.getClass(), (String)("Unable to retrieve and compare referenced LM from Program MO." + (Object)((Object)moRemovedException)));
                }
                catch (MoAccessException moAccessException) {
                    MessageLog.traceError(this.getClass(), (String)"Unable to retrieve and compare referenced LM from Program MO.", (Throwable)moAccessException);
                }
            }
        }
        if (vector.size() > 0) {
            return (ProgramMoSU_Access)vector.elementAt(0);
        }
        if (vector2.size() > 0) {
            return (ProgramMoSU_Access)vector2.elementAt(0);
        }
        return null;
    }

    private static void checkSignal(Signal signal) throws MoAccessException {
        UpgradeTrace.debug((Class)ReliableProgramUniterMoImpl.class, (int)70, (String)"checkSignal(enea.ose.system.Signal sig)", (String)("sig: " + signal));
        if (signal == null) {
            throw new FroNotAccessibleException("ReliableProgramUniter", "");
        }
    }

    private static void checkResult(long l, String string) throws FroRequestFailedException {
        UpgradeTrace.debug((Class)ReliableProgramUniterMoImpl.class, (int)70, (String)"checkResult(long result, String request)", (String)("result: " + l + "\n\trequest: " + string));
        if (l != 1L) {
            throw new FroRequestFailedException("ReliableProgramUniter", OsaRpuMgmntProxy.getResultMsg(l), string, (int)l);
        }
    }

    private void sendOsaRpuSetNewAdmActiveReq(long l, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"sendOsaRpuSetNewAdmActiveReq(long pgmFroId, Coordinator c)", (String)("pgmFroId: " + l + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        OsaRpuSetNewAdmActiveCfm osaRpuSetNewAdmActiveCfm = this.froProxy.sendOsaRpuSetNewAdmActiveReq(coordinator.getTransactionID(), this.rpuId.getValue(coordinator), l);
        ReliableProgramUniterMoImpl.checkSignal((Signal)osaRpuSetNewAdmActiveCfm);
        ReliableProgramUniterMoImpl.checkResult(osaRpuSetNewAdmActiveCfm.getResult(), "OsaRpuSetNewAdmActiveReq");
    }

    private void sendOsaRpuSetNewAdmPassiveReq(long l, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"sendOsaRpuSetNewAdmPassiveReq(long pgmFroId, Coordinator c)", (String)("pgmFroId: " + l + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        OsaRpuSetNewAdmPassiveCfm osaRpuSetNewAdmPassiveCfm = this.froProxy.sendOsaRpuSetNewAdmPassiveReq(coordinator.getTransactionID(), this.rpuId.getValue(coordinator), l);
        ReliableProgramUniterMoImpl.checkSignal((Signal)osaRpuSetNewAdmPassiveCfm);
        ReliableProgramUniterMoImpl.checkResult(osaRpuSetNewAdmPassiveCfm.getResult(), "OsaRpuSetNewAdmPassiveReq");
    }

    public boolean checkRpuUsage(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = this.getAdmActiveSlot(coordinator);
        ManagedObject managedObject2 = this.getAdmPassiveSlot(coordinator);
        String string = this.getReliableProgramLabel(coordinator);
        ProgramMoSU_Access programMoSU_Access = this.getMatchingProgram((SlotMo)managedObject, string, this.getIsForDeviceProgram(coordinator), coordinator);
        ProgramMoSU_Access programMoSU_Access2 = this.getMatchingProgram((SlotMo)managedObject2, string, this.getIsForDeviceProgram(coordinator), coordinator);
        return programMoSU_Access != null || programMoSU_Access2 != null;
    }

    public LoadModuleMo getLoadModuleMoMatchingRpuLabel(Coordinator coordinator) throws MoAccessException {
        String string = this.getReliableProgramLabel(coordinator);
        LoadModuleMo loadModuleMo = this.findLoadModule((SlotMo)this.getAdmActiveSlot(coordinator), string, coordinator);
        if (loadModuleMo == null) {
            loadModuleMo = this.findLoadModule((SlotMo)this.getAdmPassiveSlot(coordinator), string, coordinator);
        }
        if (loadModuleMo == null) {
            return null;
        }
        return loadModuleMo;
    }

    private LoadModuleMo findLoadModule(SlotMo slotMo, String string, Coordinator coordinator) throws MoAccessException {
        ProgramMoSU_Access programMoSU_Access = this.getMatchingProgram(slotMo, string, this.getIsForDeviceProgram(coordinator), coordinator);
        if (programMoSU_Access == null) {
            return null;
        }
        return (LoadModuleMo)programMoSU_Access.getLoadModule(coordinator);
    }

    protected static void d1(String string) {
        if (debuglevel >= 1) {
            ReliableProgramUniterMoImpl.sysdebug(debugheader + " " + string);
        }
    }

    static void sysdebug(String string) {
        System.out.println(string);
    }

    public Coordinator getRpuCurrentContext() {
        return coordinator;
    }

    public void setRpuCurrentContext(Coordinator coordinator) {
        ReliableProgramUniterMoImpl.setCoordinator(coordinator);
    }

    private static void setCoordinator(Coordinator coordinator) {
        ReliableProgramUniterMoImpl.coordinator = coordinator;
    }
}

