/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swmanagement;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.sudom.extif.swm.suaccess.sudom.ExtendedLoadModuleInformationInterface;
import se.ericsson.cello.sudom.extif.swm.suaccess.sudom.LoadModuleSU_DOM_MoMapInterface;
import se.ericsson.cello.sudom.extif.swm.suaccess.sudom.PiuTypeRefInterface;
import se.ericsson.cello.sudom.extif.swm.suaccess.sudom.PiuTypeSU_DOM_MoMapInterface;
import se.ericsson.cello.sudom.extif.swm.suaccess.sudom.ProxySelectorSwmInterface;
import se.ericsson.cello.sudom.extif.swm.suaccess.sudom.RepertoireProxyInformation;
import se.ericsson.cello.sudom.extif.swm.suaccess.sudom.RepertoireReadProxyInterface;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.swmanagement.LoadModuleMo;
import se.ericsson.cello.swmanagement.PiuTypeMo;
import se.ericsson.cello.swmanagement.RepertoireMoInternal;
import se.ericsson.cello.swmanagement.handler.PiuTypeLoadListHandler;
import se.ericsson.cello.swmanagement.handler.RepertoireMoDataConversionHandler;
import se.ericsson.cello.swmanagement.handler.RepertoireMoDataConversionHandlerException;
import se.ericsson.cello.swmanagement.suaccess.ExtendedLoadModuleRefInfo;
import se.ericsson.cello.swmanagement.suaccess.ExtendedLoadModuleRefInfo2;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeLoadListInfo;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeRefInfo;
import se.ericsson.cello.swmanagement.suaccess.RepertoireMoSU_Access;
import se.ericsson.cello.swmanagement.sutest.RepertoireMoVerSpecAccess;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.util.library.Lib;

public class RepertoireMoImpl
extends ManagedObjectBase
implements RepertoireMoInternal,
RepertoireMoSU_Access,
RepertoireMoVerSpecAccess {
    RepertoireProxyInformation myRepertoireProxyInformation = null;
    ProxySelectorSwmInterface myProxySelectorInterface = (ProxySelectorSwmInterface)ServiceLocatorFacade.getRepository().getService(ProxySelectorSwmInterface.class);
    private MoData data;
    private StringAttribute mySU_DOM_Key;
    private StringAttribute userLabel;
    private StringAttribute name;
    private StringAttribute info;
    private BooleanAttribute isInstalled;
    private SequenceAttribute reservedBy;
    private SequenceAttribute loadModuleRefs;
    private SequenceAttribute piuTypeRefs;
    private PiuTypeLoadListHandler myPiuTypeLoadListHandler = null;
    private static final String[] reservedClasses = new String[]{"se.ericsson.cello.swmanagement.SwAllocationMoImpl"};
    private static final String LOAD_MODULE_REFS = "loadModuleRefs";
    private static final String PIU_TYPE_REFS = "piuTypeRefs";
    private static final String IS_INSTALLED = "isInstalled";
    static final String[] SUPPORTED_VERSIONS = new String[]{"SU_1", "SU_2"};
    private static final int MO_DATA_REVISION_3_1 = 3000;
    private static final int MO_DATA_REVISION_3_5 = 3500;
    private static final int MO_DATA_REVISION_7_0 = 7000;
    private static final int MO_DATA_REVISION_9_0 = 9000;
    private static final int MO_DATA_REVISION_14_1 = 14100;
    private static final int MO_DATA_REVISION_LATEST = 14100;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid((Class)RepertoireMoImpl.class, (int)70)) {
            UpgradeTrace.debug((Class)RepertoireMoImpl.class, (int)70, (String)"create( ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context )", (String)("parent: " + managedObject.getType() + "\n\tattributes: " + Lib.toString((AttrList)attrList) + "\n\tidentity: " + string + "\n\tsource: " + managedObject2 + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        }
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"Repertoire", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"SwManagement");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"Repertoire", (int)128, (int)0);
        String string3 = MoAttributeValidator.checkAndGetStringAttribute((String)"name", (AttrList)attrList, (boolean)true, (String)"", (String)"Repertoire");
        String string4 = MoAttributeValidator.checkAndGetStringAttribute((String)"info", (AttrList)attrList, (boolean)false, (String)"", (String)"Repertoire");
        RepertoireMoImpl.checkOtherAttributes(attrList);
        return new RepertoireMoImpl(managedObject, string, string2, string3, string4, coordinator);
    }

    public static synchronized ManagedObject createMoAtUpgrade(ManagedObject managedObject, String string, String string2, String string3, Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid((Class)RepertoireMoImpl.class, (int)70)) {
            UpgradeTrace.debug((Class)RepertoireMoImpl.class, (int)70, (String)"createMoAtUpgrade(ManagedObject aParent, String anInfo, String aName, String anIdentity, Coordinator aCoordinator)", (String)("parent: " + managedObject.getType() + "\n\tanInfo: " + string + "\n\taName: " + string2 + "\n\tanIdentity: " + string3 + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        }
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"Repertoire", (String)string3);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"SwManagement");
        String string4 = "";
        MoAttributeValidator.checkStringWithLength((String)string2, (String)"name", (String)"Repertoire", (int)Integer.MAX_VALUE, (int)0);
        MoAttributeValidator.checkStringWithLength((String)string, (String)"info", (String)"Repertoire", (int)Integer.MAX_VALUE, (int)0);
        String string5 = string2;
        return new RepertoireMoImpl(managedObject, string3, string4, string2, string, string5, coordinator);
    }

    private RepertoireMoImpl(ManagedObject managedObject, String string, String string2, String string3, String string4, Coordinator coordinator) throws MoAccessException {
        this(managedObject, string, string2, string3, string4, "", coordinator);
    }

    private RepertoireMoImpl(ManagedObject managedObject, String string, String string2, String string3, String string4, String string5, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "Repertoire", string, coordinator);
        if (UpgradeTrace.valid((Class)RepertoireMoImpl.class, (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"RepertoireMoImpl( ManagedObject parent, String identity, String checkedUserLabel, String checkedName, String checkedInfo, String aSU_DOM_Key, Coordinator contex )", (String)("parent: " + managedObject.getType() + "\n\tidentity: " + string + "\n\tuserL: " + string2 + "\n\tname: " + string3 + "\n\tinfo: " + string4 + "\n\taSU_DOM_Key: " + string5 + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        }
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.mySU_DOM_Key = new StringAttribute("SU_DOM_KEY", false, string5);
        this.data.registerPersistentAttr((Attribute)this.mySU_DOM_Key);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.name = new StringAttribute("name", false, string3);
        this.data.registerPersistentAttr((Attribute)this.name);
        this.info = new StringAttribute("info", false, string4);
        this.data.registerPersistentAttr((Attribute)this.info);
        this.isInstalled = new BooleanAttribute(IS_INSTALLED, false, false);
        this.data.registerPersistentAttr((Attribute)this.isInstalled);
        this.reservedBy = new SequenceAttribute("reservedBy", false);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        this.loadModuleRefs = new SequenceAttribute(LOAD_MODULE_REFS, false);
        this.data.registerPersistentAttr((Attribute)this.loadModuleRefs);
        this.piuTypeRefs = new SequenceAttribute(PIU_TYPE_REFS, false);
        this.data.registerPersistentAttr((Attribute)this.piuTypeRefs);
        this.data.setRevision(14100);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public RepertoireMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"RepertoireMoImpl(MoData recoveredData)", (String)("recoveredData: " + moData));
        }
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(14100);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("name");
        moDataRecoveryHelper.assertAttribute("info");
        moDataRecoveryHelper.assertAttribute(IS_INSTALLED);
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute(PIU_TYPE_REFS);
        moDataRecoveryHelper.assertAttribute(LOAD_MODULE_REFS);
        moDataRecoveryHelper.assertAttribute("SU_DOM_KEY");
        this.userLabel = (StringAttribute)this.data.getAttribute("userLabel");
        this.name = (StringAttribute)this.data.getAttribute("name");
        this.info = (StringAttribute)this.data.getAttribute("info");
        this.isInstalled = (BooleanAttribute)this.data.getAttribute(IS_INSTALLED);
        this.reservedBy = (SequenceAttribute)this.data.getAttribute("reservedBy");
        this.piuTypeRefs = (SequenceAttribute)this.data.getAttribute(PIU_TYPE_REFS);
        this.loadModuleRefs = this.getLoadModuleRefs(this.data, moDataRecoveryHelper, (SequenceAttribute)this.data.getAttribute(LOAD_MODULE_REFS));
        this.mySU_DOM_Key = (StringAttribute)this.data.getAttribute("SU_DOM_KEY");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"delete(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (!this.reservedBy.isEmpty()) {
            throw new MoReservedNotDeletableException("Repertoire");
        }
        if (this.mySU_DOM_Key.getValue(coordinator).length() == 0) {
            this.setPiuTypeLoadListHandler();
            this.releasePiuTypeList(this.myPiuTypeLoadListHandler.getPiuTypeMos(), coordinator);
        } else {
            this.releasePiuTypeList(this.getUniquePiuTypeList(coordinator), coordinator);
        }
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    private String getSU_DOM_Key() {
        return this.mySU_DOM_Key.getValue(null);
    }

    public boolean getSU_DOM_Required(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSU_DOM_Required(Coordinator aCoordinator)");
        return this.mySU_DOM_Key.getValue(coordinator).length() != 0;
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"getUserLabel(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"setUserLabel(String value, Coordinator c)", (String)("value: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        }
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"Repertoire", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public String getName(Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"getName(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.mySU_DOM_Key.getValue(coordinator).length() == 0) {
            return this.name.getValue(coordinator);
        }
        return this.getRepertoireReadProxyInterface().getName((RepertoireMoSU_Access)this);
    }

    public String getInfo(Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"getInfo(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.mySU_DOM_Key.getValue(coordinator).length() == 0) {
            return this.info.getValue(coordinator);
        }
        String string = this.getRepertoireReadProxyInterface().getInformation((RepertoireMoSU_Access)this);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public ManagedObject[] getPiuTypeList(Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPiuTypeList(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.mySU_DOM_Key.getValue(coordinator).length() == 0) {
            this.setPiuTypeLoadListHandler();
            Collection collection = this.myPiuTypeLoadListHandler.getPiuTypeMos();
            ManagedObject[] managedObjectArray = new ManagedObject[collection.size()];
            Iterator iterator = collection.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                managedObjectArray[n] = (ManagedObject)iterator.next();
                ++n;
            }
            return managedObjectArray;
        }
        PiuTypeRefInterface[] piuTypeRefInterfaceArray = this.getRepertoireReadProxyInterface().getAllUniquePiuTypeRefs((RepertoireMoSU_Access)this).toArray(new PiuTypeRefInterface[0]);
        PiuTypeSU_DOM_MoMapInterface piuTypeSU_DOM_MoMapInterface = this.getProxySelectorInterface().getPiuTypeSU_DOM_MoMapInterface();
        ManagedObject[] managedObjectArray = new PiuTypeMoSU_Access[piuTypeRefInterfaceArray.length];
        for (int i = 0; i < piuTypeRefInterfaceArray.length; ++i) {
            managedObjectArray[i] = piuTypeSU_DOM_MoMapInterface.get(piuTypeRefInterfaceArray[i].getProductNumber(), piuTypeRefInterfaceArray[i].getRevision());
        }
        return managedObjectArray;
    }

    public boolean getIsInstalled(Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"getIsInstalled(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.isInstalled.getValue(coordinator);
    }

    public void setIsInstalled(boolean bl, Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"setIsInstalled(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.isInstalled.setValue(bl);
    }

    public String getRepertoireId(Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRepertoireId(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.getNamingAttributeValue();
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"getReservedBy(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Attribute[] attributeArray = this.reservedBy.getValue(coordinator);
        ManagedObject[] managedObjectArray = new ManagedObject[attributeArray.length];
        for (int i = 0; i < attributeArray.length; ++i) {
            managedObjectArray[i] = ((ReferenceAttribute)attributeArray[i]).getValue(coordinator);
        }
        return managedObjectArray;
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"reserve( ManagedObject userId, Coordinator context )", (String)("userId: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        }
        this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"Repertoire", (MoData)this.data, (SequenceAttribute)this.reservedBy, (String[])reservedClasses);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"release( ManagedObject userId, Coordinator context )", (String)("userId: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        }
        this.reservedBy = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"Repertoire", (MoData)this.data, (SequenceAttribute)this.reservedBy, (String[])reservedClasses);
    }

    public void clearReferencedPiuTypeMos(Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"reserveReferencedPiuTypeMos(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.mySU_DOM_Key.getValue(coordinator).length() == 0) {
            this.setPiuTypeLoadListHandler();
            this.releasePiuTypeList(this.myPiuTypeLoadListHandler.getPiuTypeMos(), coordinator);
        } else {
            this.releasePiuTypeList(this.getUniquePiuTypeList(coordinator), coordinator);
        }
    }

    public void reserveReferencedPiuTypeMos(Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"reserveReferencedPiuTypeMos(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.mySU_DOM_Key.getValue(coordinator).length() == 0) {
            this.setPiuTypeLoadListHandler();
            this.reservePiuTypeList(this.myPiuTypeLoadListHandler.getPiuTypeMos(), coordinator);
        } else {
            this.reservePiuTypeList(this.getUniquePiuTypeList(coordinator), coordinator);
        }
    }

    public void connectPiuTypeWithLM(PiuTypeMoSU_Access piuTypeMoSU_Access, Struct[] structArray, Coordinator coordinator) throws MoAccessException {
    }

    public Struct[] getLMData(PiuTypeMo piuTypeMo, Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"getLMData(PiuTypeMo aPiuType, Coordinator context)", (String)("PiuTypeMo: " + piuTypeMo + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        }
        Collection collection = this.getLoadModuleRefInfos(new PiuTypeRefInfo(piuTypeMo.getLocalDistinguishedName()), coordinator);
        Struct[] structArray = new Struct[collection.size()];
        StructImpl structImpl = null;
        String[] stringArray = new String[]{"loadModuleDN", "tag"};
        Object[] objectArray = null;
        ExtendedLoadModuleRefInfo extendedLoadModuleRefInfo = null;
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            extendedLoadModuleRefInfo = (ExtendedLoadModuleRefInfo)iterator.next();
            objectArray = new String[]{extendedLoadModuleRefInfo.getLdn(), extendedLoadModuleRefInfo.getTag()};
            structImpl = new StructImpl(stringArray, objectArray);
            structArray[n] = structImpl;
            ++n;
        }
        return structArray;
    }

    public Struct[] getLMData(PiuTypeMoSU_Access piuTypeMoSU_Access, Coordinator coordinator) throws MoAccessException {
        return null;
    }

    public String getLM_DataTag(Struct struct) throws MoAccessException {
        return null;
    }

    public String getLM_DataLoadModuleLDN(Struct struct) throws MoAccessException {
        return null;
    }

    public String getType() {
        return "Repertoire";
    }

    public Collection getPiuTypeLoadListInfos(Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPiuTypeLoadListInfos(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Collection collection = null;
        if (this.mySU_DOM_Key.getValue(coordinator).length() == 0) {
            this.setPiuTypeLoadListHandler();
            collection = this.myPiuTypeLoadListHandler.getPiuTypeLoadListInfos();
        } else {
            collection = new HashSet();
        }
        if (UpgradeTrace.valid(this.getClass(), (int)71)) {
            UpgradeTrace.debug(this.getClass(), (int)71, (String)"getPiuTypeLoadListInfos(Coordinator context)", (String)("Returning - thePiuTypeLoadListInfos: " + collection));
        }
        return collection;
    }

    public Collection getPiuTypeListInfos(Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPiuTypeListInfos(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        }
        if (this.mySU_DOM_Key.getValue(coordinator).length() == 0) {
            return new HashSet();
        }
        ManagedObject[] managedObjectArray = this.getPiuTypeList(coordinator);
        LinkedList<ManagedObject> linkedList = new LinkedList<ManagedObject>();
        if (managedObjectArray != null) {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                linkedList.add(managedObjectArray[i]);
            }
        }
        return linkedList;
    }

    public void setPiuTypeLoadListInfos(Collection collection, Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"setPiuTypeLoadListInfos(Collection aPiuTypeLoadListInfos)", (String)("context: " + Lib.toString((Coordinator)coordinator) + "\n\taPiuTypeLoadListInfos: " + collection));
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        PiuTypeLoadListHandler piuTypeLoadListHandler = new PiuTypeLoadListHandler(collection);
        if (this.myPiuTypeLoadListHandler != null) {
            if (this.myPiuTypeLoadListHandler.samePiuTypeRefInfos(piuTypeLoadListHandler.getPiuTypeRefInfos())) {
                this.myPiuTypeLoadListHandler = piuTypeLoadListHandler;
            } else {
                this.releasePiuTypeList(this.myPiuTypeLoadListHandler.getPiuTypeMos(), coordinator);
                this.myPiuTypeLoadListHandler = piuTypeLoadListHandler;
                this.reservePiuTypeList(this.myPiuTypeLoadListHandler.getPiuTypeMos(), coordinator);
            }
        } else {
            this.myPiuTypeLoadListHandler = piuTypeLoadListHandler;
            this.reservePiuTypeList(this.myPiuTypeLoadListHandler.getPiuTypeMos(), coordinator);
        }
        this.piuTypeRefs.setValue((Attribute[])this.myPiuTypeLoadListHandler.getPiuTypeRefsAsStringAttributeArray());
        this.loadModuleRefs.setValue((Attribute[])this.myPiuTypeLoadListHandler.getLoadModuleRefsAsStringAttributeArray());
    }

    public Collection getLoadModuleRefInfos(PiuTypeRefInfo piuTypeRefInfo, Collection collection, Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"getLoadModuleRefInfos(PiuTypeRefInfo aPiuTypeRefInfo, Collection aTags, Coordinator context)", (String)("aPiuTypeRefInfo: " + piuTypeRefInfo + "aPiuTypeRefInfo: " + piuTypeRefInfo + "aTags: " + collection + "context: " + Lib.toString((Coordinator)coordinator)));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Collection collection2 = null;
        if (this.mySU_DOM_Key.getValue(coordinator).length() == 0) {
            this.setPiuTypeLoadListHandler();
            collection2 = this.myPiuTypeLoadListHandler.getLoadModuleRefInfos(piuTypeRefInfo, collection);
        } else {
            PiuTypeMoSU_Access piuTypeMoSU_Access = (PiuTypeMoSU_Access)MoRepository.instance().lookup(piuTypeRefInfo.getLdn());
            Collection collection3 = null;
            collection3 = this.isSU_Access_VersionSupported(piuTypeMoSU_Access, "SU_3") ? this.getRepertoireReadProxyInterface().getLoadModuleRefInformations((RepertoireMoSU_Access)this, piuTypeMoSU_Access.getProductNumberOpt(coordinator), piuTypeMoSU_Access.getProductRevisionOpt(coordinator), collection) : this.getRepertoireReadProxyInterface().getLoadModuleRefInformations((RepertoireMoSU_Access)this, Lib.optimize((String)piuTypeMoSU_Access.getProductNumber(coordinator)), Lib.optimize((String)piuTypeMoSU_Access.getProductRevision(coordinator)), collection);
            collection2 = this.convertToExtendedLoadModuleRefInfos(collection3);
        }
        if (UpgradeTrace.valid(this.getClass(), (int)71)) {
            UpgradeTrace.debug(this.getClass(), (int)71, (String)"getLoadModuleRefInfos(PiuTypeRefInfo aPiuTypeRefInfo, Collection aTags, Coordinator context)", (String)("RETURNS - theLoadModuleRefInfos: " + collection2));
        }
        return collection2;
    }

    public Collection getLoadModuleRefInfosOrNull(PiuTypeRefInfo piuTypeRefInfo, Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"getLoadModuleRefInfosOrNull(PiuTypeRefInfo aPiuTypeRefInfo, Coordinator context)", (String)("aPiuTypeRefInfo: " + piuTypeRefInfo));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Collection collection = null;
        if (this.mySU_DOM_Key.getValue(coordinator).length() == 0) {
            this.setPiuTypeLoadListHandler();
            Collection collection2 = this.myPiuTypeLoadListHandler.getPiuTypeRefInfos();
            PiuTypeRefInfo piuTypeRefInfo2 = null;
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext() && !piuTypeRefInfo.isEqual(piuTypeRefInfo2 = (PiuTypeRefInfo)iterator.next())) {
                piuTypeRefInfo2 = null;
            }
            if (piuTypeRefInfo2 != null) {
                collection = this.getLoadModuleRefInfos(piuTypeRefInfo2, coordinator);
            }
        } else {
            PiuTypeMoSU_Access piuTypeMoSU_Access = (PiuTypeMoSU_Access)MoRepository.instance().lookup(piuTypeRefInfo.getLdn());
            Collection collection3 = null;
            collection3 = this.isSU_Access_VersionSupported(piuTypeMoSU_Access, "SU_3") ? this.getRepertoireReadProxyInterface().getLoadModuleRefInformations((RepertoireMoSU_Access)this, piuTypeMoSU_Access.getProductNumberOpt(coordinator), piuTypeMoSU_Access.getProductRevisionOpt(coordinator), true) : this.getRepertoireReadProxyInterface().getLoadModuleRefInformations((RepertoireMoSU_Access)this, Lib.optimize((String)piuTypeMoSU_Access.getProductNumber(coordinator)), Lib.optimize((String)piuTypeMoSU_Access.getProductRevision(coordinator)), true);
            if (collection3 != null) {
                collection = this.convertToExtendedLoadModuleRefInfos(collection3);
            }
        }
        if (UpgradeTrace.valid(this.getClass(), (int)71)) {
            UpgradeTrace.debug(this.getClass(), (int)71, (String)"getLoadModuleRefInfosOrNull(PiuTypeRefInfo aPiuTypeRefInfo, Coordinator context)", (String)("RETURNS - theLoadModuleRefInfosOrNull: " + collection));
        }
        return collection;
    }

    public Collection getLoadModuleRefInfos(PiuTypeRefInfo piuTypeRefInfo, Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"getLoadModuleRefInfos(PiuTypeRefInfo aPiuTypeRefInfo, Coordinator context)", (String)("aPiuTypeRefInfo: " + piuTypeRefInfo));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Collection collection = null;
        if (this.mySU_DOM_Key.getValue(coordinator).length() == 0) {
            this.setPiuTypeLoadListHandler();
            collection = this.myPiuTypeLoadListHandler.getLoadModuleRefInfos(piuTypeRefInfo);
        } else {
            PiuTypeMoSU_Access piuTypeMoSU_Access = (PiuTypeMoSU_Access)MoRepository.instance().lookup(piuTypeRefInfo.getLdn());
            Collection collection2 = null;
            collection2 = this.isSU_Access_VersionSupported(piuTypeMoSU_Access, "SU_3") ? this.getRepertoireReadProxyInterface().getLoadModuleRefInformations((RepertoireMoSU_Access)this, piuTypeMoSU_Access.getProductNumberOpt(coordinator), piuTypeMoSU_Access.getProductRevisionOpt(coordinator)) : this.getRepertoireReadProxyInterface().getLoadModuleRefInformations((RepertoireMoSU_Access)this, Lib.optimize((String)piuTypeMoSU_Access.getProductNumber(coordinator)), Lib.optimize((String)piuTypeMoSU_Access.getProductRevision(coordinator)));
            collection = this.convertToExtendedLoadModuleRefInfos(collection2);
        }
        if (UpgradeTrace.valid(this.getClass(), (int)71)) {
            UpgradeTrace.debug(this.getClass(), (int)71, (String)"getLoadModuleRefInfos(PiuTypeRefInfo aPiuTypeRefInfo, Coordinator context)", (String)("aPiuTypeRefInfo: " + piuTypeRefInfo + "\n\tReturning - theLoadModuleRefInfos: " + collection));
        }
        return collection;
    }

    public Collection getLoadModuleRefInfosConnectedToAnyPiuTypeRef(Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)71, (String)"getLoadModuleRefInfosConnectedToAnyPiuTypeRef(Coordinator contex)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Collection collection = null;
        if (this.mySU_DOM_Key.getValue(coordinator).length() == 0) {
            this.setPiuTypeLoadListHandler();
            collection = this.myPiuTypeLoadListHandler.getLoadModuleRefInfosConnectedToAnyPiuTypeRef();
        } else {
            Collection collection2 = this.getRepertoireReadProxyInterface().getAllLoadModuleRefInformations((RepertoireMoSU_Access)this);
            collection = this.convertToExtendedLoadModuleRefInfos(collection2);
        }
        if (UpgradeTrace.valid(this.getClass(), (int)71)) {
            UpgradeTrace.debug(this.getClass(), (int)71, (String)"getLoadModuleRefInfosConnectedToAnyPiuTypeRef(Coordinator contex)", (String)("Returning - theLoadModuleRefInfos: " + collection));
        }
        return collection;
    }

    public void actionLogPiuTypeLoadListInfos(Coordinator coordinator) {
        try {
            if (this.mySU_DOM_Key.getValue(coordinator).length() == 0) {
                StringBuffer stringBuffer = new StringBuffer("");
                Collection collection = this.getPiuTypeLoadListInfos(coordinator);
                stringBuffer.append("The PiuTypeLoadListInfos for " + this.getLocalDistinguishedName() + ":\n");
                PiuTypeLoadListInfo piuTypeLoadListInfo = null;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    piuTypeLoadListInfo = (PiuTypeLoadListInfo)iterator.next();
                    stringBuffer.append("\tPiuTypeLoadList\n" + piuTypeLoadListInfo.toLogString());
                }
                UpgradeTrace.log1(this.getClass(), (String)"actionLogPiuTypeLoadListInfos(Coordinator aCoordinator)", (String)stringBuffer.toString());
            } else {
                Collection collection = this.getPiuTypeListInfos(coordinator);
                UpgradeTrace.log1(this.getClass(), (String)"actionLogPiuTypeLoadListInfos(Coordinator aCoordinator)", (String)("thePiuTypeListInfos: " + collection));
            }
        }
        catch (MoAccessException moAccessException) {
            UpgradeTrace.error(this.getClass(), (String)"actionLogPiuTypeLoadListInfos(Coordinator aCoordinator)", (String)("Exception caught when getting PiuTypeLoadListInfos, e: " + (Object)((Object)moAccessException)));
        }
    }

    public void actionLogLoadModuleRefInfos(String string, String string2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.log1(this.getClass(), (String)"actionLogLoadModuleRefInfos(String aProductNumber, String aRevision, Coordinator context)", (String)("aProductNumber: " + string + "\n\taRevision: " + string2));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        StringBuffer stringBuffer = new StringBuffer("");
        PiuTypeMoSU_Access piuTypeMoSU_Access = this.getPiuTypeMo(string, string2, coordinator);
        if (piuTypeMoSU_Access != null) {
            Collection collection = this.getLoadModuleRefInfos(new PiuTypeRefInfo(piuTypeMoSU_Access.getLocalDistinguishedName()), coordinator);
            stringBuffer.append("The LoadModuleRefs for " + this.getLocalDistinguishedName() + " connected to the piuType:\n");
            if (collection.size() == 0) {
                stringBuffer.append("\t\tLoadModuleRef none");
            } else {
                LoadModuleMoSU_Access loadModuleMoSU_Access = null;
                ExtendedLoadModuleRefInfo extendedLoadModuleRefInfo = null;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    extendedLoadModuleRefInfo = (ExtendedLoadModuleRefInfo)iterator.next();
                    loadModuleMoSU_Access = (LoadModuleMoSU_Access)MoRepository.instance().lookup(extendedLoadModuleRefInfo.getLdn());
                    stringBuffer.append(extendedLoadModuleRefInfo.toLogString(loadModuleMoSU_Access));
                }
            }
            UpgradeTrace.log1(this.getClass(), (String)"actionLogLoadModuleRefInfos(String aProductNumber, String aRevision, Coordinator context)", (String)stringBuffer.toString());
        } else {
            UpgradeTrace.error(this.getClass(), (String)"actionLogLoadModuleRefInfos(String aProductNumber, String aRevision, Coordinator context)", (String)("Could not find any PiuType connected to the repertoire.\n\taProductNumber: " + string + "\n\taRevision: " + string2));
        }
    }

    public void actionLogLoadModuleRefInfosWithTag(String string, String string2, String string3, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.log1(this.getClass(), (String)"actionLogLoadModuleRefInfosWithTag(String aProductNumber, String aRevision, String aTag, Coordinator context)", (String)("aProductNumber: " + string + "\n\taRevision: " + string2 + "\n\taTag: " + string3));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        StringBuffer stringBuffer = new StringBuffer("");
        PiuTypeMoSU_Access piuTypeMoSU_Access = this.getPiuTypeMo(string, string2, coordinator);
        if (piuTypeMoSU_Access != null) {
            HashSet<String> hashSet = new HashSet<String>(1);
            hashSet.add(string3);
            Collection collection = this.getLoadModuleRefInfos(new PiuTypeRefInfo(piuTypeMoSU_Access.getLocalDistinguishedName()), hashSet, coordinator);
            stringBuffer.append("The LoadModuleRefs with tag " + string3 + " for " + this.getLocalDistinguishedName() + " connected to the piuType:\n");
            if (collection.size() == 0) {
                stringBuffer.append("\t\tLoadModuleRef none");
            } else {
                LoadModuleMoSU_Access loadModuleMoSU_Access = null;
                ExtendedLoadModuleRefInfo extendedLoadModuleRefInfo = null;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    extendedLoadModuleRefInfo = (ExtendedLoadModuleRefInfo)iterator.next();
                    loadModuleMoSU_Access = (LoadModuleMoSU_Access)MoRepository.instance().lookup(extendedLoadModuleRefInfo.getLdn());
                    stringBuffer.append(extendedLoadModuleRefInfo.toLogString(loadModuleMoSU_Access));
                }
            }
            UpgradeTrace.log1(this.getClass(), (String)"actionLogLoadModuleRefInfosWithTag(String aProductNumber, String aRevision, Coordinator context)", (String)stringBuffer.toString());
        } else {
            UpgradeTrace.error(this.getClass(), (String)"actionLogLoadModuleRefInfosWithTag(String aProductNumber, String aRevision, Coordinator context)", (String)("Could not find any PiuType connected to the repertoire.\n\taProductNumber: " + string + "\n\taRevision: " + string2));
        }
    }

    public void activateRepertoireMo(String string, Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)71, (String)"activateRepertoireMo(String aRepertoireName, Coordinator aCoordinator)", (String)("aRepertoireName: " + string + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        }
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.mySU_DOM_Key.getValue(coordinator).length() == 0) {
            this.mySU_DOM_Key.setValue(string);
            this.loadModuleRefs.setValue((Attribute[])new StringAttribute[0]);
            this.piuTypeRefs.setValue((Attribute[])new StringAttribute[0]);
            this.name.setValue("");
            this.info.setValue("");
        }
    }

    public int getNumberOfPiuTypeLoadLists(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.mySU_DOM_Key.getValue(coordinator).length() == 0) {
            Collection collection = this.getPiuTypeLoadListInfos(coordinator);
            return collection.size();
        }
        return this.getRepertoireReadProxyInterface().getNumberOfPiuTypeLoadLists((RepertoireMoSU_Access)this);
    }

    public LoadModuleMo[] getLoadModules(PiuTypeMo piuTypeMo, int n, Coordinator coordinator) throws MoAccessException {
        PiuTypeRefInfo piuTypeRefInfo = new PiuTypeRefInfo(piuTypeMo.getLocalDistinguishedName());
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(String.valueOf(n));
        Collection collection = this.getLoadModuleRefInfos(piuTypeRefInfo, hashSet, coordinator);
        LoadModuleMo[] loadModuleMoArray = new LoadModuleMo[collection.size()];
        LoadModuleMo loadModuleMo = null;
        ExtendedLoadModuleRefInfo extendedLoadModuleRefInfo = null;
        Iterator iterator = collection.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            extendedLoadModuleRefInfo = (ExtendedLoadModuleRefInfo)iterator.next();
            loadModuleMo = (LoadModuleMo)MoRepository.instance().lookup(extendedLoadModuleRefInfo.getLdn());
            if (loadModuleMo != null) {
                loadModuleMoArray[n2] = loadModuleMo;
                ++n2;
                continue;
            }
            UpgradeTrace.error(this.getClass(), (String)"getLoadModules(PiuTypeMo aPiuType, int aTagNumber, Coordinator aContext)", (String)("LoadModuleRefInfo found with a LoadModule LDN that does not exist.\n\ttheLoadModuleRefInfo: " + extendedLoadModuleRefInfo));
        }
        return loadModuleMoArray;
    }

    private void releasePiuTypeList(Collection collection, Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"releasePiuTypeList(Collection aPiuTypeMos, Coordinator context)", (String)("aPiuTypeMos: " + collection + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        }
        try {
            ManagedObject managedObject = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                managedObject = (ManagedObject)iterator.next();
                if (managedObject instanceof Reservable && !managedObject.isRemoved()) {
                    ((Reservable)managedObject).release((ManagedObject)this, coordinator);
                    continue;
                }
                if (!UpgradeTrace.valid(this.getClass(), (int)70)) continue;
                UpgradeTrace.debug(this.getClass(), (int)70, (String)"releasePiuTypeList(Collection aPiuTypeMos, Coordinator context)", (String)("thePiuTypeMo: " + managedObject + "\n\tPiuType Mo removed: " + managedObject.isRemoved()));
            }
        }
        catch (MoAccessException moAccessException) {
            UpgradeTrace.error(this.getClass(), (String)"reservePiuTypeList(Collection aPiuTypeMos, Coordinator context)", (String)("Exception caught when trying to release a PiuType MO.\n\taPiuTypeMos: " + collection + "\n\tException: " + (Object)((Object)moAccessException)));
            throw moAccessException;
        }
    }

    private void reservePiuTypeList(Collection collection, Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"releasePiuTypeList(Collection aPiuTypeMos, Coordinator context)", (String)("aPiuTypeMos: " + collection + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        }
        try {
            Reservable reservable = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                reservable = (Reservable)iterator.next();
                if (reservable == null) continue;
                reservable.reserve((ManagedObject)this, coordinator);
            }
        }
        catch (MoAccessException moAccessException) {
            UpgradeTrace.error(this.getClass(), (String)"reservePiuTypeList(Collection aPiuTypeMos, Coordinator context)", (String)("Exception caught when trying to reserve a PiuType MO.\n\taPiuTypeMos: " + collection + "\n\tException: " + (Object)((Object)moAccessException)));
            throw moAccessException;
        }
    }

    private void setPiuTypeLoadListHandler() throws MoAccessException {
        if (this.myPiuTypeLoadListHandler == null) {
            this.myPiuTypeLoadListHandler = new PiuTypeLoadListHandler(this.piuTypeRefs, this.loadModuleRefs);
        }
    }

    private PiuTypeMoSU_Access getPiuTypeMo(String string, String string2, Coordinator coordinator) throws MoAccessException {
        PiuTypeMoSU_Access piuTypeMoSU_Access = null;
        ManagedObject[] managedObjectArray = this.getPiuTypeList(coordinator);
        for (int i = 0; i < managedObjectArray.length && !(piuTypeMoSU_Access = (PiuTypeMoSU_Access)managedObjectArray[i]).matchPiuTypeMo(string, string2, coordinator); ++i) {
            piuTypeMoSU_Access = null;
        }
        return piuTypeMoSU_Access;
    }

    private SequenceAttribute getLoadModuleRefs(MoData moData, MoDataRecoveryHelper moDataRecoveryHelper, SequenceAttribute sequenceAttribute) {
        try {
            return RepertoireMoDataConversionHandler.INSTANCE.convertLoadModuleRefs(sequenceAttribute, moData);
        }
        catch (RepertoireMoDataConversionHandlerException repertoireMoDataConversionHandlerException) {
            moDataRecoveryHelper.fail(repertoireMoDataConversionHandlerException.getReasonTag() + "\n\t");
            return sequenceAttribute;
        }
    }

    private static void checkOtherAttributes(AttrList attrList) throws NoSuchAttributeException {
        int n;
        if (UpgradeTrace.valid((Class)RepertoireMoImpl.class, (int)70)) {
            UpgradeTrace.debug((Class)RepertoireMoImpl.class, (int)70, (String)"checkOtherAttributes( AttrList attributes )", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        }
        if ((n = attrList.size()) != 0) {
            throw new NoSuchAttributeException(attrList.getName(0), "Repertoire");
        }
    }

    private RepertoireReadProxyInterface getRepertoireReadProxyInterface() throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRepertoireReadProxyInterface()");
        }
        try {
            return this.getRepertoireProxyInformation().getRepertoireReadProxyInterface();
        }
        catch (Throwable throwable) {
            String string = "\n\tSU_DOM_Key: " + this.getSU_DOM_Key();
            if (throwable instanceof NullPointerException) {
                RepertoireProxyInformation repertoireProxyInformation = this.getRepertoireProxyInformation();
                string = string + "\n\tgetPiuTypeProxyInformation( ) returns " + repertoireProxyInformation;
                if (repertoireProxyInformation != null) {
                    RepertoireReadProxyInterface repertoireReadProxyInterface = repertoireProxyInformation.getRepertoireReadProxyInterface();
                    string = string + "\n\tgetRepertoireProxyInformation( ).getRepertoireReadProxyInterface( ) returns " + repertoireReadProxyInterface;
                }
            }
            UpgradeTrace.error(this.getClass(), (String)"getRepertoireReadProxyInterface( )", (String)("Throwable caught," + string), (Throwable)throwable);
            throw new SoftwareErrorException(throwable);
        }
    }

    private RepertoireProxyInformation getRepertoireProxyInformation() {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRepertoireProxyInformation()");
        }
        this.myRepertoireProxyInformation = this.getProxySelectorInterface().getRepertoireReadProxyInterface(this.getSU_DOM_Key(), this.myRepertoireProxyInformation);
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRepertoireProxyInformation()", (String)("RETURNS - myRepertoireProxyInformation: " + this.myRepertoireProxyInformation));
        }
        return this.myRepertoireProxyInformation;
    }

    private Collection convertToExtendedLoadModuleRefInfos(Collection collection) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"convertToExtendedLoadModuleRefInfos(Collection aLoadModuleInformationInterfaces)", (String)("aLoadModuleInformationInterfaces: " + collection));
        }
        LoadModuleSU_DOM_MoMapInterface loadModuleSU_DOM_MoMapInterface = null;
        ExtendedLoadModuleInformationInterface extendedLoadModuleInformationInterface = null;
        try {
            Iterator iterator = collection.iterator();
            HashSet<ExtendedLoadModuleRefInfo2> hashSet = new HashSet<ExtendedLoadModuleRefInfo2>();
            loadModuleSU_DOM_MoMapInterface = this.getProxySelectorInterface().getLoadModuleSU_DOM_MoMapInterface();
            while (iterator.hasNext()) {
                extendedLoadModuleInformationInterface = (ExtendedLoadModuleInformationInterface)iterator.next();
                hashSet.add(new ExtendedLoadModuleRefInfo2(loadModuleSU_DOM_MoMapInterface.get(extendedLoadModuleInformationInterface.getProductNumber(), extendedLoadModuleInformationInterface.getRevision()).getLocalDistinguishedName(), extendedLoadModuleInformationInterface.getTagAsString(), extendedLoadModuleInformationInterface.getProgramMemoryHeapSizeForToString(), extendedLoadModuleInformationInterface.getProgramMemoryPoolSizeForToString(), extendedLoadModuleInformationInterface.getExpandedProgramInstancesForString(), extendedLoadModuleInformationInterface.getLoaderNameForToString(), extendedLoadModuleInformationInterface.getDeviceLoaderNameForToString(), extendedLoadModuleInformationInterface.getDeviceLoaderInformationForToString(), extendedLoadModuleInformationInterface.getRestartCounterLimitForToString(), extendedLoadModuleInformationInterface.getRestartTimerForToString()));
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            UpgradeTrace.error(this.getClass(), (String)"convertToExtendedLoadModuleRefInfos(Collection aLoadModuleInformationInterfaces)", (String)("\n\ttheExtendedLoadModuleInformationInterface: " + extendedLoadModuleInformationInterface + "\n\ttheLoadModuleSU_DOM_MoMapInterface: " + loadModuleSU_DOM_MoMapInterface + "\n\taLoadModuleInformationInterfaces: " + collection + "\n\tThrowable caught"), (Throwable)throwable);
            throw new ConfigurationMismatchException(throwable.toString());
        }
    }

    private ProxySelectorSwmInterface getProxySelectorInterface() {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProxySelectorInterface()");
        }
        if (this.myProxySelectorInterface == null) {
            this.myProxySelectorInterface = (ProxySelectorSwmInterface)ServiceLocatorFacade.getRepository().getService(ProxySelectorSwmInterface.class);
        }
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProxySelectorInterface()", (String)("RETURNS - myProxySelectorInterface: " + this.myProxySelectorInterface));
        }
        return this.myProxySelectorInterface;
    }

    private Collection getUniquePiuTypeList(Coordinator coordinator) throws MoAccessException {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"getUniquePiuTypeList(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        }
        if (this.mySU_DOM_Key.getValue(coordinator).length() == 0) {
            this.setPiuTypeLoadListHandler();
            Collection collection = this.myPiuTypeLoadListHandler.getPiuTypeMos();
            return collection;
        }
        PiuTypeRefInterface[] piuTypeRefInterfaceArray = this.getRepertoireReadProxyInterface().getAllUniquePiuTypeRefs((RepertoireMoSU_Access)this).toArray(new PiuTypeRefInterface[0]);
        PiuTypeSU_DOM_MoMapInterface piuTypeSU_DOM_MoMapInterface = this.getProxySelectorInterface().getPiuTypeSU_DOM_MoMapInterface();
        HashSet<PiuTypeMoSU_Access> hashSet = new HashSet<PiuTypeMoSU_Access>();
        for (int i = 0; i < piuTypeRefInterfaceArray.length; ++i) {
            hashSet.add(piuTypeSU_DOM_MoMapInterface.get(piuTypeRefInterfaceArray[i].getProductNumber(), piuTypeRefInterfaceArray[i].getRevision()));
        }
        return hashSet;
    }

    private boolean isSU_Access_VersionSupported(PiuTypeMoSU_Access piuTypeMoSU_Access, String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)70)) {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"isSU_Access_VersionSupported(PiuTypeMoSU_Access aPiuTypeMoSU_Access, String anSU_AccessVersion)", (String)("aPiuTypeMoSU_Access: " + piuTypeMoSU_Access + "\n\tanSU_AccessVersion: " + string));
        }
        String[] stringArray = piuTypeMoSU_Access.getSupportedVersions();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            bl = true;
            break;
        }
        if (UpgradeTrace.valid(this.getClass(), (int)71)) {
            UpgradeTrace.debug(this.getClass(), (int)71, (String)"isSU_Access_VersionSupported(PiuTypeMoSU_Access aPiuTypeMoSU_Access, String anSU_AccessVersion)", (String)("Returns: " + bl));
        }
        return bl;
    }
}

