/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.log;

import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpAddressValidation;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv4AddressValidation;
import se.ericsson.cello.mao.Ipv6AddressValidation;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;

public class AccountInformation {
    private String remoteHost = "";
    private String userID = "";
    private String password = "";

    public AccountInformation() throws MoAccessException {
        this.check();
    }

    public AccountInformation(Struct struct) throws MoAccessException {
        String[] stringArray = struct.getNames();
        if (stringArray.length != 3) {
            throw new ValueOutOfRangeException("Missing member in accountInfo", "Log");
        }
        if (!(struct.getValue("userID") instanceof String)) {
            throw new WrongAttributeTypeException("userID", "Log");
        }
        this.userID = (String)struct.getValue("userID");
        if (!(struct.getValue("remoteHost") instanceof String)) {
            throw new WrongAttributeTypeException("remoteHost", "Log");
        }
        this.remoteHost = (String)struct.getValue("remoteHost");
        if (!(struct.getValue("password") instanceof String)) {
            throw new WrongAttributeTypeException("password", "Log");
        }
        MoAttributeValidator.validateForIllegalCharacters((String)"password", (String)((String)struct.getValue("password")), (String)"Log");
        this.password = (String)struct.getValue("password");
        this.check();
    }

    protected String getRemoteHost() {
        return this.remoteHost;
    }

    protected String getUserID() {
        return this.userID;
    }

    protected String getPassword() {
        return this.password;
    }

    private void check() throws MoAccessException {
        if (!this.remoteHost.equals("")) {
            if (Ipv6AddressValidation.isIpv6((String)this.remoteHost) || Ipv4AddressValidation.isIpv4((String)this.remoteHost)) {
                if (!this.isValidIp()) {
                    throw new IpFormatException("ipAddress " + this.remoteHost + "  cannot be set, choose other ipAddress ");
                }
            } else if (Character.isLetter(this.remoteHost.charAt(0)) && Character.isLetterOrDigit(this.remoteHost.charAt(this.remoteHost.length() - 1))) {
                char c = '.';
                char c2 = '-';
                for (int i = 1; i < this.remoteHost.length() - 1; ++i) {
                    if (Character.isLetterOrDigit(this.remoteHost.charAt(i)) || this.remoteHost.charAt(i) == c || this.remoteHost.charAt(i) == c2) continue;
                    throw new ValueOutOfRangeException("Domain name " + this.remoteHost + "is not valid", "Log");
                }
            } else {
                throw new IllegalAttributeValueException("The value " + this.remoteHost + " is not a valid Ipv4/Ipv6 address or domain name", "Log");
            }
        }
        if (this.userID == null || this.userID.equals("0") || this.userID.length() > 21) {
            throw new ValueOutOfRangeException("userIDString Value Incorrect", "Log");
        }
        if (this.password == null || this.password.equals("0") || this.password.length() > 21) {
            throw new ValueOutOfRangeException("passwordString Value Incorrect", "Log");
        }
    }

    private boolean isValidIp() throws MoAccessException {
        return !IpAddressValidation.isLoopBackIpAddress((String)this.remoteHost) && !IpAddressValidation.getIpAddress((String)this.remoteHost).equals(IpAddressValidation.getIpAddress((String)"::")) && !IpAddressValidation.isDefault((String)this.remoteHost);
    }
}

