/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.model;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnum;
import se.ericsson.cello.mimparser.MomEnumRef;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MomBase;
import se.ericsson.cello.mimparser.model.MomEntityResolvable;
import se.ericsson.cello.mimparser.model.MomEnumImpl;
import se.ericsson.cello.mimparser.model.MomEnumMemberImpl;
import se.ericsson.cello.mimparser.state.DefaultSettable;
import se.ericsson.cello.mimparser.state.MimSettable;

public class MomEnumRefImpl
extends MomBase
implements MomEnumRef,
MomEntityResolvable,
DefaultSettable,
MimSettable {
    private static final String MIM_NAME = "mimName: ";
    private static final String MIM_VERSION = "mimVersion: ";
    private static final String VALUE = "defaultValue: ";
    private static final String NEW_LINE = "\n";
    private MomEnum momEnum;
    private Integer defaultValue;
    private String defaultValueString;
    private String mimName;
    private String mimVersion;

    public MomEnumRefImpl(String string, Attributes attributes, MimModelImpl mimModelImpl, int n) {
        super(string, attributes, mimModelImpl, n);
    }

    public MomEnum getEnum() {
        return this.momEnum;
    }

    public Integer getDefault() {
        return this.defaultValue;
    }

    public String getDefaultRawData() {
        return this.defaultValueString;
    }

    public void setDefault(String string) {
        this.defaultValueString = string;
    }

    public String getMimName() {
        return this.mimName;
    }

    public void setMimName(String string) {
        this.mimName = string;
    }

    public String getMimVersion() {
        return this.mimVersion;
    }

    public void setMimVersion(String string) {
        this.mimVersion = string;
    }

    public void resolveDefault() {
        try {
            if (this.defaultValueString != null) {
                MomEnumImpl momEnumImpl = (MomEnumImpl)this.momEnum;
                MomEnumMemberImpl momEnumMemberImpl = momEnumImpl.getEnumMemberCaseInsensitive(this.defaultValueString);
                this.defaultValue = momEnumMemberImpl == null ? new Integer(this.defaultValueString) : momEnumMemberImpl.getValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            String string = "MomEnumRefImpl.setDefault()  Can not convert String to Integer for element:" + this.getName() + " String=" + this.defaultValueString + "  Exception=" + numberFormatException.toString();
            this.getModel().addToWarningList(string);
        }
    }

    public void setResolvedEntity(MomEntity momEntity) {
        this.momEnum = (MomEnum)momEntity;
    }

    public String getDescription() {
        return this.getEnum().getDescription();
    }

    public String getApplicationTag() {
        return this.getEnum().getApplicationTag();
    }

    public String getExtendedDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getMimName() != null) {
            stringBuffer.append(MIM_NAME + this.getMimName() + NEW_LINE);
        }
        if (this.getMimVersion() != null) {
            stringBuffer.append(MIM_VERSION + this.getMimVersion() + NEW_LINE);
        }
        if (this.getDefault() != null) {
            String string = this.getDefault().toString();
            stringBuffer.append(VALUE + string + NEW_LINE + NEW_LINE);
        }
        stringBuffer.append(this.getEnum().getExtendedDescription());
        return stringBuffer.toString();
    }
}

