/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.implementors;

import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.ncli.server.command.handlers.CommandResultListener;
import se.ericsson.cello.ncli.server.command.implementors.CSCommand;
import se.ericsson.cello.ncli.server.command.implementors.GroupExecutor;
import se.ericsson.cello.ncli.server.command.implementors.SetCommand;
import se.ericsson.cello.ncli.server.command.mogroup.MoGroup;
import se.ericsson.cello.ncli.server.command.result.PrintoutFactory;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.exceptions.ExceptionHandler;
import se.ericsson.cello.ncli.server.exceptions.NcliException;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.cello.neal.cm.Value;

public class ActionCommand
extends CSCommand
implements GroupExecutor {
    private String actionName = null;
    private String range = null;
    private boolean groupFlag = false;
    private boolean xmlFlag = false;

    public ActionCommand(CommandResultListener commandResultListener, NodeServices nodeServices) {
        super(commandResultListener, nodeServices);
    }

    public void setGroupFlag(boolean bl) {
        this.groupFlag = bl;
    }

    public void setRange(String string) {
        this.range = string;
    }

    public void execute() {
        try {
            Log.trace(ActionCommand.class, "ActionCommand::execute()");
            this.printout = PrintoutFactory.createPrintout(this.xmlFlag, "ACTION");
            Transaction transaction = this.transactionHandler.getTransaction(3600000);
            if (this.range != null) {
                this.executeGroupRange(this.range, transaction);
            } else if (this.groupFlag) {
                this.executeEntireGroup(transaction);
            } else {
                this.getLdn();
                Log.trace(ActionCommand.class, "Resolved LDN: " + this.ldn);
                this.executeSingleMo(this.ldn, transaction);
                this.transactionHandler.softCommitTransaction();
                this.printout.addEndText();
                this.sendResponse();
            }
        }
        catch (Exception exception) {
            this.transactionHandler.softRollbackTransaction();
            this.printout.addMoStart(this.ldn);
            this.printout.addErrorText(ExceptionHandler.map(exception, ""));
            this.printout.addMoEnd();
            if (this.xmlFlag) {
                this.printout.addEndText();
            }
            this.sendResponse();
        }
    }

    public void executeEntireGroup(Transaction transaction) throws NcliException {
        try {
            if (!this.confirmGroup(this.nodeServices.getMoGroupHandler().getDefaultGroup())) {
                this.transactionHandler.softRollbackTransaction();
                this.printout = PrintoutFactory.createPrintout();
                this.printout.addInhibitedString();
                this.sendResponse();
                return;
            }
            MoGroup moGroup = this.nodeServices.getMoGroupHandler().getDefaultGroup();
            List list = moGroup.getGroupMembers();
            Iterator iterator = list.iterator();
            String string = null;
            while (iterator.hasNext()) {
                this.nodeServices.getMemoryChecker().memoryIsEnough(1024L);
                string = (String)iterator.next();
                if (string == null) continue;
                if (string != null) {
                    this.executeSingleMo(string, transaction);
                    this.printout.addResult("\n");
                } else {
                    Log.trace(class$se$ericsson$cello$ncli$server$command$implementors$ActionCommand == null ? ActionCommand.class$("se.ericsson.cello.ncli.server.command.implementors.ActionCommand") : class$se$ericsson$cello$ncli$server$command$implementors$ActionCommand, "Encountered null element in group, ignoring.");
                }
                this.sendResponse();
                this.printout.clearPrintoutBuf();
                if (!this.resultListener.checkCancellation()) continue;
                Log.trace(SetCommand.class, "Command cancelled");
                this.transactionHandler.softRollbackTransaction();
                this.printout.addInhibitedString();
                this.resultListener.commandCancelled(this.printout);
                this.sendResponse();
                return;
            }
            this.transactionHandler.softCommitTransaction();
            this.printout.addEndText();
            this.sendResponse();
        }
        catch (Exception exception) {
            throw new NcliException(exception);
        }
    }

    public void executeGroupRange(String string, Transaction transaction) throws NcliException {
        try {
            if (!this.confirmGroupRange(this.nodeServices.getMoGroupHandler().getDefaultGroup(), string)) {
                this.transactionHandler.softRollbackTransaction();
                this.printout = PrintoutFactory.createPrintout();
                this.printout.addInhibitedString();
                this.sendResponse();
                return;
            }
            MoGroup moGroup = this.nodeServices.getMoGroupHandler().getDefaultGroup();
            int n = moGroup.getSize();
            int[] nArray = this.nodeServices.getAddressResolver().resolveIndexFromRange(string, n);
            String string2 = null;
            for (int i = 0; i < nArray.length; ++i) {
                this.nodeServices.getMemoryChecker().memoryIsEnough(1024L);
                string2 = moGroup.getLdnAtIndex(nArray[i]);
                if (string2 == null) {
                    Log.trace(class$se$ericsson$cello$ncli$server$command$implementors$ActionCommand == null ? ActionCommand.class$("se.ericsson.cello.ncli.server.command.implementors.ActionCommand") : class$se$ericsson$cello$ncli$server$command$implementors$ActionCommand, "Encountered null element in group, ignoring.");
                    continue;
                }
                this.executeSingleMo(string2, transaction);
                this.printout.addResult("\n");
                if (this.checkCancellation()) {
                    this.transactionHandler.softRollbackTransaction();
                    this.printout.addInhibitedString();
                    this.commandCancelled();
                    return;
                }
                this.sendResponse();
                this.printout.clearPrintoutBuf();
            }
            this.transactionHandler.softCommitTransaction();
            this.printout.addEndText();
            this.sendResponse();
        }
        catch (Exception exception) {
            throw new NcliException(exception);
        }
    }

    public void executeSingleMo(String string, Transaction transaction) throws NcliException {
        try {
            Mo mo = null;
            Value value = null;
            mo = this.nodeServices.getCm().getMo(string);
            this.validateMo(mo);
            value = mo.action(this.getActionName(), this.getNameValueArray(), transaction);
            this.printout.addMoStart(mo.getLdn());
            this.printout.addResultString();
            this.printout.addActionResult(this.getActionName(), value, this.nodeServices.getCm().getNameValueFactory());
            this.printout.addMoEnd();
        }
        catch (Exception exception) {
            throw new NcliException(exception);
        }
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String string) {
        this.actionName = string;
    }

    public void setXmlFlag(boolean bl) {
        this.xmlFlag = bl;
    }
}

