/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.implementors;

import java.util.ArrayList;
import se.ericsson.cello.ncli.server.command.handlers.CommandResultListener;
import se.ericsson.cello.ncli.server.command.implementors.Command;
import se.ericsson.cello.ncli.server.command.result.PrintoutFactory;
import se.ericsson.cello.ncli.server.logging.Log;

public final class ManCommand
extends Command {
    private ArrayList cmdDescList = new ArrayList(0);
    private static final String MAN_EXT = ".txt";
    private static final String MAN_PACKAGE = "/se/ericsson/cello/ncli/server/man/";
    public static final String PAGE_NOT_FOUND = "Manual page not found";
    public static final String TAB_SEPARATOR = "\t\t\t";
    public static final String LONG_CMD_TAB_SEPARATOR = "\t\t";
    public static final String CMD_DESC_HEADER = "Command\t\t\tDescription\n";

    public ManCommand(CommandResultListener commandResultListener) {
        super(commandResultListener);
        this.addCommandDescriptions();
    }

    private void addCommandDescriptions() {
        this.cmdDescList.add(new CommandDescription("!", "Execute command from history"));
        this.cmdDescList.add(new CommandDescription("action", "Execute an action on a Managed Object"));
        this.cmdDescList.add(new CommandDescription("alarms", "Print active alarm list"));
        this.cmdDescList.add(new CommandDescription("alarmsev", "Change alarm severity configuration"));
        this.cmdDescList.add(new CommandDescription("cd", "alias for jump"));
        this.cmdDescList.add(new CommandDescription("create", "Create Managed Object"));
        this.cmdDescList.add(new CommandDescription("delete", "Delete Managed Object"));
        this.cmdDescList.add(new CommandDescription("diff", "Compare Managed Objects"));
        this.cmdDescList.add(new CommandDescription("exit", "Terminates an NCLI session"));
        this.cmdDescList.add(new CommandDescription("get", "Get attributes and children of a particular Managed Object"));
        this.cmdDescList.add(new CommandDescription("group", "Manage group of Managed Objects"));
        this.cmdDescList.add(new CommandDescription("help", "alias for man"));
        this.cmdDescList.add(new CommandDescription("history", "Display command history"));
        this.cmdDescList.add(new CommandDescription("info", "Print information from the Managed Object Model (MOM)"));
        this.cmdDescList.add(new CommandDescription("jump", "Change working Managed Object"));
        this.cmdDescList.add(new CommandDescription("ls", "alias for get"));
        this.cmdDescList.add(new CommandDescription("man", "Display manual pages"));
        this.cmdDescList.add(new CommandDescription("pwd", "alias for pwldn"));
        this.cmdDescList.add(new CommandDescription("pwldn", "Print working Managed Object"));
        this.cmdDescList.add(new CommandDescription("rm", "alias for delete"));
        this.cmdDescList.add(new CommandDescription("search", "Search for Managed Objects"));
        this.cmdDescList.add(new CommandDescription("set", "Set Managed Object attribute values"));
        this.cmdDescList.add(new CommandDescription("tx", "Transaction management"));
    }

    public String getCommandDescriptions() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.cmdDescList.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(((CommandDescription)this.cmdDescList.get((int)i)).cmd);
            int n2 = 7;
            if (((CommandDescription)this.cmdDescList.get((int)i)).cmd.length() > n2) {
                stringBuffer.append(LONG_CMD_TAB_SEPARATOR);
            } else {
                stringBuffer.append(TAB_SEPARATOR);
            }
            stringBuffer.append(((CommandDescription)this.cmdDescList.get((int)i)).description);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void execute() {
        Log.trace(ManCommand.class, "execute()");
        this.printout = PrintoutFactory.createPrintout();
        this.printout.addResult(CMD_DESC_HEADER);
        this.printout.addResult(this.getCommandDescriptions());
        this.printout.addEndText();
        this.sendResponse();
    }

    private class CommandDescription {
        public String cmd;
        public String description;

        public CommandDescription(String string, String string2) {
            this.cmd = string;
            this.description = string2;
        }
    }
}

