/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.implementors;

import se.ericsson.cello.ncli.server.command.handlers.CommandResultListener;
import se.ericsson.cello.ncli.server.command.implementors.CSCommand;
import se.ericsson.cello.ncli.server.command.result.PrintoutFactory;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.cs.transaction.HardTransactionHandling;
import se.ericsson.cello.ncli.server.logging.Log;

public class TxCommand
extends CSCommand {
    private boolean startFlag = false;
    private boolean commitFlag = false;
    private boolean rollbackFlag = false;
    private Integer timeout = null;
    protected HardTransactionHandling hardTxHandler = this.nodeServices.getHardTransactionHandler();
    private static final String TX_NOT_STARTED = "No transaction started";
    private static final String TX_ALREADY_STARTED = "Transaction already started";

    public TxCommand(CommandResultListener commandResultListener, NodeServices nodeServices) {
        super(commandResultListener, nodeServices);
    }

    public void setStartFlag(boolean bl) {
        this.startFlag = bl;
    }

    public void setCommitFlag(boolean bl) {
        this.commitFlag = bl;
    }

    public void setRollbackFlag(boolean bl) {
        this.rollbackFlag = bl;
    }

    public void setTimeout(Integer n) {
        this.timeout = n;
    }

    public void execute() {
        Log.trace(TxCommand.class, "execute()");
        try {
            this.printout = PrintoutFactory.createPrintout();
            if (this.commitFlag) {
                this.executeCommit();
            } else if (this.rollbackFlag) {
                this.executeRollback();
            } else if (this.startFlag) {
                this.executeStart();
            }
        }
        catch (Exception exception) {
            this.printout.addErrorText(exception.getMessage());
        }
        this.sendResponse();
    }

    void executeStart() {
        if (this.hardTxHandler.isTransactionStarted()) {
            this.printout.addErrorText(TX_ALREADY_STARTED);
        } else {
            if (this.timeout == null) {
                this.hardTxHandler.startTransaction();
            } else {
                this.hardTxHandler.startTransaction(this.timeout * 1000);
            }
            this.printout.addExecutedString();
        }
    }

    void executeRollback() {
        if (this.hardTxHandler.isTransactionStarted()) {
            this.hardTxHandler.hardRollbackTransaction();
            this.printout.addExecutedString();
        } else {
            this.printout.addErrorText(TX_NOT_STARTED);
        }
    }

    void executeCommit() {
        if (this.hardTxHandler.isTransactionStarted()) {
            this.hardTxHandler.hardCommitTransaction();
            this.printout.addExecutedString();
        } else {
            this.printout.addErrorText(TX_NOT_STARTED);
        }
    }
}

