/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.completion.completers;

import java.util.ArrayList;
import java.util.StringTokenizer;
import se.ericsson.cello.ncli.server.command.result.PlainTextFormatter;
import se.ericsson.cello.ncli.server.completion.BaseCompleter;
import se.ericsson.cello.ncli.server.completion.Completer;
import se.ericsson.cello.ncli.server.completion.CompleterFactory;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;

public class AttrDefinitionCompleter
extends BaseCompleter {
    protected String attrOwnerLdn = null;

    public AttrDefinitionCompleter(NodeServices nodeServices) {
        super(nodeServices);
    }

    public AttrDefinitionCompleter(NodeServices nodeServices, String string) {
        super(nodeServices);
        this.attrOwnerLdn = string;
    }

    public void completeString(String string) {
        Log.trace(AttrDefinitionCompleter.class, "completeString(" + string + ")");
        Log.trace(AttrDefinitionCompleter.class, "completeString. attrOwnerLdn ='" + this.attrOwnerLdn + "'");
        this.completedString = "";
        this.completionOptionList = new ArrayList(0);
        if (string == null) {
            return;
        }
        if (string.endsWith(" ")) {
            this.completedString = string;
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        Log.trace(AttrDefinitionCompleter.class, "nrOfTokens=" + n);
        String string2 = "";
        if (n <= 0) {
            string2 = "";
        } else if (n == 1) {
            string2 = stringTokenizer.nextToken();
        } else {
            this.completedString = string;
            return;
        }
        if (!this.completeAttrDefName(string2, string)) {
            this.completedString = string;
            return;
        }
    }

    protected boolean completeAttrDefName(String string, String string2) {
        String string3;
        Log.trace(AttrDefinitionCompleter.class, "completeAttrDefToken. token = '" + string + "'");
        if (string == null || string2 == null || this.attrOwnerLdn == null) {
            return false;
        }
        int n = string.indexOf("=");
        String string4 = string3 = n < 0 ? string : string.substring(0, n);
        if (n < 0) {
            Completer completer = CompleterFactory.createAttrNameCompleter(this.nodeServices, this.attrOwnerLdn, false, false);
            completer.completeString(string3);
            String string5 = completer.getCompletedString();
            if (string5.endsWith(" ")) {
                string5 = string5.substring(0, string5.length() - 1);
            }
            if (!string5.equalsIgnoreCase(string3) || completer.getCompletionOptionList().size() > 0) {
                if (completer.getCompletionOptionList().size() <= 1) {
                    this.completedString = string5;
                    this.completionOptionList.clear();
                    return true;
                }
                this.completedString = string5;
                this.completionOptionList = completer.getCompletionOptionList();
                return true;
            }
        }
        return this.completeKnownAttrName(string3, string, string2);
    }

    protected boolean completeKnownAttrName(String string, String string2, String string3) {
        try {
            Mo mo = this.nodeServices.getCm().getMo(this.attrOwnerLdn);
            NameValue nameValue = mo.getAttribute(string, this.nodeServices.getTransactionHandler().getCurrentTransaction());
            PlainTextFormatter plainTextFormatter = new PlainTextFormatter();
            StringBuffer stringBuffer = plainTextFormatter.format(nameValue);
            char c = '\u0000';
            int n = 0;
            StringBuffer stringBuffer2 = new StringBuffer();
            int n2 = stringBuffer.length();
            for (int i = 0; i < n2; ++i) {
                c = stringBuffer.charAt(i);
                if (c == '\n' || c == ' ' && n == 32) continue;
                stringBuffer2.append(c);
                n = c;
            }
            String string4 = stringBuffer2.toString().trim();
            if (string4.toLowerCase().startsWith(string2.toLowerCase())) {
                this.completedString = string4;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            Log.trace(AttrDefinitionCompleter.class, ".completeLastToken. A 'controlled' execption was caught:" + string3);
            return false;
        }
    }
}

