/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.completion.completers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnum;
import se.ericsson.cello.mimparser.MomStruct;
import se.ericsson.cello.ncli.server.completion.CsCmdCompleter;
import se.ericsson.cello.ncli.server.completion.util.CompletionHelper;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.exceptions.MomAwarenessNotSupportedException;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.ncli.server.mom.MomEntityResolver;
import se.ericsson.cello.ncli.server.mom.MomInsensitiveSearch;

public class CmdInfoCompleter
extends CsCmdCompleter {
    protected NodeServices aNodeService = null;
    protected MomInsensitiveSearch searcher = null;
    protected MomEntityResolver entityResolver = null;
    protected String orgToken = null;
    protected String firstToken = null;
    protected String entityType = null;
    protected ArrayList searchResult = new ArrayList(0);
    protected static final String ALL = "all";
    protected static final String DOT = ".";

    public CmdInfoCompleter(NodeServices nodeServices, MimModel mimModel) {
        super(nodeServices);
        this.aNodeService = nodeServices;
        this.searcher = new MomInsensitiveSearch(mimModel);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean completeFirstToken(String string, StringTokenizer stringTokenizer, String string2) {
        String string3;
        int n;
        String string4;
        block18: {
            block16: {
                block19: {
                    block17: {
                        string4 = null;
                        n = 0;
                        this.orgToken = string;
                        string3 = null;
                        Log.trace(CsCmdCompleter.class, ".completeFirstToken() currToken='" + string + "', aStringToComplete ='" + string2 + "'");
                        try {
                            this.entityResolver = new MomEntityResolver(this.aNodeService);
                        }
                        catch (MomAwarenessNotSupportedException momAwarenessNotSupportedException) {
                            Log.info(CmdInfoCompleter.class, "completeFirstToken(): Mom awareness is not supported\n");
                            return true;
                        }
                        this.searchResult.clear();
                        if (!stringTokenizer.hasMoreTokens()) {
                            this.completionOptionList = this.getMatchingMomEntityNames("");
                            this.completionOptionList.add(0, DOT);
                            this.completedString = string2;
                            return true;
                        }
                        this.orgToken = this.firstToken = stringTokenizer.nextToken();
                        if (!string2.endsWith(" ") && !stringTokenizer.hasMoreTokens()) break block16;
                        if (!this.firstToken.equals(DOT)) break block17;
                        this.entityType = "class";
                        string3 = this.firstToken = this.searcher.getClass(this.aNodeService.getWorkingMo().getType()).getName();
                        this.searchResult = this.getMatchingActionAndAttributeNames("", this.firstToken);
                        this.searchResult.add(0, ALL);
                        break block18;
                    }
                    if (!this.entityResolver.isClass(this.firstToken)) break block19;
                    this.entityType = "class";
                    string3 = this.firstToken;
                    if (!stringTokenizer.hasMoreTokens()) {
                        this.searchResult = this.getMatchingActionAndAttributeNames("", this.firstToken);
                        this.searchResult.add(0, ALL);
                    }
                    break block18;
                }
                if (this.entityResolver.isStruct(this.firstToken)) {
                    this.entityType = "struct";
                    string3 = this.firstToken;
                    if (!stringTokenizer.hasMoreTokens()) {
                        this.searchResult = this.getMatchingMemberNames("", this.firstToken);
                        this.searchResult.add(0, ALL);
                    }
                    break block18;
                } else {
                    if (!this.entityResolver.isEnum(this.firstToken)) {
                        this.completedString = string2;
                        this.completionOptionList.clear();
                        return true;
                    }
                    this.entityType = "enum";
                    string3 = this.firstToken;
                }
                break block18;
            }
            if (this.firstToken.equals(DOT)) {
                string2 = string2 + " ";
            } else if (this.firstToken.equals(ALL)) {
                this.searchResult = this.getMatchingMomEntityNames(this.firstToken);
            } else {
                this.searchResult = this.getMatchingMomEntityNames(this.firstToken);
                if (this.searchResult.size() == 1) {
                    this.completedString = string + " " + (String)this.searchResult.get(0);
                    if (!this.firstToken.equalsIgnoreCase((String)this.searchResult.get(0))) return true;
                    this.completedString = this.completedString.concat(" ");
                    return true;
                }
                if (this.searchResult.size() <= 1) return false;
                this.completedString = string + " " + CompletionHelper.getCommonStartStr(this.searchResult, string2);
                this.completionOptionList = this.searchResult;
                return true;
            }
        }
        if (stringTokenizer.hasMoreTokens()) {
            return this.completeLastToken(this.firstToken, stringTokenizer, string2, string3);
        }
        n = string2.lastIndexOf(this.orgToken);
        string4 = string2.substring(0, n);
        if (this.searchResult.size() == 1) {
            this.completedString = string4 + (String)this.searchResult.get(0) + " ";
            this.completionOptionList.clear();
            return true;
        }
        if (this.searchResult.size() > 1) {
            this.completedString = string2 + CompletionHelper.getCommonStartStr(this.searchResult, string2);
            this.completionOptionList = this.searchResult;
            return true;
        }
        if (this.searchResult.size() >= 1) return true;
        this.completedString = string2;
        this.completionOptionList = this.searchResult;
        return true;
    }

    private boolean completeLastToken(String string, StringTokenizer stringTokenizer, String string2, String string3) {
        Log.trace(CmdInfoCompleter.class, "completeLast() currToken='" + string + "', aStringToComplete ='" + string2 + "'");
        this.searchResult.clear();
        String string4 = null;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            ++n;
        }
        if (string2.endsWith(" ") && string4.equals(ALL)) {
            this.completedString = string2;
            this.completionOptionList.clear();
            return true;
        }
        if (string2.endsWith(" ")) {
            if (this.entityType.equals("class")) {
                this.searchResult = this.getMatchingActionAndAttributeNames("", string3);
                if (this.searchResult.size() < 1) {
                    this.searchResult.add(0, ALL);
                    this.searchResult.add(1, " ");
                }
            } else if (this.entityType.equals("struct")) {
                this.searchResult = this.getMatchingMemberNames("", string3);
                this.searchResult.add(0, ALL);
                this.searchResult.add(" ");
            } else if (this.entityType.equals("enum")) {
                this.completedString = string2;
            }
        } else {
            if (this.entityType.equals("class")) {
                this.searchResult = this.getMatchingActionAndAttributeNames(string4, string3);
                if (n == 1 && (string4.equals("a") || string4.equals("al"))) {
                    this.searchResult.add(0, ALL);
                }
            } else if (this.entityType.equals("struct")) {
                this.searchResult = this.getMatchingMemberNames(string4, string3);
                if (n == 1 && (string4.equals("a") || string4.equals("al"))) {
                    this.searchResult.add(0, ALL);
                }
            } else if (this.entityType.equals("emum")) {
                // empty if block
            }
            if (this.searchResult.size() < 1 && string4.equals(ALL)) {
                string2 = string2 + " ";
            }
        }
        int n2 = string2.lastIndexOf(string4);
        String string5 = string2.substring(0, n2);
        if (this.searchResult.size() == 1) {
            this.completedString = string5 + (String)this.searchResult.get(0) + " ";
            this.completionOptionList.clear();
        } else if (this.searchResult.size() > 1) {
            this.completedString = string2;
            this.completionOptionList = this.searchResult;
        } else if (this.searchResult.size() < 1) {
            this.completedString = string2;
            this.completionOptionList = this.searchResult;
        }
        return true;
    }

    private ArrayList getMatchingMomEntityNames(String string) {
        Log.trace(CmdInfoCompleter.class, "getMatchingMomEntityNames() name='" + string + "'");
        ArrayList<String> arrayList = new ArrayList<String>(0);
        if (string == null) {
            return arrayList;
        }
        Iterator iterator = this.searcher.findClasses(string);
        while (iterator.hasNext()) {
            arrayList.add(((MomClass)iterator.next()).getName());
        }
        Iterator iterator2 = this.searcher.findStructs(string);
        while (iterator2.hasNext()) {
            arrayList.add(((MomStruct)iterator2.next()).getName());
        }
        Iterator iterator3 = this.searcher.findEnums(string);
        while (iterator3.hasNext()) {
            arrayList.add(((MomEnum)iterator3.next()).getName());
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private ArrayList getMatchingActionAndAttributeNames(String string, String string2) {
        Object object;
        Log.trace(CmdInfoCompleter.class, "getMatchingActionAndAttributeNames() name='" + string + "'");
        ArrayList<Object> arrayList = new ArrayList<Object>(0);
        if (string2 == null || string2.length() == 0) {
            return arrayList;
        }
        MomClass momClass = (MomClass)this.searcher.getClass(string2);
        Iterator iterator = momClass.getAttributes();
        if (iterator != null) {
            while (iterator.hasNext()) {
                object = ((MomEntity)iterator.next()).getName();
                if (string.length() != 0 && !((String)object).toLowerCase().startsWith(string.toLowerCase())) continue;
                arrayList.add(object);
            }
        }
        if ((object = momClass.getActions()) != null) {
            while (object.hasNext()) {
                String string3 = ((MomEntity)object.next()).getName();
                if (string.length() != 0 && !string3.toLowerCase().startsWith(string.toLowerCase())) continue;
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    private ArrayList getMatchingMemberNames(String string, String string2) {
        MomStruct momStruct;
        Iterator iterator;
        Log.trace(CmdInfoCompleter.class, "getMatchingMemberNames() name='" + string + "'+ stuctName='" + string2 + "'");
        ArrayList<String> arrayList = new ArrayList<String>(0);
        if (string2 == null || string2.length() == 0) {
            return arrayList;
        }
        Iterator iterator2 = this.searcher.findStructs(string2);
        if (iterator2.hasNext() && (iterator = (momStruct = (MomStruct)iterator2.next()).getMembers()) != null) {
            while (iterator.hasNext()) {
                String string3 = ((MomEntity)iterator.next()).getName();
                if (string.length() != 0 && !string3.toLowerCase().startsWith(string.toLowerCase())) continue;
                arrayList.add(string3);
            }
        }
        return arrayList;
    }
}

