/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.completion.util;

import java.util.ArrayList;

public class WordTokenizer {
    private String myStrToTokenize = null;
    private ArrayList myWordList = new ArrayList(0);
    private int wordIndex = 0;
    private int nrOfQuotes = 0;
    private int nrOfLeftCurlys = 0;
    private int nrOfRightCurlys = 0;

    public WordTokenizer(String string) {
        this.myStrToTokenize = string;
        this.putWordsIntoList();
    }

    private void putWordsIntoList() {
        if (this.myStrToTokenize == null || this.myStrToTokenize.length() <= 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.myStrToTokenize.length(); ++i) {
            char c = this.myStrToTokenize.charAt(i);
            if (c == ' ') {
                if (stringBuffer.length() > 0 && !this.isWithinQuotes() && !this.isWithinCurlyBrackets()) {
                    this.myWordList.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                    this.nrOfRightCurlys = 0;
                    this.nrOfLeftCurlys = 0;
                    continue;
                }
                if (!this.isWithinQuotes() && !this.isWithinCurlyBrackets()) continue;
                stringBuffer.append(c);
                continue;
            }
            if (c == '\"') {
                if (this.isWithinCurlyBrackets()) {
                    stringBuffer.append(c);
                    continue;
                }
                if (this.isWithinQuotes()) {
                    stringBuffer.append(c);
                    this.nrOfQuotes = 0;
                    continue;
                }
                stringBuffer.append(c);
                ++this.nrOfQuotes;
                continue;
            }
            if (c == '{') {
                stringBuffer.append(c);
                if (this.isWithinQuotes()) continue;
                ++this.nrOfLeftCurlys;
                continue;
            }
            if (c == '}') {
                stringBuffer.append(c);
                if (this.isWithinQuotes()) continue;
                ++this.nrOfRightCurlys;
                if (this.nrOfRightCurlys < this.nrOfLeftCurlys) continue;
                this.nrOfRightCurlys = 0;
                this.nrOfLeftCurlys = 0;
                continue;
            }
            stringBuffer.append(c);
        }
        if (stringBuffer.length() > 0) {
            this.myWordList.add(stringBuffer.toString());
        }
    }

    private boolean isWithinQuotes() {
        return this.nrOfQuotes > 0;
    }

    private boolean isWithinCurlyBrackets() {
        return this.nrOfLeftCurlys > this.nrOfRightCurlys;
    }

    public String getNextWord() {
        if (this.myStrToTokenize == null || this.myStrToTokenize.length() <= 0) {
            return null;
        }
        if (this.wordIndex >= this.myWordList.size()) {
            return null;
        }
        String string = (String)this.myWordList.get(this.wordIndex);
        ++this.wordIndex;
        return string;
    }

    public boolean hasMoreWords() {
        return this.wordIndex < this.myWordList.size();
    }

    public int getNrOfWords() {
        return this.myWordList.size();
    }
}

