/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.cs.momfilter;

import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.ncli.server.cs.momfilter.MomFilteredCmService;
import se.ericsson.cello.ncli.server.cs.momfilter.MomFilteredException;
import se.ericsson.cello.ncli.server.cs.momfilter.MomFilteredMoImpl;
import se.ericsson.cello.ncli.server.cs.momfilter.MomFilteredNode;
import se.ericsson.cello.neal.cm.CmNotificationConsumer;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.CmSubscription;
import se.ericsson.cello.neal.cm.DnAttributes;
import se.ericsson.cello.neal.cm.DnNameValues;
import se.ericsson.cello.neal.cm.MibChangeInfo;
import se.ericsson.cello.neal.cm.MibInfo;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValueFactory;
import se.ericsson.cello.neal.cm.Transaction;

public class MomFilteredCmServiceImpl
implements MomFilteredCmService {
    private CmService myCmService = null;
    private MimModel myMimModel = null;
    private MomFilteredNode myNode = null;

    public MomFilteredCmServiceImpl(CmService cmService, MimModel mimModel, MomFilteredNode momFilteredNode) {
        this.myCmService = cmService;
        this.myMimModel = mimModel;
        this.myNode = momFilteredNode;
    }

    public Transaction createNullTransaction() {
        return this.myCmService.createNullTransaction();
    }

    public Transaction createTransaction() {
        return this.myCmService.createTransaction();
    }

    public Transaction createTransaction(int n) {
        return this.myCmService.createTransaction(n);
    }

    public void detachCsNotificationConsumer(CmNotificationConsumer cmNotificationConsumer) {
        this.myCmService.detachCsNotificationConsumer(cmNotificationConsumer);
    }

    public void disableNotification(CmSubscription cmSubscription, Transaction transaction) {
        this.myCmService.disableNotification(cmSubscription, transaction);
    }

    public int getGenerationCount() {
        return this.myCmService.getGenerationCount();
    }

    public MibChangeInfo[] getMibChanges(int n) {
        return this.myCmService.getMibChanges(n);
    }

    public String getMibPrefix(Transaction transaction) {
        return this.myCmService.getMibPrefix(transaction);
    }

    public String getMibType(Transaction transaction) {
        return this.myCmService.getMibInfo().mibType;
    }

    public String getMimVersion(Transaction transaction) {
        return this.myCmService.getMibInfo().mimVersion;
    }

    public Mo getMo(String string) {
        MomFilteredMoImpl momFilteredMoImpl = new MomFilteredMoImpl(this.myCmService.getMo(string), this.myNode, this.myMimModel, false);
        return momFilteredMoImpl;
    }

    public Mo[] getMoAndAttributes(DnAttributes[] dnAttributesArray, Transaction transaction) {
        this.allowedMOsAndAttributes(dnAttributesArray);
        Mo[] moArray = this.myCmService.getMoAndAttributes(dnAttributesArray, transaction);
        for (int i = 0; i < moArray.length; ++i) {
            moArray[i] = new MomFilteredMoImpl(moArray[i], this.myNode, this.myMimModel, true);
        }
        return moArray;
    }

    public DnNameValues[] getMoAttributes(DnAttributes[] dnAttributesArray, Transaction transaction) {
        this.allowedMOsAndAttributes(dnAttributesArray);
        return this.myCmService.getMoAttributes(dnAttributesArray, transaction);
    }

    public Mo[] getMoByType(String string, Transaction transaction) {
        MomClass momClass = this.myMimModel.getClass(string);
        if (momClass == null) {
            throw new MomFilteredException("The Mo Class of the following type is not defined in the MOM: " + string);
        }
        return this.myCmService.getMoByType(string, transaction);
    }

    public NameValueFactory getNameValueFactory() {
        return this.myCmService.getNameValueFactory();
    }

    public Mo getRootMo() {
        return new MomFilteredMoImpl(this.myCmService.getRootMo(), this.myNode, this.myMimModel, false);
    }

    public boolean isCacheOn() {
        return this.myCmService.isCacheOn();
    }

    public void setCacheOn(boolean bl) {
        this.myCmService.setCacheOn(bl);
    }

    public void setMibPrefix(String string, Transaction transaction) {
        this.myCmService.setMibPrefix(string, transaction);
    }

    public MibInfo getMibInfo() {
        return this.myCmService.getMibInfo();
    }

    private void allowedMOsAndAttributes(DnAttributes[] dnAttributesArray) {
        for (int i = 0; i < dnAttributesArray.length; ++i) {
            String string = dnAttributesArray[i].getDn();
            String string2 = this.myCmService.getMo(string).getType();
            MomClass momClass = this.myMimModel.getClass(string2);
            if (momClass == null) {
                throw new MomFilteredException("The Mo Class of the following LDN is not defined in the MOM: " + string);
            }
            String[] stringArray = dnAttributesArray[i].getAttributeNames();
            for (int j = 0; j < stringArray.length; ++j) {
                String string3 = stringArray[j];
                if (momClass.getAttribute(string3) != null) continue;
                throw new MomFilteredException("The attribute '" + string3 + "' is not defined in the MOM for the following LDN: " + string);
            }
        }
    }
}

