/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.services;

import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.ncli.server.configuration.Configuration;
import se.ericsson.cello.ncli.server.configuration.ConfigurationReader;
import se.ericsson.cello.ncli.server.exceptions.MemoryNotSufficientException;
import se.ericsson.cello.ncli.server.exceptions.MomAwarenessNotSupportedException;
import se.ericsson.cello.ncli.server.exceptions.ReadMomErrorException;
import se.ericsson.cello.ncli.server.services.ControllableServer;
import se.ericsson.cello.ncli.server.services.MemoryChecker;
import se.ericsson.cello.ncli.server.services.MemoryChecking;
import se.ericsson.cello.ncli.server.services.MimModelFactory;
import se.ericsson.cello.ncli.server.services.NCLIServer;
import se.ericsson.cello.ncli.server.session.CommandFileExecutor;
import se.ericsson.cello.ncli.server.session.SessionDataManager;
import se.ericsson.cello.ncli.server.session.SessionDataManagerFactory;
import se.ericsson.cello.ncli.server.session.SessionFactory;

public class NCLIServices {
    static MimModel mimModel = null;
    static ConfigurationReader config = null;

    public static ControllableServer getControllableServer() {
        return NCLIServer.getInstance();
    }

    public static void setConfiguration(ConfigurationReader configurationReader) {
        config = configurationReader;
    }

    public static ConfigurationReader getConfigurationReader() {
        if (config != null) {
            return config;
        }
        config = new Configuration();
        return config;
    }

    public static CommandFileExecutor getCommandFileExecutor() {
        return SessionFactory.createCommandFileSession();
    }

    public static MemoryChecking getMemoryChecker() {
        return MemoryChecker.getInstance();
    }

    public static synchronized MimModel getMimModel() throws MomAwarenessNotSupportedException, MemoryNotSufficientException, ReadMomErrorException {
        if (mimModel != null) {
            return mimModel;
        }
        try {
            mimModel = MimModelFactory.createMimModel(NCLIServices.getConfigurationReader(), NCLIServices.getMemoryChecker());
        }
        catch (MomAwarenessNotSupportedException momAwarenessNotSupportedException) {
            mimModel = null;
            throw momAwarenessNotSupportedException;
        }
        catch (MemoryNotSufficientException memoryNotSufficientException) {
            mimModel = null;
            throw memoryNotSufficientException;
        }
        catch (ReadMomErrorException readMomErrorException) {
            mimModel = null;
            throw readMomErrorException;
        }
        return mimModel;
    }

    public static SessionDataManager getSessionDataManager() {
        return SessionDataManagerFactory.getSessionDataManager();
    }
}

