/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.corba.interceptor;

import com.prismtech.corba.security.SSLServerCurrent;
import com.prismtech.corba.security.X509CertificateChainPrincipal;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import org.omg.CORBA.LocalObject;
import se.ericsson.security.corba.CSUPrincipal;
import se.ericsson.security.corba.Current;
import se.ericsson.security.corba.ORBInit;
import se.ericsson.security.corba.PrngAdapter;
import se.ericsson.security.corba.interceptor.TraceErrorLogger;

public class CurrentImpl
extends LocalObject
implements Current {
    private final SSLServerCurrent sslCurrent;
    private HashMap clientPrincipalMap = new HashMap();
    private HashMap clientAICMap = new HashMap();
    private HashMap serverClientMap = new HashMap();
    private static TraceErrorLogger logger = new TraceErrorLogger();
    private static final Class thisClass = class$se$ericsson$security$corba$interceptor$CurrentImpl == null ? (class$se$ericsson$security$corba$interceptor$CurrentImpl = CurrentImpl.class$("se.ericsson.security.corba.interceptor.CurrentImpl")) : class$se$ericsson$security$corba$interceptor$CurrentImpl;
    private static SecureRandom random = null;
    static /* synthetic */ Class class$se$ericsson$security$corba$interceptor$CurrentImpl;

    CurrentImpl(SSLServerCurrent sSLServerCurrent) {
        this.sslCurrent = sSLServerCurrent;
    }

    public Principal getLocalPrincipal() {
        return this.sslCurrent.getLocalPrincipal();
    }

    public Principal getConnectionPrincipal() {
        return this.sslCurrent.getClientPrincipal();
    }

    public Principal getDelegatedPrincipal() {
        Integer n = (Integer)this.serverClientMap.get(new Integer(Thread.currentThread().hashCode()));
        if (n == null) {
            n = new Integer(Thread.currentThread().hashCode());
        }
        return (Principal)this.clientPrincipalMap.get(n);
    }

    public Principal getActingPrincipal() {
        Principal principal = null;
        principal = this.getDelegatedPrincipal();
        if (principal != null) {
            return principal;
        }
        principal = this.getConnectionPrincipal();
        if (principal != null) {
            return principal;
        }
        return this.getLocalPrincipal();
    }

    public void setDelegatedPrincipal(Principal principal) {
        this.clientPrincipalMap.put(new Integer(Thread.currentThread().hashCode()), principal);
    }

    public void setAIC(String string) {
        this.clientAICMap.put(new Integer(Thread.currentThread().hashCode()), string);
    }

    public void unsetAIC() {
        this.clientAICMap.remove(new Integer(Thread.currentThread().hashCode()));
    }

    public String getAIC() {
        return (String)this.clientAICMap.get(new Integer(Thread.currentThread().hashCode()));
    }

    public void addServerClientMapping(Integer n) {
        this.serverClientMap.put(new Integer(Thread.currentThread().hashCode()), n);
    }

    public void removeServerClientMapping() {
        this.serverClientMap.remove(new Integer(Thread.currentThread().hashCode()));
    }

    public void unsetDelegatedPrincipal() {
        this.clientPrincipalMap.remove(new Integer(Thread.currentThread().hashCode()));
    }

    public String getUniqueID(Principal principal) {
        String string = null;
        if (principal instanceof X509CertificateChainPrincipal) {
            X509CertificateChainPrincipal x509CertificateChainPrincipal = (X509CertificateChainPrincipal)principal;
            X509Certificate[] x509CertificateArray = x509CertificateChainPrincipal.getCertificateChain();
            if (x509CertificateArray != null && x509CertificateArray.length > 0 && x509CertificateArray[0] != null) {
                string = CurrentImpl.getUniqueID(x509CertificateArray[0]);
            }
        } else {
            if (principal instanceof CSUPrincipal) {
                CSUPrincipal cSUPrincipal = (CSUPrincipal)principal;
                return cSUPrincipal.getSubjectUniqueID();
            }
            logger.trace(1, this.getClass(), "Current.getUniqueID() Unknown principal format: " + principal.getClass().getName());
        }
        return string;
    }

    private static String getUniqueID(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return null;
        }
        String string = null;
        boolean[] blArray = x509Certificate.getSubjectUniqueID();
        if (blArray != null) {
            byte[] byArray = new byte[blArray.length / 8];
            for (int i = 0; i < blArray.length; ++i) {
                int n = i / 8;
                byArray[n] = (byte)(byArray[n] << 1);
                if (!blArray[i]) continue;
                int n2 = i / 8;
                byArray[n2] = (byte)(byArray[n2] + 1);
            }
            try {
                string = new String(byArray, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.traceError(thisClass, "Couldn't fetch certificate UniqueID", unsupportedEncodingException);
            }
        }
        return string;
    }

    public boolean isLocal() {
        Principal principal = this.getActingPrincipal();
        return principal != null && ((Object)principal).equals(this.getLocalPrincipal());
    }

    public static SecureRandom getSecureRandom() {
        if (random == null) {
            random = new SecureRandom();
            random.setSeed(System.currentTimeMillis());
            if (ORBInit.isServer()) {
                try {
                    random.setSeed(new PrngAdapter().getRandomBytes());
                }
                catch (IOException iOException) {
                    logger.info(class$se$ericsson$security$corba$interceptor$CurrentImpl == null ? (class$se$ericsson$security$corba$interceptor$CurrentImpl = CurrentImpl.class$("se.ericsson.security.corba.interceptor.CurrentImpl")) : class$se$ericsson$security$corba$interceptor$CurrentImpl, "Could not use PRNGD, setting seed from system time");
                    random.setSeed(System.currentTimeMillis());
                }
            }
        }
        logger.trace(1, class$se$ericsson$security$corba$interceptor$CurrentImpl == null ? (class$se$ericsson$security$corba$interceptor$CurrentImpl = CurrentImpl.class$("se.ericsson.security.corba.interceptor.CurrentImpl")) : class$se$ericsson$security$corba$interceptor$CurrentImpl, "getSecureRandom");
        return random;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

