/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.corba.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jacorb.orb.factory.AbstractSocketFactory;
import se.ericsson.security.corba.interceptor.TraceErrorLogger;

public class CSUSocketFactory
extends AbstractSocketFactory {
    protected static TraceErrorLogger logger = new TraceErrorLogger();

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return new Socket(string, n);
    }

    protected Socket doCreateSocket(String string, int n, int n2) throws IOException, UnknownHostException {
        Socket socket = new Socket();
        logger.trace(1, ((Object)((Object)this)).getClass(), "Opening socket towards: " + string + " on port " + n + " with timeout: " + n2);
        try {
            socket.bind(new InetSocketAddress("::", 0));
        }
        catch (IOException iOException) {
            logger.trace(1, ((Object)((Object)this)).getClass(), "Could not bind socket to " + iOException.getMessage());
            throw iOException;
        }
        try {
            socket.connect(new InetSocketAddress(string, n), n2);
        }
        catch (IOException iOException) {
            logger.trace(1, ((Object)((Object)this)).getClass(), "Could not connect! socket is bound to: " + socket.getLocalAddress() + " and port " + socket.getLocalPort());
            throw iOException;
        }
        logger.trace(1, ((Object)((Object)this)).getClass(), "After connect socket was bound to: " + socket.getLocalAddress() + " port " + socket.getLocalPort());
        return socket;
    }

    public boolean isSSL(Socket socket) {
        return false;
    }
}

