/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.control;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EnumMap;
import java.util.concurrent.CountDownLatch;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JRadioButton;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.provider.ExportConfigDataProvider;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.control.PrepareConvertMigrationPerformer;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.control.ReportController;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.util.MigrateRbsUtil;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.view.MigrateRbsView;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.impl.ProgressReporterExtended;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.RbsFactory;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.BemXmlException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterRadioButtonGroup;
import se.ericsson.wcdma.rbs.bem.common.gui.ProgressMonitor;
import se.ericsson.wcdma.rbs.bem.common.gui.app.AbstractBemLaunchable;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemCheckBoxSingle;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemStringField;
import se.ericsson.wcdma.rbs.bem.common.mim.MimLicensing;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSystemFunctions;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNodeConnectionListener;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.wizard.util.BemFileFilter;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLaunchChecker;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.precontrol.HandlePlugAndPlayPreController;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationView;

public class MigrateRbsController
extends AbstractApplicationController
implements ProgressReporterExtended {
    public static final String SITE_COMPLETE_CONFIGURATION_FILE = "node_specific.mo";
    public static final EnumMap<ExportConfigDataProvider.TYPE_OF_CONFIG, String> exportedFileNameMap = new EnumMap(ExportConfigDataProvider.TYPE_OF_CONFIG.class);
    public static final EnumMap<ExportConfigDataProvider.TYPE_OF_CONFIG, String> xsltFileNameMap = new EnumMap(ExportConfigDataProvider.TYPE_OF_CONFIG.class);
    public static final EnumMap<ExportConfigDataProvider.TYPE_OF_CONFIG, String> outputFileNameMap = new EnumMap(ExportConfigDataProvider.TYPE_OF_CONFIG.class);
    private static final String USER_HOME_DIRECTORY;
    private static final String CONFIG_ZIP_FILE_NAME;
    public static final String ERROR_ZIP_FILE_NAME;
    private static final String CONFIG_ZIP_FILE_PATH = "C:\\Ericsson\\DUWmigration\\";
    private static final String ROLLBACK_RESTART_INFORMATION = "MigrateRbs configuration: rollback to previous configuration";
    public static final String CABINET_RESTART_INFORMATION = "MigrateRbs configuration: Node restarted at Cabinet configuration";
    public static final String FINAL_RESTART_INFORMATION = "MigrateRbs configuration: Node restarted at the end of configuration";
    private static final String CONFIGURATION_SUCCESSFUL_INFO = "The RBS is successfully configured! \n\nThe new licensing fingerprint for this node is ";
    private static final String ORDER_LICENSES_MSG = "\n\nNew licenses have to be ordered and installed!\n\nThe RBS system can only execute without a valid License Key File for 21 days.\n";
    private static final String CONFIGURATION_REPORT = "\n\nConfiguration Report:\n";
    private static final String ADDITIONAL_INFO = "Additional information: ";
    public static final String INPUT_FILE = "Input file: ";
    public static final String LINE_NUMBER = "Line number: ";
    public static final String MESSAGE = "Message: ";
    private static final String GPB_ERROR_MESSAGE = "A GPB based RBS is not possible to migrate to DUW";
    private static final String BOARDS_LOCKED_MESSAGE = "When the boards in the baseband subrack are locked,\nit will not be possible to use the RBS for traffic anymore.\n\nDo you want to lock the boards?";
    private static final String BOARDS_NOT_LOCKED_MESSAGE = "The boards in the baseband subrack are not locked.\n\nRemember to lock the boards before the HW is replaced.";
    private static final String ROLLBACK_MESSAGE = "\n The RBS is in an undefined state. It is needed to perform a rollback.\n The rollback requires that the RBS is restarted.\n\n Do you want to perform the rollback?";
    private static final String CONFIGURATION_FAILED_MESSAGE = "Error: Configuration Failed.\n";
    private static final String PERFORM_CONFIGURE_MESSAGE = "The RBS will be configured according to the configuration files\n\nDo you want to configure the RBS?";
    public static final String MIGRATION_CANCELLED = "Migrate RBS was canceled.";
    public static final String CONFIGURATION_NOT_STORED_MESSAGE = "No configuration file will be stored.\n";
    public static final String CONFIGURATION_NOT_EXPORTED_MESSAGE = "Error: Not possible to export the configuration from the RBS.\n";
    public static final String ERROR_CONVERTING_TO_DUW_MESSAGE = "Error: The configuration files can not be converted to DUW.\n";
    public static final String ERROR_XML_PARSING_MESSAGE_PROBABLE_CAUSE = "Error: XML Parsing Error\nProbable cause: Faulty input file\nAdditional information: ";
    private AbstractApplication application;
    private MigrateRbsView view;
    private Rbs rbs = null;
    private ProgressMonitor pm = null;
    private MigrateRbsUtil migrateRbsUtil = null;
    private String mpType = null;
    private Thread myMigrationPerformerThread = null;
    private boolean exceptionCaught = false;
    private String zipFileName = CONFIG_ZIP_FILE_NAME;
    private AbstractApplicationView.WhatNextButtonPanel wnButtonPanel;
    private BemStringField filePathStringFieldPrepareConvert;
    private JButton browseButtonPrepareConvert;
    private BemCheckBoxSingle lockAllBoardsCheckBox;
    private boolean lockAllBoardsCheckBoxValue = false;
    private JButton applyButton;
    private CustomerParameterRadioButtonGroup obtainEthernetPort;
    private String gigaBitEthernetPort;
    private BemStringField filePathStringFieldConfigure;
    private JButton browseButtonConfigure;
    private JButton fetchButton;
    private JButton startConfigurationButton;

    protected void beforeVisible() {
        boolean bl = WizardLaunchChecker.wizardStarted();
        if (!bl) {
            this.getApplication().stopApplicationNoCheck();
        }
    }

    public void init() {
        this.application = this.getApplication();
        this.view = (MigrateRbsView)this.getView();
        AbstractBemLaunchable abstractBemLaunchable = (AbstractBemLaunchable)this.application.getBemLaunchable();
        this.setProgress(abstractBemLaunchable, "Migrate RBS to DUW", 2, 2);
        try {
            this.migrateRbsUtil = new MigrateRbsUtil(this);
            this.migrateRbsUtil.setMigrateRbsController(this);
            this.mpType = RbsFactory.getMpType();
            if (this.mpType.compareTo("CBU") == 0) {
                this.setProgress(abstractBemLaunchable, "Migrate RBS to DUW : openMigrateRbsCIs", 3, 5);
                this.migrateRbsUtil.openMigrateRbsCIs(false);
                this.setProgress(abstractBemLaunchable, "Migrate RBS to DUW : getRbs", 4, 5);
                this.rbs = this.migrateRbsUtil.getRbs();
                boolean bl = this.migrateRbsUtil.checkPreconditionsOK(true);
                if (bl) {
                    this.view.setPrepareAndConvertPanel();
                    this.filePathStringFieldPrepareConvert = this.view.getFilePathStringFieldPrepareConvert();
                    this.filePathStringFieldPrepareConvert.setValue(CONFIG_ZIP_FILE_NAME);
                    this.browseButtonPrepareConvert = this.view.getBrowseButtonPrepareConvert();
                    this.browseButtonPrepareConvert.addActionListener(new BrowseButtonListener(CONFIG_ZIP_FILE_PATH));
                    this.lockAllBoardsCheckBox = this.view.getLockAllBoardsCheckBox();
                    this.applyButton = this.view.getApplyButton();
                    this.applyButton.addActionListener(new ApplyButtonListener(this));
                    this.view.setConfigurePanel(this.createTempGigabitEthernetPortCP());
                    this.filePathStringFieldConfigure = this.view.getFilePathStringFieldConfigure();
                    this.filePathStringFieldConfigure.setEnabled(false);
                    this.browseButtonConfigure = this.view.getBrowseButtonConfigure();
                    this.browseButtonConfigure.setEnabled(false);
                    this.fetchButton = this.view.getFetchButton();
                    this.fetchButton.setEnabled(false);
                    this.obtainEthernetPort = this.view.getObtainEthernetPort();
                    this.obtainEthernetPort.getComponent(1).setEnabled(false);
                    this.obtainEthernetPort.getComponent(2).setEnabled(false);
                    this.startConfigurationButton = this.view.getStartConfigurationButton();
                    this.startConfigurationButton.setEnabled(false);
                    this.view.setMigrateRbsToDuwMainPanel();
                    this.wnButtonPanel = this.view.getWnButtonPanel();
                    new AbstractApplicationController.WhatNextButtonListener(this.wnButtonPanel){

                        protected void onCancelButton() {
                            MigrateRbsController.this.onCancel();
                        }

                        protected void onHelpButton() {
                        }

                        protected void onNextButton() {
                            MigrateRbsController.this.onClose();
                        }
                    };
                    this.wnButtonPanel.nextButton.setEnabled(false);
                } else {
                    this.stopWizard();
                }
            } else if (this.mpType.compareTo("DUW") == 0) {
                this.setProgress(abstractBemLaunchable, "Migrate RBS to DUW : openMigrateRbsCIs", 3, 5);
                this.migrateRbsUtil.openMigrateRbsCIs(false);
                this.setProgress(abstractBemLaunchable, "Migrate RBS to DUW : getRbs", 4, 5);
                this.rbs = this.migrateRbsUtil.getRbs();
                this.view.setPrepareAndConvertPanel();
                this.filePathStringFieldPrepareConvert = this.view.getFilePathStringFieldPrepareConvert();
                this.filePathStringFieldPrepareConvert.setEnabled(false);
                this.browseButtonPrepareConvert = this.view.getBrowseButtonPrepareConvert();
                this.browseButtonPrepareConvert.setEnabled(false);
                this.lockAllBoardsCheckBox = this.view.getLockAllBoardsCheckBox();
                this.lockAllBoardsCheckBox.setEnabled(false);
                this.applyButton = this.view.getApplyButton();
                this.applyButton.setEnabled(false);
                CustomerParameter customerParameter = null;
                customerParameter = this.rbs.getCustomerParameterObject("gigaBitEthernetPort");
                this.view.setConfigurePanel(customerParameter);
                this.filePathStringFieldConfigure = this.view.getFilePathStringFieldConfigure();
                this.filePathStringFieldConfigure.setValue(CONFIG_ZIP_FILE_NAME);
                this.browseButtonConfigure = this.view.getBrowseButtonConfigure();
                this.browseButtonConfigure.addActionListener(new BrowseButtonListener(CONFIG_ZIP_FILE_PATH));
                this.fetchButton = this.view.getFetchButton();
                this.fetchButton.addActionListener(new FetchButtonListener(this));
                this.obtainEthernetPort = this.view.getObtainEthernetPort();
                this.obtainEthernetPort.getComponent(1).setEnabled(false);
                this.obtainEthernetPort.getComponent(2).setEnabled(false);
                this.startConfigurationButton = this.view.getStartConfigurationButton();
                this.startConfigurationButton.addActionListener(new StartConfigurationButtonListener(this));
                this.startConfigurationButton.setEnabled(false);
                this.view.setMigrateRbsToDuwMainPanel();
                this.wnButtonPanel = this.view.getWnButtonPanel();
                new AbstractApplicationController.WhatNextButtonListener(this.wnButtonPanel){

                    protected void onCancelButton() {
                        MigrateRbsController.this.onCancel();
                    }

                    protected void onHelpButton() {
                    }

                    protected void onNextButton() {
                        MigrateRbsController.this.onClose();
                    }
                };
                this.wnButtonPanel.nextButton.setEnabled(false);
            } else {
                Exception exception = new Exception(GPB_ERROR_MESSAGE);
                this.reportException(exception, "");
                this.stopWizard();
            }
            this.setProgress(abstractBemLaunchable, "Migrate RBS to DUW : DONE", 5, 5);
        }
        catch (Exception exception) {
            this.reportException(exception, "");
            this.stopWizard();
        }
    }

    private void setProgress(AbstractBemLaunchable abstractBemLaunchable, String string, int n, int n2) {
        if (abstractBemLaunchable == null || abstractBemLaunchable.getProgressListener() == null) {
            return;
        }
        abstractBemLaunchable.getProgressListener().setProgress(string, n, n2);
    }

    public void reportProgress(int n, String string) {
        if (this.pm != null) {
            this.pm.reportProgress(n, string);
        }
    }

    public void reportTotalProgress(int n, String string) {
        if (this.pm != null) {
            this.pm.reportTotalProgress(n, string);
        }
    }

    private Enumeration createTempGigabitEthernetPortCP() throws BemException {
        Enumeration enumeration = null;
        try {
            EnumeratedRange enumeratedRange = new EnumeratedRange(new String[]{"TNA", "TNB"});
            enumeration = new Enumeration("AI_gigabitEthernetPort", enumeratedRange);
            enumeration.setDefaultValue("TNA");
        }
        catch (Exception exception) {
            throw new BemException("createTempGigabitEthernetPortCP()", (Throwable)exception);
        }
        return enumeration;
    }

    public void checkIfCanceled() throws InterruptedException {
        if (this.isCancelled) {
            Nal.getLog().nalTrace(4, this.getClass(), "Migrate RBS was canceled. About to interrupt thread " + Thread.currentThread().getName() + "!");
            throw new InterruptedException(MIGRATION_CANCELLED);
        }
    }

    public void onCancel() {
        this.isCancelled = true;
        if (this.myMigrationPerformerThread != null && this.myMigrationPerformerThread.isAlive()) {
            WizardLaunchChecker.wizardStopped();
            this.myMigrationPerformerThread.interrupt();
        } else {
            this.stopWizard();
        }
    }

    protected void viewClosing() {
        this.onCancel();
    }

    private void onClose() {
        if (this.mpType.compareTo("CBU") == 0) {
            if (!this.lockAllBoardsCheckBoxValue) {
                boolean bl = MigrateRbsUtil.displayWarningDialog(BOARDS_NOT_LOCKED_MESSAGE, "Warning");
                if (bl) {
                    this.stopWizard();
                }
            } else {
                this.stopWizard();
            }
        } else {
            this.stopWizard();
        }
    }

    private void stopWizard() {
        WizardLaunchChecker.wizardStopped();
        this.application.stopApplicationNoCheck();
    }

    public void reportException(Exception exception, String string) {
        ExceptionProperties exceptionProperties = ExceptionProperties.getProperties(exception);
        exceptionProperties.prependProperty("Problem", string, " - ");
        this.getEasyPopUp().displayError(exception);
    }

    private void setIntegrationUnlockState() throws MoHandlerException, BemException {
        MoHandler moHandler = this.migrateRbsUtil.getMoHandler();
        try {
            BemMo bemMo = this.getLicensingMo(moHandler);
            NalNameValue[] nalNameValueArray = new NalNameValue[]{};
            if (!moHandler.isExisting(bemMo)) {
                moHandler.create(bemMo);
            }
            moHandler.action(bemMo, "setIntegrationUnlockState", nalNameValueArray);
        }
        catch (MoHandlerException moHandlerException) {
            throw moHandlerException;
        }
        catch (BemException bemException) {
            throw bemException;
        }
    }

    private BemMo getLicensingMo(MoHandler moHandler) throws BemException {
        MoInstance moInstance = this.rbs.getRootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimSystemFunctions.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi2 = new SingleChildMoi(singleChildMoi, MimLicensing.MOTYPENAME, "1");
        BemMo bemMo = moHandler.getMo(singleChildMoi2.getLdn());
        return bemMo;
    }

    public void createConfigureMigrationPerformerThread() {
        ConfigureMigrationPerformer configureMigrationPerformer = new ConfigureMigrationPerformer(this);
        this.myMigrationPerformerThread = new Thread((Runnable)configureMigrationPerformer, "myMigrationPerformerThread");
        this.myMigrationPerformerThread.start();
    }

    public MigrateRbsView getMigrateRbsView() {
        return this.view;
    }

    public void setCancelled(boolean bl) {
        this.isCancelled = bl;
        if (bl) {
            this.pm.close();
            this.pm = null;
        }
    }

    public MigrateRbsUtil getMigrateRbsUtil() {
        return this.migrateRbsUtil;
    }

    public BemStringField getFilePathStringFieldPrepareConvert() {
        return this.filePathStringFieldPrepareConvert;
    }

    public JButton getBrowseButtonPrepareConvert() {
        return this.browseButtonPrepareConvert;
    }

    public BemCheckBoxSingle getLockAllBoardsCheckBox() {
        return this.lockAllBoardsCheckBox;
    }

    public JButton getApplyButton() {
        return this.applyButton;
    }

    public AbstractApplicationView.WhatNextButtonPanel getWnButtonPanel() {
        return this.wnButtonPanel;
    }

    public boolean isLockAllBoardsCheckBoxValue() {
        return this.lockAllBoardsCheckBoxValue;
    }

    public boolean isExceptionCaught() {
        return this.exceptionCaught;
    }

    public void setExceptionCaught(boolean bl) {
        this.exceptionCaught = bl;
    }

    public void setMyMigrationPerformerThread(Thread thread) {
        this.myMigrationPerformerThread = thread;
    }

    public Rbs getRbs() {
        return this.rbs;
    }

    public String getZipFileName() {
        return this.zipFileName;
    }

    public ProgressMonitor getPm() {
        return this.pm;
    }

    public void setPm(ProgressMonitor progressMonitor) {
        this.pm = progressMonitor;
    }

    public String getGigaBitEthernetPort() {
        return this.gigaBitEthernetPort;
    }

    public void setGigaBitEthernetPort(String string) {
        this.gigaBitEthernetPort = string;
    }

    public void viewReport(String string) throws BemException {
        new ReportController(this.view, this.rbs, this, string);
    }

    static {
        exportedFileNameMap.put(ExportConfigDataProvider.TYPE_OF_CONFIG.CABINET, "cabinet.xml");
        exportedFileNameMap.put(ExportConfigDataProvider.TYPE_OF_CONFIG.SITE, "site.xml");
        exportedFileNameMap.put(ExportConfigDataProvider.TYPE_OF_CONFIG.OAM, "oam.xml");
        xsltFileNameMap.put(ExportConfigDataProvider.TYPE_OF_CONFIG.CABINET, "conversionRulesCabinetEq.xsl");
        xsltFileNameMap.put(ExportConfigDataProvider.TYPE_OF_CONFIG.SITE, "conversionRulesSiteEq.xsl");
        xsltFileNameMap.put(ExportConfigDataProvider.TYPE_OF_CONFIG.OAM, "conversionRulesOam.xsl");
        outputFileNameMap.put(ExportConfigDataProvider.TYPE_OF_CONFIG.CABINET, "duwCabinet.xml");
        outputFileNameMap.put(ExportConfigDataProvider.TYPE_OF_CONFIG.SITE, "duwSite.xml");
        outputFileNameMap.put(ExportConfigDataProvider.TYPE_OF_CONFIG.OAM, "duwOam.xml");
        USER_HOME_DIRECTORY = System.getProperties().getProperty("user.home");
        CONFIG_ZIP_FILE_NAME = System.getProperties().getProperty("os.name").indexOf("Windows") > -1 ? USER_HOME_DIRECTORY + "\\Ericsson\\DUWmigration\\configfile.zip" : USER_HOME_DIRECTORY + "/Ericsson/DUWmigration/configfile.zip";
        ERROR_ZIP_FILE_NAME = System.getProperties().getProperty("os.name").indexOf("Windows") > -1 ? USER_HOME_DIRECTORY + "\\Ericsson\\DUWmigration\\configFile_error.zip" : USER_HOME_DIRECTORY + "/Ericsson/DUWmigration/configFile_error.zip";
    }

    class StartConfigurationButtonListener
    implements ActionListener {
        private MigrateRbsController migrateRbsController;

        public StartConfigurationButtonListener(MigrateRbsController migrateRbsController2) {
            this.migrateRbsController = migrateRbsController2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.migrateRbsController.zipFileName = this.migrateRbsController.filePathStringFieldConfigure.getValue();
            this.migrateRbsController.gigaBitEthernetPort = this.migrateRbsController.obtainEthernetPort.getCustomerParameter().getValue();
            this.migrateRbsController.migrateRbsUtil;
            boolean bl = MigrateRbsUtil.displayQuestionlDialog(MigrateRbsController.PERFORM_CONFIGURE_MESSAGE, "Confirm");
            if (bl) {
                MigrateRbsController.this.createConfigureMigrationPerformerThread();
            }
        }
    }

    class FetchButtonListener
    implements ActionListener {
        private MigrateRbsController migrateRbsController;

        public FetchButtonListener(MigrateRbsController migrateRbsController2) {
            this.migrateRbsController = migrateRbsController2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.migrateRbsController.zipFileName = this.migrateRbsController.filePathStringFieldConfigure.getValue();
            try {
                boolean bl = this.migrateRbsController.migrateRbsUtil.isGigabitEthernetPortPresent(this.migrateRbsController.zipFileName, outputFileNameMap.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.OAM));
                if (bl) {
                    this.migrateRbsController.migrateRbsUtil.setTransportOption("ipV4");
                    JRadioButton jRadioButton = (JRadioButton)this.migrateRbsController.obtainEthernetPort.getComponent(1);
                    JRadioButton jRadioButton2 = (JRadioButton)this.migrateRbsController.obtainEthernetPort.getComponent(2);
                    jRadioButton.setSelected(true);
                    jRadioButton.setEnabled(true);
                    jRadioButton2.setEnabled(true);
                }
                this.migrateRbsController.filePathStringFieldConfigure.setEnabled(false);
                this.migrateRbsController.browseButtonConfigure.setEnabled(false);
                this.migrateRbsController.fetchButton.setEnabled(false);
                this.migrateRbsController.startConfigurationButton.setEnabled(true);
            }
            catch (Exception exception) {
                MigrateRbsController.this.reportException(exception, "");
            }
        }
    }

    class ApplyButtonListener
    implements ActionListener {
        private MigrateRbsController migrateRbsController;

        public ApplyButtonListener(MigrateRbsController migrateRbsController2) {
            this.migrateRbsController = migrateRbsController2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.migrateRbsController.lockAllBoardsCheckBoxValue = this.migrateRbsController.lockAllBoardsCheckBox.getValue(null);
                this.migrateRbsController.setCancelled(false);
                this.migrateRbsController.filePathStringFieldPrepareConvert.setEnabled(false);
                this.migrateRbsController.browseButtonPrepareConvert.setEnabled(false);
                this.migrateRbsController.lockAllBoardsCheckBox.setEnabled(false);
                this.migrateRbsController.applyButton.setEnabled(false);
                ((MigrateRbsController)this.migrateRbsController).wnButtonPanel.cancelButton.setEnabled(false);
                if (this.migrateRbsController.lockAllBoardsCheckBoxValue) {
                    this.migrateRbsController.migrateRbsUtil;
                    boolean bl = MigrateRbsUtil.displayQuestionlDialog(MigrateRbsController.BOARDS_LOCKED_MESSAGE, "Confirm");
                    if (bl) {
                        this.performPrepareAndConvert();
                    } else {
                        this.migrateRbsController.filePathStringFieldPrepareConvert.setEnabled(true);
                        this.migrateRbsController.browseButtonPrepareConvert.setEnabled(true);
                        this.migrateRbsController.lockAllBoardsCheckBox.setEnabled(true);
                        this.migrateRbsController.applyButton.setEnabled(true);
                        ((MigrateRbsController)this.migrateRbsController).wnButtonPanel.cancelButton.setEnabled(true);
                    }
                } else {
                    this.performPrepareAndConvert();
                }
            }
            catch (Exception exception) {
                MigrateRbsController.this.reportException(exception, "");
                MigrateRbsController.this.stopWizard();
            }
        }

        private void performPrepareAndConvert() throws BemException {
            MigrateRbsController.this.zipFileName = MigrateRbsController.this.filePathStringFieldPrepareConvert.getValue();
            PrepareConvertMigrationPerformer prepareConvertMigrationPerformer = new PrepareConvertMigrationPerformer(this.migrateRbsController.migrateRbsUtil, null, MigrateRbsController.this.zipFileName);
            MigrateRbsController.this.myMigrationPerformerThread = new Thread((Runnable)prepareConvertMigrationPerformer, "myMigrationPerformerThread");
            MigrateRbsController.this.myMigrationPerformerThread.start();
        }
    }

    class BrowseButtonListener
    implements ActionListener {
        private String filePath = null;

        public BrowseButtonListener(String string) {
            this.filePath = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(this.filePath);
            jFileChooser.setBackground(Color.white);
            BemFileFilter bemFileFilter = new BemFileFilter("zip", "ZIP files");
            jFileChooser.setFileFilter(bemFileFilter);
            jFileChooser.setDialogTitle("Open Configuration zip File");
            int n = jFileChooser.showOpenDialog(MigrateRbsController.this.view);
            if (n == 0) {
                MigrateRbsController.this.zipFileName = jFileChooser.getSelectedFile().getAbsolutePath();
                if (MigrateRbsController.this.mpType.compareTo("CBU") == 0) {
                    MigrateRbsController.this.filePathStringFieldPrepareConvert.setValue(MigrateRbsController.this.zipFileName);
                } else {
                    MigrateRbsController.this.filePathStringFieldConfigure.setValue(MigrateRbsController.this.zipFileName);
                }
            }
        }
    }

    static class PlugAndPlayInstallerListener
    implements Installer {
        private String currentProgressDescription = "Not started";
        private int progressCounter = 0;
        private MigrateRbsController migrateRbsController;

        public PlugAndPlayInstallerListener(MigrateRbsController migrateRbsController) {
            this.migrateRbsController = migrateRbsController;
        }

        public void stopExecution() {
        }

        public void reportProgress(String string, String string2, int n) {
            if (this.migrateRbsController.pm != null) {
                this.migrateRbsController.pm.reportProgress(n, string2);
            }
            this.progressCounter += n;
            this.currentProgressDescription = string2;
        }

        public void reportProgress(String string, String string2) {
            if (this.migrateRbsController.pm != null) {
                this.progressCounter += 15;
                this.migrateRbsController.pm.reportProgress(this.progressCounter, string2);
            }
            this.currentProgressDescription = string2;
        }

        public String getReportedProgress() {
            return this.currentProgressDescription;
        }

        public void reportComplete() {
        }

        public boolean isInterrupted() {
            return false;
        }

        public void extendInstallReport(StringBuffer stringBuffer) {
        }
    }

    class ConfigureMigrationPerformer
    implements Runnable,
    NalNodeConnectionListener {
        private MigrateRbsController migrateRbsController;
        private String failureCauseConfigure = null;
        private final CountDownLatch myNodeConnLostSignal = new CountDownLatch(1);
        private final CountDownLatch myNodeConnRestoredSignal = new CountDownLatch(1);

        public ConfigureMigrationPerformer(MigrateRbsController migrateRbsController2) {
            this.migrateRbsController = migrateRbsController2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.migrateRbsController.isCancelled = false;
                this.migrateRbsController.startConfigurationButton.setEnabled(false);
                this.migrateRbsController.obtainEthernetPort.getComponent(1).setEnabled(false);
                this.migrateRbsController.obtainEthernetPort.getComponent(2).setEnabled(false);
                ((MigrateRbsController)this.migrateRbsController).wnButtonPanel.cancelButton.setEnabled(false);
                MigrateRbsController.this.pm = new ProgressMonitor(MigrateRbsController.this.view, this.migrateRbsController, "Progress Migrate RBS", 0, 100);
                MigrateRbsController.this.pm.setWidth(600);
                MigrateRbsController.this.pm.reportTotalProgress(0, "Handle plug and play");
                Nal.getLog().nalTrace(4, this.getClass(), " Handle Plug and Play. ");
                this.failureCauseConfigure = "Plug and play handling";
                PlugAndPlayInstallerListener plugAndPlayInstallerListener = new PlugAndPlayInstallerListener(this.migrateRbsController);
                HandlePlugAndPlayPreController handlePlugAndPlayPreController = new HandlePlugAndPlayPreController(plugAndPlayInstallerListener);
                handlePlugAndPlayPreController.install();
                this.migrateRbsController.checkIfCanceled();
                MigrateRbsController.this.pm.reportTotalProgress(10, "Plug and play installed");
                this.migrateRbsController.migrateRbsUtil.checkDuwPreconditionsOK(this.migrateRbsController.zipFileName, exportedFileNameMap.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.CABINET));
                this.failureCauseConfigure = "Cabinet configuration";
                this.migrateRbsController.migrateRbsUtil.performCabinetConfiguration(this.migrateRbsController.zipFileName, outputFileNameMap.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.CABINET));
                this.migrateRbsController.checkIfCanceled();
                MigrateRbsController.this.pm.reportTotalProgress(25, "Configure cabinet done");
                Nal.getFactory().addConnectionListener(this);
                this.migrateRbsController.migrateRbsUtil.restartNode(0, MigrateRbsController.CABINET_RESTART_INFORMATION);
                MigrateRbsController.this.pm.reportTotalProgress(40, "Waiting for the RBS to restart");
                this.myNodeConnLostSignal.await();
                MigrateRbsController.this.pm.reportTotalProgress(45, "Waiting for the RBS to restore connection");
                this.myNodeConnRestoredSignal.await();
                Nal.getFactory().removeConnectionListener(this);
                this.failureCauseConfigure = "Site configuration";
                this.migrateRbsController.migrateRbsUtil.performSiteConfiguration(this.migrateRbsController.zipFileName, outputFileNameMap.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.SITE));
                this.migrateRbsController.checkIfCanceled();
                MigrateRbsController.this.pm.reportTotalProgress(50, "Configure site done");
                this.failureCauseConfigure = "Oam configuration";
                this.migrateRbsController.migrateRbsUtil.performOamConfiguration(this.migrateRbsController.zipFileName, outputFileNameMap.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.SITE), outputFileNameMap.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.OAM));
                this.migrateRbsController.checkIfCanceled();
                MigrateRbsController.this.pm.reportTotalProgress(75, "Configure oam done");
                this.failureCauseConfigure = "Setting temporary licenses";
                this.migrateRbsController.setIntegrationUnlockState();
                this.failureCauseConfigure = "Site complete scripts";
                this.migrateRbsController.migrateRbsUtil.performSiteCompleteConfiguration(this.migrateRbsController.zipFileName, MigrateRbsController.SITE_COMPLETE_CONFIGURATION_FILE);
                this.migrateRbsController.checkIfCanceled();
                MigrateRbsController.this.pm.reportTotalProgress(95, "Site complete done");
                this.failureCauseConfigure = "Saving final cv and restarting node";
                this.migrateRbsController.migrateRbsUtil.createFinalCV();
                this.migrateRbsController.migrateRbsUtil.restartNode(0, MigrateRbsController.FINAL_RESTART_INFORMATION);
                this.migrateRbsController.checkIfCanceled();
                MigrateRbsController.this.pm.reportTotalProgress(100, "Ready");
                MigrateRbsController.this.pm.close();
                MoHandler moHandler = this.migrateRbsController.migrateRbsUtil.getMoHandler();
                BemMo bemMo = MigrateRbsController.this.getLicensingMo(moHandler);
                String string = (String)moHandler.getAttribute(bemMo, "fingerprint");
                String string2 = MigrateRbsController.CONFIGURATION_SUCCESSFUL_INFO + string + MigrateRbsController.ORDER_LICENSES_MSG + MigrateRbsController.CONFIGURATION_REPORT + this.migrateRbsController.migrateRbsUtil.getConfigReport();
                this.migrateRbsController.viewReport(string2);
            }
            catch (BemXmlException bemXmlException) {
                this.handleException(bemXmlException, true);
            }
            catch (Exception exception) {
                this.handleException(exception, false);
            }
            finally {
                if (!MigrateRbsController.this.exceptionCaught) {
                    MigrateRbsController.this.pm = null;
                }
                ((MigrateRbsController)this.migrateRbsController).wnButtonPanel.nextButton.setEnabled(true);
                MigrateRbsController.this.myMigrationPerformerThread = null;
            }
        }

        private void handleException(Exception exception, boolean bl) {
            MigrateRbsController.this.exceptionCaught = true;
            boolean bl2 = false;
            if (this.migrateRbsController.isCancelled) {
                Nal.getFactory().getLog().nalTrace(4, this.getClass(), "Migrate RBS was canceled by user, caught as an Exception:", exception);
                this.migrateRbsController.migrateRbsUtil;
                this.migrateRbsController.migrateRbsUtil;
                bl2 = MigrateRbsUtil.displayWarningDialog(MigrateRbsController.ROLLBACK_MESSAGE, "Warning");
                this.handleNodeInUndefinedState(bl2);
                return;
            }
            Nal.getFactory().getLog().nalTrace(1, this.getClass(), "Failed to migrate the RBS!", exception);
            if (bl) {
                MigrateRbsController.this.reportException(exception, "");
            } else {
                MigrateRbsController.this.reportException(exception, "Error: Configuration Failed.\n\nConfiguration step:\n" + this.failureCauseConfigure + "\n\nDetails:\n" + exception);
            }
            this.migrateRbsController.migrateRbsUtil;
            this.migrateRbsController.migrateRbsUtil;
            bl2 = MigrateRbsUtil.displayWarningDialog(MigrateRbsController.ROLLBACK_MESSAGE, "Warning");
            this.handleNodeInUndefinedState(bl2);
        }

        private void handleNodeInUndefinedState(boolean bl) {
            if (bl) {
                try {
                    boolean bl2 = this.migrateRbsController.migrateRbsUtil.isRollbackCVExisting();
                    if (bl2) {
                        this.migrateRbsController.migrateRbsUtil.setRollbackCVAsStartable();
                    }
                }
                catch (Exception exception) {
                    Nal.getFactory().getLog().nalTrace(1, this.getClass(), "Failed to set rollback cv as startable!", exception);
                }
                this.migrateRbsController.migrateRbsUtil.restartNode(3, MigrateRbsController.ROLLBACK_RESTART_INFORMATION);
            }
            MigrateRbsController.this.stopWizard();
        }

        public void connectionLost() {
            BemLog.log(7, "MigrateRbsController.connectionLost()");
            this.myNodeConnLostSignal.countDown();
        }

        public void connectionRestored() {
            BemLog.log(7, "MigrateRbsController.connectionRestored()");
            this.myNodeConnRestoredSignal.countDown();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FailureCause {
        EXPORT,
        CONVERT,
        OTHER;

    }
}

