/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.util.moscript;

import BasicConfig.MORef;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.omg.CORBA.UserException;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.util.moscript.Configurator;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.util.moscript.ConfiguratorInterface;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.util.moscript.FileParser;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.util.moscript.NonExistingLdnException;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.util.moscript.ParseException;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.util.moscript.SubConfigurationFailedException;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.util.moscript.URLNotFoundException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAtmConfService;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalMo;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;

public class ConfigEngine {
    private NalTransaction session = null;
    private Integer transactionTimeoutValue = null;
    private Configurator configurator;
    private ConfiguratorInterface user;
    private String configFile;
    private Vector configFileLifo = new Vector();
    private boolean isLocal;
    private NalNameValue[] configParameters;
    private String currentFile;
    private String currentCommand;
    private boolean verboseDeveloperProgress = false;
    private static final boolean TRANSACTION_COMMIT = true;
    private static final boolean TRANSACTION_ROLLBACK = false;
    private static final int TRANSACTION_ENABLE = 0;
    private static final int TRANSACTION_DISABLE = 1;
    private static final int TRANSACTION_BEGIN = 2;
    private static final int TRANSACTION_END = 3;
    private int transactionCounter = 0;
    private int lastTransactionState = 0;
    private boolean eachCommandATransaction = true;
    private boolean transactionActive = false;
    private boolean rollbackTransaction = false;
    private boolean haltMode;
    private boolean somethingWentWrong = false;
    private int numberOfCSExceptions = 0;

    public ConfigEngine(ConfiguratorInterface configuratorInterface, String string, NalNameValue[] nalNameValueArray, boolean bl, int n, boolean bl2, Configurator configurator) {
        this.user = configuratorInterface;
        this.configFile = string != null ? string : "?";
        this.configFileLifo.add(this.configFile);
        this.configParameters = nalNameValueArray;
        this.verboseDeveloperProgress = bl;
        this.haltMode = bl2;
        this.configurator = configurator;
        this.isLocal = true;
    }

    protected ConfigEngine(ConfiguratorInterface configuratorInterface, URL uRL, NalNameValue[] nalNameValueArray, boolean bl, int n, boolean bl2, Configurator configurator) {
        this.user = configuratorInterface;
        this.configFile = uRL != null ? uRL.toString() : "?";
        this.configFileLifo.add(this.configFile);
        this.configParameters = nalNameValueArray;
        this.verboseDeveloperProgress = bl;
        this.haltMode = bl2;
        this.configurator = configurator;
        this.isLocal = false;
    }

    private void performCommand(FileParser fileParser) throws IOException, ParseException, NonExistingLdnException {
        if (fileParser.sval.equals("CREATE")) {
            this.executeCreate(fileParser);
        } else if (fileParser.sval.equals("ACTION")) {
            this.executeAction(fileParser);
        } else if (fileParser.sval.equals("DELETE")) {
            this.executeDelete(fileParser);
        } else if (fileParser.sval.equals("CHECK")) {
            this.executeCheck(fileParser);
        } else if (fileParser.sval.equals("SET")) {
            this.executeSet(fileParser);
        } else if (fileParser.sval.equals("ECHO")) {
            this.executeEcho(fileParser);
        } else if (fileParser.sval.equals("TRANSACTION")) {
            this.executeTransaction(fileParser);
        } else if (fileParser.sval.equals("CALL")) {
            this.executeCall(fileParser);
        } else if (fileParser.sval.equals("REFRESH")) {
            this.executeRefresh(fileParser);
        } else if (fileParser.sval.equals("TRACE")) {
            this.executeTrace(fileParser);
        } else {
            this.currentCommand = fileParser.sval;
            throw new ParseException("<A valid command>", fileParser.sval);
        }
    }

    protected void execute() {
        this.execute(this.configFile, true);
    }

    private void execute(String string, boolean bl) {
        FileParser fileParser = null;
        this.currentFile = string;
        String string2 = string;
        this.currentCommand = "";
        try {
            Reader reader = this.isLocal ? this.getConfigFileFromLocalMachine(string2) : this.getConfigFileFromNode(string2);
            this.startSession();
            fileParser = new FileParser(reader);
            fileParser.slashSlashComments(true);
            fileParser.slashStarComments(true);
            fileParser.quoteChar(34);
            fileParser.ordinaryChar(36);
            fileParser.nextToken();
            while (fileParser.ttype != -1 && this.configurator.getProceedConfigFile() && !this.rollbackTransaction) {
                this.somethingWentWrong = false;
                if (this.haltMode) {
                    try {
                        this.performCommand(fileParser);
                    }
                    catch (Exception exception) {
                        this.user.logDeveloperProgress("Exception execute:" + exception);
                        this.somethingWentWrong = true;
                        ++this.numberOfCSExceptions;
                    }
                } else {
                    this.performCommand(fileParser);
                }
                fileParser.nextToken();
            }
            if (bl && !this.rollbackTransaction) {
                if (!this.eachCommandATransaction) {
                    this.endTransaction(true);
                }
                if (this.configurator.getProceedConfigFile()) {
                    if (this.haltMode && this.numberOfCSExceptions > 0) {
                        this.user.configurationFailed("Configuration failed: " + this.configFile);
                        this.user.configurationFailed("Number of CSExceptions = " + this.numberOfCSExceptions);
                    } else {
                        this.user.logDeveloperProgress("Configuration succeeded: " + this.configFile);
                        this.user.configurationSucceeded(this.configFile);
                    }
                }
            } else if (this.rollbackTransaction) {
                throw new SubConfigurationFailedException();
            }
            this.configFileLifo.remove(this.configFileLifo.lastElement());
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.user.logDeveloperProgress("Configuration not found: " + string2 + "; FileNotFoundException");
            if (bl) {
                this.user.configurationNotFound(string2);
            }
            this.rollbackTransaction = true;
        }
        catch (URLNotFoundException uRLNotFoundException) {
            this.user.logDeveloperProgress("Configuration not found: " + string2 + "; URLNotFoundException" + uRLNotFoundException);
            if (bl) {
                this.user.configurationNotFound(string2);
            }
            this.rollbackTransaction = true;
        }
        catch (IOException iOException) {
            this.user.logDeveloperProgress("Configuration failed: " + string2 + ", line " + fileParser.lineno() + "; IOException" + "; Exception occurred in " + this.currentCommand + " command");
            if (bl) {
                this.user.configurationFailed(string2, fileParser.lineno(), "IOException; Exception occurred in " + this.currentCommand + " command");
            }
            this.rollbackTransaction = true;
        }
        catch (ParseException parseException) {
            this.user.logDeveloperProgress("Configuration failed: " + string2 + ", line " + fileParser.lineno() + "; " + parseException.toString() + "; Exception occurred in " + this.currentCommand + " command");
            if (bl) {
                this.user.configurationFailed(string2, fileParser.lineno(), parseException.toString() + "; Exception occurred in " + this.currentCommand + " command");
            }
            this.rollbackTransaction = true;
        }
        catch (NalCmException nalCmException) {
            Nal.getLog().nalTraceError(this.getClass(), "An error occurred while interacting with the NalMo layer! CurrentFile=" + this.currentFile + ", currentCommand=" + this.currentCommand, nalCmException);
            this.user.logDeveloperProgress("Configuration failed: " + string2 + ", line " + fileParser.lineno() + "; CSException" + "; Exception occurred in " + this.currentCommand + " command" + nalCmException.toString());
            if (bl) {
                this.user.configurationFailed(string2, fileParser.lineno(), "NalCSException; Exception occurred in " + this.currentCommand + " command");
            }
            this.rollbackTransaction = true;
            throw new NalCmException(nalCmException);
        }
        catch (SubConfigurationFailedException subConfigurationFailedException) {
            this.user.logDeveloperProgress("  at: " + string2 + ", line " + fileParser.lineno());
            if (bl) {
                this.user.configurationFailed(string2, fileParser.lineno(), subConfigurationFailedException.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.user.logDeveloperProgress("Configuration failed: " + string2 + ", line " + fileParser.lineno() + "; " + exception.toString() + "; Exception occurred in " + this.currentCommand + " command");
            if (bl) {
                this.user.configurationFailed(string2, fileParser.lineno(), exception.toString() + "; Exception occurred in " + this.currentCommand + " command");
            }
            this.rollbackTransaction = true;
        }
        if (this.rollbackTransaction || !this.configurator.getProceedConfigFile()) {
            try {
                this.endTransaction(false);
            }
            catch (Exception exception) {
                this.user.logDeveloperProgress("Transaction rollback failed.");
            }
            this.lastTransactionState = 0;
        }
        if (bl) {
            this.endSession();
        }
    }

    private NalMo findMo(String string) {
        if (string.equals("null")) {
            return null;
        }
        NalMo nalMo = Nal.getFactory().getMo(string);
        return nalMo;
    }

    private void executeCheck(FileParser fileParser) throws IOException, ParseException, NonExistingLdnException {
        String string;
        String string2;
        block26: {
            this.currentCommand = "CHECK";
            string2 = "none";
            fileParser.checkBegin();
            String string3 = this.checkLdn(fileParser.getTokenValue("mo"));
            NalMo nalMo = this.findMo(string3);
            string = fileParser.getTokenValue("exception");
            String string4 = fileParser.getNextString();
            Comparable<Boolean>[] comparableArray = null;
            if (this.eachCommandATransaction) {
                this.beginTransaction();
            }
            try {
                if (this.haltMode) {
                    try {
                        comparableArray = nalMo.getAttribute(string4, this.session);
                    }
                    catch (Exception exception) {
                        this.user.logDeveloperProgress("CSException getAttribute:" + exception);
                        this.somethingWentWrong = true;
                        ++this.numberOfCSExceptions;
                    }
                } else {
                    comparableArray = nalMo.getAttribute(string4, this.session);
                }
                if (comparableArray instanceof boolean[]) {
                    boolean[] blArray = (boolean[])comparableArray;
                    Boolean[] booleanArray = new Boolean[blArray.length];
                    for (int i = 0; i < blArray.length; ++i) {
                        booleanArray[i] = Boolean.valueOf(String.valueOf(blArray[i]));
                    }
                    comparableArray = booleanArray;
                    break block26;
                }
                if (comparableArray instanceof int[]) {
                    int[] nArray = (int[])comparableArray;
                    Integer[] integerArray = new Integer[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        integerArray[i] = nArray[i];
                    }
                    comparableArray = integerArray;
                    break block26;
                }
                if (comparableArray instanceof Object[]) {
                    Object[] objectArray = comparableArray;
                    String[] stringArray = new String[objectArray.length];
                    String[] stringArray2 = new String[objectArray.length];
                    stringArray2 = this.getSequenceObjectValue(objectArray);
                    if (this.verboseDeveloperProgress) {
                        this.user.logDeveloperProgress("CHECK");
                        this.user.logDeveloperProgress("  mo = " + string3);
                        this.user.logDeveloperProgress("  " + string4 + " = " + nalMo.getLdn());
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        stringArray[i] = this.checkKeyword(fileParser.getNextString());
                        if (stringArray[i].equals(stringArray2[i])) continue;
                        this.user.logDeveloperProgress("Warning: " + this.currentFile + ", line " + fileParser.lineno() + ", CHECK " + string4 + " failed at element [" + i + "], " + "expected='" + stringArray[i] + "', " + "retrieved='" + stringArray2[i] + "'");
                    }
                    break block26;
                }
                if (comparableArray instanceof NalStruct) {
                    NalStruct nalStruct = (NalStruct)comparableArray;
                    String[] stringArray = new String[nalStruct.getSize()];
                    NalNameValue[] nalNameValueArray = nalStruct.getNameValueArray();
                    if (this.verboseDeveloperProgress) {
                        this.user.logDeveloperProgress("CHECK");
                        this.user.logDeveloperProgress("  mo = " + string3);
                        this.user.logDeveloperProgress("  " + string4 + " = " + nalMo.getLdn());
                    }
                    for (int i = 0; i < nalStruct.getSize(); ++i) {
                        String string5 = this.getObjectValue(nalNameValueArray[i].getValue());
                        stringArray[i] = this.checkKeyword(fileParser.getNextString());
                        if (stringArray[i].equals(string5)) continue;
                        this.user.logDeveloperProgress("Warning: " + this.currentFile + ", line " + fileParser.lineno() + ", CHECK " + string4 + " failed at element [" + i + "], " + "expected='" + stringArray[i] + "', " + "retrieved='" + string5 + "'");
                    }
                    break block26;
                }
                if (comparableArray instanceof Object) {
                    String string6 = this.checkKeyword(fileParser.getNextString());
                    String string7 = this.getObjectValue(comparableArray);
                    if (this.verboseDeveloperProgress) {
                        this.user.logDeveloperProgress("CHECK");
                        this.user.logDeveloperProgress("  mo = " + string3);
                        this.user.logDeveloperProgress("  " + string4 + " = " + string7);
                    }
                    if (!string6.equals(string7)) {
                        this.user.logDeveloperProgress("Warning: " + this.currentFile + ", line " + fileParser.lineno() + ", CHECK " + string4 + " failed, " + "expected='" + string6 + "', " + "retrieved='" + string7 + "'");
                    }
                    break block26;
                }
                throw new NalCmException("Unknown or unsupported attribute type encountered ");
            }
            catch (Exception exception) {
                this.user.logDeveloperProgress("ACTION: Exception getting values from struct.");
            }
        }
        fileParser.checkEnd();
        if (this.eachCommandATransaction) {
            if (!this.somethingWentWrong) {
                this.endTransaction(true);
            } else {
                try {
                    this.endTransaction(false);
                }
                catch (NalCmException nalCmException) {
                    this.user.logDeveloperProgress("Transaction rollback failed.");
                }
            }
        }
        if (this.verboseDeveloperProgress) {
            this.user.logDeveloperProgress("");
        }
        this.printException(this.currentFile, fileParser.lineno(), string, string2);
    }

    private void executeSet(FileParser fileParser) throws IOException, ParseException, NonExistingLdnException {
        this.currentCommand = "SET";
        fileParser.checkBegin();
        String string = this.checkLdn(fileParser.getTokenValue("mo"));
        NalMo nalMo = this.findMo(string);
        String string2 = fileParser.getTokenValue("exception");
        String string3 = fileParser.getNextString();
        NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue(string3, this.getAttributeValue(fileParser))};
        String string4 = "none";
        fileParser.checkEnd();
        if (this.eachCommandATransaction) {
            this.beginTransaction();
        }
        if (this.haltMode) {
            try {
                nalMo.setAttributes(nalNameValueArray, this.session);
            }
            catch (Exception exception) {
                this.user.logDeveloperProgress("CSException setAttribute:" + exception);
                this.somethingWentWrong = true;
                ++this.numberOfCSExceptions;
            }
        } else {
            nalMo.setAttributes(nalNameValueArray, this.session);
        }
        if (this.verboseDeveloperProgress) {
            this.user.logDeveloperProgress("SET");
            this.user.logDeveloperProgress("  mo = " + string);
            this.user.logDeveloperProgress("  " + this.getObjectType(nalNameValueArray[0].getValue()) + " " + string3 + " = " + this.printObjectValue(nalNameValueArray[0].getValue()));
        }
        if (this.eachCommandATransaction) {
            if (!this.somethingWentWrong) {
                this.endTransaction(true);
            } else {
                try {
                    this.endTransaction(false);
                }
                catch (NalCmException nalCmException) {
                    this.user.logDeveloperProgress("Transaction rollback failed.");
                }
            }
        }
        if (this.verboseDeveloperProgress) {
            this.user.logDeveloperProgress("");
        }
        this.printException(this.currentFile, fileParser.lineno(), string2, string4);
    }

    private void executeAction(FileParser fileParser) throws IOException, ParseException, NonExistingLdnException {
        this.currentCommand = "ACTION";
        String string = "none";
        fileParser.checkBegin();
        String string2 = fileParser.getTokenValue("actionName");
        String string3 = this.checkLdn(fileParser.getTokenValue("mo"));
        NalMo nalMo = this.findMo(string3);
        String string4 = fileParser.getTokenValue("exception");
        String string5 = fileParser.getNextString();
        if (string5.equals("nrOfParameters")) {
            Object[] objectArray;
            int n = fileParser.getNextInteger();
            NalNameValue[] nalNameValueArray = new NalNameValue[n];
            for (int i = 0; i < n; ++i) {
                nalNameValueArray[i] = Nal.getFactory().getNameValue("DUMMY" + i, this.getAttributeValue(fileParser));
            }
            Object[] objectArray2 = null;
            if (this.eachCommandATransaction) {
                this.beginTransaction();
            }
            if (this.haltMode) {
                try {
                    objectArray2 = nalMo.action(string2, nalNameValueArray, this.session);
                }
                catch (Exception exception) {
                    this.user.logDeveloperProgress("ACTION failed");
                    this.somethingWentWrong = true;
                    ++this.numberOfCSExceptions;
                }
            } else {
                objectArray2 = nalMo.action(string2, nalNameValueArray, this.session);
            }
            if (objectArray2 instanceof int[]) {
                int[] nArray = (int[])objectArray2;
                objectArray = new Integer[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    objectArray[i] = Integer.valueOf(nArray[i]);
                }
                objectArray2 = objectArray;
            } else if (objectArray2 instanceof boolean[]) {
                boolean[] blArray = (boolean[])objectArray2;
                objectArray = new Boolean[blArray.length];
                for (int i = 0; i < blArray.length; ++i) {
                    objectArray[i] = Boolean.valueOf(String.valueOf(blArray[i]));
                }
                objectArray2 = objectArray;
            } else if (objectArray2 instanceof float[]) {
                float[] fArray = (float[])objectArray2;
                objectArray = new Float[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    objectArray[i] = new Float(fArray[i]);
                }
                objectArray2 = objectArray;
            } else if (objectArray2 instanceof long[]) {
                long[] lArray = (long[])objectArray2;
                objectArray = new Long[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    objectArray[i] = lArray[i];
                }
                objectArray2 = objectArray;
            } else if (objectArray2 instanceof NalStruct) {
                try {
                    NalStruct nalStruct = (NalStruct)objectArray2;
                    objectArray = nalStruct.getNameValueArray();
                    Object[] objectArray3 = new Object[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray3[i] = objectArray[i].getValue();
                    }
                    objectArray2 = objectArray3;
                }
                catch (Exception exception) {
                    System.err.println(" !!! Exception whilst getting values from struct: " + exception);
                }
            } else if (this.verboseDeveloperProgress) {
                this.user.logDeveloperProgress("ACTION");
                this.user.logDeveloperProgress("  actionname = " + string2);
                this.user.logDeveloperProgress("  mo = " + string3);
                if (n > 0) {
                    this.user.logDeveloperProgress("nrOfParameters = " + n);
                }
                for (int i = 0; i < n; ++i) {
                    this.user.logDeveloperProgress("  " + this.getObjectType(nalNameValueArray[i].getValue()) + " " + this.printObjectValue(nalNameValueArray[i].getValue()));
                }
            }
            String string6 = this.checkKeyword(fileParser.getTokenValue("returnValue"));
            if (string6.equals("ignore")) {
                this.user.logDeveloperProgress("Inside the ignore loop");
            } else if (string6.equals("none")) {
                if (objectArray2 != null) {
                    this.user.logDeveloperProgress("ACTION failed: unexpected return value received");
                }
            } else {
                fileParser.pushBack();
                if (objectArray2 == null) {
                    this.user.logDeveloperProgress("ACTION failed: expected return value not received");
                } else if (objectArray2 instanceof Object[]) {
                    try {
                        objectArray = objectArray2;
                        String[] stringArray = null;
                        String[] stringArray2 = null;
                        stringArray = this.getSequenceObjectValue(objectArray);
                        stringArray2 = new String[stringArray.length];
                        if (this.verboseDeveloperProgress) {
                            this.user.logDeveloperProgress("  returned: " + this.getObjectType(objectArray) + " " + this.printObjectValue(objectArray));
                        }
                        for (int i = 0; i < stringArray.length; ++i) {
                            stringArray2[i] = this.checkKeyword(fileParser.getNextString());
                            if (stringArray2[i].equals(stringArray[i])) continue;
                            this.user.logDeveloperProgress("  Mismatch in return in file " + this.currentFile + ", line " + fileParser.lineno() + "  at element [" + i + "]:");
                            this.user.logDeveloperProgress("  expected: " + stringArray2[i]);
                            this.user.logDeveloperProgress("  retrieved: " + stringArray[i]);
                        }
                    }
                    catch (Exception exception) {
                        this.user.logDeveloperProgress("ACTION: Exception getting values from struct.");
                    }
                } else if (objectArray2 instanceof Object) {
                    objectArray = this.checkKeyword(fileParser.getNextString());
                    String string7 = null;
                    try {
                        string7 = this.getObjectValue(objectArray2);
                    }
                    catch (Exception exception) {
                        this.user.logDeveloperProgress("ACTION: Exception getting values from struct.");
                    }
                    if (!objectArray.equals(string7)) {
                        this.user.logDeveloperProgress("  Mismatch in return in file " + this.currentFile + ", line " + fileParser.lineno() + ": " + this.getObjectType(objectArray2) + ": ");
                        this.user.logDeveloperProgress("  expected: " + (String)objectArray);
                        this.user.logDeveloperProgress("  retrieved: " + string7);
                        this.user.logDeveloperProgress("");
                    } else if (this.verboseDeveloperProgress) {
                        this.user.logDeveloperProgress("   returned: " + this.getObjectType(objectArray2) + " " + this.printObjectValue(objectArray2));
                    }
                } else if (this.verboseDeveloperProgress) {
                    this.user.logDeveloperProgress("ACTION return  ?????type  failed");
                }
            }
            if (this.eachCommandATransaction) {
                if (!this.somethingWentWrong) {
                    this.endTransaction(true);
                } else {
                    try {
                        this.endTransaction(false);
                    }
                    catch (NalCmException nalCmException) {
                        this.user.logDeveloperProgress("Transaction rollback failed.");
                    }
                }
            }
            if (this.verboseDeveloperProgress) {
                this.user.logDeveloperProgress("");
            }
        } else {
            throw new ParseException("nrOfParameters", string5);
        }
        fileParser.checkEnd();
        this.printException(this.currentFile, fileParser.lineno(), string4, string);
    }

    private void executeDelete(FileParser fileParser) throws IOException, ParseException, NonExistingLdnException {
        this.currentCommand = "DELETE";
        fileParser.checkBegin();
        String string = this.checkLdn(fileParser.getTokenValue("mo"));
        NalMo nalMo = this.findMo(string);
        String string2 = fileParser.getTokenValue("exception");
        fileParser.checkEnd();
        String string3 = "none";
        if (this.eachCommandATransaction) {
            this.beginTransaction();
        }
        if (this.verboseDeveloperProgress) {
            this.user.logDeveloperProgress("DELETE");
            this.user.logDeveloperProgress("  mo = " + string);
        }
        if (this.haltMode) {
            try {
                nalMo.delete(this.session);
            }
            catch (Exception exception) {
                this.user.logDeveloperProgress("CSException deleteMO:" + exception);
                this.somethingWentWrong = true;
                ++this.numberOfCSExceptions;
            }
        } else {
            nalMo.delete(this.session);
        }
        if (this.eachCommandATransaction) {
            if (!this.somethingWentWrong) {
                this.endTransaction(true);
            } else {
                try {
                    this.endTransaction(false);
                }
                catch (NalCmException nalCmException) {
                    this.user.logDeveloperProgress("Transaction rollback failed.");
                }
            }
        }
        if (this.verboseDeveloperProgress) {
            this.user.logDeveloperProgress("");
        }
        this.printException(this.currentFile, fileParser.lineno(), string2, string3);
    }

    private void executeCreate(FileParser fileParser) throws IOException, ParseException, NonExistingLdnException {
        String string;
        this.currentCommand = "CREATE";
        fileParser.checkBegin();
        String string2 = fileParser.getTokenValue("parent");
        NalMo nalMo = this.findMo(this.checkLdn(string2));
        String string3 = this.checkKeyword(fileParser.getTokenValue("identity"));
        String string4 = fileParser.getTokenValue("moType");
        String string5 = fileParser.getTokenValue("exception");
        String string6 = fileParser.getNextString();
        NalMo nalMo2 = null;
        if (string6.equals("sourceMo")) {
            nalMo2 = this.findMo(fileParser.getNextString());
            string6 = fileParser.getNextString();
        }
        if (string6.equals("nrOfAttributes")) {
            int n = fileParser.getNextInteger();
            String[] stringArray = new String[n];
            NalNameValue[] nalNameValueArray = new NalNameValue[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = fileParser.getNextString();
                nalNameValueArray[i] = Nal.getFactory().getNameValue(stringArray[i], this.getAttributeValue(fileParser));
            }
            fileParser.checkEnd();
            string = "none";
            String string7 = ((Object)nalMo).toString() + "," + string4 + "=" + string3;
            NalMo nalMo3 = Nal.getFactory().getMo(string7);
            if (string4.equals(MimAtmConfService.MOTYPENAME) && nalMo3.exists()) {
                return;
            }
            if (this.eachCommandATransaction) {
                this.beginTransaction();
            }
            if (nalMo2 != null) {
                this.user.logDeveloperProgress("Source MO not yet implemented");
            }
            if (this.haltMode) {
                try {
                    nalMo3.create(nalNameValueArray, this.session);
                }
                catch (Exception exception) {
                    Nal.getLog().nalTraceError(this.getClass(), "Failed calling mo.create(...) on MO " + nalMo3 + "!", exception);
                    this.user.logDeveloperProgress("CSException createMO:" + exception);
                    this.somethingWentWrong = true;
                    ++this.numberOfCSExceptions;
                }
            } else {
                nalMo3.create(nalNameValueArray, this.session);
            }
            if (this.verboseDeveloperProgress) {
                this.user.logDeveloperProgress("CREATE");
                this.user.logDeveloperProgress("  parent = " + nalMo.getLdn());
                this.user.logDeveloperProgress("  identity = " + string3);
                this.user.logDeveloperProgress("  moType = " + string4);
                if (nalMo2 != null) {
                    this.user.logDeveloperProgress("  sourceMo = " + nalMo2.getLdn());
                }
            }
            if (this.eachCommandATransaction) {
                if (!this.somethingWentWrong) {
                    this.endTransaction(true);
                } else {
                    try {
                        this.endTransaction(false);
                    }
                    catch (NalCmException nalCmException) {
                        this.user.logDeveloperProgress("Transaction rollback failed.");
                    }
                }
            }
            if (this.verboseDeveloperProgress) {
                this.user.logDeveloperProgress("");
            }
        } else {
            throw new ParseException("sourceMo or nrOfAttributes", string6);
        }
        this.printException(this.currentFile, fileParser.lineno(), string5, string);
    }

    private void executeCall(FileParser fileParser) throws IOException, ParseException {
        try {
            fileParser.checkBegin();
        }
        catch (ParseException parseException) {
            fileParser.pushBack();
        }
        String string = this.checkKeyword(fileParser.getNextString());
        String string2 = (String)this.configFileLifo.lastElement();
        int n = string2.lastIndexOf(47) + 1;
        int n2 = string2.lastIndexOf(92) + 1;
        if (n2 > n) {
            n = n2;
        }
        String string3 = string2.substring(0, n);
        String string4 = string3 + string;
        this.configFileLifo.add(string4);
        try {
            fileParser.checkEnd();
        }
        catch (ParseException parseException) {
            fileParser.pushBack();
        }
        if (this.verboseDeveloperProgress) {
            this.user.logDeveloperProgress("CALL " + string4);
            this.user.logDeveloperProgress("");
        }
        this.execute(string4, false);
    }

    private void executeEcho(FileParser fileParser) throws IOException, ParseException {
        this.currentCommand = "ECHO";
        this.user.logOperatorProgress(this.checkLdn(fileParser.getNextString()));
    }

    private void executeTrace(FileParser fileParser) throws IOException, ParseException {
        this.currentCommand = "TRACE";
        String string = fileParser.getNextString();
        if (string.equals("OFF")) {
            this.verboseDeveloperProgress = false;
            this.user.logDeveloperProgress("Verbose developer progress logging OFF");
        } else if (string.equals("ON")) {
            this.verboseDeveloperProgress = true;
            this.user.logDeveloperProgress("Verbose developer progress logging ON");
        } else {
            this.user.logDeveloperProgress("Verbose developer progress logging " + string);
            this.user.logDeveloperProgress("  Incorrect operation");
            this.user.logDeveloperProgress("");
            throw new ParseException("ON or OFF", string);
        }
        this.user.logDeveloperProgress("");
    }

    private void executeRefresh(FileParser fileParser) throws IOException, ParseException {
        this.currentCommand = "REFRESH";
        fileParser.checkBegin();
        fileParser.checkEnd();
        if (this.verboseDeveloperProgress) {
            this.user.logDeveloperProgress("REFRESH");
            this.user.logDeveloperProgress("  Command is deprecated; please remove it.");
            this.user.logDeveloperProgress("");
        }
    }

    private void executeTransaction(FileParser fileParser) throws IOException, ParseException, NonExistingLdnException {
        this.currentCommand = "TRANSACTION";
        String string = null;
        String string2 = null;
        try {
            fileParser.checkBegin();
            string = fileParser.getTokenValue("mode");
            try {
                fileParser.checkEnd();
            }
            catch (ParseException parseException) {
                fileParser.pushBack();
                string2 = fileParser.getTokenValue("timeout");
                fileParser.checkEnd();
            }
        }
        catch (ParseException parseException) {
            fileParser.pushBack();
            string = fileParser.getNextString();
        }
        if (string.equals("ENABLE")) {
            if (this.lastTransactionState == 2) {
                this.user.logDeveloperProgress("TRANSACTION ENABLE");
                this.user.logDeveloperProgress("  Error: Can not enable transactions inside an active transaction.");
                this.user.logDeveloperProgress("");
                throw new ParseException("END", string);
            }
            if (this.lastTransactionState == 3) {
                this.user.logDeveloperProgress("TRANSACTION ENABLE");
                this.user.logDeveloperProgress("  Warning: Transactions are already enabled. Command ignored.");
                this.user.logDeveloperProgress("");
            } else {
                if (string2 != null) {
                    this.transactionTimeoutValue = Integer.valueOf(string2);
                }
                this.eachCommandATransaction = true;
                this.lastTransactionState = 0;
                if (this.verboseDeveloperProgress) {
                    this.user.logDeveloperProgress("TRANSACTION ENABLE");
                    this.user.logDeveloperProgress("");
                }
            }
        } else if (string.equals("DISABLE")) {
            if (this.lastTransactionState == 1) {
                this.user.logDeveloperProgress("TRANSACTION DISABLE");
                this.user.logDeveloperProgress("  Warning: Transactions are already disabled. Command ignored.");
                this.user.logDeveloperProgress("");
            } else {
                if (this.lastTransactionState == 2) {
                    this.user.logDeveloperProgress("TRANSACTION DISABLE");
                    this.user.logDeveloperProgress("  Error: Can not disable transactions inside an active transaction.");
                    this.user.logDeveloperProgress("");
                    throw new ParseException("END", string);
                }
                this.eachCommandATransaction = false;
                this.transactionTimeoutValue = null;
                this.lastTransactionState = 1;
                if (this.verboseDeveloperProgress) {
                    this.user.logDeveloperProgress("TRANSACTION DISABLE");
                    this.user.logDeveloperProgress("");
                }
            }
        } else if (string.equals("BEGIN")) {
            if (this.lastTransactionState == 1) {
                this.user.logDeveloperProgress("TRANSACTION BEGIN");
                this.user.logDeveloperProgress("  Error: Can not begin transaction. Transactions are disabled.");
                this.user.logDeveloperProgress("");
                throw new ParseException("ENABLE", string);
            }
            if (this.lastTransactionState == 2) {
                this.user.logDeveloperProgress("TRANSACTION BEGIN");
                this.user.logDeveloperProgress("  Error: Can not begin a transaction inside an active transaction.");
                this.user.logDeveloperProgress("");
                throw new ParseException("END", string);
            }
            if (string2 != null) {
                this.transactionTimeoutValue = Integer.valueOf(string2);
            }
            this.beginTransaction();
            this.eachCommandATransaction = false;
            this.lastTransactionState = 2;
            if (this.verboseDeveloperProgress) {
                this.user.logDeveloperProgress("TRANSACTION BEGIN");
                this.user.logDeveloperProgress("");
            }
        } else if (string.equals("END")) {
            if (this.lastTransactionState == 0) {
                this.user.logDeveloperProgress("TRANSACTION END");
                this.user.logDeveloperProgress("  Error: Can not end transaction. No transaction active.");
                this.user.logDeveloperProgress("");
                throw new ParseException("BEGIN or DISABLE", string);
            }
            if (this.lastTransactionState == 1) {
                this.user.logDeveloperProgress("TRANSACTION END");
                this.user.logDeveloperProgress("  Error: Can not end transaction. No transaction active.");
                this.user.logDeveloperProgress("");
                throw new ParseException("ENABLE", string);
            }
            if (this.lastTransactionState == 3) {
                this.user.logDeveloperProgress("TRANSACTION END");
                this.user.logDeveloperProgress("  Error: Can not end transaction. No transaction active.");
                this.user.logDeveloperProgress("");
                throw new ParseException("BEGIN or DISABLE", string);
            }
            if (this.verboseDeveloperProgress) {
                this.user.logDeveloperProgress("TRANSACTION END");
                this.user.logDeveloperProgress("");
            }
            this.transactionTimeoutValue = null;
            this.endTransaction(true);
            this.eachCommandATransaction = true;
            this.lastTransactionState = 3;
        } else {
            this.user.logDeveloperProgress("TRANSACTION " + string);
            this.user.logDeveloperProgress("  Incorrect transaction operation");
            this.user.logDeveloperProgress("");
            throw new ParseException("BEGIN, END, ENABLE or DISABLE", string);
        }
    }

    private void printException(String string, int n, String string2, String string3) {
        int n2 = string3.indexOf("TAG");
        if (n2 > 0) {
            String string4 = string3.substring(n2 + 6);
            n2 = string4.indexOf(34);
            string3 = string4.substring(0, n2);
        }
        if (string3.indexOf(string2) == -1) {
            this.user.logDeveloperProgress("  Failed in file " + string + " at line (" + n + ")! Exception mismatch");
            this.user.logDeveloperProgress("    Expected: " + string2);
            this.user.logDeveloperProgress("    Received: " + string3);
            this.user.logDeveloperProgress("");
        }
    }

    private String getObjectValue(Object object) throws UserException {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("String[]: ");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]).append(" ");
            }
            return stringBuffer.toString();
        }
        if (object instanceof Integer) {
            return object.toString();
        }
        if (object instanceof Integer[]) {
            Integer[] integerArray = (Integer[])object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Integer[]: ");
            for (int i = 0; i < integerArray.length; ++i) {
                stringBuffer.append(integerArray[i]).append(" ");
            }
            return stringBuffer.toString();
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof Boolean[]) {
            Boolean[] booleanArray = (Boolean[])object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Boolean[]: ");
            for (int i = 0; i < booleanArray.length; ++i) {
                stringBuffer.append(booleanArray[i]).append(" ");
            }
            return stringBuffer.toString();
        }
        if (object instanceof Float) {
            return object.toString();
        }
        if (object instanceof Float[]) {
            Float[] floatArray = (Float[])object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Float[]: ");
            for (int i = 0; i < floatArray.length; ++i) {
                stringBuffer.append(floatArray[i]).append(" ");
            }
            return stringBuffer.toString();
        }
        if (object instanceof Long) {
            return object.toString();
        }
        if (object instanceof Long[]) {
            Long[] longArray = (Long[])object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Long[]: ");
            for (int i = 0; i < longArray.length; ++i) {
                stringBuffer.append(longArray[i]).append(" ");
            }
            return stringBuffer.toString();
        }
        if (object instanceof NalMo) {
            NalMo nalMo = (NalMo)object;
            return nalMo.getLdn();
        }
        if (object instanceof NalNameValue) {
            NalNameValue nalNameValue = (NalNameValue)object;
            return this.getObjectValue(nalNameValue.getValue());
        }
        this.user.logDeveloperProgress("ERROR: Unsupported type detected in getObjectValue: " + object.getClass().getName());
        return "null";
    }

    private String[] getSequenceObjectValue(Object[] objectArray) throws UserException {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                Object[] objectArray2;
                if (objectArray[i] instanceof NalStruct) {
                    objectArray2 = ((NalStruct)objectArray[i]).getNameValueArray();
                    Object[] objectArray3 = new Object[objectArray2.length];
                    for (int j = 0; j < objectArray2.length; ++j) {
                        objectArray3[j] = objectArray2[j].getValue();
                    }
                    Object[] objectArray4 = objectArray3;
                    String[] stringArray = this.getSequenceObjectValue(objectArray4);
                    for (int j = 0; j < stringArray.length; ++j) {
                        vector.addElement(this.getObjectValue(stringArray[j]));
                    }
                    continue;
                }
                if (objectArray[i] instanceof int[]) {
                    objectArray2 = (int[])objectArray[i];
                    for (int j = 0; j < objectArray2.length; ++j) {
                        vector.addElement(this.getObjectValue((int)objectArray2[j]));
                    }
                    continue;
                }
                if (objectArray[i] instanceof long[]) {
                    objectArray2 = (long[])objectArray[i];
                    for (int j = 0; j < objectArray2.length; ++j) {
                        vector.addElement(this.getObjectValue((long)objectArray2[j]));
                    }
                    continue;
                }
                if (objectArray[i] instanceof float[]) {
                    objectArray2 = (float[])objectArray[i];
                    for (int j = 0; j < objectArray2.length; ++j) {
                        vector.addElement(this.getObjectValue(new Float((float)objectArray2[j])));
                    }
                    continue;
                }
                if (objectArray[i] instanceof boolean[]) {
                    objectArray2 = (boolean[])objectArray[i];
                    for (int j = 0; j < objectArray2.length; ++j) {
                        vector.addElement(this.getObjectValue(Boolean.valueOf(String.valueOf((boolean)objectArray2[j]))));
                    }
                    continue;
                }
                vector.addElement(this.getObjectValue(objectArray[i]));
                continue;
            }
            catch (Exception exception) {
                this.user.logDeveloperProgress("ACTION: Exception getting values from struct.");
            }
        }
        Object[] objectArray5 = new String[vector.size()];
        vector.copyInto(objectArray5);
        return objectArray5;
    }

    private String getObjectType(Object object) {
        if (object == null) {
            return "null (probably MoRef)";
        }
        if (object instanceof NalStruct) {
            return "Struct";
        }
        if (object instanceof String) {
            return "String";
        }
        if (object instanceof Integer) {
            return "Integer";
        }
        if (object instanceof Boolean) {
            return "Boolean";
        }
        if (object instanceof Float) {
            return "Float";
        }
        if (object instanceof Long) {
            return "Long";
        }
        if (object instanceof NalMo) {
            return "NalMo";
        }
        if (object instanceof String[]) {
            return "String[]";
        }
        if (object instanceof Integer[]) {
            return "Integer[]";
        }
        if (object instanceof Boolean[]) {
            return "Boolean[]";
        }
        if (object instanceof int[]) {
            return "int[]";
        }
        if (object instanceof Float[]) {
            return "Float[]";
        }
        if (object instanceof Long[]) {
            return "Long[]";
        }
        if (object instanceof NalMo[]) {
            return "NalMo[]";
        }
        if (object instanceof MORef) {
            return "MORef";
        }
        if (object instanceof MORef[]) {
            return "MORef[]";
        }
        this.user.logDeveloperProgress("ERROR: Unsupported type detected " + object.getClass());
        return "null";
    }

    private String printObjectValue(Object object) {
        String string = "<Unknown>";
        if (object == null) {
            string = "null";
        } else if (object instanceof NalStruct) {
            try {
                NalStruct nalStruct = (NalStruct)object;
                NalNameValue[] nalNameValueArray = nalStruct.getNameValueArray();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("numberOfElements: ").append(nalStruct.getSize());
                for (int i = 0; i < nalStruct.getSize(); ++i) {
                    stringBuffer.append("\n       ").append(nalNameValueArray[i].getName()).append("=").append(this.getObjectType(nalNameValueArray[i].getValue()));
                }
                string = stringBuffer.toString();
            }
            catch (Exception exception) {
                this.user.logDeveloperProgress(" !!! Exception whilst getting values from struct: " + exception);
            }
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            String[] stringArray = null;
            try {
                stringArray = this.getSequenceObjectValue(objectArray);
            }
            catch (Exception exception) {
                this.user.logDeveloperProgress("ACTION: Exception getting values from struct.");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("length:").append(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append("\n       ").append(stringArray[i]);
            }
            string = stringBuffer.toString();
        } else if (object instanceof Object) {
            try {
                string = this.getObjectValue(object);
            }
            catch (Exception exception) {
                this.user.logDeveloperProgress("ACTION: Exception getting values from struct.");
            }
        } else {
            string = "Unknown type";
        }
        return string;
    }

    private Object getAttributeValue(FileParser fileParser) throws IOException, NonExistingLdnException, ParseException {
        String string = fileParser.getNextString();
        if (string.startsWith("Struct")) {
            String string2 = fileParser.getNextString();
            if (string2.equals("nrOfElements")) {
                int n = fileParser.getNextInteger();
                String[] stringArray = new String[n];
                Object[] objectArray = new Object[n];
                NalNameValue[] nalNameValueArray = new NalNameValue[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = fileParser.getNextString();
                    objectArray[i] = this.getAttributeValue(fileParser);
                    nalNameValueArray[i] = Nal.getFactory().getNameValue(stringArray[i], objectArray[i]);
                }
                return Nal.getFactory().getStruct(nalNameValueArray);
            }
            this.user.logDeveloperProgress("Parse error in file " + this.currentFile + " at line:" + fileParser.lineno() + " nrOfElements expected ");
            throw new ParseException("nrOfElements", string2);
        }
        if (string.startsWith("Array")) {
            String string3 = fileParser.getNextString();
            int n = fileParser.getNextInteger();
            if (string3.startsWith("String")) {
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    String string4;
                    String string5 = string4 = fileParser.getNextString();
                    stringArray[i] = string5 = this.checkKeyword(string4);
                }
                return stringArray;
            }
            if (string3.startsWith("Integer")) {
                Integer[] integerArray = new Integer[n];
                for (int i = 0; i < n; ++i) {
                    String string6;
                    String string7 = string6 = fileParser.getNextString();
                    string7 = this.checkKeyword(string6);
                    integerArray[i] = Integer.valueOf(string7);
                }
                return integerArray;
            }
            if (string3.startsWith("Bool")) {
                Boolean[] booleanArray = new Boolean[n];
                for (int i = 0; i < n; ++i) {
                    String string8;
                    String string9 = string8 = fileParser.getNextString();
                    string9 = this.checkKeyword(string9);
                    string9 = this.checkSyntaxOfBoolean(string9);
                    booleanArray[i] = Boolean.valueOf(string9);
                }
                return booleanArray;
            }
            if (string3.startsWith("Float")) {
                Float[] floatArray = new Float[n];
                for (int i = 0; i < n; ++i) {
                    String string10 = fileParser.getNextString();
                    String string11 = this.checkKeyword(string10);
                    floatArray[i] = new Float(string11);
                }
                return floatArray;
            }
            if (string3.startsWith("Long")) {
                Long[] longArray = new Long[n];
                for (int i = 0; i < n; ++i) {
                    String string12 = fileParser.getNextString();
                    String string13 = this.checkKeyword(string12);
                    longArray[i] = Long.valueOf(string13);
                }
                return longArray;
            }
            if (string3.startsWith("Ref")) {
                NalMo[] nalMoArray = new NalMo[n];
                for (int i = 0; i < n; ++i) {
                    String string14 = this.checkKeyword(fileParser.getNextString());
                    nalMoArray[i] = this.findMo(this.checkLdn(string14));
                    if (nalMoArray[i] == null || nalMoArray[i].exists(this.session)) continue;
                    throw new NonExistingLdnException(string14);
                }
                return nalMoArray;
            }
            if (string3.startsWith("Struct")) {
                NalStruct[] nalStructArray = new NalStruct[n];
                for (int i = 0; i < n; ++i) {
                    NalNameValue[] nalNameValueArray;
                    String string15 = fileParser.getNextString();
                    if (string15.equals("nrOfElements")) {
                        int n2 = fileParser.getNextInteger();
                        String[] stringArray = new String[n2];
                        Object[] objectArray = new Object[n2];
                        nalNameValueArray = new NalNameValue[n2];
                        for (int j = 0; j < n2; ++j) {
                            stringArray[j] = fileParser.getNextString();
                            objectArray[j] = this.getAttributeValue(fileParser);
                            nalNameValueArray[j] = Nal.getFactory().getNameValue(stringArray[j], objectArray[j]);
                        }
                    } else {
                        this.user.logDeveloperProgress("Parse error in file " + this.currentFile + " at line:" + fileParser.lineno() + " nrOfElements expected ");
                        throw new ParseException("nrOfElements", string15);
                    }
                    nalStructArray[i] = Nal.getFactory().getStruct(nalNameValueArray);
                }
                return nalStructArray;
            }
        } else {
            String string16 = this.checkKeyword(fileParser.getNextString());
            if (string.startsWith("String")) {
                return string16;
            }
            if (string.startsWith("Integer")) {
                return Integer.valueOf(string16);
            }
            if (string.startsWith("Bool")) {
                string16 = this.checkSyntaxOfBoolean(string16);
                return Boolean.valueOf(String.valueOf(string16));
            }
            if (string.startsWith("Float")) {
                return new Float(string16);
            }
            if (string.startsWith("Long")) {
                return Long.valueOf(string16);
            }
            if (string.startsWith("Ref")) {
                if ("".equals(string16)) {
                    return null;
                }
                return this.findMo(this.checkLdn(string16));
            }
            this.user.logDeveloperProgress("Unknown type of attribute encountered: " + string);
            throw new ParseException("<A valid attribute type>", string);
        }
        return null;
    }

    private Reader getConfigFileFromLocalMachine(String string) throws FileNotFoundException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        return inputStreamReader;
    }

    private Reader getConfigFileFromNode(String string) throws URLNotFoundException {
        InputStreamReader inputStreamReader = null;
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            inputStreamReader = new InputStreamReader(inputStream);
        }
        catch (MalformedURLException malformedURLException) {
            throw new URLNotFoundException(string);
        }
        catch (IOException iOException) {
            throw new URLNotFoundException(string);
        }
        catch (NullPointerException nullPointerException) {
            throw new URLNotFoundException(string);
        }
        return inputStreamReader;
    }

    private String getUserValue(String string) throws ParseException {
        if (this.configParameters == null) {
            throw new ParseException("<A valid configuration parameter>", string);
        }
        for (int i = 0; i < this.configParameters.length; ++i) {
            if (!string.equals(this.configParameters[i].getName())) continue;
            return (String)this.configParameters[i].getValue();
        }
        throw new ParseException("<A valid configuration parameter>", string);
    }

    private String checkLdn(String string) throws ParseException {
        String string2 = "";
        int n = string.indexOf("$");
        while (n != -1) {
            String string3;
            String string4;
            int n2 = string.indexOf(",", n);
            if (n2 != -1) {
                string4 = string.substring(0, n);
                string3 = string.substring(n2, string.length());
                String string5 = this.getUserValue(string.substring(n, n2));
                string2 = string4.concat(string5).concat(string3);
            } else if (n2 == -1) {
                string4 = string.substring(0, n);
                string3 = this.getUserValue(string.substring(n, string.length()));
                string2 = string4.concat(string3);
            }
            string = string2;
            n = string.indexOf("$");
        }
        return string;
    }

    private String checkKeyword(String string) throws ParseException {
        if (string.startsWith("$")) {
            return this.getUserValue(string);
        }
        return string;
    }

    private String checkSyntaxOfBoolean(String string) throws ParseException {
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false")) {
            return string;
        }
        if (string.equals("1")) {
            return "true";
        }
        if (string.equals("0")) {
            return "false";
        }
        throw new ParseException("'true' (not case sensitive) or 'false' (not case sensitive) or '1' or '0'", string);
    }

    private void beginTransaction() throws NalCmException {
        if (!this.transactionActive) {
            this.session = this.transactionTimeoutValue != null ? Nal.getFactory().createTransaction(this.transactionTimeoutValue) : null;
            this.transactionActive = true;
            if (this.verboseDeveloperProgress) {
                if (this.transactionTimeoutValue != null) {
                    this.user.logDeveloperProgress("Begin transaction #" + ++this.transactionCounter + " with timeout of " + this.transactionTimeoutValue.toString() + " seconds");
                } else {
                    this.user.logDeveloperProgress("Begin transaction #" + ++this.transactionCounter + " with default timeout value");
                }
            }
        }
    }

    private void endTransaction(boolean bl) throws NalCmException {
        if (this.transactionActive && this.session != null) {
            if (bl) {
                this.session.commit();
            } else {
                this.session.rollback("", null);
            }
            this.transactionActive = false;
            if (this.verboseDeveloperProgress) {
                this.user.logDeveloperProgress("End transaction #" + this.transactionCounter);
            }
        }
    }

    private void startSession() {
        Log.trace("startSession()");
    }

    private void endSession() throws NalCmException {
        Log.trace("endSession()");
        if (this.session != null) {
            if (this.session.isNullTransaction()) {
                this.session.commit();
            } else {
                Log.logError("Error occured with ending session", null);
                this.session.rollback("Main script terminated without ending large transaction!", null);
            }
        }
        this.session = null;
    }
}

