/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.pmdatastorage.util;

import java.util.Hashtable;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.application.applications.pmdatastorage.postcontrol.UpdateNodePostController;
import se.ericsson.wcdma.rbs.bem.application.applications.pmdatastorage.precontrol.LoadMoPreController;
import se.ericsson.wcdma.rbs.bem.application.common.model.Configurator;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimManagedElementData;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPmService;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPredefRbsScannerGpeh;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMoImpl;

public class PmDataStorageHelp {
    private static final String DTD_FILE_PATH = "/se/ericsson/wcdma/rbs/bem/application/applications/PmDataStorage/dtd/PmDataStorage.dtd";
    private static PmDataStorageHelp theInstance = null;
    private static final String ME_LDN = "ManagedElement=1";
    private static final String PMSERVICE_LDN = "ManagedElement=1,SystemFunctions=1,PmService=*";
    private static final String EQUIPMENT_LDN = "ManagedElement=1,Equipment=*";
    private static final String GPEH_LDN = "ManagedElement=1,*,PredefRbsScannerGpeh=*";
    private static final Hashtable APPLICATION_MO_LOAD = new Hashtable();

    private PmDataStorageHelp() {
    }

    public static synchronized PmDataStorageHelp getTheInstance() {
        if (theInstance == null) {
            theInstance = new PmDataStorageHelp();
        }
        return theInstance;
    }

    public static Hashtable getHashtableApplicationMoLoad() {
        Hashtable hashtable = APPLICATION_MO_LOAD;
        return hashtable;
    }

    public synchronized void destroyTheInstance() {
        theInstance = null;
    }

    public static boolean checkIfActive() {
        boolean bl = false;
        if (theInstance != null) {
            bl = true;
        }
        return bl;
    }

    public static Class[] getAllPreControllerClasses() {
        Class[] classArray = new Class[]{LoadMoPreController.class};
        return classArray;
    }

    public static Class[] getAllPostControllerClasses() {
        Class[] classArray = new Class[]{UpdateNodePostController.class};
        return classArray;
    }

    public static String getDtdFilePath() {
        return DTD_FILE_PATH;
    }

    public static String getPredefRbsScannerGpehLdn(Configurator configurator) throws BemException {
        try {
            int n;
            BemMo bemMo = BemMoImpl.getRoot();
            String string = bemMo.getDN();
            Vector vector = configurator.getConfiguredChildren(string, 2, MimPredefRbsScannerGpeh.MOTYPENAME);
            String string2 = null;
            if (vector != null && (n = vector.size()) != 0) {
                string2 = (String)vector.elementAt(0);
            }
            if (string2 != null && !configurator.isConfiguredMoExisting(string2)) {
                string2 = null;
            }
            return string2;
        }
        catch (Exception exception) {
            throw new BemException(exception.toString());
        }
    }

    public static String getManagedElementDataLdn(Configurator configurator) throws BemException {
        try {
            int n;
            BemMo bemMo = BemMoImpl.getRoot();
            String string = bemMo.getDN();
            Vector vector = configurator.getConfiguredChildren(string, 1, MimManagedElementData.MOTYPENAME);
            String string2 = null;
            if (vector != null && (n = vector.size()) != 0) {
                string2 = (String)vector.elementAt(0);
            }
            if (string2 != null && !configurator.isConfiguredMoExisting(string2)) {
                string2 = null;
            }
            return string2;
        }
        catch (Exception exception) {
            throw new BemException(exception.toString());
        }
    }

    public static String getPmServiceLdn(Configurator configurator) throws BemException {
        try {
            int n;
            BemMo bemMo = BemMoImpl.getRoot();
            String string = bemMo.getDN();
            Vector vector = configurator.getConfiguredChildren(string, 2, MimPmService.MOTYPENAME);
            String string2 = null;
            if (vector != null && (n = vector.size()) != 0) {
                string2 = (String)vector.elementAt(0);
            }
            if (string2 != null && !configurator.isConfiguredMoExisting(string2)) {
                string2 = null;
            }
            return string2;
        }
        catch (Exception exception) {
            throw new BemException(exception.toString());
        }
    }

    static {
        APPLICATION_MO_LOAD.put(ME_LDN, new String[0]);
        APPLICATION_MO_LOAD.put(EQUIPMENT_LDN, new String[0]);
        APPLICATION_MO_LOAD.put(PMSERVICE_LDN, new String[]{"performanceDataPath"});
        APPLICATION_MO_LOAD.put(GPEH_LDN, new String[]{"fileLocation", "maxStorageSize", "maxFileSize"});
    }
}

