/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.replaceetm.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import se.ericsson.wcdma.rbs.bem.application.applications.replaceetm.view.ReplaceEtmViewer;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationView;

public class ReplaceEtmView
extends AbstractApplicationView
implements ReplaceEtmViewer {
    private final JPanel buttonPanel = new JPanel();
    private final JButton okButton = new JButton();
    private final JButton helpButton = new JButton();
    private final JButton cancelButton = new JButton();
    private JTable etmTable = null;
    private EtmTableModel etmModel = null;
    private final JTextArea infoTextArea = new JTextArea();
    private JLabel headingLabel = new JLabel();
    private final GridLayout lowerButtonGridLayout = new GridLayout(1, 0);
    private final JPanel tablePanel = new JPanel();
    private static final int NUM_COLUMNS = 3;
    private JComboBox etmBoardComboBox = null;

    protected void init() {
        this.initComponents();
        this.putClientProperty("HELP_KEY", "REPLACE_ETM_BUTTON_HELP");
        this.setLayout(new GridBagLayout());
        this.infoTextArea.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        this.infoTextArea.setEditable(false);
        this.infoTextArea.setBackground(Color.lightGray);
        this.infoTextArea.setText("\n\n\n");
        this.tablePanel.setLayout(new GridBagLayout());
        this.tablePanel.add((Component)this.etmTable.getTableHeader(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 10, new Insets(50, 30, 0, 20), 0, 0));
        this.tablePanel.add((Component)this.etmTable, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 10, new Insets(0, 30, 40, 20), 0, 0));
        this.tablePanel.add((Component)this.infoTextArea, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 15, 15, new Insets(10, 30, 20, 20), 0, 0));
        this.add((Component)this.tablePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 2.0, 10, 11, new Insets(50, 0, 30, 0), 0, 0));
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(), "REPLACE_DELETE_ETM");
        this.tablePanel.setBorder(titledBorder);
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 14, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.buttonPanel.setLayout(this.lowerButtonGridLayout);
        this.okButton.setText("GSL_OK");
        this.cancelButton.setText("GSL_CANCEL");
        this.helpButton.setText("GSL_HELP");
        this.helpButton.putClientProperty("HELP_ENABLE", "");
        this.helpButton.putClientProperty("HELP_KEY", "REPLACE_ETM_BUTTON_HELP");
        this.buttonPanel.add((Component)this.okButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.buttonPanel.add((Component)this.helpButton, null);
        this.helpButton.setToolTipText("GSL_HELP");
        this.okButton.setToolTipText("REPLACE_ETM_BUTTON_OK");
        this.cancelButton.setToolTipText("REPLACE_ETM_BUTTON_CANCEL");
    }

    private void initComponents() {
        this.etmModel = new EtmTableModel();
        this.etmTable = new JTable(this.etmModel);
        this.etmTable.setAutoResizeMode(0);
        this.etmTable.setRowSelectionAllowed(false);
        this.etmTable.setColumnSelectionAllowed(false);
        TableColumnModel tableColumnModel = this.etmTable.getColumnModel();
        int[] nArray = new int[]{40, 140, 140};
        for (int i = 0; i < 3; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setPreferredWidth(nArray[i]);
            tableColumn.setMinWidth(nArray[i]);
            tableColumn.setResizable(false);
            this.etmTable.setShowGrid(true);
            this.etmTable.setRowHeight(this.etmTable.getRowHeight() + 2);
        }
        this.etmTable.getTableHeader().setReorderingAllowed(false);
    }

    public boolean addRowToEtmTable(Object[] objectArray, boolean[] blArray) {
        if (objectArray.length != 3 || blArray.length != 3) {
            return false;
        }
        this.etmModel.addRow(objectArray);
        this.etmModel.addRowCellEditable(blArray);
        return true;
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public JTextArea getInfoTextArea() {
        return this.infoTextArea;
    }

    public JTable getEtmTable() {
        return this.etmTable;
    }

    public int getNumColumnsInEtmTable() {
        return 3;
    }

    public JComboBox getEtmComboBox() {
        if (this.etmBoardComboBox == null) {
            this.etmBoardComboBox = new JComboBox();
            int n = 2;
            TableColumn tableColumn = this.etmTable.getColumnModel().getColumn(n);
            tableColumn.setCellEditor(new DefaultCellEditor(this.etmBoardComboBox));
            for (int i = 0; i < this.etmModel.getRowCount(); ++i) {
                this.etmModel.setCellEditable(i, 2, true);
            }
        }
        return this.etmBoardComboBox;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public void setHeaderText(String string) {
        this.headingLabel.setText(string);
    }

    public JComponent[] getToolBarComponents() {
        return null;
    }

    public JMenu[] getMenus() {
        return null;
    }

    public void hideTheView() {
        this.setVisible(false);
    }

    public void setButtonsToEnabled(boolean bl) {
        this.okButton.setEnabled(bl);
        this.cancelButton.setEnabled(bl);
        this.helpButton.setEnabled(bl);
        for (int i = 0; i < this.etmModel.getRowCount(); ++i) {
            this.etmModel.setCellEditable(i, 2, bl);
        }
    }

    public TableCellRenderer getComboBoxRenderer(Vector vector) {
        return new EtmComboBoxRenderer(vector);
    }

    public void setEtmTableCellEditor() {
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(false);
        int n = 2;
        TableColumn tableColumn = this.etmTable.getColumnModel().getColumn(n);
        tableColumn.setCellEditor(new DefaultCellEditor(jCheckBox));
        tableColumn.setCellRenderer(new DeleteLinkCheckBoxRenderer());
        for (int i = 0; i < this.etmModel.getRowCount(); ++i) {
            this.etmModel.setCellEditable(i, 2, true);
        }
    }

    public void setTableHeader() {
        Vector<String> vector = new Vector<String>();
        vector.add("Slot");
        vector.add("Existing ETM type");
        vector.add("Delete Transmission Link");
        this.etmModel.setColumnIdentifiers(vector);
        this.etmTable.doLayout();
        this.setColumnWidth("Slot", 7);
        this.setColumnWidth("Existing ETM type", 7);
        this.setColumnWidth("Delete Transmission Link", 7);
        this.etmTable.doLayout();
    }

    private void setColumnWidth(String string, int n) {
        TableColumn tableColumn = this.etmTable.getColumn(string);
        int n2 = string.length() * n;
        tableColumn.setPreferredWidth(n2);
        tableColumn.setResizable(false);
    }

    static class DeleteLinkCheckBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = (Boolean)object;
            JCheckBox jCheckBox = new JCheckBox();
            if (bl3) {
                jCheckBox.setSelected(true);
            }
            return jCheckBox;
        }
    }

    static class EtmComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        public EtmComboBoxRenderer(Vector vector) {
            super(vector);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl && !bl2) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setSelectedItem(object);
            return this;
        }
    }

    class EtmTableModel
    extends DefaultTableModel {
        final String[] columnNames = new String[]{"REPLACE_DELETE_ETM_SLOT_COLUMN_HEADER", "REPLACE_DELETE_ETM_EXISTING_BOARD_COLUMN_HEADER", "REPLACE_DELETE_ETM_NEW_BOARD_COLUMN_HEADER"};
        private Vector editableCells = new Vector();
        private Boolean[] editableRow = new Boolean[3];
        private Object[][] rowData = new Object[][]{{"2", "Etm1", "NONE"}};

        public EtmTableModel() {
            super.setDataVector(this.rowData, this.columnNames);
            this.editableRow[0] = false;
            this.editableRow[1] = false;
            this.editableRow[2] = false;
            this.editableCells.addElement(this.editableRow);
            this.addTableModelListener(new EtmTableModelListener());
        }

        public boolean isCellEditable(int n, int n2) {
            Boolean[] booleanArray = (Boolean[])this.editableCells.get(n);
            return booleanArray[n2];
        }

        public void setCellEditable(int n, int n2, boolean bl) {
            Boolean[] booleanArray = (Boolean[])this.editableCells.get(n);
            booleanArray[n2] = bl;
            this.editableCells.set(n, booleanArray);
        }

        public void addRowCellEditable(boolean[] blArray) {
            Boolean[] booleanArray = new Boolean[]{blArray[0], blArray[1], blArray[2]};
            this.editableCells.addElement(booleanArray);
        }

        class EtmTableModelListener
        implements TableModelListener {
            EtmTableModelListener() {
            }

            public void tableChanged(final TableModelEvent tableModelEvent) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        try {
                            int n = tableModelEvent.getColumn();
                            int n2 = tableModelEvent.getFirstRow();
                            if (n != 2) {
                                return;
                            }
                            Boolean bl = (Boolean)ReplaceEtmView.this.etmTable.getValueAt(n2, n);
                            try {
                                if (!ReplaceEtmView.this.etmTable.getValueAt(0, 2).equals(bl)) {
                                    ReplaceEtmView.this.etmTable.setValueAt(bl, 0, 2);
                                }
                                if (!ReplaceEtmView.this.etmTable.getValueAt(1, 2).equals(bl)) {
                                    ReplaceEtmView.this.etmTable.setValueAt(bl, 1, 2);
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                // empty catch block
                            }
                            if (bl.booleanValue()) {
                                ReplaceEtmView.this.okButton.setEnabled(true);
                            } else {
                                ReplaceEtmView.this.okButton.setEnabled(false);
                            }
                        }
                        catch (ClassCastException classCastException) {
                            // empty catch block
                        }
                    }
                };
                Thread thread = new Thread(runnable);
                thread.start();
            }
        }
    }
}

