/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.client.clients.cli.function;

import se.ericsson.wcdma.rbs.bem.client.clients.cli.control.CliController;
import se.ericsson.wcdma.rbs.bem.client.clients.cli.function.AbstractFunction;
import se.ericsson.wcdma.rbs.bem.client.clients.cli.function.CabinetWizard;
import se.ericsson.wcdma.rbs.bem.client.clients.cli.function.IubWizard;
import se.ericsson.wcdma.rbs.bem.client.clients.cli.function.SiteWizard;
import se.ericsson.wcdma.rbs.bem.client.clients.cli.util.CliLog;
import se.ericsson.wcdma.rbs.bem.client.clients.cli.xml.XmlEntity;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public class NpcWizard
extends AbstractFunction {
    Rbs rbs;

    public NpcWizard(String[] stringArray, CliController cliController) {
        super(stringArray, cliController);
    }

    public void execute() {
        XmlEntity xmlEntity = this.getCliController().getXmlEntity();
        try {
            this.handleNpcCabinet(xmlEntity);
            if (xmlEntity.isOk()) {
                this.handleNpcIub(xmlEntity);
                if (xmlEntity.isOk()) {
                    this.handleNpcSite(xmlEntity);
                }
            }
        }
        catch (Exception exception) {
            xmlEntity.addErrorMessage("NpcWizard exception=" + exception.toString(), exception);
            xmlEntity.endApplication();
        }
    }

    private void handleNpcCabinet(XmlEntity xmlEntity) throws BemException {
        xmlEntity.beginApplication(this.getFunctionName() + " NPC Cabinet");
        String string = super.getArgument(2);
        CliLog.log("NpcWizard.handleNpcCabinet(), xmlfile name=" + string);
        CabinetWizard cabinetWizard = new CabinetWizard(super.getArguments(), super.getCliController());
        cabinetWizard.execute(string);
        this.rbs = cabinetWizard.getRbs();
        xmlEntity.endApplication();
    }

    private void handleNpcSite(XmlEntity xmlEntity) throws BemException {
        xmlEntity.beginApplication(this.getFunctionName() + " NPC Site");
        String string = super.getArgument(3);
        CliLog.log("NpcWizard.handleNpcSite(), xmlfile name=" + string);
        SiteWizard siteWizard = new SiteWizard(super.getArguments(), super.getCliController());
        siteWizard.execute(string);
        xmlEntity.endApplication();
    }

    private void handleNpcIub(XmlEntity xmlEntity) throws Exception {
        xmlEntity.beginApplication(this.getFunctionName() + " NPC Iub");
        String string = super.getArgument(4);
        CliLog.log("NpcWizard.handleNpcSiteIub(), xmlfile name=" + string);
        IubWizard iubWizard = new IubWizard(super.getArguments(), super.getCliController());
        iubWizard.execute(string);
        xmlEntity.endApplication();
        xmlEntity.endApplication();
    }
}

