/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeSet;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.AbstractEtmBoardManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.AtmAndPtUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.DuwEtmBoardManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.EtmBoardManagerFactory;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.RIAndCPWrapper;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.RIManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.StandardManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.AtmPortParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.EtbSlotParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.ExistOnNodeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.IpOverAtmLinkParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.LocationParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.PhysicalLineParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.ReqNoOfLinksMomConverter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.ReqNoOfLinksParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.StandardParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationParameterList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationTypeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TimeSlotsInFractionParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.UninstallParameterList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.ipoveratm.DuwDefaultIpOverAtmTerminationTypeListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.ipoveratm.IpOverAtmManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.ipoveratm.IpOverAtmRegistrator;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.ipoveratm.IpOverAtmUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.loader.TerminationLoader;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.DuwEtm4Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.DuwEtmc41Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.AtmPortProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.IpOverAtmProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.LocationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.PhysicalTerminationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.AbstractTerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.AtmPortRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.AtmRepertoireRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.FractionalRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.ImaRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.termination.TerminationData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.DynamicCustomerParameterProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ListRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceNameValue;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class AtmAndPtCI
extends AbstractConfigurationItem
implements CustomerParameterListener,
AtmPortProvider,
LocationProvider,
DynamicCustomerParameterProvider,
PhysicalTerminationProvider,
IpOverAtmProvider {
    public static final String name = "AtmAndPtCI";
    public static final boolean ATM = true;
    public static final boolean PPT = false;
    public static final int MAX_NO_OF_LINES = 84;
    public static final int MAX_NO_OF_LINKS = 28;
    public static final int MAX_NO_OF_TIME_SLOTS = 31;
    public static final String REASON_MAX_NO_OF_LINKS = "Number of required links can NOT be more than number of lines!";
    public static final String REASON_VALUE_NOT_CHANGABLE = "Value not changable!";
    public static final String ATMPORT = "AtmPort";
    public static final String PHYSICAL_TERM = "Physical_Termination";
    private static final String[] IP_ATM_PSEUDO_PREFIX = new String[]{"firstOAMatm_", "secondOAMatm_"};
    private static boolean isOnSiteLocation = false;
    private static final String LOADED = "Loaded";
    private static final String LOADED_PSEUDO_PREFIX = "LoadedTerm{0}_";
    private static final String PARAMETER_LIST_PSEUDO = "TerminationParameterList_{0}";
    private static final String DELETE_PARAMETER_LIST_PSEUDO = "DeleteParameterList_{0}";
    private static final String INVALID_TERMINATION_TYPES = "Invalid Termination Types";
    private static final String PSEUDO_IP_OVER_ATM_LINK = "IpOverAtmLink";
    private static final String PSEUDO_EXISTS_ON_NODE = "ExistsOnNode";
    private static String TIMESLOTS_IN_FRACTION_DEFAULT = "1,2,3,4,5,6,7,8,9,10";
    private final boolean[] ip_atm_link_created = new boolean[]{false, false};
    private LocationParameter locationParameter;
    private boolean isOpen = false;
    private RIManager theRIManager = null;
    private int loadedPseudoCounter = 1;
    private int loadedAtmPortPseudoCounter = 1;
    private int parameterListCounter = 1;
    private int atmPortCounter = 1;
    private int uninstallParameterListCounter = 1;
    private boolean isXMLFileInUse = false;
    private List listOfLoadedRIAndCPWrappers = new ArrayList();
    private List listOfNewRIAndCPWrappers = new ArrayList();
    private List listOfNewRIAndCPWrappersForDuwV2 = new ArrayList();
    private String configErrorReason = null;
    private List parameterListsForUninstall = new ArrayList();
    private String[] etbSlotRange = null;
    private String[] unfilteredTerminationTypeRange = null;
    private String[] currentTerminationTypeRange = null;
    private String[] standardRange = null;
    private ListRange physicalLineRange = null;
    private ListRange timeSlotsRange = null;
    private IntegerRange requiredNumberOfLinksRange = null;
    private String[] disallowedTerminationTypesUsingGbitEthernet = new String[]{"IMA_Chan_STM1_E1", "OC3", "Chan_STM1_E1", "Chan_OC3_T1", "IMA_Chan_OC3_T1", "STM1_ETSI", "STM1_TTC"};
    private boolean isDuwStm1Configured;
    private AbstractEtmBoardManager boardManager = null;
    private TerminationLoader terminationLoader = null;
    StandardManager standardManager = null;
    IpOverAtmRegistrator ipOverAtmManager = null;
    private static final String FRACTIONAL_RESTRICTION_REASON = "All and only all of the time slots in the default \nIP/ATM link fractional configuration must be used by\n the redundant IP/ATM link fractional configuration";
    private static final String LINES_IN_IMA_REASON = "Either none of the lines or all of the lines in the\ndefault IP/ATM link IMA configuration must be used by\nthe redundant IP/ATM link IMA configuration";
    private static final String OCCUPIED_LINE_REASON = "The redundant IP/ATM link tries to use an occupied physical line";
    private static final IntegerRange NO_OF_IMA_GROUPS_RANGE = new IntegerRange(1, 14);
    private DuwDefaultIpOverAtmTerminationTypeListener defaultLinkTermTypeListener;
    private List existingTerminations = new ArrayList();
    private AtmRepertoireRI atmRepertoireRI;

    public static String getIpAtmPseudoPrefixByIndex(int n) {
        return IP_ATM_PSEUDO_PREFIX[n];
    }

    public AtmAndPtCI(Rbs rbs) {
        super(rbs);
        this.atmRepertoireRI = new AtmRepertoireRI(rbs);
    }

    protected AbstractEtmBoardManager getEtmBoardManager() {
        return this.boardManager;
    }

    protected TerminationLoader getTerminationLoader() {
        return this.terminationLoader;
    }

    public boolean open() throws BemException {
        if (this.isOpen) {
            throw new BemException("AtmAndPtCI.open(): Already open");
        }
        EtmBoardProvider etmBoardProvider = (EtmBoardProvider)this.rbs.getProvider(EtmBoardProvider.class);
        AbstractTerminationRI.setLoadedStandard(null);
        this.standardManager = new StandardManager();
        this.ipOverAtmManager = new IpOverAtmManager();
        this.boardManager = EtmBoardManagerFactory.createBoardManager(this.rbs, this, etmBoardProvider);
        this.terminationLoader = new TerminationLoader(this, this.boardManager, etmBoardProvider);
        this.theRIManager = new RIManager(this.rbs, etmBoardProvider, this.boardManager);
        this.boardManager.loadAllEtmsFromNode();
        this.initCustomerParameterRanges();
        if (this.boardManager.isEtmBoardsExistingOnNode()) {
            this.terminationLoader.loadAllTerminations();
        }
        ImaRI.resetUsedImaIds();
        this.createCPForLocation();
        this.isOpen = true;
        return this.isOpen;
    }

    public void afterOpen() throws BemException {
        CustomerParameter customerParameter = this.rbs.getCustomerParameterObject("gigaBitEthernetPortCreate");
        customerParameter.addCustomerParameterListener(new GigabitEthernetPortCreateListener());
        Enumeration enumeration = (Enumeration)this.getRbs().getCustomerParameterObject("gigaBitEthernetPort");
        enumeration.addCustomerParameterListener(new GigabitPortListener());
    }

    public boolean isEtmBoardsExistingOnNode() {
        return this.boardManager.isEtmBoardsExistingOnNode();
    }

    public RIAndCPWrapper addTermination(boolean bl, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws BemException {
        TerminationParameterList terminationParameterList = this.createCustomerParameters(bl, string, string2, string3, string4, string5, string6, string7, string8);
        terminationParameterList.getIpOverAtmLinkParameter().setLoadedValue("NO");
        terminationParameterList.getExistOnNodeParameter().setValue("NO");
        RIAndCPWrapper rIAndCPWrapper = this.theRIManager.createRIsForTermination(terminationParameterList, null, null, null, null, null);
        this.listOfNewRIAndCPWrappers.add(rIAndCPWrapper);
        return rIAndCPWrapper;
    }

    public void addAdditionalTerminationForDuwV2(TerminationParameterList terminationParameterList) throws BemException {
        this.listOfNewRIAndCPWrappersForDuwV2.addAll(this.listOfLoadedRIAndCPWrappers);
    }

    public void addLoadedTermination(String string, String string2, String string3, String[] stringArray, TerminationData terminationData) throws BemException {
        Object object;
        String string4 = null;
        boolean bl = false;
        if (string != null) {
            bl = true;
            object = new Integer(this.loadedAtmPortPseudoCounter);
            string4 = MessageFormat.format("AtmPort_{0}_", object);
            ++this.loadedAtmPortPseudoCounter;
        } else {
            object = new Integer(this.loadedPseudoCounter);
            ++this.loadedPseudoCounter;
            string4 = MessageFormat.format(LOADED_PSEUDO_PREFIX, object);
        }
        object = string4 + "etbSlot";
        String string5 = string4 + "terminationType";
        String string6 = string4 + "standard";
        String string7 = string4 + "physicalLine";
        String string8 = string4 + "timeSlotsInFraction";
        String string9 = string4 + "requiredNumberOfLinks";
        String string10 = string4 + PSEUDO_IP_OVER_ATM_LINK;
        String string11 = string4 + PSEUDO_EXISTS_ON_NODE;
        TerminationParameterList terminationParameterList = this.createCustomerParameters(bl, (String)object, string5, string6, string7, string8, string9, string10, string11);
        String[] stringArray2 = terminationData.getLineNumbers();
        IpOverAtmLinkParameter ipOverAtmLinkParameter = terminationParameterList.getIpOverAtmLinkParameter();
        ipOverAtmLinkParameter.setLoadedValue("NO");
        ipOverAtmLinkParameter.getRestriction().setAccessLevel(0);
        ExistOnNodeParameter existOnNodeParameter = terminationParameterList.getExistOnNodeParameter();
        existOnNodeParameter.setLoadedValue("YES");
        existOnNodeParameter.getRestriction().setAccessLevel(0);
        RIAndCPWrapper rIAndCPWrapper = this.theRIManager.createRIsForTermination(terminationParameterList, string, string2, string3, stringArray, stringArray2);
        this.listOfLoadedRIAndCPWrappers.add(rIAndCPWrapper);
        this.updateLoadedValues(terminationParameterList, terminationData, string, string2);
    }

    public void addLoadedIpAtmLinkTermination(Integer n, String string, String string2, String string3, String[] stringArray, TerminationData terminationData) throws BemException {
        int n2 = n;
        this.ip_atm_link_created[n2] = true;
        String string4 = IP_ATM_PSEUDO_PREFIX[n2];
        boolean bl = true;
        String string5 = string4 + "etbSlot";
        String string6 = string4 + "terminationType";
        String string7 = string4 + "standard";
        String string8 = string4 + "physicalLine";
        String string9 = string4 + "timeSlotsInFraction";
        String string10 = string4 + "requiredNumberOfLinks";
        String string11 = string4 + PSEUDO_IP_OVER_ATM_LINK;
        String string12 = string4 + PSEUDO_EXISTS_ON_NODE;
        TerminationParameterList terminationParameterList = this.createCustomerParameters(bl, string5, string6, string7, string8, string9, string10, string11, string12);
        IpOverAtmLinkParameter ipOverAtmLinkParameter = terminationParameterList.getIpOverAtmLinkParameter();
        ipOverAtmLinkParameter.setLoadedValue("YES");
        ipOverAtmLinkParameter.getRestriction().setAccessLevel(0);
        ExistOnNodeParameter existOnNodeParameter = terminationParameterList.getExistOnNodeParameter();
        existOnNodeParameter.setLoadedValue("YES");
        existOnNodeParameter.getRestriction().setAccessLevel(0);
        String[] stringArray2 = terminationData.getLineNumbers();
        RIAndCPWrapper rIAndCPWrapper = this.theRIManager.createRIsForTermination(terminationParameterList, string, string2, string3, stringArray, stringArray2);
        this.listOfLoadedRIAndCPWrappers.add(rIAndCPWrapper);
        this.listOfNewRIAndCPWrappersForDuwV2.add(rIAndCPWrapper);
        this.updateLoadedValues(terminationParameterList, terminationData, string, string2);
        this.ipOverAtmManager.registerIpOverAtmParameter(n2, terminationParameterList);
    }

    private void updateLoadedValues(TerminationParameterList terminationParameterList, TerminationData terminationData, String string, String string2) throws BemException {
        Object object;
        String string3;
        TerminationTypeParameter terminationTypeParameter = null;
        if (DuwUtil.hasDuw()) {
            terminationTypeParameter = terminationParameterList.getTerminationTypeParameter();
            string3 = terminationData.getTerminationType();
            terminationTypeParameter.setLoadedValue(string3);
            terminationTypeParameter.setValue(string3);
        }
        string3 = terminationData.getSlotNumber();
        EtbSlotParameter etbSlotParameter = terminationParameterList.getSlotParameter();
        etbSlotParameter.setLoadedValue(string3);
        etbSlotParameter.setValue(string3);
        String string4 = terminationData.getStandard();
        StandardParameter standardParameter = terminationParameterList.getStandardParameter();
        standardParameter.setLoadedValue(string4);
        standardParameter.setValue(string4);
        if (AbstractTerminationRI.getLoadedStandard() == null) {
            AbstractTerminationRI.setLoadedStandard(string4);
        }
        this.standardManager.registerStandardCP(standardParameter);
        if (!DuwUtil.hasDuw()) {
            terminationTypeParameter = terminationParameterList.getTerminationTypeParameter();
            object = terminationData.getTerminationType();
            terminationTypeParameter.setLoadedValue(object);
            terminationTypeParameter.setValue((String)object);
        }
        object = terminationData.getLineNumbers();
        String string5 = BemUtil.getCommaSeparatedValueString(object);
        PhysicalLineParameter physicalLineParameter = terminationParameterList.getLineParameter();
        physicalLineParameter.setLoadedValue(string5);
        physicalLineParameter.setValue(string5);
        String string6 = terminationData.getRequiredNumberOfLinks();
        ReqNoOfLinksParameter reqNoOfLinksParameter = terminationParameterList.getRequiredNumberOfLinksParameter();
        ParameterRestriction parameterRestriction = reqNoOfLinksParameter.getRestriction();
        if (string6 != null) {
            reqNoOfLinksParameter.setLoadedValue(string6);
            reqNoOfLinksParameter.setValue(string6);
            parameterRestriction.setAccessLevel(0);
        } else {
            parameterRestriction.setAccessLevel(1);
        }
        TimeSlotsInFractionParameter timeSlotsInFractionParameter = terminationParameterList.getTimeSlotsInFractionParameter();
        String[] stringArray = terminationData.getTimeSlotsInFraction();
        String string7 = BemUtil.getCommaSeparatedValueString(stringArray);
        timeSlotsInFractionParameter.setLoadedValue(string7);
        timeSlotsInFractionParameter.setValue(string7);
        parameterRestriction = timeSlotsInFractionParameter.getRestriction();
        parameterRestriction.setAccessLevel(0);
        ExistOnNodeParameter existOnNodeParameter = terminationParameterList.getExistOnNodeParameter();
        existOnNodeParameter.setLoadedValue("YES");
        IpOverAtmLinkParameter ipOverAtmLinkParameter = terminationParameterList.getIpOverAtmLinkParameter();
        parameterRestriction = etbSlotParameter.getRestriction();
        if (!DuwUtil.isPrimaryDuwV2()) {
            parameterRestriction.setAccessLevel(0);
        }
        parameterRestriction = standardParameter.getRestriction();
        parameterRestriction.setAccessLevel(0);
        parameterRestriction = terminationTypeParameter.getRestriction();
        if (!DuwUtil.isPrimaryDuwV2()) {
            parameterRestriction.setAccessLevel(0);
        }
        String string8 = terminationTypeParameter.getValue();
        String[] stringArray2 = DuwEtmc41Mapping.getAllTerminationTypes();
        boolean bl = BemUtil.isStringInArray(string8, stringArray2);
        stringArray2 = DuwEtm4Mapping.getAllTerminationTypes();
        boolean bl2 = BemUtil.isStringInArray(string8, stringArray2);
        if (!bl && !bl2) {
            this.setIsDuwStm1Configured(false);
        } else {
            this.setIsDuwStm1Configured(true);
        }
        parameterRestriction = physicalLineParameter.getRestriction();
        if (!DuwUtil.isPrimaryDuwV2()) {
            parameterRestriction.setAccessLevel(0);
        }
        parameterRestriction = timeSlotsInFractionParameter.getRestriction();
        parameterRestriction.setAccessLevel(0);
        parameterRestriction = existOnNodeParameter.getRestriction();
        parameterRestriction.setAccessLevel(0);
        parameterRestriction = ipOverAtmLinkParameter.getRestriction();
        parameterRestriction.setAccessLevel(0);
    }

    public void deleteAtmPort(String string, int n) throws MoHandlerException, BemException {
        AtmPortParameter atmPortParameter = new AtmPortParameter(string);
        if (DuwUtil.isPrimaryDuwV2() && this.isLmSwapNeeded() && !this.listOfLoadedRIAndCPWrappers.isEmpty()) {
            atmPortParameter.setValue(((RIAndCPWrapper)this.listOfLoadedRIAndCPWrappers.get(n)).getAtmPortRI().getAtmPortRdnId());
        }
        if (atmPortParameter.getValue() != "##UNDEFINED" || !DuwUtil.isPrimaryDuwV2() || !this.isLmSwapNeeded()) {
            this.parameterListsForUninstall.add(atmPortParameter);
        }
        this.addParameter(atmPortParameter);
    }

    public void deleteTermination(String string, String string2, int n) throws BemException {
        EtbSlotParameter etbSlotParameter = new EtbSlotParameter(string, this.etbSlotRange);
        EnumeratedRange enumeratedRange = new EnumeratedRange(this.etbSlotRange);
        etbSlotParameter.setRangeInRestriction(enumeratedRange, true);
        PhysicalLineParameter physicalLineParameter = new PhysicalLineParameter(string2, this.physicalLineRange, 1, 84, false, true);
        physicalLineParameter.setRangeInRestriction(this.physicalLineRange, true);
        Integer n2 = new Integer(this.uninstallParameterListCounter++);
        String string3 = MessageFormat.format(DELETE_PARAMETER_LIST_PSEUDO, n2);
        UninstallParameterList uninstallParameterList = new UninstallParameterList(string3, etbSlotParameter, physicalLineParameter);
        this.parameterListsForUninstall.add(uninstallParameterList);
        uninstallParameterList.addCustomerParameterListener(this);
        this.addParameter(etbSlotParameter);
        this.addParameter(physicalLineParameter);
    }

    protected TerminationParameterList createCustomerParameters(boolean bl, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws BemException {
        Object object;
        EtbSlotParameter etbSlotParameter = new EtbSlotParameter(string, this.etbSlotRange);
        String[] stringArray = this.getTerminationTypeRange();
        EnumeratedRange enumeratedRange = new EnumeratedRange(this.etbSlotRange);
        etbSlotParameter.setRangeInRestriction(enumeratedRange, true);
        TerminationTypeParameter terminationTypeParameter = null;
        terminationTypeParameter = new TerminationTypeParameter(string2, stringArray);
        if (stringArray.length > 0) {
            terminationTypeParameter.setDefaultValue(stringArray[0]);
        }
        EnumeratedRange enumeratedRange2 = new EnumeratedRange(stringArray);
        terminationTypeParameter.setRangeInRestriction(enumeratedRange2, true);
        if (DuwUtil.hasDuw() && string2.startsWith("ATM")) {
            this.addDefaultLinkTermTypeListener(terminationTypeParameter, true);
        }
        if (DuwUtil.hasDuw() && string2.startsWith("first") && stringArray.length >= 1) {
            object = (DuwEtmBoardManager)this.boardManager;
            ((DuwEtmBoardManager)object).setFirstFoundTerminationType(stringArray[0]);
        }
        object = new StandardParameter(string3, this.standardRange);
        this.standardManager.registerStandardCP((StandardParameter)object);
        PhysicalLineParameter physicalLineParameter = new PhysicalLineParameter(string4, this.physicalLineRange, 1, 84, false, true);
        physicalLineParameter.setRangeInRestriction(this.physicalLineRange, true);
        physicalLineParameter.setDefaultValue("1");
        TimeSlotsInFractionParameter timeSlotsInFractionParameter = new TimeSlotsInFractionParameter(string5, this.timeSlotsRange, 0, 31, false, true);
        timeSlotsInFractionParameter.getRestriction().setAccessLevel(1);
        timeSlotsInFractionParameter.getRestriction().setActive(true);
        ReqNoOfLinksParameter reqNoOfLinksParameter = new ReqNoOfLinksParameter(string6, this.requiredNumberOfLinksRange);
        reqNoOfLinksParameter.getRestriction().setAccessLevel(2);
        ReqNoOfLinksMomConverter reqNoOfLinksMomConverter = new ReqNoOfLinksMomConverter();
        reqNoOfLinksParameter.setMomConverter(reqNoOfLinksMomConverter);
        reqNoOfLinksParameter.setDefaultValue("1");
        reqNoOfLinksParameter.setLoadedValue("1");
        ExistOnNodeParameter existOnNodeParameter = new ExistOnNodeParameter(string8);
        IpOverAtmLinkParameter ipOverAtmLinkParameter = new IpOverAtmLinkParameter(string7);
        Integer n = new Integer(this.parameterListCounter);
        String string9 = MessageFormat.format(PARAMETER_LIST_PSEUDO, n);
        ++this.parameterListCounter;
        TerminationParameterList terminationParameterList = new TerminationParameterList(string9, bl, etbSlotParameter, terminationTypeParameter, (StandardParameter)object, physicalLineParameter, timeSlotsInFractionParameter, reqNoOfLinksParameter, ipOverAtmLinkParameter, existOnNodeParameter);
        this.addParameter(etbSlotParameter);
        this.addParameter(terminationTypeParameter);
        this.addParameter(physicalLineParameter);
        this.addParameter(timeSlotsInFractionParameter);
        this.addParameter(reqNoOfLinksParameter);
        terminationParameterList.addCustomerParameterListener(this);
        this.existingTerminations.add(terminationTypeParameter);
        return terminationParameterList;
    }

    void setTerminationTypeRange(List list) {
        this.currentTerminationTypeRange = new String[list.size()];
        list.toArray(this.currentTerminationTypeRange);
    }

    void setTerminationTypeRange(String[] stringArray) {
        this.currentTerminationTypeRange = stringArray;
    }

    String[] getTerminationTypeRange() {
        return this.currentTerminationTypeRange;
    }

    void filterTerminaionRangesForGbitEthernet() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(this.disallowedTerminationTypesUsingGbitEthernet));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.unfilteredTerminationTypeRange.length; ++i) {
            if (hashSet.contains(this.unfilteredTerminationTypeRange[i])) continue;
            arrayList.add(this.unfilteredTerminationTypeRange[i]);
        }
        this.setTerminationTypeRange(arrayList);
        EnumeratedRange enumeratedRange = new EnumeratedRange(arrayList);
        ParameterEvent parameterEvent = new ParameterEvent(2);
        ListIterator listIterator = this.existingTerminations.listIterator();
        while (listIterator.hasNext()) {
            TerminationTypeParameter terminationTypeParameter = (TerminationTypeParameter)listIterator.next();
            terminationTypeParameter.setRangeInRestriction(enumeratedRange, true);
            terminationTypeParameter.notifyAllListeners(parameterEvent);
        }
    }

    void restoreTerminationRanges() {
        this.setTerminationTypeRange(this.unfilteredTerminationTypeRange);
        EnumeratedRange enumeratedRange = new EnumeratedRange(this.unfilteredTerminationTypeRange);
        ListIterator listIterator = this.existingTerminations.listIterator();
        while (listIterator.hasNext()) {
            TerminationTypeParameter terminationTypeParameter = (TerminationTypeParameter)listIterator.next();
            terminationTypeParameter.setRangeInRestriction(enumeratedRange, true);
        }
    }

    protected void initCustomerParameterRanges() throws BemException {
        this.unfilteredTerminationTypeRange = this.boardManager.getAllSupportedTerminationTypes();
        this.currentTerminationTypeRange = this.unfilteredTerminationTypeRange;
        this.standardRange = this.boardManager.getAllSupportedStandards();
        String[] stringArray = this.boardManager.getAllSupportedSlots();
        this.etbSlotRange = new String[stringArray.length + 1];
        this.etbSlotRange[0] = "None";
        for (int i = 0; i < stringArray.length; ++i) {
            this.etbSlotRange[i + 1] = stringArray[i];
        }
        this.physicalLineRange = new ListRange(new IntegerRange(1, 84));
        this.requiredNumberOfLinksRange = new IntegerRange(1, 28);
        this.timeSlotsRange = new ListRange(new IntegerRange(1, 31));
    }

    public ArrayList getNeededRIs() throws BemException {
        if (!this.isOpen) {
            throw new BemException("AtmAndPtCI is not open");
        }
        ArrayList arrayList = this.theRIManager.getNeededRIs(this.listOfNewRIAndCPWrappers);
        if (DuwUtil.isPrimaryDuwV2() && this.isLmSwapNeeded()) {
            arrayList.addAll(this.theRIManager.getNeededRIs(this.listOfNewRIAndCPWrappersForDuwV2));
            for (int i = 0; i < this.listOfNewRIAndCPWrappersForDuwV2.size(); ++i) {
                RIAndCPWrapper rIAndCPWrapper = (RIAndCPWrapper)this.listOfNewRIAndCPWrappersForDuwV2.get(i);
                AtmPortRI atmPortRI = rIAndCPWrapper.getAtmPortRI();
                atmPortRI.setToBeInstalled();
                TerminationParameterList terminationParameterList = rIAndCPWrapper.getParamList();
                String string = terminationParameterList.getSlotParameter().getValue();
                ImaRI imaRI = rIAndCPWrapper.getImaRI();
                imaRI.setToBeInstalled();
                FractionalRI fractionalRI = rIAndCPWrapper.getFractionalRI();
                fractionalRI.setToBeInstalled();
                Map map = rIAndCPWrapper.getTerminationRIs();
                AbstractTerminationRI abstractTerminationRI = (AbstractTerminationRI)map.get(string);
                abstractTerminationRI.setToBeInstalled();
            }
        }
        arrayList.add(this.atmRepertoireRI);
        this.handleDuplicatedImaRIs(arrayList);
        return arrayList;
    }

    public List getRIsToUninstall() throws BemException {
        if (!this.isOpen) {
            throw new BemException("AtmAndPtCI is not open");
        }
        if (DuwUtil.isPrimaryDuwV2() && this.isLmSwapNeeded()) {
            this.prepareRIsBeforeUninstallOfDuwV2();
        }
        ArrayList arrayList = this.theRIManager.getRIsToUninstall(this.listOfLoadedRIAndCPWrappers);
        arrayList.add(this.atmRepertoireRI);
        return arrayList;
    }

    public void prepareRIsBeforeUninstallOfDuwV2() throws BemException {
        for (int i = 0; i < 2; ++i) {
            try {
                String string = MessageFormat.format("DeleteAtmPort{0}_", new Integer(i));
                String string2 = string + "rdnId";
                this.deleteAtmPort(string2, i);
                string = MessageFormat.format("DeletePhysPathTerm{0}_", new Integer(i));
                String string3 = string + "etbSlot";
                String string4 = string + "physicalLine";
                this.deleteTermination(string3, string4, i);
                continue;
            }
            catch (MoHandlerException moHandlerException) {
                throw new BemException("Failed in prepareRIsBeforeUninstallOfDuwV2() with MoHandlerException, could be deleteAtmPort or deleteTermination", (Throwable)moHandlerException);
            }
        }
        this.theRIManager.checkRIsToBeUninstalled(this.listOfLoadedRIAndCPWrappers, this.parameterListsForUninstall);
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        try {
            if (parameterEvent.isValueChanged()) {
                TerminationParameterList terminationParameterList;
                Iterator iterator;
                Object object2;
                if (customerParameter == this.locationParameter) {
                    isOnSiteLocation = this.locationParameter.getValue().equals("On Site");
                    return;
                }
                if (customerParameter instanceof TerminationParameterList && (object2 = ((TerminationParameterList)((Object)(iterator = (TerminationParameterList)customerParameter))).getChangedParameter()) instanceof ReqNoOfLinksParameter) {
                    return;
                }
                iterator = this.listOfLoadedRIAndCPWrappers.iterator();
                this.configErrorReason = null;
                while (iterator.hasNext()) {
                    object2 = (RIAndCPWrapper)iterator.next();
                    terminationParameterList = ((RIAndCPWrapper)object2).getParamList();
                    if (terminationParameterList != customerParameter) continue;
                    ((RIAndCPWrapper)object2).updateRiReferences();
                    IpOverAtmLinkParameter ipOverAtmLinkParameter = terminationParameterList.getIpOverAtmLinkParameter();
                    if (ipOverAtmLinkParameter.getValue().equals("YES")) {
                        this.updateCPForIpOverAtmLink(terminationParameterList);
                    } else {
                        this.updateCustomerParameters(terminationParameterList);
                    }
                    return;
                }
                for (Object object2 : this.listOfNewRIAndCPWrappers) {
                    terminationParameterList = ((RIAndCPWrapper)object2).getParamList();
                    if (terminationParameterList != customerParameter) continue;
                    ((RIAndCPWrapper)object2).updateRiReferences();
                    IpOverAtmLinkParameter ipOverAtmLinkParameter = terminationParameterList.getIpOverAtmLinkParameter();
                    if (ipOverAtmLinkParameter.getValue().equals("YES")) {
                        this.updateCPForIpOverAtmLink(terminationParameterList);
                    } else {
                        this.updateCustomerParameters(terminationParameterList);
                    }
                    return;
                }
                for (Object object2 : this.listOfNewRIAndCPWrappersForDuwV2) {
                    terminationParameterList = ((RIAndCPWrapper)object2).getParamList();
                    if (terminationParameterList != customerParameter) continue;
                    ((RIAndCPWrapper)object2).updateRiReferences();
                    IpOverAtmLinkParameter ipOverAtmLinkParameter = terminationParameterList.getIpOverAtmLinkParameter();
                    if (ipOverAtmLinkParameter.getValue().equals("YES")) {
                        this.updateCPForIpOverAtmLink(terminationParameterList);
                    } else {
                        this.updateCustomerParameters(terminationParameterList);
                    }
                    return;
                }
            }
        }
        catch (BemException bemException) {
            bemException.printStackTrace();
            throw new Error(bemException.toString());
        }
    }

    private void updateCustomerParameters(TerminationParameterList terminationParameterList) throws BemException {
        ListRange listRange;
        Object object;
        CustomerParameterImpl customerParameterImpl;
        String string = terminationParameterList.getSlotParameter().getValue();
        if (string.equals("##UNDEFINED")) {
            return;
        }
        StandardParameter standardParameter = terminationParameterList.getStandardParameter();
        standardParameter.getRestriction().setAccessLevel(3);
        String[] stringArray = null;
        stringArray = standardParameter.equals(this.standardManager.getFirstStandardCP()) ? this.boardManager.getAvailableTerminationTypes(string, null) : this.boardManager.getAvailableTerminationTypes(string, this.standardManager.getConfiguredStandard());
        if (stringArray == null) {
            this.configErrorReason = INVALID_TERMINATION_TYPES;
            return;
        }
        EnumeratedRange enumeratedRange = new EnumeratedRange(stringArray);
        TerminationTypeParameter terminationTypeParameter = terminationParameterList.getTerminationTypeParameter();
        terminationTypeParameter.setRangeInRestriction(enumeratedRange, true);
        String[] stringArray2 = this.boardManager.getAvailableStandards(string);
        EnumeratedRange enumeratedRange2 = new EnumeratedRange(stringArray2);
        standardParameter.setRangeInRestriction(enumeratedRange2, true);
        String string2 = terminationTypeParameter.getValue();
        String string3 = this.boardManager.getStandard(string, string2);
        if (string3 != null && standardParameter.isValidValue(string3)) {
            standardParameter.setValue(string3);
        } else if (string3 == null) {
            string3 = standardParameter.getValue();
        }
        PhysicalLineParameter physicalLineParameter = terminationParameterList.getLineParameter();
        String[] stringArray3 = null;
        stringArray3 = this.isXMLFileInUse ? this.getAvailableLines(string, false) : this.getAvailableLines(string, terminationParameterList);
        if (stringArray3 != null && stringArray3.length > 0) {
            Integer[] integerArray;
            customerParameterImpl = terminationParameterList.getExistOnNodeParameter();
            if (customerParameterImpl.getLoadedValue().equals("YES")) {
                integerArray = this.boardManager.getLineRange(string, string2);
                object = new ListRange((ParameterRange)integerArray);
                physicalLineParameter.setRangeInRestriction((ParameterRange)object, true);
            } else {
                integerArray = AtmAndPtUtil.convertStringArrayToIntegerArray(stringArray3);
                object = new IntegerRange(integerArray);
                listRange = new ListRange((ParameterRange)object);
                physicalLineParameter.setRangeInRestriction(listRange, true);
            }
            int n = this.boardManager.getMaxNoOfLines(string, string3);
            physicalLineParameter.setLengthRange(1, n);
        }
        customerParameterImpl = terminationParameterList.getRequiredNumberOfLinksParameter();
        if (this.boardManager.isIma(string, string2)) {
            String[] stringArray4 = physicalLineParameter.getAllLines();
            object = new IntegerRange(1, stringArray4.length);
            ((ReqNoOfLinksParameter)customerParameterImpl).getRestriction().setRange((ParameterRange)object, true);
            ((ReqNoOfLinksParameter)customerParameterImpl).getRestriction().setAccessLevel(3);
        } else {
            ((ReqNoOfLinksParameter)customerParameterImpl).getRestriction().setAccessLevel(1);
        }
        TimeSlotsInFractionParameter timeSlotsInFractionParameter = terminationParameterList.getTimeSlotsInFractionParameter();
        if (this.boardManager.isFractional(string, string2)) {
            object = this.boardManager.getMaxNoOfTimeSlots(string, string2);
            timeSlotsInFractionParameter.setLengthRange(1, (Integer)object);
            timeSlotsInFractionParameter.setDefaultValue(TIMESLOTS_IN_FRACTION_DEFAULT);
            listRange = new ListRange(new IntegerRange(1, ((Integer)object).intValue()));
            timeSlotsInFractionParameter.getRestriction().setAccessLevel(3);
            timeSlotsInFractionParameter.setRangeInRestriction(listRange, true);
        } else {
            timeSlotsInFractionParameter.getRestriction().setAccessLevel(1);
        }
    }

    private void updateCPForIpOverAtmLink(TerminationParameterList terminationParameterList) throws BemException {
        Object object;
        Object object2;
        String string;
        EtbSlotParameter etbSlotParameter = terminationParameterList.getSlotParameter();
        String string2 = etbSlotParameter.getValue();
        if (string2.equals("##UNDEFINED")) {
            return;
        }
        if (string2.equals("None")) {
            terminationParameterList.setAsUndefinedCP();
            terminationParameterList.setAsIgnoredCP();
            etbSlotParameter.getRestriction().setAccessLevel(3);
            return;
        }
        etbSlotParameter.getRestriction().setAccessLevel(3);
        StandardParameter standardParameter = terminationParameterList.getStandardParameter();
        standardParameter.getRestriction().setAccessLevel(3);
        String[] stringArray = null;
        stringArray = standardParameter.equals(this.standardManager.getFirstStandardCP()) ? this.boardManager.getAvailableTerminationTypes(string2, null) : this.boardManager.getAvailableTerminationTypes(string2, this.standardManager.getConfiguredStandard());
        if (stringArray == null) {
            this.configErrorReason = INVALID_TERMINATION_TYPES;
            return;
        }
        EnumeratedRange enumeratedRange = new EnumeratedRange(stringArray);
        TerminationTypeParameter terminationTypeParameter = terminationParameterList.getTerminationTypeParameter();
        terminationTypeParameter.setRangeInRestriction(enumeratedRange, true);
        terminationTypeParameter.getRestriction().setAccessLevel(3);
        String string3 = terminationTypeParameter.getValue();
        if (!enumeratedRange.isValueInRange(string3)) {
            terminationTypeParameter.setValue(stringArray[0]);
            terminationTypeParameter.setDefaultValue(stringArray[0]);
            string3 = stringArray[0];
        }
        if ((string = this.boardManager.getStandard(string2, string3)) != null && standardParameter.isValidValue(string)) {
            standardParameter.setValue(string);
        } else if (string == null) {
            string = standardParameter.getValue();
        }
        PhysicalLineParameter physicalLineParameter = terminationParameterList.getLineParameter();
        IpOverAtmLinkParameter ipOverAtmLinkParameter = terminationParameterList.getIpOverAtmLinkParameter();
        ipOverAtmLinkParameter.getRestriction().setAccessLevel(3);
        ExistOnNodeParameter existOnNodeParameter = terminationParameterList.getExistOnNodeParameter();
        existOnNodeParameter.getRestriction().setAccessLevel(3);
        IntegerRange integerRange = this.boardManager.getLineRange(string2, string3);
        int n = integerRange.getMaxValue();
        if (n > 0) {
            object2 = new ListRange(integerRange);
            physicalLineParameter.setRangeInRestriction((ParameterRange)object2, true);
            physicalLineParameter.getRestriction().setAccessLevel(3);
            int n2 = this.boardManager.getMaxNoOfLines(string2, this.standardManager.getConfiguredStandard());
            physicalLineParameter.setLengthRange(1, n2);
        }
        object2 = terminationParameterList.getRequiredNumberOfLinksParameter();
        if (this.boardManager.isIma(string2, string3)) {
            String[] stringArray2 = physicalLineParameter.getAllLines();
            object = new IntegerRange(1, stringArray2.length);
            ((ReqNoOfLinksParameter)object2).getRestriction().setRange((ParameterRange)object, true);
            ((ReqNoOfLinksParameter)object2).getRestriction().setAccessLevel(3);
        } else {
            ((ReqNoOfLinksParameter)object2).getRestriction().setAccessLevel(1);
        }
        TimeSlotsInFractionParameter timeSlotsInFractionParameter = terminationParameterList.getTimeSlotsInFractionParameter();
        if (this.boardManager.isFractional(string2, string3)) {
            object = this.boardManager.getMaxNoOfTimeSlots(string2, string3);
            timeSlotsInFractionParameter.setLengthRange(1, (Integer)object);
            timeSlotsInFractionParameter.setDefaultValue(TIMESLOTS_IN_FRACTION_DEFAULT);
            ListRange listRange = new ListRange(new IntegerRange(1, ((Integer)object).intValue()));
            timeSlotsInFractionParameter.setRangeInRestriction(listRange, true);
            timeSlotsInFractionParameter.getRestriction().setAccessLevel(3);
        } else {
            timeSlotsInFractionParameter.getRestriction().setAccessLevel(1);
        }
    }

    private void updateCPWithValidRangesForDynamicCP(TerminationParameterList terminationParameterList) throws BemException {
        TerminationParameterList[] terminationParameterListArray = this.getAllTerminationParameterLists(true);
        String[] stringArray = null;
        stringArray = terminationParameterListArray == null || this.standardManager.getConfiguredStandard() == null ? this.boardManager.getAvailableSlots() : this.boardManager.getAvailableSlots(terminationParameterListArray, this.standardManager.getConfiguredStandard());
        EnumeratedRange enumeratedRange = new EnumeratedRange(stringArray);
        EtbSlotParameter etbSlotParameter = terminationParameterList.getSlotParameter();
        etbSlotParameter.setRangeInRestriction(enumeratedRange, true);
        IntegerRange integerRange = new IntegerRange(1, 1);
        ReqNoOfLinksParameter reqNoOfLinksParameter = terminationParameterList.getRequiredNumberOfLinksParameter();
        reqNoOfLinksParameter.getRestriction().setRange(integerRange, true);
    }

    private void updateCPWithValidRangesForIpOverAtmLink(TerminationParameterList terminationParameterList) throws BemException {
        EtbSlotParameter etbSlotParameter = terminationParameterList.getSlotParameter();
        int n = etbSlotParameter.getAccessLevel();
        if (n != 0) {
            String[] stringArray;
            String[] stringArray2 = null;
            stringArray2 = this.boardManager.getAvailableSlots(null, this.standardManager.getConfiguredStandard());
            String string = terminationParameterList.getIpOverAtmLinkParameter().getValue();
            if (string.equals("YES") && etbSlotParameter.getName().startsWith(IP_ATM_PSEUDO_PREFIX[1])) {
                stringArray = (String[])stringArray2.clone();
                stringArray2 = new String[stringArray.length + 1];
                stringArray2[0] = "None";
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray2[i + 1] = stringArray[i];
                }
            }
            stringArray = new EnumeratedRange(stringArray2);
            etbSlotParameter.setRangeInRestriction((ParameterRange)stringArray, true);
            IntegerRange integerRange = new IntegerRange(1, 1);
            ReqNoOfLinksParameter reqNoOfLinksParameter = terminationParameterList.getRequiredNumberOfLinksParameter();
            reqNoOfLinksParameter.getRestriction().setRange(integerRange, true);
        }
    }

    protected ArrayList getAllLoadedParameterLists() {
        ArrayList<TerminationParameterList> arrayList = new ArrayList<TerminationParameterList>();
        for (RIAndCPWrapper rIAndCPWrapper : this.listOfLoadedRIAndCPWrappers) {
            arrayList.add(rIAndCPWrapper.getParamList());
        }
        return arrayList;
    }

    protected ArrayList getAllNewParameterLists() {
        ArrayList<TerminationParameterList> arrayList = new ArrayList<TerminationParameterList>();
        for (RIAndCPWrapper rIAndCPWrapper : this.listOfNewRIAndCPWrappers) {
            arrayList.add(rIAndCPWrapper.getParamList());
        }
        return arrayList;
    }

    public void checkConsistency() throws BemException {
        Object object;
        Object object2;
        Object object3;
        super.checkConsistency();
        this.boardManager.checkBoardCombinationConsistency();
        for (int i = 0; i < 2; ++i) {
            String string;
            object3 = IP_ATM_PSEUDO_PREFIX[i];
            object2 = null;
            try {
                object2 = (EtbSlotParameter)this.rbs.getCustomerParameterObject((String)object3 + "etbSlot");
            }
            catch (BemException bemException) {
                // empty catch block
            }
            if (object2 == null || ((String)(object = ((CustomerParameterImpl)object2).getValue())).equals(string = ((CustomerParameterImpl)object2).getLoadedValue()) || string.equals("##UNDEFINED")) continue;
            String string2 = "It is not possible to change etbslot of a configured ATM-link.new Slot: " + (String)object + ",old Slot: " + string;
            throw new BemException(string2);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getAllLoadedParameterLists());
        object3 = this.getAllNewParameterLists();
        object2 = ((ArrayList)object3).iterator();
        while (object2.hasNext()) {
            object = (TerminationParameterList)object2.next();
            if (this.isTerminationParameterListRemoved((TerminationParameterList)object)) continue;
            this.checkForConfigurationErrors((TerminationParameterList)object);
            this.checkConsistencyForStandard((TerminationParameterList)object);
            this.checkConsistencyForNotLoadedCP((TerminationParameterList)object, arrayList);
        }
        this.checkConsistencyAtm();
        this.theRIManager.checkRIsToBeUninstalled(this.listOfLoadedRIAndCPWrappers, this.parameterListsForUninstall);
    }

    public void checkConsistency(List list) throws CustomerParameterException, BemException {
        super.checkConsistency(list);
        this.checkConsistencyAtm();
    }

    private void checkForConfigurationErrors(TerminationParameterList terminationParameterList) throws BemException {
        if (this.configErrorReason != null) {
            if (this.configErrorReason.equals(INVALID_TERMINATION_TYPES)) {
                String string = terminationParameterList.getSlotParameter().getValue();
                String string2 = "Slot " + string + " does NOT support any type of Termination.\n " + "Please check that there is an ET-board in slot " + string + ".\n";
                throw new BemException(string2);
            }
        }
    }

    private void checkConsistencyForStandard(TerminationParameterList terminationParameterList) throws BemException {
        String string = terminationParameterList.getStandardParameter().getValue();
        String string2 = this.standardManager.getConfiguredStandard();
        if (string2 != null && !string2.equals(string)) {
            String string3 = terminationParameterList.getTerminationTypeParameter().getValue();
            String string4 = "The Termination Type MUST be of same standard (" + string2 + ") for the Rbs Node!\n" + "Termination Type: \"" + string3 + "\" interferes with other Termination Type on the Rbs Node!";
            throw new BemException(string4);
        }
    }

    private void checkConsistencyForNotLoadedCP(TerminationParameterList terminationParameterList, ArrayList arrayList) throws BemException {
        boolean bl = terminationParameterList.hasAtmPort();
        String string = terminationParameterList.getSlotParameter().getValue();
        String string2 = terminationParameterList.getLineParameter().getValue();
        for (TerminationParameterList terminationParameterList2 : arrayList) {
            boolean bl2 = terminationParameterList2.hasAtmPort();
            String string3 = terminationParameterList2.getSlotParameter().getValue();
            String string4 = terminationParameterList2.getLineParameter().getValue();
            if (!string.equals(string3) || !string2.equals(string4) || !(!bl2 && !bl || bl2 && !bl) && (!bl2 || !bl)) continue;
            String string5 = "The etbSlot=\"" + string3 + "\" and physicalLine=\"" + string4 + "\" are already occupied!";
            throw new BemException(string5);
        }
    }

    protected void checkConsistencyAtm() throws BemException {
        TerminationData terminationData = this.getIpOverAtmLinkTerminationData(0);
        String string = terminationData.getSlotNumber();
        if (string != null) {
            this.checkUnlockedChannels();
            this.checkMaxImaGroups();
            this.checkIpAtmOverAtmTerminationType();
            this.checkIpOverAtmLines();
            this.checkIpOverAtmSlotsInFraction();
        }
    }

    private void checkUnlockedChannels() throws BemException {
        Object object2;
        if (!DuwUtil.hasDuw()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ParameterRange parameterRange = null;
        List list = this.getConfiguredAtmPorts();
        for (Object object2 : list) {
            String string = ((TerminationParameterList)object2).getTerminationTypeParameter().getValue();
            if (!"Chan_STM1_E1".equals(string) && !"IMA_Chan_STM1_E1".equals(string) && !"Chan_OC3_T1".equals(string) && !"IMA_Chan_OC3_T1".equals(string)) continue;
            PhysicalLineParameter physicalLineParameter = ((TerminationParameterList)object2).getLineParameter();
            if ("IMA_Chan_STM1_E1".equals(string) || "IMA_Chan_OC3_T1".equals(string)) {
                parameterRange = physicalLineParameter.getLengthRange();
            }
            String[] stringArray = physicalLineParameter.getAllLines();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        object2 = "" + arrayList.size();
        if (parameterRange != null && !parameterRange.isValueInRange(object2)) {
            throw new BemException("Too many ETB lines selected. Range is " + parameterRange.getDescription() + " and current selected lines are " + (String)object2 + ".");
        }
    }

    private void checkMaxImaGroups() throws BemException {
        String string;
        Object object2;
        if (!DuwUtil.hasDuw()) {
            return;
        }
        int n = 0;
        List list = this.getConfiguredAtmPorts();
        for (Object object2 : list) {
            string = ((TerminationParameterList)object2).getTerminationTypeParameter().getValue();
            if (!"IMA_Chan_STM1_E1".equals(string) && !"IMA_Chan_OC3_T1".equals(string)) continue;
            ++n;
        }
        object2 = "" + n;
        if (n > 0 && !NO_OF_IMA_GROUPS_RANGE.isValueInRange(object2)) {
            string = "Max number of IMA groups is reached. Range is " + NO_OF_IMA_GROUPS_RANGE.toString() + " and number of groups are " + (String)object2 + ".";
            throw new BemException(string);
        }
    }

    private void checkIpAtmOverAtmTerminationType() throws BemException {
        String string;
        String string2;
        boolean bl;
        TerminationData terminationData = this.getIpOverAtmLinkTerminationData(0);
        TerminationData terminationData2 = this.getIpOverAtmLinkTerminationData(1);
        String string3 = terminationData2.getSlotNumber();
        if (string3 != null && (bl = this.usesSameEtbSlotAndLine(terminationData.getSlotNumber(), terminationData2.getSlotNumber(), terminationData.getLineNumbers(), terminationData2.getLineNumbers())) && !(string2 = terminationData.getTerminationType()).equals(string = terminationData2.getTerminationType())) {
            String string4 = "If both default and redundant IP/ATM links use the same\nETB slot and line, the termination type must be the same";
            throw new BemException(string4);
        }
    }

    private boolean checkIpOverAtmLines() throws BemException {
        boolean bl = true;
        TerminationData terminationData = this.getIpOverAtmLinkTerminationData(0);
        TerminationData terminationData2 = this.getIpOverAtmLinkTerminationData(1);
        String string = terminationData2.getSlotNumber();
        if (string != null) {
            String string2 = terminationData.getTerminationType();
            String string3 = terminationData2.getTerminationType();
            String string4 = terminationData.getSlotNumber();
            String string5 = terminationData2.getSlotNumber();
            boolean bl2 = this.isIma(string4, string2);
            boolean bl3 = this.isIma(string5, string3);
            String string6 = terminationData.getSlotNumber();
            String string7 = terminationData2.getSlotNumber();
            String[] stringArray = terminationData2.getLineNumbers();
            String[] stringArray2 = terminationData.getLineNumbers();
            String string8 = "";
            if (bl2) {
                if (bl3) {
                    if (bl && string6.equals(string7) && !(bl = IpOverAtmUtil.isSameLinesInIma(stringArray2, stringArray))) {
                        string8 = LINES_IN_IMA_REASON;
                    }
                } else if (string4.equals(string5)) {
                    String string9 = stringArray[0];
                    boolean bl4 = IpOverAtmUtil.isLineInImaGroup(string9, stringArray2);
                    boolean bl5 = bl = !bl4;
                    if (!bl) {
                        string8 = OCCUPIED_LINE_REASON;
                    }
                }
            } else if (bl3 && string4.equals(string5)) {
                String string10 = stringArray2[0];
                boolean bl6 = IpOverAtmUtil.isLineInImaGroup(string10, stringArray);
                boolean bl7 = bl = !bl6;
                if (!bl) {
                    string8 = OCCUPIED_LINE_REASON;
                }
            }
            if (!bl) {
                throw new BemException(string8);
            }
        }
        return bl;
    }

    private boolean checkIpOverAtmSlotsInFraction() throws BemException {
        boolean bl = true;
        TerminationData terminationData = this.getIpOverAtmLinkTerminationData(0);
        TerminationData terminationData2 = this.getIpOverAtmLinkTerminationData(1);
        String string = terminationData2.getSlotNumber();
        if (string != null) {
            String string2 = terminationData.getTerminationType();
            String string3 = terminationData2.getTerminationType();
            String string4 = terminationData.getSlotNumber();
            String string5 = terminationData2.getSlotNumber();
            String[] stringArray = terminationData.getLineNumbers();
            String[] stringArray2 = terminationData2.getLineNumbers();
            String[] stringArray3 = terminationData.getTimeSlotsInFraction();
            String[] stringArray4 = terminationData2.getTimeSlotsInFraction();
            boolean bl2 = this.isFractional(string4, string2);
            boolean bl3 = this.isFractional(string5, string3);
            String string6 = "";
            if (bl2 && bl3 && bl && string4.equals(string5) && stringArray[0].equals(stringArray2[0]) && !(bl = IpOverAtmUtil.isSameSlotsInFractional(stringArray3, stringArray4))) {
                string6 = FRACTIONAL_RESTRICTION_REASON;
            }
            if (!bl) {
                throw new BemException(string6);
            }
        }
        return bl;
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        int n;
        String string;
        String string2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ServiceNameValue serviceNameValue;
        Object object5;
        int n2;
        this.isXMLFileInUse = true;
        if (DuwUtil.hasDuw()) {
            this.updateBoardManagerWithFirstFoundTerminationTypeParamName(serviceValue);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n2 = 0; n2 < 2; ++n2) {
            object5 = IP_ATM_PSEUDO_PREFIX[n2];
            serviceNameValue = serviceValue.getAttribute((String)object5, "etbSlot");
            if (serviceNameValue == null) continue;
            object4 = this.createCP(IP_ATM_PSEUDO_PREFIX[n2]);
            object3 = (TerminationParameterList)object4.get(0);
            object2 = ((TerminationParameterList)object3).getAllPseudos();
            object = object2.iterator();
            while (object.hasNext()) {
                arrayList.add((String)object.next());
            }
        }
        if (DuwUtil.hasDuw() && (object5 = serviceValue.getAttribute(string2 = IP_ATM_PSEUDO_PREFIX[0], "terminationType")) != null && (((ServiceNameValue)object5).getValueAsString().endsWith("Chan_STM1_E1") || ((ServiceNameValue)object5).getValueAsString().endsWith("Chan_STM1_Fractional_E1") || ((ServiceNameValue)object5).getValueAsString().endsWith("IMA_Chan_STM1_E1") || ((ServiceNameValue)object5).getValueAsString().endsWith("OC3") || ((ServiceNameValue)object5).getValueAsString().endsWith("Chan_OC3_T1") || ((ServiceNameValue)object5).getValueAsString().endsWith("Chan_OC3_fractional_T1") || ((ServiceNameValue)object5).getValueAsString().endsWith("IMA_Chan_OC3_T1") || ((ServiceNameValue)object5).getValueAsString().endsWith("STM1_ETSI") || ((ServiceNameValue)object5).getValueAsString().endsWith("STM1_TTC"))) {
            this.setIsDuwStm1Configured(true);
        }
        n2 = 0;
        while (n2 == 0) {
            object5 = MessageFormat.format("ATM{0}_", new Integer(this.atmPortCounter));
            serviceNameValue = serviceValue.getAttribute((String)object5, "etbSlot");
            if (serviceNameValue == null) {
                n2 = 1;
                continue;
            }
            object4 = this.createCPForAtmPort(this.atmPortCounter++);
            object3 = ((TerminationParameterList)object4).getAllPseudos();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                arrayList.add((String)object2.next());
            }
        }
        boolean bl = false;
        int n3 = 1;
        while (!bl) {
            object4 = MessageFormat.format("PhysPathTerm{0}_", new Integer(n3));
            object3 = serviceValue.getAttribute((String)object4, "etbSlot");
            if (object3 == null) {
                bl = true;
            } else {
                object2 = (String)object4 + "etbSlot";
                arrayList.add(object2);
                object = (String)object4 + "terminationType";
                arrayList.add(object);
                string = (String)object4 + "standard";
                arrayList.add(string);
                String string3 = (String)object4 + "physicalLine";
                arrayList.add(string3);
                String string4 = (String)object4 + "timeSlotsInFraction";
                arrayList.add(string4);
                String string5 = (String)object4 + "requiredNumberOfLinks";
                arrayList.add(string5);
                String string6 = (String)object4 + PSEUDO_IP_OVER_ATM_LINK;
                arrayList.add(string6);
                String string7 = (String)object4 + PSEUDO_EXISTS_ON_NODE;
                arrayList.add(string7);
                this.addTermination(false, (String)object2, (String)object, string, string3, string4, string5, string6, string7);
            }
            ++n3;
        }
        try {
            n3 = 0;
            n = 1;
            while (n3 == 0) {
                object3 = MessageFormat.format("DeleteAtmPort{0}_", new Integer(n));
                object2 = serviceValue.getAttribute((String)object3, "rdnId");
                if (object2 == null) {
                    n3 = 1;
                } else {
                    object = (String)object3 + "rdnId";
                    arrayList.add(object);
                    this.deleteAtmPort((String)object, n);
                }
                ++n;
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("Fail in setCustoerParameters in " + this.getClass() + ", this.deleteAtmPort", (Throwable)moHandlerException);
        }
        n3 = 0;
        n = 1;
        while (n3 == 0) {
            object3 = MessageFormat.format("DeletePhysPathTerm{0}_", new Integer(n));
            object2 = serviceValue.getAttribute((String)object3, "etbSlot");
            if (object2 == null) {
                n3 = 1;
            } else {
                object = (String)object3 + "etbSlot";
                arrayList.add(object);
                string = (String)object3 + "physicalLine";
                arrayList.add(string);
                this.deleteTermination((String)object, string, n);
            }
            ++n;
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        if (DuwUtil.hasDuw()) {
            stringArray = this.getSortedParamNames(stringArray);
            this.verifyValidityOfAllTerminationTypes(stringArray, serviceValue);
        }
        super.setCustomerParametersFromSV(stringArray, serviceValue);
    }

    private void verifyValidityOfAllTerminationTypes(String[] stringArray, ServiceValue serviceValue) throws BemException {
        String[] stringArray2 = this.boardManager.getAllSupportedTerminationTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            ServiceNameValue serviceNameValue;
            String string2 = stringArray[i];
            if (!string2.endsWith("terminationType") || (serviceNameValue = serviceValue.getAttribute(string2)) == null || BemUtil.isStringInArray(string = (String)serviceNameValue.getValue(), stringArray2)) continue;
            throw new BemException("Termination type=" + string + " is not supported in a DUW equipped RBS");
        }
    }

    private void updateBoardManagerWithFirstFoundTerminationTypeParamName(ServiceValue serviceValue) {
        String string;
        String[] stringArray = this.boardManager.getAllSupportedTerminationTypes();
        String string2 = "firstOAMatm_terminationType";
        ServiceNameValue serviceNameValue = serviceValue.getAttribute(string2);
        if (serviceNameValue != null && BemUtil.isStringInArray(string = (String)serviceNameValue.getValue(), stringArray)) {
            DuwEtmBoardManager duwEtmBoardManager = (DuwEtmBoardManager)this.boardManager;
            duwEtmBoardManager.setFirstFoundTerminationType(string);
        }
    }

    private String[] getSortedParamNames(String[] stringArray) {
        String string;
        int n;
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        String string2 = "firstOAMatm_terminationType";
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            if (!string2.equals(string)) continue;
            stringArray2[0] = string2;
            n2 = 1;
            break;
        }
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            if (string2.equals(string) || !string.endsWith("terminationType")) continue;
            stringArray2[n2++] = string;
        }
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            if (string2.equals(string) || string.endsWith("terminationType")) continue;
            stringArray2[n2++] = string;
        }
        return stringArray2;
    }

    public String getName() {
        return name;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public String getAtmPortLdn(String string) throws BemException {
        return this.getAtmPortLdn(string, false);
    }

    public String getAtmPortLdn(String string, boolean bl) throws BemException {
        String string2 = null;
        Collection collection = this.getAllRIAndCPWrappers(true);
        ExceptionProperties exceptionProperties = new ExceptionProperties();
        exceptionProperties.setProperty("ConfigItem (CI)", this);
        exceptionProperties.setProperty("PseudoName", string);
        exceptionProperties.setProperty("Failing Method", this.getClass().getName() + " getAtmPortLdn()");
        Iterator iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                RIAndCPWrapper rIAndCPWrapper = (RIAndCPWrapper)iterator.next();
                TerminationParameterList terminationParameterList = rIAndCPWrapper.getParamList();
                EtbSlotParameter etbSlotParameter = terminationParameterList.getSlotParameter();
                String string3 = etbSlotParameter.getName();
                if (!string3.equals(string) || etbSlotParameter.getValue().equals("##UNDEFINED") || etbSlotParameter.getValue().equals("None")) continue;
                AtmPortRI atmPortRI = rIAndCPWrapper.getAtmPortRI();
                exceptionProperties.setProperty("ResourceItem  (RI)", atmPortRI);
                if (this.isOkToUseTermination(string3)) {
                    string2 = atmPortRI.generateAtmPortLdn(bl);
                } else {
                    rIAndCPWrapper = this.findIndex(IP_ATM_PSEUDO_PREFIX[0] + "etbSlot");
                    atmPortRI = rIAndCPWrapper.getAtmPortRI();
                    string2 = atmPortRI.generateAtmPortLdn(bl);
                }
                break;
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("getAtmPortLdn() failed", exceptionProperties, (Throwable)moHandlerException);
        }
        return string2;
    }

    private boolean isOkToUseTermination(String string) {
        boolean bl = true;
        if (string.indexOf(IP_ATM_PSEUDO_PREFIX[1]) != -1) {
            TerminationData terminationData = this.getIpOverAtmLinkTerminationData(0);
            TerminationData terminationData2 = this.getIpOverAtmLinkTerminationData(1);
            boolean bl2 = this.usesSameEtbSlotAndLine(terminationData.getSlotNumber(), terminationData2.getSlotNumber(), terminationData.getLineNumbers(), terminationData2.getLineNumbers());
            bl = !bl2;
        }
        return bl;
    }

    private boolean usesSameEtbSlotAndLine(String string, String string2, String[] stringArray, String[] stringArray2) {
        if (string == null || string2 == null || stringArray == null || stringArray2 == null) {
            return false;
        }
        boolean bl = false;
        if (string.equals(string2) && stringArray.length == stringArray2.length) {
            boolean bl2 = true;
            block0: for (int i = 0; i < stringArray.length && bl2; ++i) {
                bl2 = false;
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (!stringArray[i].equals(stringArray2[j])) continue;
                    bl2 = true;
                    continue block0;
                }
            }
            bl = bl2;
        }
        return bl;
    }

    private RIAndCPWrapper findIndex(String string) {
        Collection collection = this.getAllRIAndCPWrappers(true);
        for (RIAndCPWrapper rIAndCPWrapper : collection) {
            TerminationParameterList terminationParameterList = rIAndCPWrapper.getParamList();
            EtbSlotParameter etbSlotParameter = terminationParameterList.getSlotParameter();
            String string2 = etbSlotParameter.getName();
            if (!string2.equals(string)) continue;
            return rIAndCPWrapper;
        }
        return null;
    }

    public TerminationData getIpOverAtmLinkTerminationData(int n) {
        int n2 = n;
        String string = IP_ATM_PSEUDO_PREFIX[n2];
        String string2 = string + "etbSlot";
        String string3 = null;
        String string4 = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string5 = null;
        TerminationParameterList[] terminationParameterListArray = this.getAllTerminationParameterLists(true);
        for (int i = 0; i < terminationParameterListArray.length; ++i) {
            EtbSlotParameter etbSlotParameter = terminationParameterListArray[i].getSlotParameter();
            String string6 = etbSlotParameter.getName();
            if (!string6.equals(string2)) continue;
            string3 = etbSlotParameter.getValue();
            TerminationTypeParameter terminationTypeParameter = terminationParameterListArray[i].getTerminationTypeParameter();
            string4 = terminationTypeParameter.getValue();
            PhysicalLineParameter physicalLineParameter = terminationParameterListArray[i].getLineParameter();
            stringArray = physicalLineParameter.getAllLines();
            ReqNoOfLinksParameter reqNoOfLinksParameter = terminationParameterListArray[i].getRequiredNumberOfLinksParameter();
            string5 = reqNoOfLinksParameter.getValue();
            TimeSlotsInFractionParameter timeSlotsInFractionParameter = terminationParameterListArray[i].getTimeSlotsInFractionParameter();
            stringArray2 = timeSlotsInFractionParameter.getAllTimeSlots();
            break;
        }
        TerminationData terminationData = new TerminationData(string3, string4, null, stringArray, stringArray2, string5);
        return terminationData;
    }

    public TerminationParameterList getIpOverAtmLinkParams(int n) {
        int n2 = n;
        String string = IP_ATM_PSEUDO_PREFIX[n2];
        String string2 = string + "etbSlot";
        TerminationParameterList[] terminationParameterListArray = this.getAllTerminationParameterLists(true);
        for (int i = 0; i < terminationParameterListArray.length; ++i) {
            EtbSlotParameter etbSlotParameter = terminationParameterListArray[i].getSlotParameter();
            String string3 = etbSlotParameter.getName();
            if (!string3.equals(string2)) continue;
            return terminationParameterListArray[i];
        }
        return null;
    }

    public Integer getMaxPeakCellRate(int n) throws BemException {
        return this.getPeakCellRate(n, "MAX_PCR");
    }

    public Integer getMaxMinCellRate(int n) throws BemException {
        return this.getMinCellRate(n, "MAX_MCR");
    }

    public Integer getDefaultPeakCellRate(int n) throws BemException {
        return this.getPeakCellRate(n, "MAX_DEFAULT");
    }

    private Integer getPeakCellRate(int n, String string) throws BemException {
        TerminationData terminationData = this.getIpOverAtmLinkTerminationData(n);
        return this.boardManager.getPeakCellRate(terminationData, string, IP_ATM_PSEUDO_PREFIX[n] + "vpServiceCategory");
    }

    public Integer getMinCellRate(int n, String string) throws BemException {
        TerminationData terminationData = this.getIpOverAtmLinkTerminationData(n);
        return this.boardManager.getMinCellRate(terminationData, string);
    }

    public String[] getAvailableLines(String string) throws BemException {
        return this.getAvailableLines(string, true);
    }

    private String[] getAvailableLines(String string, boolean bl) throws BemException {
        TerminationParameterList[] terminationParameterListArray = this.getAllTerminationParameterLists(bl);
        return this.boardManager.getAvailableLines(string, terminationParameterListArray, this.standardManager.getConfiguredStandard());
    }

    private String[] getAvailableLines(String string, TerminationParameterList terminationParameterList) throws BemException {
        TerminationParameterList[] terminationParameterListArray = this.getAllTerminationParameterLists(true, terminationParameterList);
        return this.boardManager.getAvailableLines(string, terminationParameterListArray, this.standardManager.getConfiguredStandard());
    }

    public String[] getAvailableSlots() throws BemException {
        TerminationParameterList[] terminationParameterListArray = this.getAllTerminationParameterLists(true);
        return this.boardManager.getAvailableSlots(terminationParameterListArray, this.standardManager.getConfiguredStandard());
    }

    public String[] getAvailableTerminationTypes(String string) throws BemException {
        return this.boardManager.getAvailableTerminationTypes(string, this.standardManager.getConfiguredStandard());
    }

    public String[] getAvailableTimeSlots(String string, String string2) throws BemException {
        Integer n = this.boardManager.getMaxNoOfTimeSlots(string, string2);
        if (n == null) {
            return null;
        }
        return BemUtil.createStringArrayFromInt(n);
    }

    public List getConfiguredAtmPorts() {
        String[] stringArray;
        Object object;
        String string;
        Object object2;
        ArrayList<TerminationParameterList> arrayList = new ArrayList<TerminationParameterList>();
        TerminationParameterList terminationParameterList = this.getIpOverAtmLinkParams(0);
        TerminationParameterList terminationParameterList2 = this.getIpOverAtmLinkParams(1);
        TerminationParameterList terminationParameterList3 = null;
        if (terminationParameterList != null && terminationParameterList2 != null && this.usesSameEtbSlotAndLine((String)(object2 = terminationParameterList.getSlotParameter().getValue()), string = terminationParameterList2.getSlotParameter().getValue(), (String[])(object = terminationParameterList.getLineParameter().getAllLines()), stringArray = terminationParameterList2.getLineParameter().getAllLines())) {
            terminationParameterList3 = terminationParameterList2;
        }
        object2 = this.getAllTerminationParameterLists(true, terminationParameterList3);
        for (int i = 0; i < ((TerminationParameterList[])object2).length; ++i) {
            if (!object2[i].hasAtmPort() || ((CustomerParameterImpl)(object = object2[i].getSlotParameter())).getAccessLevel() == 1) continue;
            arrayList.add(object2[i]);
        }
        return arrayList;
    }

    public boolean isFractional(String string, String string2) throws BemException {
        return this.boardManager.isFractional(string, string2);
    }

    public boolean isIma(String string, String string2) throws BemException {
        return this.boardManager.isIma(string, string2);
    }

    public LocationParameter getLocationParameter() {
        return this.locationParameter;
    }

    private Collection getAllRIAndCPWrappers(boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : this.listOfLoadedRIAndCPWrappers) {
            Object object2 = ((RIAndCPWrapper)object).getParamList();
            if (this.isTerminationParameterListRemoved((TerminationParameterList)object2)) continue;
            arrayList.add(object);
        }
        if (bl) {
            for (Object object2 : this.listOfNewRIAndCPWrappers) {
                TerminationParameterList terminationParameterList = ((RIAndCPWrapper)object2).getParamList();
                if (this.isTerminationParameterListRemoved(terminationParameterList)) continue;
                arrayList.add(object2);
            }
        }
        return arrayList;
    }

    private void removeRIAndCPWrapper(TerminationParameterList terminationParameterList) {
        Iterator iterator = this.listOfNewRIAndCPWrappers.iterator();
        while (iterator.hasNext()) {
            RIAndCPWrapper rIAndCPWrapper = (RIAndCPWrapper)iterator.next();
            TerminationParameterList terminationParameterList2 = rIAndCPWrapper.getParamList();
            if (!terminationParameterList2.equals(terminationParameterList)) continue;
            iterator.remove();
            return;
        }
    }

    public TerminationParameterList[] getAllTerminationParameterLists(boolean bl) {
        return this.getAllTerminationParameterLists(bl, null);
    }

    private TerminationParameterList[] getAllTerminationParameterLists(boolean bl, TerminationParameterList terminationParameterList) {
        Object object;
        Object object2;
        Object object32;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = null;
        if (terminationParameterList != null) {
            string = terminationParameterList.getSlotParameter().getName();
        }
        for (Object object32 : this.listOfLoadedRIAndCPWrappers) {
            object2 = ((RIAndCPWrapper)object32).getParamList();
            object = ((TerminationParameterList)object2).getSlotParameter().getName();
            if (string != null && ((String)object).equals(string) || this.isTerminationParameterListRemoved((TerminationParameterList)object2)) continue;
            arrayList.add(object2);
        }
        object32 = this.listOfNewRIAndCPWrappers.iterator();
        if (bl) {
            while (object32.hasNext()) {
                object2 = (RIAndCPWrapper)object32.next();
                object = ((RIAndCPWrapper)object2).getParamList();
                String string2 = ((TerminationParameterList)object).getSlotParameter().getName();
                if (string != null && string2.equals(string) || this.isTerminationParameterListRemoved((TerminationParameterList)object)) continue;
                arrayList.add(object);
            }
        }
        return arrayList.toArray(new TerminationParameterList[0]);
    }

    private boolean isTerminationParameterListRemoved(TerminationParameterList terminationParameterList) {
        EtbSlotParameter etbSlotParameter = terminationParameterList.getSlotParameter();
        return etbSlotParameter.getAccessLevel() == 1;
    }

    public String getConfiguredPhysTermLdn(String string, String string2) throws BemException {
        String string3 = null;
        RIAndCPWrapper rIAndCPWrapper = this.findRIandCPWrapperFromSlotAndLine(string, string2);
        if (rIAndCPWrapper != null) {
            string3 = rIAndCPWrapper.getLdnFromLine(string, string2);
        }
        if (string3 == null) {
            Collection collection = this.getAllRIAndCPWrappers(true);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext() && string3 == null) {
                RIAndCPWrapper rIAndCPWrapper2 = (RIAndCPWrapper)iterator.next();
                string3 = rIAndCPWrapper2.generateLdnFromSlotAndLine(string, string2);
            }
        }
        return string3;
    }

    public String getConfiguredSynchPhysTermLdn(String string, String string2) throws BemException {
        String string3 = null;
        if (string2.equals("9") && DuwUtil.hasDuw()) {
            string3 = this.getConfiguredSynchPhysTermLdnForDuwSynchPort9();
        } else {
            string3 = this.getConfiguredPhysTermLdn(string, string2);
            RIAndCPWrapper rIAndCPWrapper = this.findRIandCPWrapperFromSlotAndLine(string, string2);
            String string4 = "";
            if (rIAndCPWrapper != null) {
                string4 = rIAndCPWrapper.getSynchTerminationMoType(string, string2);
            } else {
                Collection collection = this.getAllRIAndCPWrappers(true);
                Iterator iterator = collection.iterator();
                while (iterator.hasNext() && string3 == null) {
                    RIAndCPWrapper rIAndCPWrapper2 = (RIAndCPWrapper)iterator.next();
                    string3 = rIAndCPWrapper2.generateSynchLdnFromSlotAndLine(string, string2);
                }
            }
            if (!string4.equals("")) {
                string3 = BemUtil.extractLdn(string3, string4);
            }
        }
        return string3;
    }

    private String getConfiguredSynchPhysTermLdnForDuwSynchPort9() throws BemException {
        String string = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminal=1,Os155SpiTtp=pp5";
        return string;
    }

    private RIAndCPWrapper findRIandCPWrapperFromSlotAndLine(String string, String string2) {
        RIAndCPWrapper rIAndCPWrapper = null;
        Collection collection = this.getAllRIAndCPWrappers(true);
        for (RIAndCPWrapper rIAndCPWrapper2 : collection) {
            String string3 = rIAndCPWrapper2.getLdnFromLine(string, string2);
            if (string3 == null) continue;
            rIAndCPWrapper = rIAndCPWrapper2;
            break;
        }
        return rIAndCPWrapper;
    }

    public String getConfiguredLine(String string) {
        String string2 = null;
        Collection collection = this.getAllRIAndCPWrappers(true);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && string2 == null) {
            RIAndCPWrapper rIAndCPWrapper = (RIAndCPWrapper)iterator.next();
            string2 = rIAndCPWrapper.getConfiguredLine(string);
        }
        return string2;
    }

    public String[] getConfiguredPhysTermLines(String string) throws BemException {
        return this.getConfiguredPhysTermLines(string, false);
    }

    private String[] getConfiguredPhysTermLines(String string, boolean bl) throws BemException {
        TreeSet<String> treeSet = new TreeSet<String>();
        Collection collection = this.getAllRIAndCPWrappers(true);
        Iterator iterator = collection.iterator();
        if (string == null) {
            return treeSet.toArray(new String[0]);
        }
        while (iterator.hasNext()) {
            String[] stringArray;
            RIAndCPWrapper rIAndCPWrapper = (RIAndCPWrapper)iterator.next();
            String string2 = rIAndCPWrapper.getParamList().getTerminationTypeParameter().getValue();
            if (this.isIma(string, string2) && (stringArray = rIAndCPWrapper.getConfiguredPhysTermLinesForIma(string)) != null) {
                if (bl) {
                    stringArray = rIAndCPWrapper.getSynchPorts(string, stringArray);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    treeSet.add(stringArray[i]);
                }
            }
            if ((stringArray = rIAndCPWrapper.getConfiguredPhysTermLines(string)) == null) continue;
            String[] stringArray2 = new String[]{stringArray};
            if (bl) {
                stringArray2 = rIAndCPWrapper.getSynchPorts(string, stringArray2);
            }
            treeSet.add(stringArray2[0]);
        }
        return treeSet.toArray(new String[0]);
    }

    public String[] getConfiguredSynchPorts(String string) throws BemException {
        String[] stringArray = null;
        stringArray = this.isDuwStm1Configured && DuwUtil.hasDuw() ? new String[]{"9"} : this.getConfiguredPhysTermLines(string, true);
        return stringArray;
    }

    public String[] getConfiguredPhysTermSlots() throws BemException {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        TerminationParameterList[] terminationParameterListArray = this.getAllTerminationParameterLists(true);
        for (int i = 0; i < terminationParameterListArray.length; ++i) {
            String string;
            EtbSlotParameter etbSlotParameter = terminationParameterListArray[i].getSlotParameter();
            int n = etbSlotParameter.getAccessLevel();
            if (n == 1 || (string = etbSlotParameter.getValue()).equals("##UNDEFINED") || string.equals("None")) continue;
            treeSet.add(new Integer(string));
        }
        Integer[] integerArray = treeSet.toArray(new Integer[0]);
        return AtmAndPtUtil.convertIntegerArrayToStringArray(integerArray);
    }

    public boolean isCbuBoard(String string) throws BemException {
        return this.boardManager.isCbu(string);
    }

    public List createCP() throws BemException {
        return null;
    }

    public List createCP(String string) throws BemException {
        TerminationParameterList terminationParameterList;
        ArrayList<TerminationParameterList> arrayList = new ArrayList<TerminationParameterList>();
        if (string.equals(ATMPORT) && (terminationParameterList = this.createCPForAtmPort(this.atmPortCounter++)) != null) {
            arrayList.add(terminationParameterList);
            return arrayList;
        }
        if (string.equals(IP_ATM_PSEUDO_PREFIX[0]) && (terminationParameterList = this.createCPForIpAtmLink(0)) != null) {
            arrayList.add(terminationParameterList);
            return arrayList;
        }
        if (string.equals(IP_ATM_PSEUDO_PREFIX[1]) && (terminationParameterList = this.createCPForIpAtmLink(1)) != null) {
            arrayList.add(terminationParameterList);
            return arrayList;
        }
        if (string.equals(PHYSICAL_TERM)) {
            return null;
        }
        return null;
    }

    public String removeCP(List list) {
        Object e;
        if (list.size() == 1 && (e = list.get(0)) instanceof TerminationParameterList) {
            TerminationParameterList terminationParameterList = (TerminationParameterList)e;
            String string = terminationParameterList.setAsRemovedCP();
            if (string == null) {
                this.removeRIAndCPWrapper(terminationParameterList);
                StandardParameter standardParameter = terminationParameterList.getStandardParameter();
                this.standardManager.unRegisterStandardCP(standardParameter);
            } else {
                return string;
            }
        }
        return "";
    }

    protected void createCPForLocation() throws BemException {
        this.locationParameter = new LocationParameter();
        this.locationParameter.setValue(isOnSiteLocation);
        this.locationParameter.addCustomerParameterListener(this);
    }

    protected TerminationParameterList createCPForAtmPort(int n) throws BemException {
        String string = MessageFormat.format("ATM{0}_", new Integer(n));
        String string2 = string + "etbSlot";
        String string3 = string + "terminationType";
        String string4 = string + "physicalLine";
        String string5 = string + "standard";
        String string6 = string + "timeSlotsInFraction";
        String string7 = string + "requiredNumberOfLinks";
        String string8 = string + PSEUDO_IP_OVER_ATM_LINK;
        String string9 = string + PSEUDO_EXISTS_ON_NODE;
        RIAndCPWrapper rIAndCPWrapper = this.addTermination(true, string2, string3, string5, string4, string6, string7, string8, string9);
        TerminationParameterList terminationParameterList = rIAndCPWrapper.getParamList();
        IpOverAtmLinkParameter ipOverAtmLinkParameter = terminationParameterList.getIpOverAtmLinkParameter();
        ipOverAtmLinkParameter.setValue(false);
        ExistOnNodeParameter existOnNodeParameter = terminationParameterList.getExistOnNodeParameter();
        existOnNodeParameter.setValue("NO");
        this.updateCPWithValidRangesForDynamicCP(terminationParameterList);
        return terminationParameterList;
    }

    protected TerminationParameterList createCPForIpAtmLink(int n) throws BemException {
        if (n < 0 || n >= IP_ATM_PSEUDO_PREFIX.length) {
            return null;
        }
        String string = IP_ATM_PSEUDO_PREFIX[n];
        String string2 = string + "etbSlot";
        if (this.ip_atm_link_created[n]) {
            return this.getListOfCP(string2);
        }
        String string3 = string + "terminationType";
        String string4 = string + "physicalLine";
        String string5 = string + "standard";
        String string6 = string + "timeSlotsInFraction";
        String string7 = string + "requiredNumberOfLinks";
        String string8 = string + PSEUDO_IP_OVER_ATM_LINK;
        String string9 = string + PSEUDO_EXISTS_ON_NODE;
        RIAndCPWrapper rIAndCPWrapper = this.addTermination(true, string2, string3, string5, string4, string6, string7, string8, string9);
        TerminationParameterList terminationParameterList = rIAndCPWrapper.getParamList();
        IpOverAtmLinkParameter ipOverAtmLinkParameter = terminationParameterList.getIpOverAtmLinkParameter();
        ipOverAtmLinkParameter.setValue(true);
        ExistOnNodeParameter existOnNodeParameter = terminationParameterList.getExistOnNodeParameter();
        existOnNodeParameter.setValue("NO");
        this.ip_atm_link_created[n] = true;
        this.updateCPWithValidRangesForIpOverAtmLink(terminationParameterList);
        this.ipOverAtmManager.registerIpOverAtmParameter(n, terminationParameterList);
        if (DuwUtil.hasDuw() && n == 0) {
            this.defaultLinkTermTypeListener = this.addDefaultLinkTermTypeListener(string3);
        } else if (this.defaultLinkTermTypeListener != null) {
            TerminationTypeParameter terminationTypeParameter = terminationParameterList.getTerminationTypeParameter();
            this.defaultLinkTermTypeListener.setTerminationTypeSecondCustomerParameter(terminationTypeParameter);
        }
        return terminationParameterList;
    }

    private TerminationParameterList getListOfCP(String string) {
        TerminationParameterList[] terminationParameterListArray = this.getAllTerminationParameterLists(true);
        for (int i = 0; i < terminationParameterListArray.length; ++i) {
            EtbSlotParameter etbSlotParameter = terminationParameterListArray[i].getSlotParameter();
            if (!etbSlotParameter.getName().equals(string)) continue;
            return terminationParameterListArray[i];
        }
        return null;
    }

    public IpOverAtmRegistrator getIpOverAtmRegistrator() {
        return this.ipOverAtmManager;
    }

    private void handleDuplicatedImaRIs(List list) throws BemException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            Object object;
            Object object22;
            arrayList.addAll(this.getImaRis(list));
            for (Object object22 : this.listOfLoadedRIAndCPWrappers) {
                object = ((RIAndCPWrapper)object22).getImaRI();
                arrayList.add(object);
            }
            object22 = arrayList.iterator();
            object = (ArrayList)arrayList.clone();
            while (object22.hasNext()) {
                ImaRI imaRI = (ImaRI)object22.next();
                ((ArrayList)object).remove(imaRI);
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    ImaRI imaRI2 = (ImaRI)iterator.next();
                    boolean bl = imaRI.usesSameTerminations(imaRI2);
                    if (!bl) continue;
                    imaRI2.setLoadedLdn(imaRI.generateImaGroupLdn());
                }
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("handleDuplicatedImaRIs", "", (Throwable)moHandlerException);
        }
    }

    private List getImaRis(List list) {
        ArrayList arrayList = new ArrayList();
        for (Object e : list) {
            if (!(e instanceof ImaRI)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public String[] getAllowedLinesMatchingDefaultOamAtmLink() throws BemException {
        return this.boardManager.getAllowedLinesMatchingDefaultOamAtmLink();
    }

    public AbstractEtmBoardManager getBoardManager() {
        return this.boardManager;
    }

    private DuwDefaultIpOverAtmTerminationTypeListener addDefaultLinkTermTypeListener(String string) throws BemException {
        CustomerParameterImpl customerParameterImpl = (CustomerParameterImpl)super.getRbs().getCustomerParameterObject(string);
        DuwDefaultIpOverAtmTerminationTypeListener duwDefaultIpOverAtmTerminationTypeListener = this.addDefaultLinkTermTypeListener(customerParameterImpl, false);
        return duwDefaultIpOverAtmTerminationTypeListener;
    }

    private DuwDefaultIpOverAtmTerminationTypeListener addDefaultLinkTermTypeListener(CustomerParameterImpl customerParameterImpl, boolean bl) throws BemException {
        DuwDefaultIpOverAtmTerminationTypeListener duwDefaultIpOverAtmTerminationTypeListener = null;
        DuwEtmBoardManager duwEtmBoardManager = (DuwEtmBoardManager)this.boardManager;
        CustomerParameterImpl customerParameterImpl2 = (CustomerParameterImpl)duwEtmBoardManager.getDefaultOamLinkTerminationTypeCP();
        if (customerParameterImpl2 != null) {
            duwDefaultIpOverAtmTerminationTypeListener = new DuwDefaultIpOverAtmTerminationTypeListener(this, customerParameterImpl);
            customerParameterImpl2.addCustomerParameterListener(duwDefaultIpOverAtmTerminationTypeListener);
            duwDefaultIpOverAtmTerminationTypeListener.forceUpdate(bl);
        }
        return duwDefaultIpOverAtmTerminationTypeListener;
    }

    public void setIsDuwStm1Configured(boolean bl) {
        this.isDuwStm1Configured = bl;
    }

    public boolean getIsDuwStm1Configured() {
        return this.isDuwStm1Configured;
    }

    public boolean isLmSwapNeeded() throws BemException {
        BemLog.log(3, this.getClass() + ": isLmSwapNeeded(), to check whether LM swap is needed!");
        boolean bl = false;
        if (DuwUtil.hasDuw()) {
            String string = "IPoverGigabitEthernet_transportOption";
            String string2 = "firstOAMatm_terminationType";
            BemLog.log(3, this.getClass() + ": isLmSwapNeeded(),  before check " + string + " is supported");
            if (this.rbs.isParameterSupported(string)) {
                BemLog.log(3, this.getClass() + ": isLmSwapNeeded(), " + string + " is supported");
                String string3 = this.rbs.getCustomerParameterObject(string).getValue();
                String string4 = this.rbs.getCustomerParameterServerObject(string).getLoadedValue();
                boolean bl2 = string4.equals("ipV4");
                boolean bl3 = string3.equals("ipV4");
                BemLog.log(3, this.getClass() + ": isLmSwapNeeded(), newTransportOption is " + string3 + ", loadedTransportOption is " + string4);
                if (this.rbs.isParameterSupported(string2)) {
                    boolean bl4;
                    String string5 = this.rbs.getCustomerParameterServerObject(string2).getLoadedValue();
                    String string6 = this.rbs.getCustomerParameterObject(string2).getValue();
                    boolean bl5 = !bl2 && (string5.indexOf("STM") != -1 || string5.indexOf("OC3") != -1);
                    boolean bl6 = bl4 = !bl3 && (string6.indexOf("STM") != -1 || string6.indexOf("OC3") != -1);
                    if (!(!bl5 && !bl4 || bl5 && bl4)) {
                        BemLog.log(3, this.getClass() + ": isLmSwapNeeded(), isLmSwapNeeded is going to be set to true");
                        bl = true;
                    }
                }
            }
            BemLog.log(3, this.getClass() + ": isLmSwapNeeded(),  after check " + string + " is supported");
        }
        return bl;
    }

    private class GigabitPortListener
    implements CustomerParameterListener {
        private GigabitPortListener() {
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                if (customerParameter.getValue().equals("TNA")) {
                    AtmAndPtCI.this.filterTerminaionRangesForGbitEthernet();
                } else if (customerParameter.getValue().equals("TNB")) {
                    AtmAndPtCI.this.restoreTerminationRanges();
                }
            }
        }
    }

    private class GigabitEthernetPortCreateListener
    implements CustomerParameterListener {
        private GigabitEthernetPortCreateListener() {
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                if (customerParameter.getValue().equals("YES")) {
                    AtmAndPtCI.this.filterTerminaionRangesForGbitEthernet();
                } else {
                    AtmAndPtCI.this.restoreTerminationRanges();
                }
            }
        }
    }
}

