/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.AbstractEtmBoardManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.AtmAndPtCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.AtmAndPtUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationParameterList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.DuwEtm4Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.DuwEtmc1Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.DuwEtmc41Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.EtmBoard;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class DuwEtmBoardManager
extends AbstractEtmBoardManager {
    private final String DO_NOT_USE_STANDARD_FOR_LOOKUP;
    private static String[][] allowedTerminationTypeCombinations = new String[][]{{"E1", "IMA_E1"}, {"J1", "IMA_J1"}, {"T1", "IMA_T1"}, {"Chan_STM1_E1", "IMA_Chan_STM1_E1"}, {"Chan_OC3_T1", "IMA_Chan_OC3_T1"}, {"STM1_TTC"}, {"OC3"}, {"STM1_ETSI"}};
    private Mapping[] allMappings;
    private EtmBoardProvider etmBoardProvider;
    private AtmAndPtCI atmAndPtCi;
    private String firstFoundTerminationType;

    public DuwEtmBoardManager(Rbs rbs, AtmAndPtCI atmAndPtCI, EtmBoardProvider etmBoardProvider) {
        super(rbs, etmBoardProvider);
        this.DO_NOT_USE_STANDARD_FOR_LOOKUP = null;
        this.etmBoardProvider = etmBoardProvider;
        this.atmAndPtCi = atmAndPtCI;
        this.allMappings = new Mapping[]{new DuwEtmc1Mapping(), new DuwEtmc41Mapping(), new DuwEtm4Mapping()};
    }

    protected Map createBoardSlots(List list) {
        HashMap<String, TreeMap> hashMap = new HashMap<String, TreeMap>();
        String[] stringArray = this.etmBoardProvider.getSupportedEtmBoardTypesForAtm();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], new TreeMap());
        }
        if (list != null) {
            for (EtmBoard etmBoard : list) {
                String string = etmBoard.getTransportCapabilty();
                if (!"ATM".equals(string)) continue;
                String string2 = etmBoard.getType();
                String string3 = String.valueOf(etmBoard.getSlotNo());
                TreeMap treeMap = (TreeMap)hashMap.get(string2);
                treeMap.put(Integer.valueOf(string3), null);
                hashMap.remove(string2);
                hashMap.put(string2, treeMap);
            }
        }
        return hashMap;
    }

    protected Mapping getEtmMapping(String string, Map map) throws BemException {
        Mapping mapping = this.getMapping();
        return mapping;
    }

    public String[] getAvailableLines(String string, TerminationParameterList[] terminationParameterListArray, String string2) throws BemException {
        if (string == null) {
            return null;
        }
        Set set = this.getAlreadyOccupiedLines(string, terminationParameterListArray);
        if (set.size() >= this.getMaxNoOfLines(string, string2)) {
            return null;
        }
        Mapping mapping = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            mapping = this.getEtmMapping(string, this.getSlotMappings());
            if (mapping != null) {
                int n = mapping.getMinLineNumberForStandard(string2);
                int n2 = mapping.getMaxLineNumberForStandard(string2);
                if (n > 0 && n2 > 0) {
                    for (int i = n; i <= n2; ++i) {
                        String string3 = "" + i;
                        if (set.contains(string3)) continue;
                        arrayList.add(string3);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new BemException("getAvailableLines() Can not read available lines", (Throwable)exception);
        }
        return arrayList.toArray(new String[0]);
    }

    private String getTerminationTypeForDefaultLink() {
        String string = "firstOAMatm_terminationType";
        String string2 = "None";
        try {
            if (super.getRbs().isConfigurationItemSupported("AtmAndPtCI")) {
                string2 = super.getRbs().getCustomerParameter(string);
            }
        }
        catch (BemException bemException) {
            string2 = "None";
        }
        return string2;
    }

    public String[] getAllowedTerminationTypesMatchingDefaultOamAtmLink() throws BemException {
        String[] stringArray = new String[]{};
        String string = this.getTerminationTypeForDefaultLink();
        if (string != null) {
            block0: for (String[] stringArray2 : allowedTerminationTypeCombinations) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    String string2 = stringArray2[i];
                    if (!string.equals(string2)) continue;
                    stringArray = stringArray2;
                    continue block0;
                }
            }
        }
        return stringArray;
    }

    public String[] getAllowedLinesMatchingDefaultOamAtmLink() throws BemException {
        String[] stringArray = new String[]{};
        Mapping mapping = null;
        String string = this.getConfiguredDefaultOamLinkSlot();
        mapping = this.getEtmMapping(string, this.getSlotMappings());
        if (mapping != null) {
            String string2 = this.getTerminationTypeForDefaultLink();
            Integer n = mapping.getMinLineNumberForTerminationType(string2);
            Integer n2 = mapping.getMaxLineNumberForTerminationType(string2);
            stringArray = BemUtil.createStringArrayFromInt(n, n2);
        }
        return stringArray;
    }

    private String getConfiguredDefaultOamLinkSlot() throws BemException {
        String string = "firstOAMatm_etbSlot";
        String string2 = super.getRbs().getCustomerParameter(string);
        return string2;
    }

    private String getConfiguredRedundantOamLinkTerminationType() throws BemException {
        String string = "secondOAMatm_terminationType";
        String string2 = "None";
        if (super.getRbs().isParameterSupported(string)) {
            string2 = super.getRbs().getCustomerParameter(string);
        }
        return string2;
    }

    public CustomerParameter getDefaultOamLinkTerminationTypeCP() throws BemException {
        String string = "firstOAMatm_terminationType";
        CustomerParameter customerParameter = null;
        if (super.getRbs().isParameterSupported(string)) {
            customerParameter = super.getRbs().getCustomerParameterObject(string);
        }
        return customerParameter;
    }

    public void checkBoardCombinationConsistency() throws BemException {
        if (this.areTerminationTypeCpsSupported()) {
            this.checkTerminatonTypeCombinations();
        }
    }

    private void checkTerminatonTypeCombinations() throws BemException {
        String[] stringArray = this.getAllowedTerminationTypesMatchingDefaultOamAtmLink();
        String string = this.getTerminationTypeForDefaultLink();
        String string2 = this.getConfiguredRedundantOamLinkTerminationType();
        boolean bl = true;
        if (stringArray != null && stringArray.length > 0 && this.isTerminationTypeSet(string) && this.isTerminationTypeSet(string2)) {
            bl = false;
            block0: for (String[] stringArray2 : allowedTerminationTypeCombinations) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    String string3 = stringArray2[i];
                    if (!string2.equals(string3)) continue;
                    bl = true;
                    continue block0;
                }
            }
        }
        if (!bl) {
            throw new BemException("The selected combination of Default and Redundant OAM Link is not supported");
        }
    }

    private boolean isTerminationTypeSet(String string) {
        boolean bl = true;
        if (string == null || string.length() == 0 || string.equals("None") || string.equals("-") || string.equals("##UNDEFINED")) {
            bl = false;
        }
        return bl;
    }

    private boolean areTerminationTypeCpsSupported() {
        boolean bl = false;
        String string = "firstOAMatm_terminationType";
        String string2 = "secondOAMatm_terminationType";
        if (super.getRbs().isParameterSupported(string) && super.getRbs().isParameterSupported(string2)) {
            bl = true;
        }
        return bl;
    }

    public String getStandard(String string, String string2) throws BemException {
        Mapping mapping = this.getEtmMappingForDuw();
        return mapping.getStandard(string2);
    }

    protected void createSlotMappings(Map map, EtmBoardProvider etmBoardProvider) {
    }

    public String[] getAllSupportedStandards() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.allMappings.length; ++i) {
            Mapping mapping = this.allMappings[i];
            String[] stringArray = mapping.getSupportedStandards();
            AtmAndPtUtil.addSupportedValuesIntoRange(arrayList, stringArray);
        }
        return AtmAndPtUtil.convertListIntoStringArray(arrayList);
    }

    public String[] getAllSupportedTerminationTypes() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.allMappings.length; ++i) {
            Mapping mapping = this.allMappings[i];
            String[] stringArray = mapping.getSupportedTerminationTypes();
            AtmAndPtUtil.addSupportedValuesIntoRange(arrayList, stringArray);
        }
        return AtmAndPtUtil.convertListIntoStringArray(arrayList);
    }

    protected Mapping getEtmMappingForDuw() throws BemException {
        Mapping mapping = this.getMapping();
        return mapping;
    }

    public Mapping getEtmMapping(String string) {
        Mapping mapping = null;
        for (int i = 0; i < this.allMappings.length; ++i) {
            Mapping mapping2 = this.allMappings[i];
            if (!mapping2.supportsMoType(string)) continue;
            mapping = mapping2;
            break;
        }
        return mapping;
    }

    public String[] getAvailableTerminationTypes(String string) throws BemException {
        String[] stringArray = this.getAvailableTerminationTypes(string, this.DO_NOT_USE_STANDARD_FOR_LOOKUP);
        return stringArray;
    }

    public String[] getAvailableTerminationTypes(String string, String string2) throws BemException {
        String[] stringArray = null;
        if (string2 == null) {
            stringArray = this.getAllSupportedTerminationTypes();
        } else {
            TerminationParameterList[] terminationParameterListArray;
            stringArray = this.getAllowedTerminationTypesMatchingDefaultOamAtmLink();
            if ((stringArray == null || stringArray.length == 0) && (terminationParameterListArray = this.atmAndPtCi.getAllTerminationParameterLists(true)) != null) {
                for (int i = 0; i < terminationParameterListArray.length; ++i) {
                    TerminationParameterList terminationParameterList = terminationParameterListArray[i];
                    String string3 = terminationParameterList.getTerminationTypeParameter().getValue();
                    if (!this.isTerminationTypeSet(string3)) continue;
                    Mapping mapping = this.getEtmMappingForTerminationType(string3);
                    stringArray = string2.equals(this.DO_NOT_USE_STANDARD_FOR_LOOKUP) ? mapping.getSupportedTerminationTypes() : mapping.getTerminationTypes(string2);
                }
            }
            if (stringArray == null || stringArray.length == 0) {
                stringArray = this.getAllSupportedTerminationTypes();
            }
        }
        return stringArray;
    }

    private Mapping getMapping() throws BemException {
        Mapping mapping = this.getMapping(false);
        return mapping;
    }

    private Mapping getMapping(boolean bl) throws BemException {
        Mapping mapping = null;
        String string = this.getTerminationTypeForDefaultLink();
        if (this.isTerminationTypeSet(string)) {
            mapping = this.getEtmMappingForTerminationType(string);
        } else {
            String string2 = this.getFirstSetTerminationType();
            if (this.isTerminationTypeSet(string2)) {
                mapping = this.getEtmMappingForTerminationType(string2);
            }
        }
        if (mapping == null && this.isTerminationTypeSet(this.firstFoundTerminationType)) {
            mapping = this.getEtmMappingForTerminationType(this.firstFoundTerminationType);
        }
        if (mapping == null && !bl) {
            throw new BemException("DuwEtmBoardManager.getMapping() can not find any Mapping");
        }
        return mapping;
    }

    private String getFirstSetTerminationType() {
        String string = null;
        TerminationParameterList[] terminationParameterListArray = this.atmAndPtCi.getAllTerminationParameterLists(true);
        if (terminationParameterListArray != null) {
            for (int i = 0; i < terminationParameterListArray.length; ++i) {
                TerminationParameterList terminationParameterList = terminationParameterListArray[i];
                String string2 = terminationParameterList.getTerminationTypeParameter().getValue();
                if (!this.isTerminationTypeSet(string2)) continue;
                string = string2;
                break;
            }
        }
        return string;
    }

    private Mapping getEtmMappingForTerminationType(String string) {
        Mapping mapping = null;
        for (int i = 0; i < this.allMappings.length; ++i) {
            Mapping mapping2 = this.allMappings[i];
            String[] stringArray = mapping2.getSupportedTerminationTypes();
            if (!BemUtil.isStringInArray(string, stringArray)) continue;
            mapping = mapping2;
            break;
        }
        return mapping;
    }

    public String[] getAvailableStandards(String string) throws BemException {
        Mapping mapping = this.getMapping(true);
        String[] stringArray = null;
        stringArray = mapping != null ? this.getAvailableStandards(mapping) : this.getAllSupportedStandards();
        return stringArray;
    }

    public void setFirstFoundTerminationType(String string) {
        this.firstFoundTerminationType = string;
    }
}

