/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortCustomerParameterProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortInfo;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcBus;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimExternalNode;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class ExternalNodeRI
extends AbstractResourceItem {
    public static final String name = "EXTERNAL_NODE";
    private static final String[] myInstallationPhases = new String[]{"ExternalNodeCreationPhase", "EcPortCreationPhase"};
    private String ldn = null;
    private String unitNumber;

    public ExternalNodeRI(Rbs rbs, String string) throws BemException {
        super(name, rbs, myInstallationPhases);
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(rbs.getEquipmentMoi(), MimExternalNode.MOTYPENAME, string);
        this.ldn = fixedRdnMoi.getLdn();
        this.unitNumber = string;
    }

    public void install(String string) throws BemException {
        CustomerParameter customerParameter;
        if (!super.containsPhase(this.getInstallationPhases(), string)) {
            return;
        }
        if (this.rbs.isParameterSupported("supportSystemControl") && this.rbs.getRbsData().isRbs6000() && (customerParameter = this.rbs.getCustomerParameterObject("supportSystemControl")).getValue().equalsIgnoreCase("TRUE")) {
            if (string.equals("ExternalNodeCreationPhase")) {
                if (this.hasEcPortsChanged()) {
                    super.createMoIfNotExisting(this.ldn);
                }
            } else if (string.equals("EcPortCreationPhase")) {
                this.installEcPort();
            }
        }
    }

    private void installEcPort() throws BemException {
        EcPortCustomerParameterProvider ecPortCustomerParameterProvider = (EcPortCustomerParameterProvider)this.rbs.getProvider(EcPortCustomerParameterProvider.class);
        EcPortInfo[] ecPortInfoArray = ecPortCustomerParameterProvider.getEcPortCustomerParameters("EXTNODE", this.unitNumber);
        for (int i = 0; i < ecPortInfoArray.length; ++i) {
            EcPortInfo ecPortInfo = ecPortInfoArray[i];
            Enumeration enumeration = ecPortInfo.getHubPositionParameter();
            Enumeration enumeration2 = ecPortInfo.getcascadingOrderParameter();
            Enumeration enumeration3 = ecPortInfo.getPortNumberParameter();
            if (!enumeration.hasValueChanged() && !enumeration2.hasValueChanged()) continue;
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.rbs.getEquipmentMoi(), MimExternalNode.MOTYPENAME, this.unitNumber);
            FixedRdnMoi fixedRdnMoi2 = new FixedRdnMoi(fixedRdnMoi, MimEcPort.MOTYPENAME, String.valueOf(enumeration3.getValue()));
            String string = fixedRdnMoi2.getLdn();
            BemMo bemMo = super.getMo(string);
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            vector.add(Nal.getFactory().getNameValue("hubPosition", enumeration.getValueMom()));
            vector.add(Nal.getFactory().getNameValue("cascadingOrder", enumeration2.getValueMom()));
            MoInstance moInstance = this.rbs.getMoiRefs().getEquipmentMoi();
            FixedRdnMoi fixedRdnMoi3 = new FixedRdnMoi(moInstance, MimEcBus.MOTYPENAME, String.valueOf(1));
            String string2 = fixedRdnMoi3.getLdn();
            BemMo bemMo2 = this.rbs.getMoHandler().getMo(string2);
            vector.add(Nal.getFactory().getNameValue("ecBusRef", bemMo2));
            if (super.isExisting(bemMo)) {
                super.setAttributes(bemMo, vector);
                continue;
            }
            super.createMoIfNotExisting(string, vector);
        }
    }

    private boolean hasEcPortsChanged() throws BemException {
        boolean bl = false;
        EcPortCustomerParameterProvider ecPortCustomerParameterProvider = (EcPortCustomerParameterProvider)this.rbs.getProvider(EcPortCustomerParameterProvider.class);
        EcPortInfo[] ecPortInfoArray = ecPortCustomerParameterProvider.getEcPortCustomerParameters("EXTNODE", this.unitNumber);
        for (int i = 0; i < ecPortInfoArray.length; ++i) {
            EcPortInfo ecPortInfo = ecPortInfoArray[i];
            Enumeration enumeration = ecPortInfo.getHubPositionParameter();
            if (!enumeration.hasValueChanged()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String getDisplayName() {
        return "EXTERNAL_NODE: " + this.getLdn();
    }

    public String getLdn() {
        return this.ldn;
    }
}

