/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic;

import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class NodeRestartRI
extends AbstractResourceItem {
    public static final String name = "NODE-RESTART";
    private static final int DEFAULTRESTARTRANK = 1;
    private static final String[] myInstallationPhases = new String[]{"NodeRestartPhase"};
    private final int restartRank;
    private String restartConfirmed = "NO";

    public NodeRestartRI(Rbs rbs, int n) {
        super(name, rbs, myInstallationPhases);
        this.restartRank = n;
    }

    public NodeRestartRI(Rbs rbs) {
        this(rbs, 1);
    }

    public void install(String string) throws BemException {
        if (myInstallationPhases[0].equals(string)) {
            this.checkIfRestartNeeded();
            if (this.restartConfirmed.equals("YES")) {
                String string2 = this.rbs.getRootMoi().getLdn();
                BemMo bemMo = this.getMo(string2);
                NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("restartRank", new Integer(this.restartRank)), Nal.getFactory().getNameValue("restartReason", new Integer(0)), Nal.getFactory().getNameValue("restartInfo", this.rbs.getRbsStep() + " Restart RBS planned configuration")};
                this.action(bemMo, "manualRestart", nalNameValueArray);
                System.exit(0);
            }
        }
    }

    private void checkIfRestartNeeded() throws BemException {
        CustomerParameter customerParameter = super.getCustomerParameter("nodeRestart");
        this.restartConfirmed = customerParameter.getValue();
    }

    public boolean isInstalled() {
        return true;
    }

    public String getDisplayName() {
        return name;
    }

    public String getLdn() {
        return "";
    }
}

