/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonalarm;

import java.text.MessageFormat;
import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonalarm.AlarmManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonalarm.resource.AlarmPortRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonalarm.resource.ControlPortRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.xalm.NormallyOpenConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.xalm.SeverityConversion;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAlarmPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimControlPort;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class AbstractAlarmManager
implements AlarmManager {
    private Rbs rbs;
    private ArrayList alarmPortRIs = null;
    private ArrayList controlPortRIs = null;
    private MoInstance hwUnitMoi;
    private MoInstance[] alarmPortMois;
    private MoInstance[] controlPortMois;
    protected final int MAX_NO_ALARMPORTS;
    protected final int MAX_NO_CONTROLPORTS;
    private static final String NOT_CONFIGURED_FOR_USE = "Port is not configured for use";
    private final String HW_UNIT_TYPE;
    private int cabinetNum;
    private StringParameter[] alarmSloganParam;
    private StringParameter[] equipmentParam;
    private IntegerParameter[] alarmPortIdParam;
    private IntegerParameter[] controlPortIdParam;
    private YesNoCustomerParameter[] alarmPortNormallyOpenParam;
    private YesNoCustomerParameter[] controlPortNormallyOpenParam;
    private Enumeration[] severityParam;
    private Enumeration[] alarmPortParam;
    private Enumeration[] controlPortParam;
    private IntegerParameter[] probableCauseParam;
    private ParameterRestriction[] configurePortRestrictionAlarmPort;
    private ParameterRestriction[] configurePortRestrictionControlPort;
    private ParameterRestriction portIdRange;
    private String[] alarmPortPseudos = new String[]{"sectorNumber", "rruwPositionInSector", "alarmSlogan", "probableCause", "normallyOpen", "severity", "portId", "externalAlarmUnit"};
    private String[] controlPortPseudos = new String[]{"normallyOpen", "equipmentName", "portId", "externalAlarmUnit"};

    public AbstractAlarmManager(Rbs rbs, MoInstance moInstance, int n, int n2, String string) throws BemException {
        this.rbs = rbs;
        this.hwUnitMoi = moInstance;
        this.MAX_NO_ALARMPORTS = n;
        this.MAX_NO_CONTROLPORTS = n2;
        this.HW_UNIT_TYPE = string;
        this.initMoiResources();
        this.initPortRestrictionAlarmPort();
        this.initPortRestrictionControlPort();
    }

    public AbstractAlarmManager(Rbs rbs, MoInstance moInstance, int n, int n2, String string, int n3) throws BemException {
        this.rbs = rbs;
        this.hwUnitMoi = moInstance;
        this.MAX_NO_ALARMPORTS = n;
        this.MAX_NO_CONTROLPORTS = n2;
        this.HW_UNIT_TYPE = string;
        this.cabinetNum = n3;
        this.initMoiResources();
        this.initPortRestrictionAlarmPort();
        this.initPortRestrictionControlPort();
    }

    protected void initMoiResources() {
        int n;
        int n2;
        this.alarmPortMois = new MoInstance[this.MAX_NO_ALARMPORTS];
        this.controlPortMois = new MoInstance[this.MAX_NO_CONTROLPORTS];
        for (n2 = 0; n2 < this.MAX_NO_ALARMPORTS; ++n2) {
            n = n2 + 1;
            this.alarmPortMois[n2] = new FixedRdnMoi(this.hwUnitMoi, MimAlarmPort.MOTYPENAME, "" + n);
        }
        for (n2 = 0; n2 < this.MAX_NO_CONTROLPORTS; ++n2) {
            n = n2 + 1;
            this.controlPortMois[n2] = new FixedRdnMoi(this.hwUnitMoi, MimControlPort.MOTYPENAME, "" + n);
        }
    }

    private void initPortRestrictionAlarmPort() {
        this.configurePortRestrictionAlarmPort = new ParameterRestriction[this.MAX_NO_ALARMPORTS];
        for (int i = 0; i < this.MAX_NO_ALARMPORTS; ++i) {
            this.configurePortRestrictionAlarmPort[i] = new ParameterRestriction(NOT_CONFIGURED_FOR_USE, 1);
        }
    }

    private void initPortRestrictionControlPort() {
        this.configurePortRestrictionControlPort = new ParameterRestriction[this.MAX_NO_CONTROLPORTS];
        for (int i = 0; i < this.MAX_NO_CONTROLPORTS; ++i) {
            this.configurePortRestrictionControlPort[i] = new ParameterRestriction(NOT_CONFIGURED_FOR_USE, 1);
        }
    }

    public void createAlarmPortRIs() throws BemException {
        this.createAlarmPortRIs(this.HW_UNIT_TYPE);
    }

    private void createAlarmPortRIs(String string) throws BemException {
        ArrayList<AlarmPortRI> arrayList = new ArrayList<AlarmPortRI>();
        String string2 = "";
        for (int i = 0; i < this.MAX_NO_ALARMPORTS; ++i) {
            String string3 = this.alarmPortMois[i].getLdn();
            AlarmPortRI alarmPortRI = new AlarmPortRI(this.rbs, string3, string, this.cabinetNum);
            string2 = this.getPortId(string3);
            if (alarmPortRI.isExisting(string3)) {
                if (this.alarmPortIdParam != null && this.alarmPortIdParam[i] != null) {
                    this.alarmPortIdParam[i].setLoadedValue(string2);
                }
                alarmPortRI.setLoadedValues();
                if (!this.rbs.getRbsStep().equals("STEP_CABINET")) {
                    this.configurePortRestrictionAlarmPort[i].setActive(false);
                }
            }
            arrayList.add(alarmPortRI);
        }
        this.alarmPortRIs = arrayList;
    }

    public void createAlarmPortRIs(ServiceValue serviceValue) throws BemException {
        this.createAlarmPortRIs(this.HW_UNIT_TYPE, serviceValue);
    }

    private void createAlarmPortRIs(String string, ServiceValue serviceValue) throws BemException {
        ArrayList<AlarmPortRI> arrayList = new ArrayList<AlarmPortRI>();
        for (int i = 0; i < this.MAX_NO_ALARMPORTS; ++i) {
            int n = i + 1;
            String string2 = MessageFormat.format("CAB{0}_", new Integer(this.cabinetNum)) + string + MessageFormat.format("ExternalAlarm{0}_", new Integer(n));
            String string3 = string2 + "alarmSlogan";
            String string4 = serviceValue.getValue(string3);
            string3 = string2 + "normallyOpen";
            String string5 = serviceValue.getValue(string3);
            string3 = string2 + "severity";
            String string6 = serviceValue.getValue(string3);
            string3 = string2 + "probableCause";
            String string7 = serviceValue.getValue(string3);
            if (!(string4 != null && string4.length() != 0 || string7 != null && string7.length() != 0 || string5 != null && string5.length() != 0) && (string6 == null || string6.length() == 0)) continue;
            String string8 = this.alarmPortMois[i].getLdn();
            AlarmPortRI alarmPortRI = new AlarmPortRI(this.rbs, string8, string, this.cabinetNum);
            if (alarmPortRI.isExisting(string8)) {
                alarmPortRI.setLoadedValues();
            }
            arrayList.add(alarmPortRI);
        }
        this.alarmPortRIs = arrayList;
    }

    public void createControlPortRIs() throws BemException {
        this.createControlPortRIs(this.HW_UNIT_TYPE);
    }

    private void createControlPortRIs(String string) throws BemException {
        ArrayList<ControlPortRI> arrayList = new ArrayList<ControlPortRI>();
        String string2 = "";
        for (int i = 0; i < this.MAX_NO_CONTROLPORTS; ++i) {
            String string3 = this.controlPortMois[i].getLdn();
            ControlPortRI controlPortRI = new ControlPortRI(this.rbs, string3, string, this.cabinetNum);
            string2 = this.getPortId(string3);
            if (controlPortRI.isExisting(string3)) {
                if (this.controlPortIdParam != null && this.controlPortIdParam[i] != null) {
                    this.controlPortIdParam[i].setLoadedValue(string2);
                }
                controlPortRI.setLoadedValues();
                if (!this.rbs.getRbsStep().equals("STEP_CABINET")) {
                    this.configurePortRestrictionControlPort[i].setActive(false);
                }
            }
            arrayList.add(controlPortRI);
        }
        this.controlPortRIs = arrayList;
    }

    public void createControlPortRIs(ServiceValue serviceValue) throws BemException {
        this.createControlPortRIs(this.HW_UNIT_TYPE, serviceValue);
    }

    private void createControlPortRIs(String string, ServiceValue serviceValue) throws BemException {
        ArrayList<ControlPortRI> arrayList = new ArrayList<ControlPortRI>();
        for (int i = 0; i < this.MAX_NO_CONTROLPORTS; ++i) {
            int n = i + 1;
            String string2 = MessageFormat.format("CAB{0}_", new Integer(this.cabinetNum)) + string + MessageFormat.format("ControlPort{0}_", new Integer(n));
            String string3 = string2 + "equipmentName";
            String string4 = serviceValue.getValue(string3);
            string3 = string2 + "normallyOpen";
            String string5 = serviceValue.getValue(string3);
            if ((string4 == null || string4.length() == 0) && (string5 == null || string5.length() == 0)) continue;
            String string6 = this.controlPortMois[i].getLdn();
            ControlPortRI controlPortRI = new ControlPortRI(this.rbs, string6, string, this.cabinetNum);
            if (controlPortRI.isExisting(string6)) {
                controlPortRI.setLoadedValues();
            }
            arrayList.add(controlPortRI);
        }
        this.controlPortRIs = arrayList;
    }

    private String getPortId(String string) throws BemException {
        return BemUtil.getRdn(string);
    }

    public String getHwUnitLdn() throws BemException {
        return this.hwUnitMoi.getLdn();
    }

    public MoInstance getHwUnitMoi() throws BemException {
        return this.hwUnitMoi;
    }

    public ArrayList getControlPortCustomerParameters(ServiceValue serviceValue) throws BemException {
        return this.getControlPortCustomerParameters(this.HW_UNIT_TYPE, serviceValue);
    }

    public ArrayList getControlPortCustomerParameters(String string, ServiceValue serviceValue) throws BemException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String[] stringArray = new String[this.controlPortPseudos.length];
        for (int i = 0; i < this.MAX_NO_CONTROLPORTS; ++i) {
            int n = i + 1;
            String string2 = MessageFormat.format("CAB{0}_", new Integer(this.cabinetNum)) + string + MessageFormat.format("ControlPort{0}_", new Integer(n));
            for (int j = 0; j < this.controlPortPseudos.length; ++j) {
                stringArray[j] = string2 + this.controlPortPseudos[j];
                if (serviceValue.getValue(stringArray[j]) == null) continue;
                this.configurePortRestrictionControlPort[i].setActive(false);
            }
            arrayList.add(stringArray);
            stringArray = new String[this.controlPortPseudos.length];
        }
        return arrayList;
    }

    public ArrayList getNeededRIs() {
        AbstractResourceItem abstractResourceItem;
        int n;
        int n2;
        ArrayList<AlarmPortRI> arrayList = new ArrayList<AlarmPortRI>();
        if (this.alarmPortRIs != null) {
            for (n2 = 0; n2 < this.alarmPortRIs.size(); ++n2) {
                for (n = 0; n < this.MAX_NO_ALARMPORTS; ++n) {
                    if (this.configurePortRestrictionAlarmPort[n].isActive() || this.alarmPortRIs.get(n2) == null || arrayList.contains(this.alarmPortRIs.get(n2))) continue;
                    abstractResourceItem = (AlarmPortRI)this.alarmPortRIs.get(n2);
                    arrayList.add((AlarmPortRI)abstractResourceItem);
                }
            }
        }
        if (this.controlPortRIs != null) {
            for (n2 = 0; n2 < this.controlPortRIs.size(); ++n2) {
                for (n = 0; n < this.MAX_NO_CONTROLPORTS; ++n) {
                    if (this.configurePortRestrictionControlPort[n].isActive() || this.controlPortRIs.get(n2) == null || arrayList.contains(this.controlPortRIs.get(n2))) continue;
                    abstractResourceItem = (ControlPortRI)this.controlPortRIs.get(n2);
                    arrayList.add((AlarmPortRI)abstractResourceItem);
                }
            }
        }
        return arrayList;
    }

    public ArrayList getCustomerParameters() throws BemException {
        return this.getCustomerParameters(this.HW_UNIT_TYPE);
    }

    private ArrayList getCustomerParameters(String string) throws BemException {
        int n;
        this.alarmSloganParam = new StringParameter[this.MAX_NO_ALARMPORTS];
        this.alarmPortNormallyOpenParam = new YesNoCustomerParameter[this.MAX_NO_ALARMPORTS];
        this.severityParam = new Enumeration[this.MAX_NO_ALARMPORTS];
        this.alarmPortParam = new Enumeration[this.MAX_NO_ALARMPORTS];
        this.probableCauseParam = new IntegerParameter[this.MAX_NO_ALARMPORTS];
        this.alarmPortIdParam = new IntegerParameter[this.MAX_NO_ALARMPORTS];
        this.equipmentParam = new StringParameter[this.MAX_NO_CONTROLPORTS];
        this.controlPortNormallyOpenParam = new YesNoCustomerParameter[this.MAX_NO_CONTROLPORTS];
        this.controlPortIdParam = new IntegerParameter[this.MAX_NO_CONTROLPORTS];
        this.controlPortParam = new Enumeration[this.MAX_NO_CONTROLPORTS];
        int[] nArray = new int[this.MAX_NO_ALARMPORTS];
        ArrayList<CustomerParameterImpl> arrayList = new ArrayList<CustomerParameterImpl>();
        for (int i = 0; i < nArray.length; ++i) {
            n = i + 1;
            String string2 = MessageFormat.format("CAB{0}_", new Integer(this.cabinetNum)) + string + MessageFormat.format("ExternalAlarm{0}_", new Integer(n));
            arrayList.add(this.getAlarmSlogan(string2, i));
            arrayList.add(this.getAlarmPortNormallyOpen(string2, i));
            arrayList.add(this.getServerity(string2, i));
            arrayList.add(this.getProbableCause(string2, i));
            arrayList.add(this.getAlarmPortIdSlogan(string2, i));
            arrayList.add(this.getAlarmPortParam(string2, i));
        }
        int[] nArray2 = new int[this.MAX_NO_CONTROLPORTS];
        for (n = 0; n < nArray2.length; ++n) {
            int n2 = n + 1;
            String string3 = MessageFormat.format("CAB{0}_", new Integer(this.cabinetNum)) + string + MessageFormat.format("ControlPort{0}_", new Integer(n2));
            arrayList.add(this.getEquipmentName(string3, n));
            arrayList.add(this.getControlPortNormallyOpen(string3, n));
            arrayList.add(this.getControlPortIdSlogan(string3, n));
            arrayList.add(this.getControlPortParam(string3, n));
        }
        return arrayList;
    }

    protected StringParameter getAlarmSlogan(String string, int n) throws BemException {
        String string2 = "";
        string2 = string + "alarmSlogan";
        StringRange stringRange = new StringRange(MimAlarmPort.MINLEN_ALARMSLOGAN, MimAlarmPort.MAXLEN_ALARMSLOGAN);
        this.alarmSloganParam[n] = new StringParameter(string2, stringRange);
        this.alarmSloganParam[n].setDefaultValue("");
        this.alarmSloganParam[n].addRestriction(this.configurePortRestrictionAlarmPort[n]);
        return this.alarmSloganParam[n];
    }

    protected IntegerParameter getAlarmPortIdSlogan(String string, int n) throws BemException {
        String string2 = "";
        string2 = string + "portId";
        IntegerRange integerRange = new IntegerRange(1, this.MAX_NO_ALARMPORTS);
        this.alarmPortIdParam[n] = new IntegerParameter(string2, integerRange);
        this.alarmPortIdParam[n].setDefaultValue("");
        this.alarmPortIdParam[n].addRestriction(this.configurePortRestrictionAlarmPort[n]);
        this.portIdRange = new ParameterRestriction("Port Id out of range", integerRange, true);
        this.alarmPortIdParam[n].addRestriction(this.portIdRange);
        return this.alarmPortIdParam[n];
    }

    protected IntegerParameter getControlPortIdSlogan(String string, int n) throws BemException {
        String string2 = "";
        string2 = string + "portId";
        IntegerRange integerRange = new IntegerRange(0, 100);
        this.controlPortIdParam[n] = new IntegerParameter(string2, integerRange);
        this.controlPortIdParam[n].setDefaultValue("");
        this.controlPortIdParam[n].addRestriction(this.configurePortRestrictionControlPort[n]);
        return this.controlPortIdParam[n];
    }

    protected YesNoCustomerParameter getAlarmPortNormallyOpen(String string, int n) throws BemException {
        String string2 = "";
        string2 = string + "normallyOpen";
        this.alarmPortNormallyOpenParam[n] = new YesNoCustomerParameter(string2);
        this.alarmPortNormallyOpenParam[n].setDefaultValue("YES");
        this.alarmPortNormallyOpenParam[n].addRestriction(this.configurePortRestrictionAlarmPort[n]);
        NormallyOpenConversion normallyOpenConversion = new NormallyOpenConversion();
        this.alarmPortNormallyOpenParam[n].setMomConverter(normallyOpenConversion);
        return this.alarmPortNormallyOpenParam[n];
    }

    protected Enumeration getServerity(String string, int n) throws BemException {
        String string2 = "";
        string2 = string + "severity";
        String[] stringArray = new String[]{"Critical", "Major", "Minor", "Warning"};
        this.severityParam[n] = new Enumeration(string2, stringArray);
        this.severityParam[n].setDefaultValue("Minor");
        this.severityParam[n].addRestriction(this.configurePortRestrictionAlarmPort[n]);
        SeverityConversion severityConversion = new SeverityConversion();
        this.severityParam[n].setMomConverter(severityConversion);
        return this.severityParam[n];
    }

    private Enumeration getAlarmPortParam(String string, int n) throws BemException {
        String string2 = "";
        string2 = string + "externalAlarmUnit";
        String[] stringArray = new String[]{"Sau", "Scu", "Sup", "Rruw"};
        this.alarmPortParam[n] = new Enumeration(string2, stringArray);
        this.alarmPortParam[n].addRestriction(this.configurePortRestrictionAlarmPort[n]);
        return this.alarmPortParam[n];
    }

    private Enumeration getControlPortParam(String string, int n) throws BemException {
        String string2 = "";
        string2 = string + "externalAlarmUnit";
        String[] stringArray = new String[]{"Sau", "Scu", "Sup", "Rruw"};
        this.controlPortParam[n] = new Enumeration(string2, stringArray);
        this.controlPortParam[n].addRestriction(this.configurePortRestrictionControlPort[n]);
        return this.controlPortParam[n];
    }

    protected IntegerParameter getProbableCause(String string, int n) throws BemException {
        String string2 = "";
        string2 = string + "probableCause";
        Integer n2 = new Integer(0);
        Integer n3 = new Integer(574);
        Integer n4 = MimAlarmPort.DEFAULT_PROBABLECAUSE;
        IntegerRange integerRange = new IntegerRange(n2, n3);
        this.probableCauseParam[n] = new IntegerParameter(string2, integerRange);
        this.probableCauseParam[n].setDefaultValue(n4.toString());
        this.probableCauseParam[n].addRestriction(this.configurePortRestrictionAlarmPort[n]);
        return this.probableCauseParam[n];
    }

    protected StringParameter getEquipmentName(String string, int n) throws BemException {
        String string2 = "";
        string2 = string + "equipmentName";
        StringRange stringRange = new StringRange(MimControlPort.MINLEN_EQUIPMENTNAME, MimControlPort.MAXLEN_EQUIPMENTNAME);
        this.equipmentParam[n] = new StringParameter(string2, stringRange);
        this.equipmentParam[n].setDefaultValue(MimControlPort.DEFAULT_EQUIPMENTNAME);
        this.equipmentParam[n].addRestriction(this.configurePortRestrictionControlPort[n]);
        return this.equipmentParam[n];
    }

    protected YesNoCustomerParameter getControlPortNormallyOpen(String string, int n) throws BemException {
        String string2 = "";
        string2 = string + "normallyOpen";
        this.controlPortNormallyOpenParam[n] = new YesNoCustomerParameter(string2);
        this.controlPortNormallyOpenParam[n].setDefaultValue("YES");
        NormallyOpenConversion normallyOpenConversion = new NormallyOpenConversion();
        this.controlPortNormallyOpenParam[n].setMomConverter(normallyOpenConversion);
        this.controlPortNormallyOpenParam[n].addRestriction(this.configurePortRestrictionControlPort[n]);
        return this.controlPortNormallyOpenParam[n];
    }

    public int getMAX_NO_ALARMPORTS() {
        return this.MAX_NO_ALARMPORTS;
    }

    public int getMAX_NO_CONTROLPORTS() {
        return this.MAX_NO_CONTROLPORTS;
    }

    public void setHwUnitMoi(MoInstance moInstance) {
        this.hwUnitMoi = moInstance;
    }

    public String getHW_UNIT_TYPE() {
        return this.HW_UNIT_TYPE;
    }

    public ArrayList getAlarmPortCustomerParameters(ServiceValue serviceValue) throws BemException {
        return this.getAlarmPortCustomerParameters(this.HW_UNIT_TYPE, serviceValue);
    }

    public ArrayList getAlarmPortCustomerParameters(String string, ServiceValue serviceValue) throws BemException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String[] stringArray = new String[this.alarmPortPseudos.length];
        for (int i = 0; i < this.MAX_NO_ALARMPORTS; ++i) {
            int n = i + 1;
            String string2 = MessageFormat.format("CAB{0}_", new Integer(this.cabinetNum)) + string + MessageFormat.format("ExternalAlarm{0}_", new Integer(n));
            for (int j = 0; j < this.alarmPortPseudos.length; ++j) {
                stringArray[j] = string2 + this.alarmPortPseudos[j];
                if (serviceValue.getValue(stringArray[j]) == null) continue;
                this.configurePortRestrictionAlarmPort[i].setActive(false);
            }
            arrayList.add(stringArray);
            stringArray = new String[this.alarmPortPseudos.length];
        }
        return arrayList;
    }

    public ArrayList getMoiResources() {
        ArrayList<MoInstance> arrayList = new ArrayList<MoInstance>();
        arrayList.add(this.hwUnitMoi);
        if (this.hwUnitMoi != null) {
            int n;
            for (n = 0; n < this.MAX_NO_ALARMPORTS; ++n) {
                arrayList.add(this.alarmPortMois[n]);
            }
            for (n = 0; n < this.MAX_NO_CONTROLPORTS; ++n) {
                arrayList.add(this.controlPortMois[n]);
            }
        }
        return arrayList;
    }

    public void saveAttributes() throws BemException {
        for (int i = 0; i < this.alarmPortRIs.size(); ++i) {
            AlarmPortRI alarmPortRI = (AlarmPortRI)this.alarmPortRIs.get(i);
            alarmPortRI.saveAttributes();
            for (int j = 0; j < this.MAX_NO_ALARMPORTS; ++j) {
                this.configurePortRestrictionAlarmPort[j].setActive(false);
            }
        }
    }
}

