/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource;

import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class SupportSystemAvailableRI
extends AbstractResourceItem {
    public static final String NAME = "SupportSystemAvailable";
    private static final String[] myInstallationPhases = new String[]{"SupportSystemSettingsPhase"};
    private final boolean supportSystemAvailable;
    private String nodeBFunctionLdn;
    private String supportSystemAvailableValue;

    public SupportSystemAvailableRI(Rbs rbs, boolean bl) throws BemException {
        super(NAME, rbs, myInstallationPhases);
        this.supportSystemAvailable = bl;
        this.createLdn();
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            try {
                this.installSupportSystemAvailable();
            }
            catch (BemException bemException) {
                throw new BemException(bemException.toString() + "Can not set attribute supportSystemAvailable in MO NodeBFunction.");
            }
        }
    }

    public String getDisplayName() {
        return "SupportSystemAvailable: " + this.getLdn();
    }

    public String getLdn() {
        return this.nodeBFunctionLdn;
    }

    public boolean isInstalled() throws BemException {
        boolean bl = false;
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(this.nodeBFunctionLdn);
        try {
            Boolean bl2;
            if (bemMo.isExisting() && (bl2 = (Boolean)moHandler.getAttribute(bemMo, "supportSystemAvailable")) != null) {
                this.supportSystemAvailableValue = bl2 != false ? "TRUE" : "FALSE";
                bl = true;
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException.toString());
        }
        catch (NalCmException nalCmException) {
            throw new BemException(nalCmException.toString());
        }
        return bl;
    }

    public String getSupportSystemAvailableValue() {
        return this.supportSystemAvailableValue;
    }

    private void createLdn() throws BemException {
        this.nodeBFunctionLdn = this.rbs.getNodeBFunctionMoi().getLdn();
    }

    private void installSupportSystemAvailable() throws BemException {
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(this.nodeBFunctionLdn);
        try {
            moHandler.setAttribute(bemMo, "supportSystemAvailable", this.supportSystemAvailable);
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException.toString());
        }
    }
}

