/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpAccessHostEt;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpHostLink;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpInterface;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpOam;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSec;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSystem;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.ReferringMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class IpInterfaceRI
extends AbstractResourceItem {
    public static final String name = "IpInterfaceRI";
    private static String[] phases = new String[]{"IpInterfaceCreationPhase"};
    private final List pseudoList = new ArrayList();
    private MoInstance ethernetInterfaceMoi;
    private MoInstance ipInterfaceMoi;
    private final ParameterRestriction restrictionReadOnly = new ParameterRestriction("Read only", 0);
    private boolean usedOnlyByIpHostLink = false;
    private boolean usedByBothIpHosts = false;
    private static final int DUMMY_VID = 719;
    private boolean configByDHCP = false;

    public boolean isConfigByDHCP() {
        return this.configByDHCP;
    }

    public void setConfigByDHCP(boolean bl) {
        this.configByDHCP = bl;
    }

    public IpInterfaceRI(Rbs rbs, MoInstance moInstance, boolean bl) throws BemException {
        super(name, rbs, phases);
        this.usedOnlyByIpHostLink = bl;
        List list = this.getCustomerParameters();
        for (CustomerParameter customerParameter : list) {
            this.pseudoList.add(customerParameter.getName());
        }
        if (moInstance != null) {
            this.ethernetInterfaceMoi = moInstance;
            this.initializeMois();
            this.initiateCPWithNodeValues();
        }
    }

    public void setEthernetPortMoi(MoInstance moInstance) throws BemException {
        this.ethernetInterfaceMoi = moInstance;
        this.initializeMois();
    }

    private void initializeMois() throws BemException {
        MoInstance moInstance = this.rbs.getRootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimIpSystem.MOTYPENAME, "1");
        BemMo bemMo = this.getMo(singleChildMoi.getLdn());
        SingleChildMoi singleChildMoi2 = new SingleChildMoi(singleChildMoi, MimIpSec.MOTYPENAME, "1");
        BemMo bemMo2 = this.getMo(singleChildMoi2.getLdn());
        if (!this.usedOnlyByIpHostLink) {
            BemMo[] bemMoArray = this.getChildren(bemMo, 1, MimIpAccessHostEt.MOTYPENAME, "");
            if (bemMoArray.length <= 1) {
                SingleChildMoi singleChildMoi3 = new SingleChildMoi(singleChildMoi, MimIpAccessHostEt.MOTYPENAME, "1");
                this.ipInterfaceMoi = new ReferringMoi(this.ethernetInterfaceMoi, MimIpInterface.MOTYPENAME, singleChildMoi3, "ipInterfaceMoRef", "1");
            } else {
                FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(singleChildMoi, MimIpAccessHostEt.MOTYPENAME, "2");
                this.ipInterfaceMoi = new ReferringMoi(this.ethernetInterfaceMoi, MimIpInterface.MOTYPENAME, fixedRdnMoi, "ipInterfaceMoRef", "1");
            }
        } else if (this.usedOnlyByIpHostLink) {
            SingleChildMoi singleChildMoi4 = new SingleChildMoi(moInstance, MimIpOam.MOTYPENAME, "1");
            SingleChildMoi singleChildMoi5 = new SingleChildMoi(singleChildMoi4, MimIp.MOTYPENAME, "1");
            SingleChildMoi singleChildMoi6 = new SingleChildMoi(singleChildMoi5, MimIpHostLink.MOTYPENAME, "1");
            BemMo bemMo3 = this.getMo(singleChildMoi6.getLdn());
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(singleChildMoi, MimIpAccessHostEt.MOTYPENAME, "3");
            BemMo bemMo4 = this.getMo(fixedRdnMoi.getLdn());
            this.ipInterfaceMoi = this.isExisting(bemMo3) && !this.isExisting(bemMo2) ? new ReferringMoi(this.ethernetInterfaceMoi, MimIpInterface.MOTYPENAME, singleChildMoi6, "ipInterfaceMoRef", "1") : (this.isExisting(bemMo4) ? new ReferringMoi(this.ethernetInterfaceMoi, MimIpInterface.MOTYPENAME, fixedRdnMoi, "ipInterfaceMoRef", "2") : new FixedRdnMoi(this.ethernetInterfaceMoi, MimIpInterface.MOTYPENAME, "2"));
        }
    }

    private void initiateCPWithNodeValues() throws BemException {
        String string = this.ipInterfaceMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        String string2 = "";
        Object object = null;
        boolean bl = this.isInstalled();
        if (bl) {
            Object object2;
            String string3;
            Object object3;
            Integer n = (Integer)this.getAttribute(bemMo, "configurationMode");
            if (n != null) {
                boolean bl2 = this.configByDHCP = n == 1;
                if (this.configByDHCP) {
                    object3 = (NalStruct)this.getAttribute(bemMo, "dhcpClientIdentifier");
                    string3 = (String)object3.getMember("clientIdentifier").getValue();
                    object2 = (Integer)object3.getMember("clientIdentifierType").getValue();
                    CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject("OamIpHost_DhcpClientIdentifier_clientIdentifier");
                    customerParameterServer.setLoadedValue(string3);
                    CustomerParameterServer customerParameterServer2 = this.rbs.getCustomerParameterServerObject("OamIpHost_DhcpClientIdentifier_clientIdentifierType");
                    customerParameterServer2.setLoadedValue(object2);
                }
            }
            object3 = this.getCustomerParameters().iterator();
            while (object3.hasNext()) {
                string3 = ((CustomerParameter)object3.next()).getName();
                object2 = this.rbs.getCustomerParameterServerObject(string3);
                string2 = object2.getAttributeName();
                object = this.getAttribute(bemMo, string2);
                if (object != null && string3.equals("OamIpHost_oamVid")) {
                    if ((Integer)object == 719) {
                        object = new Integer(0);
                    }
                }
                object2.setLoadedValue(object);
                if (!string3.equals("IPoverGigabitEthernet_syncSubnetMask")) continue;
                object2.addRestriction(this.restrictionReadOnly);
            }
        }
    }

    private List getCustomerParameters() throws BemException {
        ArrayList<CustomerParameter> arrayList = new ArrayList<CustomerParameter>();
        if (this.usedOnlyByIpHostLink) {
            arrayList.add(this.rbs.getCustomerParameterObject("OamIpHost_configurationMode"));
            arrayList.add(this.rbs.getCustomerParameterObject("OamIpHost_oamSubnetMask"));
            arrayList.add(this.rbs.getCustomerParameterObject("OamIpHost_oamDefaultRouter0"));
            arrayList.add(this.rbs.getCustomerParameterObject("OamIpHost_oamVid"));
        } else {
            arrayList.add(this.rbs.getCustomerParameterObject("IPoverGigabitEthernet_syncSubnetMask"));
            arrayList.add(this.rbs.getCustomerParameterObject("IPoverGigabitEthernet_defaultRouter0"));
            arrayList.add(this.rbs.getCustomerParameterObject("IPoverGigabitEthernet_syncVid"));
        }
        return arrayList;
    }

    public boolean isInstalled() throws BemException {
        boolean bl = false;
        String string = this.ipInterfaceMoi.getLdn();
        bl = this.isExisting(string);
        return bl;
    }

    public boolean shouldRiBeInstalled() throws BemException {
        boolean bl = false;
        if (this.isInstalled()) {
            for (String string : this.pseudoList) {
                CustomerParameter customerParameter;
                boolean bl2;
                if (string.equals("OamIpHost_configurationMode") || !(bl2 = (customerParameter = this.rbs.getCustomerParameterObject(string)).hasValueChanged())) continue;
                bl = bl2;
                break;
            }
        } else {
            for (String string : this.pseudoList) {
                CustomerParameter customerParameter;
                if (string.equals("OamIpHost_configurationMode") || !(customerParameter = this.rbs.getCustomerParameterObject(string)).isValidValue()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void install(String string) throws BemException {
        if (string.equals("IpInterfaceCreationPhase")) {
            this.installIpInterFace();
        }
    }

    private void installIpInterFace() throws BemException {
        String string = this.ipInterfaceMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        boolean bl = this.isInstalled();
        if (!bl) {
            NalNameValue[] nalNameValueArray;
            Object object;
            String string2;
            Object object2;
            CustomerParameterServer customerParameterServer;
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            String string3 = "rps";
            Object object3 = false;
            vector.add(Nal.getFactory().getNameValue(string3, object3));
            if (this.configByDHCP) {
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject("OamIpHost_DhcpClientIdentifier_clientIdentifier");
                CustomerParameter customerParameter2 = this.rbs.getCustomerParameterObject("OamIpHost_DhcpClientIdentifier_clientIdentifierType");
                if (!customerParameter2.getValue().equals("##UNDEFINED") && !customerParameter2.getValue().equals("")) {
                    customerParameterServer = this.rbs.getCustomerParameterServerObject(customerParameter2.getName());
                    object2 = this.rbs.getCustomerParameterServerObject(customerParameter.getName());
                    string2 = !customerParameter.getValue().equals("##UNDEFINED") && customerParameter2.getValue().equals("MANUAL") ? object2.getValueMom() : "";
                    object = customerParameterServer.getValueMom();
                    nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("clientIdentifier", string2), Nal.getFactory().getNameValue("clientIdentifierType", object)};
                    NalStruct nalStruct = Nal.getFactory().getStruct(nalNameValueArray);
                    vector.add(Nal.getFactory().getNameValue("dhcpClientIdentifier", nalStruct));
                }
            }
            for (CustomerParameter customerParameter2 : this.getCustomerParameters()) {
                Object object4;
                customerParameterServer = this.rbs.getCustomerParameterServerObject(customerParameter2.getName());
                object2 = customerParameter2.getValue();
                string2 = customerParameter2.getName();
                if (((String)object2).equals("##UNDEFINED") || ((String)object2).equals("")) continue;
                object = this.rbs.getCustomerParameter("OamIpHost_oamIpAddress");
                nalNameValueArray = this.rbs.getCustomerParameterServerObject("ipAddress").getLoadedValue();
                if (string2.equals("IPoverGigabitEthernet_syncVid") || string2.equals("OamIpHost_oamVid")) {
                    object4 = null;
                    String string4 = customerParameterServer.getAttributeName();
                    Integer n = (Integer)customerParameterServer.getValueMom();
                    if (n != 0) {
                        object4 = true;
                    } else {
                        object4 = false;
                        if (this.usedOnlyByIpHostLink) {
                            n = new Integer(719);
                        }
                    }
                    vector.add(Nal.getFactory().getNameValue(string4, n));
                    vector.add(Nal.getFactory().getNameValue("vLan", object4));
                    continue;
                }
                if (string2.equals("OamIpHost_oamDefaultRouter0") && this.usedOnlyByIpHostLink || string2.equals("IPoverGigabitEthernet_defaultRouter0") && this.usedByBothIpHosts) {
                    object4 = null;
                    object4 = !((String)object).equals(nalNameValueArray) ? customerParameterServer.getValueMom() : "169.254.255.251";
                    vector.add(Nal.getFactory().getNameValue("defaultRouter0", object4));
                    continue;
                }
                if (string2.equals("OamIpHost_oamSubnetMask") && this.usedOnlyByIpHostLink || string2.equals("IPoverGigabitEthernet_syncSubnetMask") && this.usedByBothIpHosts) {
                    object4 = null;
                    object4 = !((String)object).equals(nalNameValueArray) ? customerParameterServer.getValueMom() : new Integer(16);
                    vector.add(Nal.getFactory().getNameValue("networkPrefixLength", object4));
                    continue;
                }
                string3 = customerParameterServer.getAttributeName();
                object3 = customerParameterServer.getValueMom();
                vector.add(Nal.getFactory().getNameValue(string3, object3));
            }
            this.create(bemMo, vector);
        } else {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            Iterator iterator = this.getCustomerParameters().iterator();
            while (iterator.hasNext()) {
                String string5 = ((CustomerParameter)iterator.next()).getName();
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string5);
                boolean bl2 = customerParameterServer.hasValueChanged();
                if (!bl2) continue;
                String string6 = customerParameterServer.getAttributeName();
                Object object = customerParameterServer.getValueMom();
                if (string5.equals("OamIpHost_oamSubnetMask") || string5.equals("OamIpHost_oamDefaultRouter0")) continue;
                if (string5.equals("IPoverGigabitEthernet_syncVid") || string5.equals("OamIpHost_oamVid")) {
                    vector.add(Nal.getFactory().getNameValue(string6, object));
                    int n = (Integer)object;
                    if (n != 0) {
                        vector.add(Nal.getFactory().getNameValue("vLan", Boolean.TRUE));
                        continue;
                    }
                    vector.add(Nal.getFactory().getNameValue("vLan", Boolean.FALSE));
                    continue;
                }
                vector.add(Nal.getFactory().getNameValue(string6, object));
            }
            if (vector.size() > 0) {
                this.setAttributes(bemMo, vector);
            }
        }
    }

    public String getLdn() {
        return "";
    }

    public String getDisplayName() {
        return name;
    }

    public MoInstance getMoi() {
        return this.ipInterfaceMoi;
    }

    public CustomerParameter getIpHostLinkSubnetMask() throws BemException {
        CustomerParameter customerParameter = null;
        if (this.rbs.isParameterSupported("OamIpHost_oamSubnetMask")) {
            customerParameter = this.rbs.getCustomerParameterObject("OamIpHost_oamSubnetMask");
        }
        return customerParameter;
    }

    public CustomerParameter getIpHostLinkDefaultRouter() throws BemException {
        CustomerParameter customerParameter = null;
        if (this.rbs.isParameterSupported("OamIpHost_oamDefaultRouter0")) {
            customerParameter = this.rbs.getCustomerParameterObject("OamIpHost_oamDefaultRouter0");
        }
        return customerParameter;
    }

    public void setUsedByBothIpHosts(boolean bl) {
        this.usedByBothIpHosts = bl;
    }
}

