/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.iprouting;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.iprouting.DynamicRouteTypesCPManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.iprouting.IpRoutingCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.iprouting.RouteUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalFactory;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class RoutingTableRI
extends AbstractResourceItem {
    public static final String name = "RoutingTableRI";
    private static String[] phases = new String[]{"IpRoutingSettingPhase", "DeleteStaticRoutePhase"};
    private final String ldn;
    private final ParameterRestriction ignoredRestriction = new ParameterRestriction("", 1);
    private final IpRoutingCI ipRoutingCI;
    private final IpAddressRange ipAddressRange = new IpAddressRange();
    private final IntegerRange integerRange = new IntegerRange(Integer.MIN_VALUE, Integer.MAX_VALUE);
    private ArrayList destIpAddressCP = null;
    private ArrayList destSubnetMaskAddressCP = null;
    private ArrayList nextHopAddressCP = null;
    private ArrayList routeMetricCP = null;
    private ArrayList redistributeCP = null;
    private IpAddressParameter dynamicDestIpAddressCP = null;
    private IpAddressParameter dynamicSubnetMaskAddressCP = null;
    private IpAddressParameter dynamicNextHopAddressCP = null;
    private IntegerParameter dynamicRouteMetricCP = null;
    private YesNoCustomerParameter dynamicRedistributeCP = null;

    public RoutingTableRI(Rbs rbs, IpRoutingCI ipRoutingCI) throws BemException {
        super(name, rbs, phases);
        this.ipRoutingCI = ipRoutingCI;
        this.ldn = this.rbs.getMoiRefs().getIpRoutingTable().getLdn();
        this.setupCustomerParameters();
    }

    public boolean isInstalled() throws BemException {
        return true;
    }

    boolean shouldRiBeInstalled() {
        boolean bl = false;
        int n = this.destIpAddressCP.size();
        for (int i = 0; i < n; ++i) {
            CustomerParameter customerParameter = (CustomerParameter)this.destIpAddressCP.get(i);
            CustomerParameter customerParameter2 = (CustomerParameter)this.destSubnetMaskAddressCP.get(i);
            CustomerParameter customerParameter3 = (CustomerParameter)this.nextHopAddressCP.get(i);
            CustomerParameter customerParameter4 = (CustomerParameter)this.routeMetricCP.get(i);
            CustomerParameter customerParameter5 = (CustomerParameter)this.redistributeCP.get(i);
            if (!customerParameter.hasValueChanged() && !customerParameter2.hasValueChanged() && !customerParameter3.hasValueChanged() && !customerParameter4.hasValueChanged() && !customerParameter5.hasValueChanged()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    boolean shouldRiBeUnInstalled() {
        boolean bl = false;
        int n = this.destIpAddressCP.size();
        for (int i = 0; i < n; ++i) {
            IpAddressParameter ipAddressParameter = (IpAddressParameter)this.destIpAddressCP.get(i);
            if (ipAddressParameter.getLoadedValue().equals("##UNDEFINED") || ipAddressParameter.getAccessLevel() != 1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void install(String string) throws BemException {
        ArrayList[] arrayListArray = new ArrayList[]{this.destIpAddressCP, this.destSubnetMaskAddressCP, this.nextHopAddressCP, this.routeMetricCP, this.redistributeCP};
        if (string.equals("IpRoutingSettingPhase")) {
            this.removeDuplicatedRoutes();
            Vector vector = RouteUtil.getCreatedRoutes(arrayListArray);
            this.addRoutesToRbs(vector);
        }
    }

    public void uninstall(String string) throws BemException {
        ArrayList[] arrayListArray = new ArrayList[]{this.destIpAddressCP, this.destSubnetMaskAddressCP, this.nextHopAddressCP, this.routeMetricCP, this.redistributeCP};
        if (string.equals("DeleteStaticRoutePhase")) {
            Vector vector = RouteUtil.getDeletedRoutes(arrayListArray);
            this.removeRoutesFromRbs(vector);
        }
    }

    void checkConsistency() throws BemException {
        int n = this.destIpAddressCP.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            CustomerParameter customerParameter = (CustomerParameter)this.destIpAddressCP.get(i);
            if (customerParameter.getAccessLevel() == 1) continue;
            bl = true;
            break;
        }
        String string = this.getRbs().getRbsStep();
        if (!bl && !string.equals("STEP_EXPANSION")) {
            throw new BemException("Routing not correctly configured.\nAt least one route must be added.");
        }
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return name;
    }

    private void setupCustomerParameters() throws BemException {
        NalStruct nalStruct = null;
        NalNameValue nalNameValue = null;
        Vector vector = this.getLoadedRoutingTableVector();
        int n = 0;
        this.destIpAddressCP = new ArrayList();
        this.destSubnetMaskAddressCP = new ArrayList();
        this.nextHopAddressCP = new ArrayList();
        this.routeMetricCP = new ArrayList();
        this.redistributeCP = new ArrayList();
        java.util.Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            nalStruct = (NalStruct)enumeration.nextElement();
            Integer n2 = new Integer(++n);
            String string = MessageFormat.format("R_{0}_", n2);
            nalNameValue = nalStruct.getMember("destinationIpAddr");
            CustomerParameterImpl customerParameterImpl = new IpAddressParameter(string + "routeIpAddress", this.ipAddressRange);
            customerParameterImpl.setLoadedValue(nalNameValue.getValue());
            this.destIpAddressCP.add(customerParameterImpl);
            this.ipRoutingCI.addParameter(customerParameterImpl);
            nalNameValue = nalStruct.getMember("destinationNetworkMask");
            customerParameterImpl = new IpAddressParameter(string + "routeSubnetMask", this.ipAddressRange);
            customerParameterImpl.setLoadedValue(nalNameValue.getValue());
            this.destSubnetMaskAddressCP.add(customerParameterImpl);
            this.ipRoutingCI.addParameter(customerParameterImpl);
            nalNameValue = nalStruct.getMember("nextHopIpAddr");
            customerParameterImpl = new IpAddressParameter(string + "hopIpAddress", this.ipAddressRange);
            customerParameterImpl.setLoadedValue(nalNameValue.getValue());
            this.nextHopAddressCP.add(customerParameterImpl);
            this.ipRoutingCI.addParameter(customerParameterImpl);
            nalNameValue = nalStruct.getMember("routeMetric");
            customerParameterImpl = new IntegerParameter(string + "routeMetric", this.integerRange);
            customerParameterImpl.setLoadedValue(nalNameValue.getValue());
            this.routeMetricCP.add(customerParameterImpl);
            this.ipRoutingCI.addParameter(customerParameterImpl);
            nalNameValue = nalStruct.getMember("redistribute");
            customerParameterImpl = new YesNoCustomerParameter(string + "redistribute");
            Boolean bl = (Boolean)nalNameValue.getValue();
            String string2 = bl.toString();
            String string3 = this.translateBooleanToYesNo(string2);
            ((YesNoCustomerParameter)customerParameterImpl).setLoadedValue(string3);
            this.redistributeCP.add(customerParameterImpl);
            this.ipRoutingCI.addParameter(customerParameterImpl);
        }
    }

    private String translateBooleanToYesNo(String string) {
        String string2 = string;
        string2 = string.equalsIgnoreCase("true") ? "YES" : "NO";
        return string2;
    }

    public String removeCP(List list) {
        String string = "";
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            try {
                CustomerParameterServer customerParameterServer = (CustomerParameterServer)list.get(i);
                customerParameterServer.addRestriction(this.ignoredRestriction);
                continue;
            }
            catch (Exception exception) {
                string = exception.toString();
            }
        }
        return string;
    }

    void addFromValues(String string, String string2, String string3, String string4, String string5) throws BemException {
        this.createCP();
        this.dynamicDestIpAddressCP.setValue(string);
        this.dynamicSubnetMaskAddressCP.setValue(string2);
        this.dynamicNextHopAddressCP.setValue(string3);
        this.dynamicRouteMetricCP.setValue(string4);
        this.dynamicRedistributeCP.setValue(string5);
        this.checkDynamicConsistency();
    }

    public List createCP() {
        ArrayList<CustomerParameterImpl> arrayList = new ArrayList<CustomerParameterImpl>();
        int n = this.destIpAddressCP.size() + 1;
        Integer n2 = new Integer(n);
        String string = MessageFormat.format("R_{0}_", n2);
        DynamicRouteTypesCPManager dynamicRouteTypesCPManager = new DynamicRouteTypesCPManager();
        Enumeration enumeration = dynamicRouteTypesCPManager.createDynamicRouteTypesCP(string);
        arrayList.add(enumeration);
        this.dynamicDestIpAddressCP = new IpAddressParameter(string + "routeIpAddress", this.ipAddressRange);
        this.dynamicDestIpAddressCP.setValue("0.0.0.0");
        arrayList.add(this.dynamicDestIpAddressCP);
        this.destIpAddressCP.add(this.dynamicDestIpAddressCP);
        this.ipRoutingCI.addParameter(this.dynamicDestIpAddressCP);
        this.dynamicSubnetMaskAddressCP = new IpAddressParameter(string + "routeSubnetMask", this.ipAddressRange);
        this.dynamicSubnetMaskAddressCP.setValue("0.0.0.0");
        arrayList.add(this.dynamicSubnetMaskAddressCP);
        this.destSubnetMaskAddressCP.add(this.dynamicSubnetMaskAddressCP);
        this.ipRoutingCI.addParameter(this.dynamicSubnetMaskAddressCP);
        this.dynamicNextHopAddressCP = new IpAddressParameter(string + "hopIpAddress", this.ipAddressRange);
        this.dynamicNextHopAddressCP.setValue("");
        arrayList.add(this.dynamicNextHopAddressCP);
        this.nextHopAddressCP.add(this.dynamicNextHopAddressCP);
        this.ipRoutingCI.addParameter(this.dynamicNextHopAddressCP);
        this.dynamicRouteMetricCP = new IntegerParameter(string + "routeMetric", this.integerRange);
        this.dynamicRouteMetricCP.setValue("100");
        arrayList.add(this.dynamicRouteMetricCP);
        this.routeMetricCP.add(this.dynamicRouteMetricCP);
        this.ipRoutingCI.addParameter(this.dynamicRouteMetricCP);
        this.dynamicRedistributeCP = new YesNoCustomerParameter(string + "redistribute");
        this.dynamicRedistributeCP.setValue("NO");
        arrayList.add(this.dynamicRedistributeCP);
        this.redistributeCP.add(this.dynamicRedistributeCP);
        this.ipRoutingCI.addParameter(this.dynamicRedistributeCP);
        dynamicRouteTypesCPManager.activateListener(this.dynamicDestIpAddressCP, this.dynamicSubnetMaskAddressCP, this.dynamicNextHopAddressCP, this.dynamicRouteMetricCP, this.dynamicRedistributeCP);
        return arrayList;
    }

    void checkDynamicConsistency() throws BemException {
        if (!this.dynamicDestIpAddressCP.isValidValue()) {
            throw new BemException("Destination IP address is invalid. Reason= " + this.dynamicDestIpAddressCP.getInvalidityReason());
        }
        if (this.dynamicDestIpAddressCP.getValue().length() < 7) {
            throw new BemException("Destination IP address is invalid. Reason= incorrect ip address entered");
        }
        if (!this.dynamicSubnetMaskAddressCP.isValidValue()) {
            throw new BemException("Subnet mask is invalid. Reason= " + this.dynamicSubnetMaskAddressCP.getInvalidityReason());
        }
        if (this.dynamicSubnetMaskAddressCP.getValue().length() < 7) {
            throw new BemException("Subnet mask is invalid. Reason= incorrect ip address entered");
        }
        if (!this.dynamicNextHopAddressCP.isValidValue()) {
            throw new BemException("Next hop address is invalid. Reason= " + this.dynamicNextHopAddressCP.getInvalidityReason());
        }
        if (this.dynamicNextHopAddressCP.getValue().length() < 7) {
            throw new BemException("Next hop address is invalid. Reason= incorrect ip address entered");
        }
        if (!this.dynamicRouteMetricCP.isValidValue()) {
            throw new BemException("Route Metric is invalid. Reason= " + this.dynamicRouteMetricCP.getInvalidityReason());
        }
        if (!this.dynamicRedistributeCP.isValidValue()) {
            throw new BemException("Redistribute is invalid. Reason= " + this.dynamicRedistributeCP.getInvalidityReason());
        }
        this.removeDuplicatedRoutes();
    }

    private void removeDuplicatedRoutes() {
        int n = this.destIpAddressCP.size();
        int n2 = this.destSubnetMaskAddressCP.size();
        int n3 = this.nextHopAddressCP.size();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (n == n2 && n == n3) {
            for (int i = 0; i < n; ++i) {
                CustomerParameter customerParameter;
                String string = "";
                CustomerParameter customerParameter2 = customerParameter = (CustomerParameter)this.destIpAddressCP.get(i);
                int n4 = customerParameter.getAccessLevel();
                if (n4 == 1) continue;
                String string2 = customerParameter.getValue();
                String string3 = customerParameter.getName();
                int n5 = string3.lastIndexOf("_");
                string = string + string3.substring(n5 + 1) + "=" + string2 + " ";
                customerParameter = (CustomerParameter)this.destSubnetMaskAddressCP.get(i);
                string2 = customerParameter.getValue();
                string3 = customerParameter.getName();
                n5 = string3.lastIndexOf("_");
                string = string + string3.substring(n5 + 1) + "=" + string2 + " ";
                customerParameter = (CustomerParameter)this.nextHopAddressCP.get(i);
                string2 = customerParameter.getValue();
                string3 = customerParameter.getName();
                n5 = string3.lastIndexOf("_");
                string = string + string3.substring(n5 + 1) + "=" + string2 + " ";
                customerParameter = (CustomerParameter)this.routeMetricCP.get(i);
                string2 = customerParameter.getValue();
                string3 = customerParameter.getName();
                n5 = string3.lastIndexOf("_");
                String string4 = hashMap.put(string = string + string3.substring(n5 + 1) + "=" + string2 + " ", string);
                if (string4 == null) continue;
                ArrayList<CustomerParameter> arrayList = new ArrayList<CustomerParameter>();
                arrayList.add(customerParameter2);
                this.removeCP(arrayList);
            }
        }
    }

    public void removeRouteIfExisting(String string, String string2, String string3, String string4, String string5) throws BemException {
        int n = this.destIpAddressCP.size();
        for (int i = 0; i < n; ++i) {
            CustomerParameter customerParameter = (CustomerParameter)this.destIpAddressCP.get(i);
            CustomerParameter customerParameter2 = (CustomerParameter)this.destSubnetMaskAddressCP.get(i);
            CustomerParameter customerParameter3 = (CustomerParameter)this.nextHopAddressCP.get(i);
            CustomerParameter customerParameter4 = (CustomerParameter)this.routeMetricCP.get(i);
            CustomerParameter customerParameter5 = (CustomerParameter)this.redistributeCP.get(i);
            if (!customerParameter.getValue().equals(string) || !customerParameter2.getValue().equals(string2) || !customerParameter3.getValue().equals(string3) || customerParameter4.getValue().equals(string4) && customerParameter5.getValue().equals(string5)) continue;
            CustomerParameterImpl customerParameterImpl = null;
            String string6 = "";
            customerParameterImpl = (CustomerParameterImpl)this.rbs.getCustomerParameterServerObject("defaultRouter");
            string6 = customerParameterImpl.getValue();
            if (!string3.equals(string6)) continue;
            ArrayList<CustomerParameter> arrayList = new ArrayList<CustomerParameter>();
            arrayList.add(customerParameter);
            arrayList.add(customerParameter2);
            arrayList.add(customerParameter3);
            arrayList.add(customerParameter4);
            arrayList.add(customerParameter5);
            this.removeCP(arrayList);
        }
    }

    Vector getLoadedRoutingTableVector() throws BemException {
        Vector<NalStruct> vector = new Vector<NalStruct>(0, 1);
        String string = null;
        NalNameValue[] nalNameValueArray = null;
        NalFactory nalFactory = Nal.getFactory();
        NalTransaction nalTransaction = nalFactory.createTransaction();
        BemMo bemMo = this.getMo(this.ldn);
        try {
            string = "numberOfRoutes";
            nalNameValueArray = new NalNameValue[]{};
            Integer n = (Integer)bemMo.action(string, nalNameValueArray, nalTransaction);
            if (n == null) {
                throw new NullPointerException("Action=" + string + "on the ipRoutingTableMo=" + bemMo + " returned Integer noRoutes=null" + "!");
            }
            int[] nArray = (int[])bemMo.getAttribute("indexOfDeletableStaticRoutes", nalTransaction);
            string = "getRoutingTableEntry";
            NalNameValue nalNameValue = Nal.getFactory().getNameValue("index", null);
            nalNameValueArray = new NalNameValue[]{nalNameValue};
            for (int i = 0; i < n; ++i) {
                String string2 = nalNameValueArray[0].getName();
                Integer n2 = new Integer(i);
                nalNameValueArray[0] = Nal.getFactory().getNameValue(string2, n2);
                NalStruct nalStruct = (NalStruct)bemMo.action(string, nalNameValueArray, nalTransaction);
                NalNameValue nalNameValue2 = nalStruct.getMember("routeType");
                Integer n3 = (Integer)nalNameValue2.getValue();
                int n4 = 2;
                boolean bl = RouteUtil.isRouteDeletable(nArray, i);
                if (n3 != n4 || !bl) continue;
                vector.add(nalStruct);
            }
            nalTransaction.commit();
        }
        catch (NalCmException nalCmException) {
            BemException bemException = null;
            try {
                StringBuffer stringBuffer = new StringBuffer();
                if (nalNameValueArray != null) {
                    for (int i = 0; i < nalNameValueArray.length; ++i) {
                        stringBuffer.append(nalNameValueArray[i]).append(", ");
                    }
                }
                bemException = new BemException(null, "Action->" + string, "", "parameters: " + stringBuffer.toString(), nalCmException);
                nalTransaction.rollback("Failed to getLoadedRoutingTable", bemException);
                throw bemException;
            }
            catch (NalCmException nalCmException2) {
                throw new BemException(this.getClass().getName(), "Rollback transaction error", null, nalCmException2.toString(), nalCmException2);
            }
        }
        return vector;
    }

    void addRoutesToRbs(Vector vector) throws BemException {
        String string = null;
        NalNameValue[] nalNameValueArray = null;
        string = "addStaticRoute";
        nalNameValueArray = new NalNameValue[5];
        for (NalStruct nalStruct : vector) {
            nalNameValueArray[0] = nalStruct.getMember("destinationIpAddr");
            nalNameValueArray[1] = nalStruct.getMember("destinationNetworkMask");
            nalNameValueArray[2] = nalStruct.getMember("nextHopIpAddr");
            nalNameValueArray[3] = nalStruct.getMember("routeMetric");
            nalNameValueArray[4] = nalStruct.getMember("redistribute");
            RouteUtil.changeName(nalNameValueArray, 0, "ipAddress");
            RouteUtil.changeName(nalNameValueArray, 1, "subnetMask");
            RouteUtil.changeName(nalNameValueArray, 2, "hopIpAddress");
            RouteUtil.changeName(nalNameValueArray, 3, "routeMetric");
            RouteUtil.changeName(nalNameValueArray, 4, "redistribute");
            BemMo bemMo = this.getMo(this.ldn);
            this.action(bemMo, string, nalNameValueArray);
        }
    }

    void removeRoutesFromRbs(Vector vector) throws BemException {
        String string = null;
        NalNameValue[] nalNameValueArray = null;
        string = "deleteStaticRoute";
        nalNameValueArray = new NalNameValue[1];
        for (NalStruct nalStruct : vector) {
            nalNameValueArray[0] = Nal.getFactory().getNameValue("routingTableEntry", nalStruct);
            BemMo bemMo = this.getMo(this.ldn);
            this.action(bemMo, string, nalNameValueArray);
        }
    }
}

