/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.networksync;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.AtmPortProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.PhysicalTerminationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.provider.GigabitEthernetSyncRefProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.provider.IpSyncRefListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.provider.IpSyncRefProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.provider.PacketFrequencySyncRefListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.provider.PacketFrequencySyncRefProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.networksync.CpriBasedSyncRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.networksync.SynchronizationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.ControlSystemProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public class NetworkSyncCI
extends AbstractConfigurationItem
implements IpSyncRefListener,
PacketFrequencySyncRefListener,
CustomerParameterListener {
    public static final String name = "NetworkSyncCI";
    private boolean isOpen = false;
    PhysicalTerminationProvider physicalTerminationProvider = null;
    ControlSystemProvider controlSystemProvider = null;
    AtmPortProvider atmPortProvider = null;
    IpSyncRefProvider ipSyncRefProvider = null;
    PacketFrequencySyncRefProvider packetFrequencySyncRefProvider = null;
    private GigabitEthernetSyncRefProvider gigabitEthernetSyncRefProvider = null;
    SynchronizationRI synchronizationRI = null;
    CpriBasedSyncRI cpribasedsyncRI = null;
    public static final String ACTION_VALUE_ADD = "ADD";
    public static final String ACTION_VALUE_DELETE = "DELETE";

    public NetworkSyncCI(Rbs rbs) {
        super(rbs);
    }

    public boolean open() throws BemException {
        boolean bl = true;
        try {
            if (this.isOpen) {
                throw new BemException("NetworkSyncCI.open(): Already open");
            }
            this.setupProviders();
            this.synchronizationRI = DuwUtil.hasDuw() ? new SynchronizationRI(this.getRbs(), this, this.physicalTerminationProvider, this.controlSystemProvider, this.atmPortProvider, this.ipSyncRefProvider, this.packetFrequencySyncRefProvider, this.gigabitEthernetSyncRefProvider) : new SynchronizationRI(this.getRbs(), this, this.physicalTerminationProvider, this.controlSystemProvider, this.atmPortProvider, this.ipSyncRefProvider);
            this.cpribasedsyncRI = new CpriBasedSyncRI(this.getRbs());
            List list = this.cpribasedsyncRI.createCustomerParameters();
            this.addCustomerParameters(list);
            this.cpribasedsyncRI.initiateCPWithNodeValues();
            this.isOpen = true;
        }
        catch (BemException bemException) {
            bemException.setProperty("ConfigItem (CI)", name);
            throw bemException;
        }
        return bl;
    }

    private void addCustomerParameters(List list) {
        if (list != null) {
            for (CustomerParameter customerParameter : list) {
                this.addParameter(customerParameter);
            }
        }
    }

    private void setupProviders() throws BemException {
        AbstractConfigurationItem abstractConfigurationItem;
        if (this.physicalTerminationProvider == null) {
            this.physicalTerminationProvider = (PhysicalTerminationProvider)((Object)this.getRbs().getConfigItem("AtmAndPtCI"));
            if (this.physicalTerminationProvider == null) {
                throw new BemException("NetworkSyncCI.open(): can not obtain PhysicalTerminationProvider");
            }
        }
        if (this.atmPortProvider == null) {
            this.atmPortProvider = (AtmPortProvider)((Object)this.getRbs().getConfigItem("AtmAndPtCI"));
            if (this.atmPortProvider == null) {
                throw new BemException("NetworkSyncCI.open(): can not obtain AtmPortProvider");
            }
        }
        if (this.controlSystemProvider == null) {
            this.controlSystemProvider = (ControlSystemProvider)((Object)this.getRbs().getConfigItem("CabinetBasicCI"));
            if (this.controlSystemProvider == null) {
                throw new BemException("NetworkSyncCI.open(): can not obtain ControlSystemProvider");
            }
        }
        if (this.ipSyncRefProvider == null && (abstractConfigurationItem = (AbstractConfigurationItem)this.getRbs().getConfigItem("IpOverGigabitEthernetCI")).isOpen()) {
            this.ipSyncRefProvider = (IpSyncRefProvider)((Object)this.getRbs().getConfigItem("IpOverGigabitEthernetCI"));
            if (this.ipSyncRefProvider == null) {
                throw new BemException("NetworkSyncCI.open(): can not obtain IpSyncRefProvider");
            }
            this.ipSyncRefProvider.addIpSyncRefListener(this);
        }
        if (DuwUtil.hasDuw() && this.packetFrequencySyncRefProvider == null && (abstractConfigurationItem = (AbstractConfigurationItem)this.getRbs().getConfigItem("IpOverGigabitEthernetCI")).isOpen()) {
            this.packetFrequencySyncRefProvider = (PacketFrequencySyncRefProvider)((Object)this.getRbs().getConfigItem("IpOverGigabitEthernetCI"));
            if (this.packetFrequencySyncRefProvider == null) {
                throw new BemException("NetworkSyncCI.open(): can not obtain IpSyncRefProvider");
            }
            this.packetFrequencySyncRefProvider.addPacketFrequencySyncRefListener(this);
        }
        if (this.gigabitEthernetSyncRefProvider == null && (abstractConfigurationItem = (AbstractConfigurationItem)this.getRbs().getConfigItem("IpOverGigabitEthernetCI")) != null && abstractConfigurationItem.isOpen()) {
            this.gigabitEthernetSyncRefProvider = (GigabitEthernetSyncRefProvider)((Object)this.getRbs().getConfigItem("EthernetSwitchCI"));
            if (this.gigabitEthernetSyncRefProvider == null) {
                throw new BemException("NetworkSyncCI.open(): can not obtain IpSyncRefProvider");
            }
        }
    }

    public boolean open(ServiceValue serviceValue) throws BemException {
        boolean bl = true;
        try {
            this.open();
            this.setCustomerParameters(serviceValue);
            this.checkConsistency();
        }
        catch (BemException bemException) {
            throw bemException;
        }
        catch (Exception exception) {
            throw new BemException("NetworkSyncCI.open(sv) got exception=" + exception.toString());
        }
        return bl;
    }

    public void refreshCI() throws BemException {
        this.synchronizationRI.refreshRI();
    }

    public void checkConsistency() throws BemException {
        super.checkConsistency();
        this.synchronizationRI.checkConsistency();
        this.cpribasedsyncRI.checkConsistency();
    }

    public String getName() {
        return name;
    }

    public ArrayList getNeededRIs() throws BemException {
        ArrayList arrayList = this.getRIsToBeInstalled();
        return arrayList;
    }

    public ArrayList getRIsToBeInstalled() throws BemException {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        if (!this.isOpen) {
            throw new BemException("getRIsToBeInstalled : CI not open");
        }
        this.checkConsistency();
        if (this.synchronizationRI.shouldRiBeInstalled()) {
            arrayList.add(this.synchronizationRI);
        }
        if (this.cpribasedsyncRI.shouldRiBeInstalled()) {
            arrayList.add(this.cpribasedsyncRI);
        }
        return arrayList;
    }

    public List getRIsToUninstall() throws BemException {
        ArrayList<SynchronizationRI> arrayList = new ArrayList<SynchronizationRI>();
        if (!this.isOpen) {
            throw new BemException("getRIsToBeUnInstalled : CI not open");
        }
        if (this.synchronizationRI.shouldRiBeUninstalled()) {
            arrayList.add(this.synchronizationRI);
        }
        return arrayList;
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        int n;
        this.synchronizationRI.refreshRI();
        Integer n2 = null;
        String string8 = null;
        boolean bl = false;
        boolean bl2 = false;
        String string9 = null;
        String string10 = null;
        String string11 = this.getRbs().getRbsStep();
        for (n = 0; n < 8; ++n) {
            n2 = new Integer(n + 1);
            string8 = MessageFormat.format("Y_{0}_", n2);
            string7 = string8 + "synchSlot";
            string6 = string8 + "synchPort";
            string5 = this.getRbs().getCustomerParameter(string6);
            if (string5.equals("5")) {
                bl = true;
                string9 = string7;
                string10 = string6;
            }
            if (!string5.equals("6")) continue;
            bl2 = true;
            string9 = string7;
            string10 = string6;
        }
        for (n = 0; n < 8; ++n) {
            n2 = new Integer(n + 1);
            string8 = MessageFormat.format("Y_{0}_", n2);
            string7 = string8 + "synchSlot";
            string6 = serviceValue.getValue(string7);
            if (string6 == null) {
                if (string11.equals("STEP_EXPANSION") || string11.equals("STEP_SITE")) continue;
                this.getRbs().setCustomerParameter(string7, "-");
                continue;
            }
            string5 = string8 + "synchPort";
            string4 = serviceValue.getValue(string5);
            string3 = this.getRbs().getCustomerParameter(string5);
            if (string11.equals("STEP_EXPANSION") && (string2 = serviceValue.getValue(string = string8 + "action")) != null) {
                if (!string4.equals("5")) {
                    if (!string4.equals("6")) {
                        throw new BemException("Only support ADD/DELETE for GpsSyncRef/TuSyncREf");
                    }
                }
                if (string2.equals(ACTION_VALUE_ADD)) {
                    if (string4 != null && string3 != null && string4.equals(string3)) {
                        if (string4.equals("5")) {
                            throw new BemException("GpsSyncRef exists");
                        }
                        if (string4.equals("6")) {
                            throw new BemException("TuSynRef exists");
                        }
                    }
                    if (string4.equals("5") && bl2) {
                        this.getRbs().setCustomerParameter(string9, "-");
                        this.getRbs().setCustomerParameter(string10, "-");
                    } else if (string4.equals("6") && bl) {
                        this.getRbs().setCustomerParameter(string9, "-");
                        this.getRbs().setCustomerParameter(string10, "-");
                    }
                } else if (string2.equals(ACTION_VALUE_DELETE) && string4 != null && string3 != null && !string4.equals(string3)) {
                    if (string4.equals("5")) {
                        throw new BemException("GpsSyncRef does not exist");
                    }
                    if (string4.equals("6")) {
                        throw new BemException("TuSynRef does not exist");
                    }
                }
                this.getRbs().setCustomerParameter(string, string2);
            }
            this.getRbs().setCustomerParameter(string7, string6);
            this.getRbs().setCustomerParameter(string5, string4);
        }
        String string12 = "configureCpriBasedSync";
        string7 = serviceValue.getValue(string12);
        string6 = "administrativeState";
        string5 = serviceValue.getValue(string6);
        string4 = "syncNodePriority";
        string3 = serviceValue.getValue(string4);
        string = "syncRiPortCandidate";
        string2 = serviceValue.getValue(string);
        if (string7 != null && string7.equals("YES")) {
            if (string11.equals("STEP_EXPANSION")) {
                if (string3 == null) {
                    throw new BemException("syncNodePriority should be set");
                }
                if (string2 == null) {
                    throw new BemException("syncRiPortCandidate should be set");
                }
            }
            this.getRbs().setCustomerParameter(string12, string7);
            this.getRbs().setCustomerParameter(string6, string5);
            this.getRbs().setCustomerParameter(string4, string3);
            string2 = this.trimSpaceCharOfSyncRiPortCandidate(string2);
            this.getRbs().setCustomerParameter(string, string2);
        } else if (string7 != null && string7.equals("NO")) {
            this.getRbs().setCustomerParameter(string12, string7);
        }
    }

    private String trimSpaceCharOfSyncRiPortCandidate(String string) {
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            if (bl) {
                stringBuffer.append(",");
            }
            string2 = stringTokenizer.nextToken();
            String string3 = string2.trim();
            stringBuffer.append(string3);
            bl = true;
        }
        return stringBuffer.toString();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public ConfigurationCheckReport checkConfiguration() throws BemException {
        ConfigurationCheckReport configurationCheckReport = new ConfigurationCheckReport();
        return configurationCheckReport;
    }

    public static int getNumberOfSyncs() {
        return 8;
    }

    public void updateIpSyncRef() {
        try {
            this.refreshCI();
        }
        catch (BemException bemException) {
            System.out.println("NetworkSyncCI.updateIpSyncRef() " + bemException.toString());
        }
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
    }

    public void updateFrequencySyncRef() {
        try {
            this.refreshCI();
        }
        catch (BemException bemException) {
            System.out.println("NetworkSyncCI.updateIpSyncRef() " + bemException.toString());
        }
    }
}

