/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3.CuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3.CuSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3.PowerDistrSystemRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;

public class PowerDistrManager {
    private Rbs rbs;
    private boolean isPowerDistrSupported;
    private String cabinetPosition;
    private String subrackPosition;
    private ArrayList listOfRIs;
    private CuRI cuRI;
    private CuSubrackRI cuSubrackRI;
    private PowerDistrSystemRI powerDistrSystemRI;

    public PowerDistrManager(Rbs rbs, boolean bl, String string, String string2) throws BemException {
        this.cabinetPosition = string;
        this.subrackPosition = string2;
        this.rbs = rbs;
        this.isPowerDistrSupported = bl;
        this.listOfRIs = new ArrayList(0);
        this.createRIs();
    }

    private void createRIs() throws BemException {
        if (this.isPowerDistrSupported) {
            this.cuSubrackRI = new CuSubrackRI(this.rbs, this.cabinetPosition, this.subrackPosition);
            MoInstance moInstance = this.cuSubrackRI.getMoi();
            this.cuRI = new CuRI(this.rbs, moInstance);
            this.powerDistrSystemRI = new PowerDistrSystemRI(this.rbs);
            this.listOfRIs.add(this.cuSubrackRI);
            this.listOfRIs.add(this.cuRI);
            this.listOfRIs.add(this.powerDistrSystemRI);
        }
    }

    public ArrayList getRIsToBeInstalled() {
        return this.listOfRIs;
    }

    public boolean isPowerDistrSupported() {
        return this.isPowerDistrSupported;
    }
}

