/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.check.ReportEntry;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AntennaSystemProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.CellAndCarrierProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EquippedSectorRadioInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.AbstractRadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.NoOfCarriersParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.SectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.AtfProviderInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.Configuration;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.SectorCapability;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.SectorCapabilityManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.reconfigurations.Reconfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.custparam.OutputPowerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProviderImpl;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public abstract class AbstractRbs3RadioEquipmentCI
extends AbstractRadioEquipmentCI {
    private static final String NO_CONFIGURED_SECTORS_ERROR_MESSAGE = "At least one sector must be configured";
    private static final String RECONFIGURATION_NOT_SUPPORTED_RESTRICTION = "The type of reconfiguration is not supported";
    private static final String PRECONDITIONS_NOT_MET_RESTRICTION = "The preconditions for reconfiguration are not met: ";
    private static final String NOT_POSSIBLE_TO_DELETE_SECTOR = "Not possible to delete sector ";
    private static final String NOT_ALLOWED_COMBINATION = "This combination of carriers and output power is not allowed";
    private static final String OUTPUT_POWER_IGNORED = "Output power is ignored";
    private static final String OUTPUT_POWER_EXTERNAL_MIX = "EXTERNAL output power can not be mixed with other output power types";
    private boolean isOpen;
    private int maxNoOfSectors;
    private int maxNoOfCarriers;
    private String VALUE_NO = "NO";
    private String VALUE_YES = "YES";
    private String[] createSectorServiceNames;
    private String[] noOfCarriersServiceNames;
    private String[] outputPowerServiceNames;
    private YesNoCustomerParameter[] createSectorParameters;
    private NoOfCarriersParameter[] noOfCarriersParameters;
    private OutputPowerParameter[] outputPowerParameters;
    private ParameterRestriction[] dynamicOutputPowerRestriction;
    private ParameterRestriction[] outputPowerSupportedReconfRestriction;
    private ParameterRestriction[] outputPowerPreconditionReconfRestriction;
    private ParameterRestriction[] outputPowerRestrictionIgnore;
    private ParameterRestriction[] deleteSectorRestriction;
    private SectorRI[] sectors;
    private Configuration[] configurations;
    private SectorCapabilityManager sectorCapabilityMgr = new SectorCapabilityManager();
    private Map installedConfigurations = new HashMap();
    private AtfProviderImpl myAtfProvider;
    public static final int NUMBER_OF_TX_BRANCHES_PER_CARRIER_FOR_TX_DIVERSITY = 2;
    public static final int NUMBER_OF_RX_BRANCHES_PER_SECTOR_FOR_RX_DIVERSITY = 2;
    public static final int NUMBER_OF_SECTORANTENNA_PER_SECTOR = 1;

    public AbstractRbs3RadioEquipmentCI(Rbs rbs) {
        super(rbs);
        this.maxNoOfSectors = rbs.getMaxNumberOfSectors();
        this.maxNoOfCarriers = rbs.getMaxNumberOfCarriers();
        this.configurations = new Configuration[this.maxNoOfSectors];
        this.initServiceNames();
    }

    private void initServiceNames() {
        this.createSectorServiceNames = new String[this.maxNoOfSectors];
        this.noOfCarriersServiceNames = new String[this.maxNoOfSectors];
        this.outputPowerServiceNames = new String[this.maxNoOfSectors];
        for (int i = 1; i <= this.maxNoOfSectors; ++i) {
            String string = MessageFormat.format("S{0}_", new Integer(i));
            this.createSectorServiceNames[i - 1] = string + "createSector";
            this.noOfCarriersServiceNames[i - 1] = string + "numberOfCarriers";
            this.outputPowerServiceNames[i - 1] = string + "outputPower";
        }
    }

    public boolean open() throws BemException {
        if (this.isOpen) {
            return true;
        }
        super.open();
        this.isOpen = true;
        this.createConfigurations();
        this.createCustomerParameters();
        this.updateLoadedValues();
        this.createSectors();
        this.updateLoadedSectors();
        return true;
    }

    public boolean open(ServiceValue serviceValue) throws BemException {
        boolean bl = false;
        bl = super.open(serviceValue);
        if (!bl) {
            for (int i = 0; i < this.maxNoOfSectors; ++i) {
                String string = serviceValue.getValue(this.createSectorServiceNames[i]);
                String string2 = serviceValue.getValue(this.noOfCarriersServiceNames[i]);
                String string3 = serviceValue.getValue(this.outputPowerServiceNames[i]);
                if (string3 == null && string2 == null && string == null) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            return false;
        }
        this.open();
        return true;
    }

    private void createSectors() throws BemException {
        this.sectors = new SectorRI[this.maxNoOfSectors];
        AntennaSystemProvider antennaSystemProvider = null;
        try {
            antennaSystemProvider = this.getRbs().getAntennaSystemProvider();
        }
        catch (Exception exception) {
            throw new BemException("getAntennaSystemProvider", "AntennaSystemCI", (Throwable)exception);
        }
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            this.sectors[i] = new SectorRI(this.getRbs(), antennaSystemProvider.getSectorLdn(i + 1), i + 1);
        }
    }

    protected abstract void createConfigurations() throws BemException;

    protected void addSectorCapability(int n, SectorCapability sectorCapability) {
        this.sectorCapabilityMgr.addSectorCapability(n, sectorCapability);
        this.setupAtfProvider(sectorCapability);
    }

    protected SectorCapabilityManager getSectorCapabilityManager() {
        return this.sectorCapabilityMgr;
    }

    private void createCustomerParameters() throws BemException {
        this.createSectorParameters = new YesNoCustomerParameter[this.maxNoOfSectors];
        this.noOfCarriersParameters = new NoOfCarriersParameter[this.maxNoOfSectors];
        this.outputPowerParameters = new OutputPowerParameter[this.maxNoOfSectors];
        this.dynamicOutputPowerRestriction = new ParameterRestriction[this.maxNoOfSectors];
        this.outputPowerSupportedReconfRestriction = new ParameterRestriction[this.maxNoOfSectors];
        this.outputPowerPreconditionReconfRestriction = new ParameterRestriction[this.maxNoOfSectors];
        this.deleteSectorRestriction = new ParameterRestriction[this.maxNoOfSectors];
        this.outputPowerRestrictionIgnore = new ParameterRestriction[this.maxNoOfSectors];
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            SectorCapability sectorCapability = this.sectorCapabilityMgr.getSectorCapability(i + 1);
            Configuration[] configurationArray = sectorCapability.getConfigurations();
            if (this.useCreateSectorParameter()) {
                this.createSectorParameters[i] = new YesNoCustomerParameter(this.createSectorServiceNames[i]);
                this.addParameter(this.createSectorParameters[i]);
                this.createSectorParameters[i].setDefaultValue(this.VALUE_NO);
                continue;
            }
            EnumeratedRange enumeratedRange = this.getNoOfCarriersRange(configurationArray, true);
            this.noOfCarriersParameters[i] = new NoOfCarriersParameter(this.noOfCarriersServiceNames[i], enumeratedRange);
            this.addParameter(this.noOfCarriersParameters[i]);
            EnumeratedRange enumeratedRange2 = this.getOutputPowerRange(configurationArray);
            this.outputPowerParameters[i] = new OutputPowerParameter(this.outputPowerServiceNames[i], enumeratedRange2);
            this.addParameter(this.outputPowerParameters[i]);
            this.dynamicOutputPowerRestriction[i] = new ParameterRestriction(NOT_ALLOWED_COMBINATION, enumeratedRange2, true);
            this.outputPowerParameters[i].addRestriction(this.dynamicOutputPowerRestriction[i]);
            this.outputPowerRestrictionIgnore[i] = new ParameterRestriction(OUTPUT_POWER_IGNORED, 1);
            this.outputPowerParameters[i].addRestriction(this.outputPowerRestrictionIgnore[i]);
            this.noOfCarriersParameters[i].setDefaultValue("0");
            this.outputPowerParameters[i].setDefaultValue(this.getDefaultOutputPower(configurationArray));
        }
        this.addParameterListeners();
    }

    private void addParameterListeners() {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            if (this.useCreateSectorParameter()) {
                this.createSectorParameters[i].addCustomerParameterListener(new CreateSectorListener(i + 1));
                continue;
            }
            this.noOfCarriersParameters[i].addCustomerParameterListener(new NoOfCarriersListener(i + 1));
            this.outputPowerParameters[i].addCustomerParameterListener(new OutputPowerListener(i + 1));
        }
    }

    private EnumeratedRange getNoOfCarriersRange(Configuration[] configurationArray, boolean bl) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        if (bl) {
            treeSet.add(new Integer(0));
        }
        for (int i = 0; i < configurationArray.length; ++i) {
            int n = configurationArray[i].getNoOfCarriers();
            treeSet.add(new Integer(n));
        }
        String[] stringArray = new String[treeSet.size()];
        Iterator iterator = treeSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = iterator.next().toString();
            ++n;
        }
        return new EnumeratedRange(stringArray);
    }

    private EnumeratedRange getOutputPowerRange(Configuration[] configurationArray) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < configurationArray.length; ++i) {
            String string = configurationArray[i].getOutputPower();
            treeSet.add(string);
        }
        String[] stringArray = treeSet.toArray(new String[0]);
        return new EnumeratedRange(stringArray);
    }

    private String getDefaultOutputPower(Configuration[] configurationArray) {
        String string = null;
        if (configurationArray.length > 0) {
            string = configurationArray[0].getOutputPower();
        }
        for (int i = 0; i < configurationArray.length; ++i) {
            String string2 = configurationArray[i].getOutputPower();
            if (!"NORMAL".equals(string2)) continue;
            string = string2;
            break;
        }
        return string;
    }

    public EquippedSectorRadioInfo[] getEquippedSectorsRadioInfo() {
        throw new RuntimeException("Only implemented for DUW");
    }

    protected void updateLoadedValues() throws BemException {
        try {
            block2: for (int i = 1; i <= this.maxNoOfSectors; ++i) {
                SectorCapability sectorCapability = this.sectorCapabilityMgr.getSectorCapability(i);
                Configuration[] configurationArray = sectorCapability.getConfigurations();
                for (int j = 0; j < configurationArray.length; ++j) {
                    boolean bl = configurationArray[j].isInstalled();
                    if (bl) {
                        Object[] objectArray;
                        Reconfiguration[] reconfigurationArray;
                        this.configurations[i - 1] = configurationArray[j];
                        if (this.useCreateSectorParameter()) {
                            String string = configurationArray[j].getCreateSector();
                            this.createSectorParameters[i - 1].setLoadedValue(String.valueOf(string));
                            reconfigurationArray = sectorCapability.getReconfigurations(this.configurations[i - 1]);
                            objectArray = new Configuration[reconfigurationArray.length + 1];
                            objectArray[0] = this.configurations[i - 1];
                            for (int k = 1; k < objectArray.length; ++k) {
                                objectArray[k] = reconfigurationArray[k - 1].getToConfiguration();
                            }
                            continue block2;
                        }
                        int n = configurationArray[j].getNoOfCarriers();
                        reconfigurationArray = configurationArray[j].getOutputPower();
                        this.noOfCarriersParameters[i - 1].setLoadedValue(String.valueOf(n));
                        this.outputPowerParameters[i - 1].setLoadedValue(String.valueOf(reconfigurationArray));
                        objectArray = sectorCapability.getReconfigurations(this.configurations[i - 1]);
                        Configuration[] configurationArray2 = new Configuration[objectArray.length + 1];
                        configurationArray2[0] = this.configurations[i - 1];
                        for (int k = 1; k < configurationArray2.length; ++k) {
                            configurationArray2[k] = objectArray[k - 1].getToConfiguration();
                        }
                        EnumeratedRange enumeratedRange = this.getNoOfCarriersRange(configurationArray2, true);
                        ParameterRestriction parameterRestriction = new ParameterRestriction(RECONFIGURATION_NOT_SUPPORTED_RESTRICTION, enumeratedRange, true);
                        this.noOfCarriersParameters[i - 1].addRestriction(parameterRestriction);
                        this.updateOutputPowerRestrictions(i);
                        continue block2;
                    }
                    if (this.useCreateSectorParameter()) {
                        this.createSectorParameters[i - 1].setLoadedValue(this.VALUE_NO);
                        continue;
                    }
                    this.noOfCarriersParameters[i - 1].setLoadedValue("0");
                    this.outputPowerParameters[i - 1].setLoadedValue(this.getDefaultOutputPower(configurationArray));
                }
            }
        }
        catch (OutOfRangeException outOfRangeException) {
            throw new BemException(this.getClass().getName(), "updateLoadedValues()", null, "Counting sectors and carriers", outOfRangeException);
        }
    }

    private void updateOutputPowerRestrictions(int n) {
        Object object;
        Object object2;
        this.resetOutputPowerRestrictions(n);
        int n2 = this.noOfCarriersParameters[n - 1].getValueAsInt();
        SectorCapability sectorCapability = this.sectorCapabilityMgr.getSectorCapability(n);
        Configuration[] configurationArray = sectorCapability.getConfigurations(n2);
        boolean bl = true;
        if (n2 > 0) {
            object2 = this.getOutputPowerRange(configurationArray);
            this.dynamicOutputPowerRestriction[n - 1].setRange((ParameterRange)object2, true);
        } else {
            bl = false;
        }
        this.dynamicOutputPowerRestriction[n - 1].setActive(bl);
        this.outputPowerRestrictionIgnore[n - 1].setActive(!bl);
        object2 = this.noOfCarriersParameters[n - 1].getLoadedValue();
        String string = this.outputPowerParameters[n - 1].getLoadedValue();
        if (((String)object2).equals("0") || ((String)object2).equals("##UNDEFINED") || string.equals("##UNDEFINED")) {
            return;
        }
        Reconfiguration[] reconfigurationArray = sectorCapability.getReconfigurations(Integer.parseInt((String)object2), string, n2);
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        Configuration configuration = sectorCapability.getConfiguration(Integer.parseInt((String)object2), string);
        boolean bl2 = false;
        for (int i = 0; i < reconfigurationArray.length; ++i) {
            object = reconfigurationArray[i].getToConfiguration();
            arrayList.add((Configuration)object);
            if (configuration != object) continue;
            bl2 = true;
        }
        if (!bl2) {
            arrayList.add(configuration);
        }
        Configuration[] configurationArray2 = arrayList.toArray(new Configuration[0]);
        object = this.getOutputPowerRange(configurationArray2);
        this.outputPowerSupportedReconfRestriction[n - 1] = new ParameterRestriction(RECONFIGURATION_NOT_SUPPORTED_RESTRICTION, (ParameterRange)object, true);
        this.outputPowerParameters[n - 1].addRestriction(this.outputPowerSupportedReconfRestriction[n - 1]);
    }

    private void resetOutputPowerRestrictions(int n) {
        if (this.outputPowerSupportedReconfRestriction[n - 1] != null) {
            this.outputPowerParameters[n - 1].removeRestriction(this.outputPowerSupportedReconfRestriction[n - 1]);
            this.outputPowerSupportedReconfRestriction[n - 1] = null;
        }
    }

    private void resetOutputPowerPreconditionReconfRestrictions(int n) {
        if (this.outputPowerPreconditionReconfRestriction[n - 1] != null) {
            this.outputPowerParameters[n - 1].removeRestriction(this.outputPowerPreconditionReconfRestriction[n - 1]);
            this.outputPowerPreconditionReconfRestriction[n - 1] = null;
        }
    }

    private void updateLoadedSectors() throws BemException {
        for (int i = 0; i < this.sectors.length; ++i) {
            boolean bl = this.sectors[i].isInstalled();
            if (!bl) {
                String string;
                if (this.useCreateSectorParameter()) {
                    string = this.createSectorParameters[i].getLoadedValue();
                    if (string.equals(this.VALUE_NO)) continue;
                    this.createSectorParameters[i].setLoadedValue(this.VALUE_NO);
                    this.configurations[i] = null;
                    continue;
                }
                string = this.noOfCarriersParameters[i].getLoadedValue();
                if (string.equals("0") || string.equals("##UNDEFINED")) continue;
                this.noOfCarriersParameters[i].setLoadedValue("0");
                this.configurations[i] = null;
                continue;
            }
            this.installedConfigurations.put(new Integer(i + 1), this.configurations[i]);
        }
    }

    public void checkConsistency() throws BemException {
        super.checkConsistency();
        if (!this.useCreateSectorParameter()) {
            this.updateOutputPowerPreconditionReconfRestrictions();
        }
        this.updateDeleteSectorRestrictions();
        super.checkConsistency();
        if (this.useCreateSectorParameter()) {
            this.checkCreateSector();
        } else {
            this.checkCarriersAndOutputPower();
            this.checkExternalOutputPower();
        }
        this.checkSectors();
    }

    private void updateOutputPowerPreconditionReconfRestrictions() throws BemException {
        for (int i = 1; i <= this.maxNoOfSectors; ++i) {
            boolean bl;
            Reconfiguration reconfiguration;
            this.resetOutputPowerPreconditionReconfRestrictions(i);
            if (this.configurations[i - 1] == null || (reconfiguration = this.getReconfiguration(i)) == null || (bl = reconfiguration.isPreconditionsMet())) continue;
            Configuration[] configurationArray = new Configuration[]{reconfiguration.getToConfiguration()};
            EnumeratedRange enumeratedRange = this.getOutputPowerRange(configurationArray);
            String string = reconfiguration.getFailReasons();
            this.outputPowerPreconditionReconfRestriction[i - 1] = new ParameterRestriction(PRECONDITIONS_NOT_MET_RESTRICTION + string, enumeratedRange, false);
            this.outputPowerParameters[i - 1].addRestriction(this.outputPowerPreconditionReconfRestriction[i - 1]);
        }
    }

    private void updateDeleteSectorRestrictions() throws BemException {
        CellAndCarrierProvider cellAndCarrierProvider = null;
        try {
            cellAndCarrierProvider = this.getRbs().getCellAndCarrierProvider();
        }
        catch (Exception exception) {
            throw new BemException("getCellAndCarrierProvider", "CellAndCarrierCI", (Throwable)exception);
        }
        for (int i = 1; i <= this.maxNoOfSectors; ++i) {
            boolean bl;
            this.resetDeleteSectorRestrictions(i);
            Configuration configuration = (Configuration)this.installedConfigurations.get(new Integer(i));
            if (configuration == null || (bl = cellAndCarrierProvider.areCellsOffline(i))) continue;
            EnumeratedRange enumeratedRange = new EnumeratedRange(new String[]{"0"});
            this.deleteSectorRestriction[i - 1] = new ParameterRestriction(NOT_POSSIBLE_TO_DELETE_SECTOR + i + ". " + "All cells in sector must be offline", enumeratedRange, false);
            if (this.useCreateSectorParameter()) {
                this.createSectorParameters[i - 1].addRestriction(this.deleteSectorRestriction[i - 1]);
                continue;
            }
            this.noOfCarriersParameters[i - 1].addRestriction(this.deleteSectorRestriction[i - 1]);
        }
    }

    private void checkCarriersAndOutputPower() throws BemException {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n = this.noOfCarriersParameters[i].getValueAsInt();
            if (n <= 0 || this.configurations[i] != null) continue;
            throw new BemException("Sector " + (i + 1) + ": Invalid number of Carriers or invalid Output power");
        }
    }

    private void checkCreateSector() throws BemException {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            String string = this.createSectorParameters[i].getValue();
            if (string.equals(this.VALUE_NO) || this.configurations[i] != null) continue;
            throw new BemException("Sector " + (i + 1) + ": Invalid value for create sector");
        }
    }

    private void checkExternalOutputPower() throws BemException {
        int[] nArray = this.getEquippedSectors();
        int n = nArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!"EXTERNAL".equals(this.outputPowerParameters[i].getValue())) continue;
            ++n2;
        }
        if (n2 > 0 && n2 != n) {
            throw new BemException(OUTPUT_POWER_EXTERNAL_MIX);
        }
    }

    protected boolean isBranchedOutputPower(int n) {
        return "BRANCHED".equals(this.outputPowerParameters[n - 1].getValue());
    }

    private void checkSectors() throws BemException {
        int[] nArray = this.getEquippedSectors();
        int n = this.installedConfigurations.size();
        if (nArray.length == 0 && n == 0) {
            throw new BemException(NO_CONFIGURED_SECTORS_ERROR_MESSAGE);
        }
    }

    private void resetDeleteSectorRestrictions(int n) {
        if (this.deleteSectorRestriction[n - 1] != null) {
            if (this.noOfCarriersParameters[n - 1] != null) {
                this.noOfCarriersParameters[n - 1].removeRestriction(this.deleteSectorRestriction[n - 1]);
            }
            this.deleteSectorRestriction[n - 1] = null;
        }
    }

    public ConfigurationCheckReport checkConfiguration() throws BemException {
        ConfigurationCheckReport configurationCheckReport = new ConfigurationCheckReport();
        configurationCheckReport.addReportEntry(this.checkSectorConfiguration());
        configurationCheckReport.addReportEntry(this.checkFoundConfigurations());
        return configurationCheckReport;
    }

    private List checkSectorConfiguration() throws BemException {
        List<ReportEntry> list = new ArrayList<ReportEntry>();
        int[] nArray = this.getEquippedSectors();
        if (nArray.length == 0) {
            list.add(new ReportEntry("Stopping", "", "", "", "Cannot find any equipped sector."));
            return list;
        }
        list = this.checkSectorConfigurationLeftRight();
        return list;
    }

    protected List checkSectorConfigurationLeftRight() throws BemException {
        ArrayList<ReportEntry> arrayList = new ArrayList<ReportEntry>();
        int[] nArray = this.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == i + 1) continue;
            String string = "Equipment in position " + nArray[i];
            String string2 = "Equipment in position " + (i + 1);
            arrayList.add(new ReportEntry("Error", "", string, string2, "Sector equipment must be configured from left to right."));
            break;
        }
        return arrayList;
    }

    private List checkFoundConfigurations() throws BemException {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            if (this.configurations[i] == null) continue;
            ConfigurationCheckReport configurationCheckReport = this.configurations[i].checkConfiguration();
            arrayList.addAll(configurationCheckReport.getAllReportEntries());
        }
        return arrayList;
    }

    private void updateConfigurationType(int n) throws BemException {
        SectorCapability sectorCapability = this.sectorCapabilityMgr.getSectorCapability(n);
        if (this.useCreateSectorParameter()) {
            String string = this.createSectorParameters[n - 1].getValue();
            Configuration configuration = sectorCapability.getConfiguration(string);
            if (configuration == null) {
                if (string.equals(this.VALUE_NO)) {
                    this.configurations[n - 1] = configuration;
                    this.notifyRadioEquipmentListeners(n);
                }
            } else {
                this.configurations[n - 1] = configuration;
                this.notifyRadioEquipmentListeners(n);
            }
        } else {
            String string;
            int n2 = this.noOfCarriersParameters[n - 1].getValueAsInt();
            Configuration configuration = sectorCapability.getConfiguration(n2, string = this.outputPowerParameters[n - 1].getValue());
            if (configuration == null) {
                if (n2 == 0) {
                    this.configurations[n - 1] = configuration;
                    this.notifyRadioEquipmentListeners(n);
                }
            } else {
                this.configurations[n - 1] = configuration;
                this.notifyRadioEquipmentListeners(n);
            }
        }
    }

    private void updateCreateSector(int n) throws BemException {
        this.updateConfigurationType(n);
    }

    private void updateNoOfCarriers(int n) throws BemException {
        this.updateConfigurationType(n);
        this.updateOutputPowerRestrictions(n);
    }

    private void updateOutputPower(int n) throws BemException {
        this.updateConfigurationType(n);
    }

    public int[] getEquippedSectors() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            if (this.configurations[i] == null) continue;
            arrayList.add(new Integer(i + 1));
        }
        Integer[] integerArray = arrayList.toArray(new Integer[0]);
        int[] nArray = BemUtil.convertIntegerArrayToIntArray(integerArray);
        return nArray;
    }

    public int[] getExistingSectors() throws BemException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.sectors.length; ++i) {
            if (this.sectors[i] == null || !this.sectors[i].isInstalled()) continue;
            arrayList.add(new Integer(i + 1));
        }
        Integer[] integerArray = arrayList.toArray(new Integer[0]);
        int[] nArray = BemUtil.convertIntegerArrayToIntArray(integerArray);
        return nArray;
    }

    public int getMaxNumberOfCarriers(int n) {
        int n2 = 0;
        if (this.useCreateSectorParameter()) {
            if (this.createSectorParameters[n - 1].getValue().equals(this.VALUE_NO)) {
                n2 = 0;
            } else if ((n == 4 || n == 5 || n == 6) && this.createSectorParameters[n - 1].getValue().equals(this.VALUE_YES)) {
                n2 = 1;
            } else if ((n == 1 || n == 2 || n == 3) && this.createSectorParameters[n - 1].getValue().equals(this.VALUE_YES)) {
                n2 = this.rbs.getMaxNumberOfCarriers();
            }
        } else {
            n2 = this.noOfCarriersParameters[n - 1].getValueAsInt();
        }
        return n2;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public ArrayList getNeededRIs() throws BemException {
        if (!this.isOpen) {
            throw new BemException("RadioEquipmentCI is not open.");
        }
        this.checkConsistency();
        ArrayList arrayList = super.getNeededRIs();
        arrayList.addAll(this.getConfigurationResourceItems());
        for (int i = 1; i <= this.maxNoOfSectors; ++i) {
            Reconfiguration reconfiguration = this.getReconfiguration(i);
            if (reconfiguration == null) continue;
            List list = reconfiguration.getRisToInstall();
            arrayList.addAll(list);
        }
        return arrayList;
    }

    protected List getConfigurationResourceItems() throws BemException {
        ArrayList<ResourceItem> arrayList = new ArrayList<ResourceItem>();
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            if (this.configurations[i] == null) continue;
            List list = this.configurations[i].getResourceItems();
            for (ResourceItem resourceItem : list) {
                if (arrayList.contains(resourceItem)) continue;
                arrayList.add(resourceItem);
            }
            arrayList.add(this.sectors[i]);
        }
        return arrayList;
    }

    public List getRIsToUninstall() throws BemException {
        List<SectorRI> list = new ArrayList();
        list = super.getRIsToUninstall();
        for (int i = 1; i <= this.maxNoOfSectors; ++i) {
            Object object;
            Reconfiguration reconfiguration = this.getReconfiguration(i);
            if (reconfiguration != null) {
                object = reconfiguration.getRisToUninstall();
                list.addAll((Collection<SectorRI>)object);
            }
            if (this.configurations[i - 1] != null || (object = (Configuration)this.installedConfigurations.get(new Integer(i))) == null) continue;
            list.add(this.sectors[i - 1]);
            List list2 = object.getResourceItemsToUninstall();
            ArrayList arrayList = new ArrayList();
            for (int j = 0; j < this.maxNoOfSectors; ++j) {
                if (i == j + 1 || this.configurations[j] == null) continue;
                Object object2 = this.configurations[j].getResourceItems();
                arrayList.addAll(object2);
            }
            for (Object object2 : list2) {
                if (arrayList.contains(object2) || list.contains(object2)) continue;
                list.add((SectorRI)object2);
            }
        }
        return list;
    }

    private Reconfiguration getReconfiguration(int n) throws BemException {
        Reconfiguration reconfiguration;
        if (!this.useCreateSectorParameter()) {
            String string = this.noOfCarriersParameters[n - 1].getLoadedValue();
            String string2 = this.outputPowerParameters[n - 1].getLoadedValue();
            if (string.equals("0") || string.equals("##UNDEFINED") || string2.equals("##UNDEFINED")) {
                return null;
            }
            int n2 = Integer.parseInt(string);
            int n3 = this.noOfCarriersParameters[n - 1].getValueAsInt();
            String string3 = this.outputPowerParameters[n - 1].getValue();
            if (n3 == 0) {
                return null;
            }
            SectorCapability sectorCapability = this.sectorCapabilityMgr.getSectorCapability(n);
            reconfiguration = sectorCapability.getReconfiguration(n2, string2, n3, string3);
            if (reconfiguration == null && (n2 > 0 && n2 != n3 || !string2.equals(string3))) {
                throw new BemException("The type of reconfiguration is not supported. No of carriers: " + n3 + ", Output power: " + string3);
            }
        } else {
            String string = this.createSectorParameters[n - 1].getLoadedValue();
            if (string.equals(this.VALUE_NO)) {
                return null;
            }
            String string4 = this.createSectorParameters[n - 1].getValue();
            if (string4.equals(this.VALUE_NO)) {
                return null;
            }
            SectorCapability sectorCapability = this.sectorCapabilityMgr.getSectorCapability(n);
            reconfiguration = sectorCapability.getReconfigurations(string, string4);
            if (reconfiguration == null && !string.equals(this.VALUE_NO) && !string.equals(string4)) {
                throw new BemException("The type of reconfiguration is not supported. create sector: " + string4);
            }
        }
        return reconfiguration;
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        int n;
        int n2;
        String[] stringArray = null;
        if (this.useCreateSectorParameter()) {
            n2 = this.maxNoOfSectors;
            stringArray = new String[n2];
            for (n = 0; n < this.maxNoOfSectors; ++n) {
                stringArray[n] = this.createSectorServiceNames[n];
            }
            this.handleAddCarriersForMainRemote(serviceValue, this.maxNoOfSectors, this.maxNoOfCarriers);
        } else {
            n2 = 2 * this.maxNoOfSectors;
            stringArray = new String[n2];
            for (n = 0; n < this.maxNoOfSectors; ++n) {
                stringArray[n] = this.noOfCarriersServiceNames[n];
                stringArray[n + this.maxNoOfSectors] = this.outputPowerServiceNames[n];
            }
        }
        for (n2 = 1; n2 <= this.maxNoOfSectors; ++n2) {
            String string = MessageFormat.format("S{0}_", new Integer(n2));
            String string2 = string + "deleteSector";
            if (serviceValue.getAttribute(string2) == null) continue;
            if (this.useCreateSectorParameter()) {
                this.createSectorParameters[n2 - 1].setValue(this.VALUE_NO);
                continue;
            }
            this.noOfCarriersParameters[n2 - 1].setValue("0");
        }
        super.setCustomerParametersFromSV(stringArray, serviceValue);
        super.setCustomerParameters(serviceValue);
    }

    public String getTerminationObject(int n, String string) throws BemException {
        String string2 = null;
        if (this.configurations[n - 1] != null) {
            string2 = this.configurations[n - 1].getTerminationObject(string);
        }
        return string2;
    }

    public int getNumberOfSupportedTxBranches(int n) {
        int n2 = 0;
        if (this.configurations[n - 1] != null) {
            n2 = this.configurations[n - 1].getNoOfSupportedTxBranches();
        }
        return n2;
    }

    public int getLoadedNumberOfSupportedTxBranches(int n) {
        int n2 = 0;
        if (this.configurations[n - 1] != null) {
            n2 = this.configurations[n - 1].getNoOfSupportedTxBranches();
        }
        return n2;
    }

    public boolean isExternalOutputPowerUsed() {
        boolean bl = false;
        if (this.outputPowerParameters.length > 0 && this.outputPowerParameters[0] != null && "EXTERNAL".equals(this.outputPowerParameters[0].getValue())) {
            bl = true;
        }
        return bl;
    }

    protected void setupAtfProvider(SectorCapability sectorCapability) {
        Configuration[] configurationArray;
        if (this.myAtfProvider == null) {
            this.myAtfProvider = new AtfProviderImpl();
        }
        if ((configurationArray = sectorCapability.getConfigurations()).length > 0) {
            AtfProviderInfo[] atfProviderInfoArray = configurationArray[0].getAtfProviderInfo();
            for (int i = 0; i < atfProviderInfoArray.length; ++i) {
                this.myAtfProvider.putAtfLdns(atfProviderInfoArray[i].getAtfRole(), atfProviderInfoArray[i].getPrimaryLdn(), atfProviderInfoArray[i].getSecondaryLdn());
            }
        }
    }

    protected AtfProvider getAtfProvider() {
        return this.myAtfProvider;
    }

    protected boolean isToBeConfigured(int n) {
        if (n < 1 || n > this.getRbs().getMaxNumberOfSectors()) {
            return false;
        }
        return this.configurations[n - 1] != null && this.installedConfigurations.get(new Integer(n)) == null;
    }

    public boolean isUniniteSectorNeeded(int n) {
        return false;
    }

    protected SectorRI getSector(int n) {
        if (n < 1 || n > this.getRbs().getMaxNumberOfSectors()) {
            return null;
        }
        return this.sectors[n - 1];
    }

    public int getNumberOfDuwSlots() {
        return 1;
    }

    public int getMinNumberOfCarriers(int n) {
        return 1;
    }

    public String getConfigurationGroup() {
        return "ALL1";
    }

    public CustomerParameter getConfigurationGroupParameter() {
        return null;
    }

    public void setNumberOfLoadedCarriers(int[] nArray) {
    }

    public int[] getCarriersInSector(int n, int n2) throws BemException {
        int n3 = this.getMaxNumberOfCarriers(n2);
        int[] nArray = null;
        if (n == 0) {
            nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray[i] = i + 1;
            }
        }
        return nArray;
    }

    public boolean isCarrierLocatedInBbp(int n, int n2, int n3) throws BemException {
        return n - 1 == 0;
    }

    public boolean isDualRadioInterfaceBoardNeeded(int n) {
        return false;
    }

    public boolean usesAdvancedCarrierAllocationMode() {
        return false;
    }

    public int[] getSupportedTxDivRange(int n) {
        return new int[]{1};
    }

    public int getNumberOfSupportedRxBranches(int n) {
        return 2;
    }

    public int getLoadedNumberOfSupportedRxBranches(int n) {
        return 2;
    }

    public int[] getNumberOfRxBranchesPerAntenna(int n) {
        return new int[]{2};
    }

    private class OutputPowerListener
    implements CustomerParameterListener {
        int sector;

        public OutputPowerListener(int n) {
            this.sector = n;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                int n = customerParameter.getAccessLevel();
                if (n == 0) {
                    return;
                }
                try {
                    AbstractRbs3RadioEquipmentCI.this.updateOutputPower(this.sector);
                }
                catch (BemException bemException) {
                    throw new RuntimeException(bemException.toString());
                }
            }
        }
    }

    private class NoOfCarriersListener
    implements CustomerParameterListener {
        int sector;

        public NoOfCarriersListener(int n) {
            this.sector = n;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                int n = customerParameter.getAccessLevel();
                if (n == 0) {
                    return;
                }
                try {
                    AbstractRbs3RadioEquipmentCI.this.updateNoOfCarriers(this.sector);
                }
                catch (BemException bemException) {
                    throw new RuntimeException(bemException.toString());
                }
            }
        }
    }

    private class CreateSectorListener
    implements CustomerParameterListener {
        int sector;

        public CreateSectorListener(int n) {
            this.sector = n;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                int n = customerParameter.getAccessLevel();
                if (n == 0) {
                    return;
                }
                try {
                    AbstractRbs3RadioEquipmentCI.this.updateCreateSector(this.sector);
                }
                catch (BemException bemException) {
                    throw new RuntimeException(bemException.toString());
                }
            }
        }
    }
}

