/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractCableRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDigitalCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.moi.CableMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class DigitalCableRI
extends AbstractCableRI {
    private static final String name = "DigitalCable";
    private String objectALdn;
    private int objectAConnector;
    private String objectBLdn;
    private int objectBConnector;
    private int electricalDelay;
    private NalNameValue[] cableAttributes = null;
    private String ldn;
    private String id;
    private String fixedRdn;

    public DigitalCableRI(Rbs rbs, String string, int n, String string2, int n2, int n3) throws BemException {
        this(rbs, string, n, string2, n2, n3, null);
    }

    public DigitalCableRI(Rbs rbs, String string, int n, String string2, int n2, int n3, String string3) throws BemException {
        super(rbs, name);
        this.objectALdn = string;
        this.objectAConnector = n;
        this.objectBLdn = string2;
        this.objectBConnector = n2;
        this.electricalDelay = n3;
        this.fixedRdn = string3;
        this.setCableLdn(string, string2, string3);
    }

    public void install(String string) throws BemException {
        if (!string.equals("CabinetCableCreationPhase")) {
            return;
        }
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        BemMo bemMo = moHandlerImpl.getMo(this.objectALdn);
        BemMo bemMo2 = moHandlerImpl.getMo(this.objectBLdn);
        boolean bl = false;
        try {
            bl = moHandlerImpl.isExisting(bemMo) && moHandlerImpl.isExisting(bemMo2);
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("Could not access node: " + moHandlerException);
        }
        if (!bl) {
            throw new BemException("Digital cable: " + this.ldn + " could not be created.\n" + "Object A ldn: " + this.objectALdn + "\n" + "Object B ldn: " + this.objectBLdn);
        }
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        NalNameValue nalNameValue = null;
        String string2 = this.getLdnWithoutDeviceGroup(this.objectALdn);
        BemMo bemMo3 = moHandlerImpl.getMo(string2);
        nalNameValue = Nal.getFactory().getNameValue("connectedToObjectARef", bemMo3);
        vector.add(nalNameValue);
        String string3 = this.getLdnWithoutDeviceGroup(this.objectBLdn);
        BemMo bemMo4 = moHandlerImpl.getMo(string3);
        nalNameValue = Nal.getFactory().getNameValue("connectedToObjectBRef", bemMo4);
        vector.add(nalNameValue);
        nalNameValue = Nal.getFactory().getNameValue("objectAConnector", new Integer(this.objectAConnector));
        vector.add(nalNameValue);
        nalNameValue = Nal.getFactory().getNameValue("objectBConnector", new Integer(this.objectBConnector));
        vector.add(nalNameValue);
        nalNameValue = Nal.getFactory().getNameValue("electricalDelay", new Integer(this.electricalDelay));
        vector.add(nalNameValue);
        nalNameValue = Nal.getFactory().getNameValue("alarmStatus", new Integer(0));
        vector.add(nalNameValue);
        if (this.fixedRdn == null) {
            this.updateLdn();
        }
        this.createMoIfNotExisting(this.ldn, vector);
        this.setAttributes();
    }

    private void updateLdn() throws BemException {
        int n = this.ldn.lastIndexOf("=");
        String string = this.ldn.substring(n + 1);
        if (string.startsWith("_")) {
            this.setCableLdn(this.objectALdn, this.objectBLdn, null);
        }
    }

    private void setCableLdn(String string, String string2, String string3) throws BemException {
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(this.getLdnWithoutDeviceGroup(string));
        BemMo bemMo2 = moHandler.getMo(this.getLdnWithoutDeviceGroup(string2));
        this.id = this.getRdn(this.objectALdn, string3);
        CableMoi cableMoi = new CableMoi(MimDigitalCable.MOTYPENAME, "A_AND_B", "connectedToObjectARef", bemMo, "objectAConnector", new Integer(this.objectAConnector), "connectedToObjectBRef", bemMo2, "objectBConnector", new Integer(this.objectBConnector), this.id);
        this.ldn = cableMoi.getLdn();
    }

    private String getRdn(String string, String string2) throws BemException {
        String string3 = string2;
        if (string3 == null) {
            String string4 = this.getSubrackId(string);
            String string5 = this.getSlotNumber(string);
            if (string4.equals("") || string5.equals("")) {
                String string6 = this.getPiuRdn(string);
                string3 = string6 + "_" + this.getNameA(this.objectAConnector);
            } else {
                string3 = string4 + "_" + string5 + "_" + this.getNameA(this.objectAConnector);
            }
        }
        return string3;
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("CabinetCableDeletionPhase")) {
            this.deleteMoIfNotExisting(this.ldn);
        }
    }

    public String getDisplayName() {
        return "DigitalCable:" + this.ldn;
    }

    public String getLdn() {
        return this.ldn;
    }

    private String getNameA(int n) throws BemException {
        String string = null;
        switch (n) {
            case 1: {
                string = "DATA_A";
                break;
            }
            case 7: {
                string = "DATA_1";
                break;
            }
            case 8: {
                string = "DATA_2";
                break;
            }
            case 9: {
                string = "RI_A";
                break;
            }
            case 2: {
                string = "DATA_B";
                break;
            }
            case 10: {
                string = "RI_B";
                break;
            }
            case 3: {
                string = "DATA_C";
                break;
            }
            case 11: {
                string = "RI_C";
                break;
            }
            case 4: {
                string = "DATA_D";
                break;
            }
            case 12: {
                string = "RI_D";
                break;
            }
            case 5: {
                string = "DATA_E";
                break;
            }
            case 13: {
                string = "RI_E";
                break;
            }
            case 6: {
                string = "DATA_F";
                break;
            }
            case 14: {
                string = "RI_F";
                break;
            }
            default: {
                throw new BemException("Wrong connector A for DigitalCable: " + n);
            }
        }
        return string;
    }

    private String getSlotNumber(String string) {
        return BemUtil.extractRdnId(string, "Slot");
    }

    private String getSubrackId(String string) {
        return BemUtil.extractRdnId(string, "Subrack");
    }

    private String getPiuRdn(String string) {
        return BemUtil.extractRdnId(string, "PlugInUnit");
    }

    private String getLdnWithoutDeviceGroup(String string) {
        String string2 = string;
        if (!BemUtil.isLdnOfType(string, MimPlugInUnit.MOTYPENAME) && !BemUtil.isLdnOfType(string, MimAuxPlugInUnit.MOTYPENAME)) {
            int n = string.lastIndexOf(",");
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public void setAttributes(NalNameValue[] nalNameValueArray) throws BemException {
        this.cableAttributes = nalNameValueArray;
    }

    private void setAttributes() throws BemException {
        if (this.cableAttributes == null) {
            return;
        }
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        BemMo bemMo = moHandlerImpl.getMo(this.ldn);
        try {
            if (bemMo.isExisting()) {
                moHandlerImpl.setAttributes(bemMo, this.cableAttributes);
            }
        }
        catch (Exception exception) {
            throw new BemException("DigitalCableRI.setAttributes()", "setAttributes()", this.ldn, null, exception);
        }
    }

    public boolean isInstalled() throws BemException {
        boolean bl = super.isInstalled();
        if (bl) {
            try {
                BemMo bemMo;
                MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
                BemMo bemMo2 = moHandlerImpl.getMo(this.ldn);
                BemMo bemMo3 = (BemMo)moHandlerImpl.getAttribute(bemMo2, "connectedToObjectARef");
                BemMo bemMo4 = bemMo = moHandlerImpl.getMo(this.objectALdn);
                if (!bemMo.getType().equals("PlugInUnit")) {
                    bemMo4 = bemMo.getParent();
                }
                boolean bl2 = ((Object)bemMo3).equals(bemMo4);
                BemMo bemMo5 = (BemMo)moHandlerImpl.getAttribute(bemMo2, "connectedToObjectBRef");
                BemMo bemMo6 = moHandlerImpl.getMo(this.objectBLdn);
                BemMo bemMo7 = bemMo6.getParent();
                boolean bl3 = ((Object)bemMo5).equals(bemMo7);
                Integer n = (Integer)moHandlerImpl.getAttribute(bemMo2, "objectAConnector");
                boolean bl4 = n == this.objectAConnector;
                Integer n2 = (Integer)moHandlerImpl.getAttribute(bemMo2, "objectBConnector");
                boolean bl5 = n2 == this.objectBConnector;
                bl = bl2 && bl3 && bl4 && bl5;
            }
            catch (MoHandlerException moHandlerException) {
                throw new BemException(moHandlerException.getAction(), moHandlerException.getLdn(), (Throwable)moHandlerException);
            }
        }
        return bl;
    }

    public Object[] getAttributes(String[] stringArray) throws BemException {
        Object[] objectArray = new Object[stringArray.length];
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        BemMo bemMo = moHandlerImpl.getMo(this.ldn);
        try {
            objectArray = moHandlerImpl.getAttributes(bemMo, stringArray);
        }
        catch (Exception exception) {
            throw new BemException("DigitalCableRI.getAttributes()", "getAttributes()", this.ldn, null, exception);
        }
        return objectArray;
    }

    public String getConnectedToObjectALdn() {
        return this.objectALdn;
    }

    public String getConnectedToObjectBLdn() {
        return this.objectBLdn;
    }
}

